<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Value.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Value.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Value.i3                                              

<P><PRE>INTERFACE <interface><A HREF="Value.m3">Value</A></interface>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>;

TYPE
  T = M3.Value;
  CheckState = M3.CheckState;

TYPE
  Class = {Expr, Var, Type, Exception, Procedure,
           Module, Field, Method, Formal, Error};

PROCEDURE <A HREF="Value.m3#TypeCheck">TypeCheck</A> (t: T;  VAR cs: CheckState);

PROCEDURE <A HREF="Value.m3#TypeOf">TypeOf</A> (t: T): M3.Type;
</PRE><BLOCKQUOTE><EM> returns the type of 't' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#SetGlobals">SetGlobals</A> (t: T);
</PRE><BLOCKQUOTE><EM> assign offsets to any needed global data. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#Load">Load</A> (t: T);
</PRE><BLOCKQUOTE><EM> generate code to load 't' on the evaluation stack </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#Declare">Declare</A> (t: T);
</PRE><BLOCKQUOTE><EM> generate the C declaration for t; initialize it to the user
   specified value if possible </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#NeedsInit">NeedsInit</A> (t: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns TRUE if 't' needs runtime code to be initialized </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#LangInit">LangInit</A> (t: T);
</PRE><BLOCKQUOTE><EM> generate language required initialization for t if Declare0 did nothing </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#UserInit">UserInit</A> (t: T);
</PRE><BLOCKQUOTE><EM> generate the user specified initialization for t </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#ClassOf">ClassOf</A>          (t: T): Class;
PROCEDURE <A HREF="Value.m3#IsExternal">IsExternal</A>       (t: T): BOOLEAN;
PROCEDURE <A HREF="Value.m3#IsImported">IsImported</A>       (t: T): BOOLEAN;
PROCEDURE <A HREF="Value.m3#IsWritable">IsWritable</A>       (t: T): BOOLEAN;
PROCEDURE <A HREF="Value.m3#ToExpr">ToExpr</A>           (t: T): M3.Expr;
PROCEDURE <A HREF="Value.m3#ToType">ToType</A>           (t: T): M3.Type;
PROCEDURE <A HREF="Value.m3#Base">Base</A>             (t: T): T;
PROCEDURE <A HREF="Value.m3#CName">CName</A>            (t: T): M3ID.T;
PROCEDURE <A HREF="Value.m3#GlobalName">GlobalName</A>       (t: T;  dots, with_module: BOOLEAN): TEXT;
PROCEDURE <A HREF="Value.m3#IllegalRecursion">IllegalRecursion</A> (t: T);

PROCEDURE <A HREF="Value.m3#AddFPTag">AddFPTag</A>   (t: T;  VAR x: M3.FPInfo): CARDINAL;
PROCEDURE <A HREF="Value.m3#AddFPEdges">AddFPEdges</A> (t: T;  VAR x: M3.FPInfo;  n: CARDINAL): CARDINAL;

PROCEDURE <A HREF="Value.m3#Reset">Reset</A> ();

PROCEDURE <A HREF="Value.m3#SetModule">SetModule</A> (t: T): T;
</PRE><BLOCKQUOTE><EM> sets the current module's list of values to 't' and
   returns the previouse module's value list.  This routine
   is only called when the <CODE>current</CODE> module changes. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#Reuse">Reuse</A> (t: T);
</PRE><BLOCKQUOTE><EM> prepares the values on list 't' for reuse in another
   compilation ==&gt; reset a bunch of flags </EM></BLOCKQUOTE><PRE>

END Value.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
