<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/Value.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/Value.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Value.m3                                              

<P><PRE>MODULE <module>Value</module> EXPORTS <A HREF="Value.i3"><implements>Value</A></implements>, <A HREF="ValueRep.i3"><implements>ValueRep</A></implements>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../misc/Scope.i3">Scope</A>, <A HREF="../../../m3middle/src/M3FP.i3">M3FP</A>, <A HREF="../misc/CG.i3">CG</A>;
IMPORT <A HREF="../misc/Scanner.i3">Scanner</A>, <A HREF="../misc/Host.i3">Host</A>, <A HREF="../builtinTypes/ErrType.i3">ErrType</A>, <A HREF="../types/TypeFP.i3">TypeFP</A>, <A HREF="Procedure.i3">Procedure</A>;

CONST NOT_CHECKED = -1;
CONST CHECKED     = 0;

PROCEDURE <A NAME="TypeCheck"><procedure>TypeCheck</procedure></A> (t: T;  VAR cs: CheckState) =
  VAR save: INTEGER;
  BEGIN
    IF (t = NIL) THEN RETURN END;
    IF (t.checked) THEN RETURN END;
    IF (t.checkDepth = NOT_CHECKED) THEN
      (* this node is not currently being checked *)
      save := Scanner.offset;
      Scanner.offset := t.origin;
        t.checkDepth := Type.recursionDepth;
        t.typeCheck (cs);
        t.checkDepth := CHECKED;
        t.checked := TRUE;
      Scanner.offset := save;
    ELSIF (t.checkDepth # Type.recursionDepth) THEN
      (* this is a legal recursion, just return *)
    ELSE
      IllegalRecursion (t);
    END;
  END TypeCheck;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (t: T): Type.T =
  VAR x: Type.T;
  BEGIN
    IF (t = NIL) THEN RETURN ErrType.T END;
    IF (t.inTypeOf) THEN IllegalRecursion (t);  RETURN ErrType.T  END;
    t.inTypeOf := TRUE;
    x := t.typeOf ();
    t.inTypeOf := FALSE;
    RETURN x;
  END TypeOf;

PROCEDURE <A NAME="SetGlobals"><procedure>SetGlobals</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL ) THEN RETURN END;
    &lt;*ASSERT t.checked *&gt;
    t.set_globals ();
  END SetGlobals;

PROCEDURE <A NAME="Load"><procedure>Load</procedure></A> (t: T) =
  BEGIN
    IF (t = NIL) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    t.used := TRUE;
    t.load ();
  END Load;

PROCEDURE <A NAME="ToExpr"><procedure>ToExpr</procedure></A> (t: T): Expr.T =
  VAR e: Expr.T;
  BEGIN
    IF (t = NIL) THEN RETURN NIL END;
    IF (t.inToExpr) THEN IllegalRecursion (t); RETURN NIL END;
    t.inToExpr := TRUE;
    e := t.toExpr ();
    t.inToExpr := FALSE;
    RETURN e;
  END ToExpr;

PROCEDURE <A NAME="ToType"><procedure>ToType</procedure></A> (t: T): Type.T =
  VAR x: Type.T;
  BEGIN
    IF (t = NIL) THEN RETURN NIL END;
    IF (t.inToType) THEN IllegalRecursion (t); RETURN NIL END;
    t.inToType := TRUE;
    x := t.toType ();
    t.inToType := FALSE;
    RETURN x;
  END ToType;

PROCEDURE <A NAME="Base"><procedure>Base</procedure></A> (t: T): T =
  BEGIN
    IF (t = NIL) THEN RETURN NIL END;
    RETURN t.base ();
  END Base;

PROCEDURE <A NAME="IllegalRecursion"><procedure>IllegalRecursion</procedure></A> (t: T) =
  BEGIN
    IF (NOT t.error) THEN
      Error.ID (t.name, &quot;illegal recursive declaration&quot;);
      t.error := TRUE;
    END;
  END IllegalRecursion;

PROCEDURE <A NAME="ClassOf"><procedure>ClassOf</procedure></A> (t: T): Class =
  BEGIN
    IF (t = NIL) THEN RETURN Class.Error END;
    RETURN t.class;
  END ClassOf;

VAR mbuf: M3Buf.T := NIL;

PROCEDURE <A NAME="ToFP"><procedure>ToFP</procedure></A> (t: T): M3FP.T =
  VAR n: CARDINAL;  x: M3.FPInfo;  fp: M3FP.T;
  BEGIN
    IF (t = NIL) THEN RETURN M3FP.Zero END;
    t := Base (t);
    IF (mbuf = NIL) THEN mbuf := M3Buf.New () END;

    (* build the tag *)
    x.tag     := NIL;
    x.buf     := mbuf;  mbuf := NIL;
    x.n_nodes := 0;
    x.others  := NIL;
    n := AddFPTag (t, x);
    IF (x.tag # NIL)
      THEN fp := TypeFP.FromText (x.tag);
      ELSE fp := TypeFP.FromBuf (x.buf);
    END;
    mbuf := x.buf;  x.buf := NIL;  x.tag := NIL;

    (* add any type information *)
    IF (n &gt; 0) THEN
      &lt;*ASSERT n = 1*&gt;
      EVAL AddFPEdges (t, x, 0);
      fp := TypeFP.FromPair (fp, TypeFP.FromType (x.nodes[0]));
    END;

    RETURN fp;
  END ToFP;

PROCEDURE <A NAME="AddFPTag"><procedure>AddFPTag</procedure></A> (t: T;  VAR x: M3.FPInfo): CARDINAL =
  VAR n: CARDINAL;
  BEGIN
    IF (t = NIL) THEN RETURN 0 END;
    t := t.base ();
    M3Buf.PutChar (x.buf, '&lt;');
    n := t.add_fp_tag (x);
    M3Buf.PutChar (x.buf, '&gt;');
    RETURN n;
  END AddFPTag;

PROCEDURE <A NAME="AddFPEdges"><procedure>AddFPEdges</procedure></A> (t: T;  VAR x: M3.FPInfo;  n: CARDINAL): CARDINAL =
  VAR u: T;  type: Type.T;
  BEGIN
    IF (t = NIL) THEN RETURN n END;
    u := t.base ();
    type := u.fp_type ();
    IF (type # NIL) THEN
      IF (x.others = NIL)
        THEN x.nodes [n] := type;
        ELSE x.others [n] := type;
      END;
      INC (n);
    END;
    RETURN n;
  END AddFPEdges;

PROCEDURE <A NAME="FPStart"><procedure>FPStart</procedure></A> (t: T;  VAR x: M3.FPInfo;  tag: TEXT;
                   offset: INTEGER;  global: BOOLEAN) =
  VAR s: Scope.IDStack;
  BEGIN
    M3Buf.PutText (x.buf, tag);
    IF (global) THEN
      s.top := 0;
      Scope.NameToPrefix (t, s, dots := TRUE);
      Scope.PutStack (x.buf, s);
    ELSE
      M3ID.Put (x.buf, t.name);
    END;
    IF (offset # 0) THEN
      M3Buf.PutChar (x.buf, '@');
      M3Buf.PutInt  (x.buf, offset);
    END;
    IF (t.external) THEN
      M3Buf.PutChar (x.buf, '$');
      M3ID.Put      (x.buf, t.extName);
    END;
  END FPStart;

TYPE
  VSFlags = RECORD
    need_vs     : BOOLEAN;
    imported    : BOOLEAN;
    implemented : BOOLEAN;
  END;

PROCEDURE <A NAME="Declare"><procedure>Declare</procedure></A> (t: T) =
  VAR f: VSFlags;  fp: M3FP.T;
  BEGIN
    IF (t = NIL) THEN RETURN END;
    IF (t.declared) THEN RETURN END;
    IF (NOT t.used) AND (t.imported) THEN RETURN END;
    t.declared := TRUE;
    GetVSFlags (t, f);
    IF t.declare () AND (Host.versionStamps) AND (f.need_vs) THEN
      fp := ToFP (t);
      Host.env.note_version_stamp (Scope.ModuleName (t), t.name,
                                   fp, f.imported, f.implemented);
    END;
  END Declare;

PROCEDURE <A NAME="GetVSFlags"><procedure>GetVSFlags</procedure></A> (t: T;  VAR f: VSFlags) =
  BEGIN
    f.need_vs := t.imported OR t.exported;

    IF (t.external)
      THEN f.imported := NOT t.exported;
      ELSE f.imported := t.imported;
    END;

    f.implemented := NOT f.imported;
    IF (NOT t.external) AND (t.class = Class.Procedure) THEN
      f.implemented := Procedure.HasBody (Base (t));
    END;

  END GetVSFlags;

PROCEDURE <A NAME="NeedsInit"><procedure>NeedsInit</procedure></A> (t: T): BOOLEAN =
  BEGIN
    IF (t = NIL) THEN RETURN FALSE END;
    RETURN t.need_init ();
  END NeedsInit;

PROCEDURE <A NAME="LangInit"><procedure>LangInit</procedure></A> (t: T) =
  VAR save: INTEGER;
  BEGIN
    IF (t = NIL) THEN RETURN END;
    IF (t.compiled) THEN RETURN END;
    &lt;* ASSERT t.checked *&gt;
    t.compiled := TRUE;
    save := Scanner.offset;
    Scanner.offset := t.origin;
    t.lang_init ();
    CG.Free_temps ();
    Scanner.offset := save;
  END LangInit;

PROCEDURE <A NAME="UserInit"><procedure>UserInit</procedure></A> (t: T) =
  VAR save: INTEGER;
  BEGIN
    IF (t = NIL) THEN RETURN; END;
    save := Scanner.offset;
    Scanner.offset := t.origin;
    t.user_init ();
    CG.Free_temps ();
    Scanner.offset := save;
  END UserInit;

VAR all: T;  (* all values in the current module *)

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T;  name: M3ID.T;  c: Class) =
  BEGIN
    t.origin     := Scanner.offset;
    t.name       := name;
    t.extName    := M3ID.NoID;
    t.scope      := NIL;
    t.checkDepth := NOT_CHECKED;
    t.class      := c;
    t.checked    := FALSE;
    t.readonly   := FALSE;
    t.external   := FALSE;
    t.unused     := FALSE;
    t.obsolete   := FALSE;
    t.up_level   := FALSE;

    IF (c # Class.Module) THEN
      t.vnext := all;  all := t;
    END;

    t.error      := FALSE;
    t.used       := FALSE;
    t.declared   := FALSE;
    t.compiled   := FALSE;
    t.imported   := NOT Scanner.in_main;
    t.exported   := FALSE;
    t.exportable := FALSE;
    t.inTypeOf   := FALSE;
    t.inToExpr   := FALSE;
    t.inToType   := FALSE;
  END Init;

PROCEDURE <A NAME="NoExpr"><procedure>NoExpr</procedure></A> (&lt;*UNUSED*&gt; t: T): Expr.T =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NoExpr;

PROCEDURE <A NAME="NoType"><procedure>NoType</procedure></A> (&lt;*UNUSED*&gt; t: T): Type.T =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NoType;

PROCEDURE <A NAME="NoLoader"><procedure>NoLoader</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
    &lt;* ASSERT FALSE *&gt;
  END NoLoader;

PROCEDURE <A NAME="Never"><procedure>Never</procedure></A> (&lt;*UNUSED*&gt; t: T): BOOLEAN =
  BEGIN
    RETURN FALSE;
  END Never;

PROCEDURE <A NAME="NoInit"><procedure>NoInit</procedure></A> (&lt;*UNUSED*&gt; t: T) =
  BEGIN
  END NoInit;

PROCEDURE <A NAME="Always"><procedure>Always</procedure></A> (&lt;*UNUSED*&gt; t: T): BOOLEAN =
  BEGIN
    RETURN TRUE;
  END Always;

PROCEDURE <A NAME="TypeVoid"><procedure>TypeVoid</procedure></A> (&lt;*UNUSED*&gt; t: T): Type.T =
  BEGIN
    RETURN NIL;
  END TypeVoid;

PROCEDURE <A NAME="Self"><procedure>Self</procedure></A> (t: T): T =
  BEGIN
    RETURN t;
  END Self;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> () =
  BEGIN
    all := NIL;
  END Reset;

PROCEDURE <A NAME="SetModule"><procedure>SetModule</procedure></A> (new: T): T =
  VAR old := all;
  BEGIN
    all := new;
    RETURN old;
  END SetModule;

PROCEDURE <A NAME="Reuse"><procedure>Reuse</procedure></A> (t: T) =
  BEGIN
    WHILE (t # NIL) DO
      t.used       := FALSE;
      t.error      := FALSE;
      t.declared   := FALSE;
      t.compiled   := FALSE;
      t.imported   := (NOT Host.emitBuiltins);
      t.exported   := FALSE;
      t.exportable := FALSE;
      t.inTypeOf   := FALSE;
      t.inToExpr   := FALSE;
      t.inToType   := FALSE;
      t := t.vnext;
    END;
  END Reuse;

PROCEDURE <A NAME="IsExternal"><procedure>IsExternal</procedure></A> (t: T): BOOLEAN =
  BEGIN
    RETURN (t.external);
  END IsExternal;

PROCEDURE <A NAME="IsImported"><procedure>IsImported</procedure></A> (t: T): BOOLEAN =
  BEGIN
    RETURN (t # NIL) AND (t.imported);
  END IsImported;

PROCEDURE <A NAME="IsWritable"><procedure>IsWritable</procedure></A> (t: T): BOOLEAN =
  BEGIN
    RETURN NOT t.readonly;
  END IsWritable;

PROCEDURE <A NAME="CName"><procedure>CName</procedure></A> (t: T): M3ID.T =
  BEGIN
    IF (t = NIL) THEN RETURN M3ID.NoID END;
    RETURN t.base().name;
  END CName;

PROCEDURE <A NAME="GlobalName"><procedure>GlobalName</procedure></A> (t: T;  dots, with_module: BOOLEAN): TEXT =
  VAR ss: Scope.IDStack;
  BEGIN
    IF (t = NIL) THEN RETURN NIL END;
    ss.top := 0;
    Scope.NameToPrefix (t, ss, NOT dots, dots, with_module);
    RETURN Scope.StackToText (ss);
  END GlobalName;

BEGIN
END Value.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
