<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/values/ValueRep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/values/ValueRep.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ValueRep.i3                                           

<P><PRE>INTERFACE <interface><A HREF="Value.m3">ValueRep</A></interface>;

IMPORT <A HREF="../misc/M3.i3">M3</A>, <A HREF="#x1">M3ID</A>, <A HREF="Value.i3">Value</A>;

REVEAL
  M3.<A NAME="Value">Value</A> = M3.ValueNode BRANDED &quot;Value.T&quot; OBJECT
    name       : M3ID.T;
    extName    : M3ID.T;
    scope      : M3.Scope;
    vnext      : M3.Value; (* linked list of all values in the same module *)
    checkDepth : BITS 12 FOR [-2048..2047];
    class      : BITS 4 FOR Value.Class;
    checked    : M3.Flag;
    readonly   : M3.Flag;
    external   : M3.Flag;
    unused     : M3.Flag;
    obsolete   : M3.Flag;
    up_level   : M3.Flag;
    error      : M3.Flag; (* reset in each compilation *)
    used       : M3.Flag; (* reset in each compilation *)
    declared   : M3.Flag; (* reset in each compilation *)
    compiled   : M3.Flag; (* reset in each compilation *)
    imported   : M3.Flag; (* reset in each compilation *)
    exported   : M3.Flag; (* reset in each compilation *)
    exportable : M3.Flag; (* reset in each compilation *)
    inTypeOf   : M3.Flag; (* reset in each compilation *)
    inToExpr   : M3.Flag; (* reset in each compilation *)
    inToType   : M3.Flag; (* reset in each compilation *)
  METHODS
    typeCheck   (VAR cs: M3.CheckState);
    set_globals ()                        := NoInit;
    load        ()                        := NoLoader;
    declare     (): BOOLEAN               := Never;
    need_init   (): BOOLEAN               := Never;
    lang_init   ()                        := NoInit;
    user_init   ()                        := NoInit;
    toExpr      (): M3.Expr               := NoExpr;
    toType      (): M3.Type               := NoType;
    typeOf      (): M3.Type               := NoType;
    base        (): M3.Value              := Self;
    add_fp_tag  (VAR x: M3.FPInfo): CARDINAL;
    fp_type     (): M3.Type;
  END;

PROCEDURE <A HREF="Value.m3#Init">Init</A> (v: M3.Value;  name: M3ID.T;  c: Value.Class);
</PRE><BLOCKQUOTE><EM> initializes a Value.T </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#FPStart">FPStart</A> (v: M3.Value;  VAR x: M3.FPInfo; tag: TEXT;
                   offset: INTEGER;  global: BOOLEAN);
</PRE><BLOCKQUOTE><EM> add <CODE>tag</CODE>, the name, external name, and offset of 'v' to 'x's buffer </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#NoExpr">NoExpr</A> (v: M3.Value): M3.Expr;
</PRE><BLOCKQUOTE><EM> == ASSERT (FALSE) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#NoType">NoType</A> (v: M3.Value): M3.Type;
</PRE><BLOCKQUOTE><EM> == ASSERT (FALSE) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#NoLoader">NoLoader</A> (v: M3.Value);
</PRE><BLOCKQUOTE><EM> == ASSERT (FALSE) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#Never">Never</A> (v: M3.Value): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns FALSE </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#NoInit">NoInit</A> (v: M3.Value);
</PRE><BLOCKQUOTE><EM> == noop </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#Always">Always</A> (v: M3.Value): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns TRUE </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#TypeVoid">TypeVoid</A> (v: M3.Value): M3.Type;
</PRE><BLOCKQUOTE><EM> == RETURN Void.T </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Value.m3#Self">Self</A> (v: M3.Value): M3.Value;
</PRE><BLOCKQUOTE><EM> == RETURN v </EM></BLOCKQUOTE><PRE>

END ValueRep.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
