<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxCheck.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxCheck.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: MxCheck.m3                                            
 Last Modified On Mon Sep 19 14:29:36 PDT 1994 By kalsow     
      Modified On Wed May 26 15:47:11 PDT 1993 By muller     

<P><PRE>MODULE <module><implements><A HREF="MxCheck.i3">MxCheck</A></implements></module>;

IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../word/src/Word.i3">Word</A>;
IMPORT <A HREF="Mx.i3">Mx</A>, <A HREF="MxRep.i3">MxRep</A>, <A HREF="MxMap.i3">MxMap</A>, <A HREF="#x1">M3ID</A>, <A HREF="MxSet.i3">MxSet</A>, <A HREF="MxVS.i3">MxVS</A>, <A HREF="MxVSSet.i3">MxVSSet</A>;
&lt;*FATAL Wr.Failure, Thread.Alerted*&gt;

CONST
  Margin = 78;

TYPE
  State = RECORD
    base       : Mx.LinkSet;
    errors     : Wr.T;
    failed     : BOOLEAN     := FALSE;
    opaques    : MxMap.T     := NIL; (* type name -&gt; OpaqueInfo *)
    all_opaques: OpaqueInfo  := NIL;
    import_err : ImportError := NIL;
    err_width  : INTEGER     := 0;
    bad_vs     : MxVS.Info;
  END;

TYPE
  UnitProc = PROCEDURE (VAR s: State;  u: Mx.Unit);

TYPE
  ImportError = REF RECORD
    import_name : Mx.Name;
    importer    : Mx.Unit;
    next        : ImportError;
  END;

TYPE
  OpaqueInfo = REF RECORD
    next   : OpaqueInfo     := NIL;
    type   : Mx.OpaqueType  := NIL;
    t_unit : Mx.Unit        := NIL;
    reveal : Mx.Revelation  := NIL;
    r_unit : Mx.Unit        := NIL;
  END;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="IsProgram"><procedure>IsProgram</procedure></A> (base: Mx.LinkSet;  errors : Wr.T): BOOLEAN =
  VAR s: State;
  BEGIN
    InitState (s, base, errors);
    CheckUnits (s);    IF (s.failed) THEN RETURN FALSE END;
    CheckMain (s);     IF (s.failed) THEN RETURN FALSE END;
    CheckStamps (s);   IF (s.failed) THEN RETURN FALSE END;
    CheckOpaques (s);  IF (s.failed) THEN RETURN FALSE END;
    RETURN TRUE;
  END IsProgram;

PROCEDURE <A NAME="IsLibrary"><procedure>IsLibrary</procedure></A> (base: Mx.LinkSet;  errors : Wr.T): BOOLEAN =
  VAR s: State;
  BEGIN
    InitState (s, base, errors);
    CheckUnits (s);    IF (s.failed) THEN RETURN FALSE END;
    RETURN TRUE;
  END IsLibrary;

PROCEDURE <A NAME="InitState"><procedure>InitState</procedure></A> (VAR s: State;  base: Mx.LinkSet;  errors: Wr.T) =
  BEGIN
    s.base       := base;
    s.errors     := errors;
    s.failed     := FALSE;
  END InitState;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="CheckUnits"><procedure>CheckUnits</procedure></A> (VAR s: State) =
  BEGIN
    s.import_err := NIL;

    (* make sure that there are no virtual units remaining *)
    ForEachUnit (s, CheckVirtualUnit);

    (* check to make sure that all imports and exports are satisfied *)
    ForEachUnit (s, CheckUnitImports);

    IF (s.import_err # NIL) THEN DumpImportErrors (s, s.import_err) END;
  END CheckUnits;

PROCEDURE <A NAME="CheckVirtualUnit"><procedure>CheckVirtualUnit</procedure></A> (VAR s: State;  u: Mx.Unit) =
  BEGIN
    IF (u.virtual) THEN
      s.import_err := NEW (ImportError, next := s.import_err, importer := u,
                           import_name := LAST(Mx.Name));
    END;
  END CheckVirtualUnit;

PROCEDURE <A NAME="CheckUnitImports"><procedure>CheckUnitImports</procedure></A> (VAR s: State;  u: Mx.Unit) =
  BEGIN
    CheckUnitList (s, u, u.imported_units);
    CheckUnitList (s, u, u.exported_units);
    CheckUnitList (s, u, u.used_interfaces);
  END CheckUnitImports;

PROCEDURE <A NAME="CheckUnitList"><procedure>CheckUnitList</procedure></A> (VAR s: State;  u: Mx.Unit;  READONLY n: Mx.InfoList) =
  VAR nm: INTEGER;
  BEGIN
    FOR i := n.start TO n.start + n.cnt - 1 DO
      nm := u.info [i];
      IF MxMap.Get (s.base.interfaces, nm) = NIL THEN
        s.import_err := NEW (ImportError, next := s.import_err, importer := u,
                             import_name := nm);
      END;
    END;
  END CheckUnitList;

PROCEDURE <A NAME="DumpImportErrors"><procedure>DumpImportErrors</procedure></A> (VAR s: State;  err: ImportError) =
  VAR new, match, tmp: ImportError;
  BEGIN
    WHILE (err # NIL) DO
      new := NIL;
      match := err;
      err := err.next;
      match.next := NIL;
      WHILE (err # NIL) DO
        tmp := err.next;
        IF (err.import_name = match.import_name)
          THEN err.next := match;  match := err;
          ELSE err.next := new;    new := err;
        END;
        err := tmp;
      END;
      IF (match.import_name = LAST (Mx.Name))
        THEN DumpMissingUnit (s, match);
        ELSE DumpImportErrorList (s, match);
      END;
      err := new;
    END;
  END DumpImportErrors;

PROCEDURE <A NAME="DumpImportErrorList"><procedure>DumpImportErrorList</procedure></A> (VAR s: State;  err: ImportError) =
  VAR name := M3ID.ToText (err.import_name);
  BEGIN
    Err (s, &quot;missing compiled interface \&quot;&quot;, name, &quot;.io\&quot; imported by:  &quot;);
    WHILE (err # NIL) DO
      Err (s, MxRep.UnitName (err.importer), &quot;  &quot;);
      err := err.next;
    END;
    ErrNL (s);
  END DumpImportErrorList;

PROCEDURE <A NAME="DumpMissingUnit"><procedure>DumpMissingUnit</procedure></A> (VAR s: State;  err: ImportError) =
  CONST RSym = ARRAY BOOLEAN OF TEXT { &quot; = &quot;, &quot; &lt;: &quot; };
  VAR u_name: TEXT;  x: ImportError;
      r: Mx.Revelation;  o: Mx.ObjectType;  u: Mx.Unit;
  BEGIN
    x := err;
    WHILE (x # NIL) DO
      u := x.importer;
      u_name := MxRep.UnitName (u);
      IF (u.export_def_syms.cnt + u.export_use_syms.cnt &gt; 0) THEN
        Err (s, u_name, &quot;: missing exported symbols:  &quot;);
        DumpVSList (s, u, u.export_def_syms);
        DumpVSList (s, u, u.export_use_syms);
        ErrNL (s);
      END;
      r := u.revelations;
      IF (r # NIL) THEN
        Err (s, u_name, &quot;: missing revelations:  &quot;);
        WHILE (r # NIL) DO
          Err (s, TName (s, r.lhs), RSym[r.partial], TName (s, r.rhs), &quot;   &quot;);
          r := r.next;
        END;
        ErrNL (s);
      END;
      o := u.exported_objects;
      IF (o # NIL) THEN
        Err (s, u_name, &quot;: missing object types:  &quot;);
        WHILE (o # NIL) DO
          Err (s, TName (s, o.type), &quot;  &quot;);
          o := o.next;
        END;
        ErrNL (s);
      END;
      DumpClients (s, u);
      x := x.next;
    END;
  END DumpMissingUnit;

PROCEDURE <A NAME="DumpVSList"><procedure>DumpVSList</procedure></A> (VAR s: State;  u: Mx.Unit;  READONLY z: Mx.InfoList) =
  VAR info: MxVS.Info;
  BEGIN
    FOR i := z.start TO z.start + z.cnt - 1 DO
       MxVS.Get (u.info[i], info);
       Err (s, M3ID.ToText (info.source), &quot;.&quot;,
               M3ID.ToText (info.symbol),&quot;  &quot;);
    END;
  END DumpVSList;

PROCEDURE <A NAME="DumpClients"><procedure>DumpClients</procedure></A> (VAR s: State;  u: Mx.Unit) =
  VAR cl: MxSet.T;  ux: Mx.UnitList;
  BEGIN
    cl := MxMap.Get (s.base.clients, u.name);
    ux := MxSet.ToList (cl);
    IF (ux = NIL) THEN RETURN; END;
    Err (s, &quot;imported by:  &quot;);
    WHILE (ux # NIL) DO
      IF (ux.unit # u) THEN
        Err (s, MxRep.UnitName (ux.unit), &quot;  &quot;);
      END;
      ux := ux.next;
    END;
    ErrNL (s);
  END DumpClients;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="CheckMain"><procedure>CheckMain</procedure></A> (VAR s: State) =
  (* check to make sure that &quot;Main&quot; is exported *)
  VAR main := M3ID.Add (&quot;Main&quot;);
  VAR unit := MxMap.Get (s.base.interfaces, main);
  BEGIN
    IF (unit = NIL) THEN
      Err (s, &quot;missing \&quot;Main\&quot; module&quot;, Wr.EOL);
      ErrNL (s);
    END;
  END CheckMain;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="CheckStamps"><procedure>CheckStamps</procedure></A> (VAR s: State) =
  VAR c: MxVSSet.Contents;  vs: MxVS.T;
  BEGIN
    (* make sure that every defined stamp is implemented *)
    c := MxVSSet.GetData (s.base.vs_exports);
    FOR i := 0 TO LAST (c^) DO
      vs := c[i];
      IF (vs # MxVS.NoVS) THEN
        IF MxVSSet.Get (s.base.vs_impls, vs) = MxVS.NoVS THEN
          DumpStamp (s, vs, &quot;: is exported, but not implemented:  &quot;);
        END;
      END;
    END;

    (* make sure that every implemented stamp is defined *)
    c := MxVSSet.GetData (s.base.vs_impls);
    FOR i := 0 TO LAST (c^) DO
      vs := c[i];
      IF (vs # MxVS.NoVS) THEN
        IF MxVSSet.Get (s.base.vs_exports, vs) = MxVS.NoVS THEN
          DumpStamp (s, vs, &quot;: is implemented, but not exported:  &quot;);
        END;
      END;
    END;
  END CheckStamps;

PROCEDURE <A NAME="DumpStamp"><procedure>DumpStamp</procedure></A> (VAR s: State;  vs: MxVS.T;  msg: TEXT) =
  VAR info: MxVS.Info;
  BEGIN
    MxVS.Get (vs, info);
    Err (s, M3ID.ToText (info.source), &quot;.&quot;);
    Err (s, M3ID.ToText (info.symbol), msg);
    MxVS.Get (vs, s.bad_vs);
    ForEachUnit (s, DumpBadVS);
    ErrNL (s);
  END DumpStamp;

PROCEDURE <A NAME="DumpBadVS"><procedure>DumpBadVS</procedure></A> (VAR s: State;  u: Mx.Unit) =
  BEGIN
    IF   DumpBadVStamps (s, u, u.export_def_syms, s.bad_vs)
      OR DumpBadVStamps (s, u, u.export_use_syms, s.bad_vs)
      OR DumpBadVStamps (s, u, u.import_def_syms, s.bad_vs)
      OR DumpBadVStamps (s, u, u.import_use_syms, s.bad_vs) THEN
    END;
  END DumpBadVS;

PROCEDURE <A NAME="DumpBadVStamps"><procedure>DumpBadVStamps</procedure></A> (VAR s: State;  u: Mx.Unit;  READONLY z: Mx.InfoList;
                          READONLY bad: MxVS.Info): BOOLEAN =
  VAR info: MxVS.Info;  vs: MxVS.T;
  BEGIN
    FOR i := z.start TO z.start + z.cnt - 1 DO
      vs := u.info [i];
      MxVS.Get (vs, info);
      IF (info.source = bad.source) AND (info.symbol = bad.symbol) THEN
        Err (s, MxRep.UnitName (u), &quot;  &quot;);
        RETURN TRUE;
      END;
    END;
    RETURN FALSE;
  END DumpBadVStamps;
</PRE><BLOCKQUOTE><EM>------------------------------------------------------------------------</EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="CheckOpaques"><procedure>CheckOpaques</procedure></A> (VAR s: State) =
  VAR o: OpaqueInfo;
  BEGIN
    s.opaques := MxMap.New (503);
    ForEachUnit (s, NoteOpaques);
    ForEachUnit (s, IdentifyOpaques);
    o := s.all_opaques;
    WHILE (o # NIL) DO
      IF (o.reveal = NIL) THEN
        Err (s, &quot;opaque type never revealed: &quot;, TName (s, o.type.type));
        ErrNL (s);
        Err (s, &quot;  defined in &quot;, MxRep.UnitName (o.t_unit));
        ErrNL (s);
      END;
      o := o.next;
    END;
  END CheckOpaques;

PROCEDURE <A NAME="NoteOpaques"><procedure>NoteOpaques</procedure></A> (VAR s: State;  u: Mx.Unit) =
  VAR o: Mx.OpaqueType;  z: OpaqueInfo;
  BEGIN
    o := u.opaques;
    WHILE (o # NIL) DO
      z := MxMap.Get (s.opaques, o.type);
      IF (z # NIL) THEN
        Err (s, &quot;opaque type defined twice: &quot;, TName (s, z.type.type));
        ErrNL (s);
        Err (s, &quot;  defined in  &quot;, MxRep.UnitName (z.t_unit));  ErrNL (s);
        Err (s, &quot;  and also    &quot;, MxRep.UnitName (u));         ErrNL (s);
      ELSE
        z := NEW (OpaqueInfo, type := o, t_unit := u, next:= s.all_opaques);
        s.all_opaques := z;
        MxMap.Insert (s.opaques, o.type, z);
      END;
      o := o.next;
    END;
  END NoteOpaques;

PROCEDURE <A NAME="IdentifyOpaques"><procedure>IdentifyOpaques</procedure></A> (VAR s: State;  u: Mx.Unit) =
  VAR z: OpaqueInfo;  r := u.revelations;
  BEGIN
    WHILE (r # NIL) DO
      IF (r.partial) OR (NOT r.export) THEN
        (* ignore for now *)
      ELSE
        z := MxMap.Get (s.opaques, r.lhs);
        IF (z # NIL) THEN
          IF (z.reveal # NIL) THEN
            Err (s, &quot;multiple revelations for opaque type:  &quot;,
                     TName(s, z.type.type));                       ErrNL (s);
            Err (s, &quot;  defined in  &quot;, MxRep.UnitName (z.t_unit));  ErrNL (s);
            Err (s, &quot;  revealed in &quot;, MxRep.UnitName (z.r_unit));  ErrNL (s);
            Err (s, &quot;  and also in &quot;, MxRep.UnitName (u));         ErrNL (s);
          ELSE
            z.reveal := r;
            z.r_unit := u;
          END;
        ELSE
          Err (s, &quot;revelation without matching opaque type declaration:  &quot;,
                   TName (s, r.lhs));  ErrNL (s);
          Err (s, &quot;  revealed in &quot;, MxRep.UnitName (u));  ErrNL (s);
        END;
      END;
      r := r.next;
    END;
  END IdentifyOpaques;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="ForEachUnit"><procedure>ForEachUnit</procedure></A> (VAR s: State;  p: UnitProc) =
  VAR x: MxMap.Contents;  u: Mx.Unit;
  BEGIN
    x := MxMap.GetData (s.base.interfaces);
    FOR i := 0 TO LAST (x^) DO
      u := x[i].value;
      IF (u # NIL) THEN p (s, u) END;
    END;
    x := MxMap.GetData (s.base.modules);
    FOR i := 0 TO LAST (x^) DO
      u := x[i].value;
      IF (u # NIL) THEN p (s, u) END;
    END;
    x := MxMap.GetData (s.base.virtuals);
    FOR i := 0 TO LAST (x^) DO
      u := x[i].value;
      IF (u # NIL) THEN p (s, u) END;
    END;
  END ForEachUnit;

PROCEDURE <A NAME="TName"><procedure>TName</procedure></A> (&lt;*UNUSED*&gt; VAR s: State;  t: Mx.TypeName): TEXT =
  BEGIN
    RETURN &quot;_t&quot; &amp; Fmt.Unsigned (Word.And (t, 16_ffffffff), 16);
  END TName;

PROCEDURE <A NAME="Err"><procedure>Err</procedure></A> (VAR s: State;  a, b, c, d: TEXT := NIL) =
  VAR len: INTEGER;
  BEGIN
    s.failed := TRUE;
    IF (s.errors = NIL) THEN RETURN END;

    len := 0;
    IF (a # NIL) THEN INC (len, Text.Length (a)); END;
    IF (b # NIL) THEN INC (len, Text.Length (b)); END;
    IF (c # NIL) THEN INC (len, Text.Length (c)); END;
    IF (d # NIL) THEN INC (len, Text.Length (d)); END;

    IF (s.err_width + len &gt; Margin) THEN
      Wr.PutText (s.errors, Wr.EOL);
      Wr.PutText (s.errors, &quot;   &quot;);
      s.err_width := 3;
    END;

    IF (a # NIL) THEN Wr.PutText (s.errors, a); END;
    IF (b # NIL) THEN Wr.PutText (s.errors, b); END;
    IF (c # NIL) THEN Wr.PutText (s.errors, c); END;
    IF (d # NIL) THEN Wr.PutText (s.errors, d); END;
    INC (s.err_width, len);
  END Err;

PROCEDURE <A NAME="ErrNL"><procedure>ErrNL</procedure></A> (VAR s: State) =
  BEGIN
    IF (s.errors = NIL) THEN RETURN END;
    IF (s.err_width &gt; 0) THEN
      Wr.PutText (s.errors, Wr.EOL);
      s.err_width := 0;
    END;
  END ErrNL;

BEGIN
END MxCheck.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
