<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxIO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxIO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: Mx.m3                                                 
 Last Modified On Mon Sep 19 14:22:36 PDT 1994 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="MxIO.i3">MxIO</A></implements></module>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../m3middle/src/M3FP.i3">M3FP</A>, <A HREF="../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="Mx.i3">Mx</A>;

CONST
  HexDigit = ARRAY [0..15] OF CHAR {
                 '0','1','2','3','4','5','6','7',
                 '8','9','a','b','c','d','e','f' };

PROCEDURE <A NAME="PutTxt"><procedure>PutTxt</procedure></A> (wr: M3Buf.T;  a, b, c, d, e: TEXT := NIL) =
  BEGIN
    IF (a # NIL) THEN M3Buf.PutText (wr, a); END;
    IF (b # NIL) THEN M3Buf.PutText (wr, b); END;
    IF (c # NIL) THEN M3Buf.PutText (wr, c); END;
    IF (d # NIL) THEN M3Buf.PutText (wr, d); END;
    IF (e # NIL) THEN M3Buf.PutText (wr, e); END;
  END PutTxt;

PROCEDURE <A NAME="PutCh"><procedure>PutCh</procedure></A>  (wr: M3Buf.T;  ch: CHAR) =
  BEGIN
    M3Buf.PutChar (wr, ch);
  END PutCh;

PROCEDURE <A NAME="PutInt"><procedure>PutInt</procedure></A> (wr: M3Buf.T;  i: INTEGER;  ch: TEXT) =
  BEGIN
    M3Buf.PutInt (wr, i);
    M3Buf.PutText (wr, ch);
  END PutInt;

PROCEDURE <A NAME="PutFP"><procedure>PutFP</procedure></A> (wr: M3Buf.T;  READONLY x: M3FP.T;  ch: TEXT) =
  VAR n, j: INTEGER;  buf: ARRAY [0 .. 2 * NUMBER (x.byte) - 1] OF CHAR;
  BEGIN
    j := 0;
    FOR i := FIRST (x.byte) TO LAST (x.byte) DO
      n := x.byte[i];
      buf[j] := HexDigit [Word.RightShift (n, 4)];  INC (j);
      buf[j] := HexDigit [Word.And (n, 16_f)];      INC (j);
    END;
    M3Buf.PutSub (wr, buf);
    M3Buf.PutText (wr, ch);
  END PutFP;

PROCEDURE <A NAME="PutHex"><procedure>PutHex</procedure></A> (wr: M3Buf.T;  xx: Mx.Int32;  ch: TEXT) =
  VAR buf: ARRAY [0..7] OF CHAR;  x: INTEGER := xx;
  BEGIN
    FOR j := 7 TO 0 BY -1 DO
      buf[j] := HexDigit [Word.Mod (x, 16)];
      x := Word.Divide (x, 16);
    END;
    M3Buf.PutSub (wr, buf);
    M3Buf.PutText (wr, ch);
  END PutHex;

BEGIN
END MxIO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
