<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxIn.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxIn.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: MxIn.m3                                               
 Last Modified On Thu Jan 26 14:22:57 PST 1995 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="MxIn.i3">MxIn</A></implements></module>;

IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../os/src/Common/File.i3">File</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>;
IMPORT <A HREF="Mx.i3">Mx</A>, <A HREF="MxRep.i3">MxRep</A>, <A HREF="#x1">M3ID</A>, <A HREF="../../m3middle/src/M3FP.i3">M3FP</A>, <A HREF="../../m3middle/src/M3File.i3">M3File</A>, <A HREF="MxVS.i3">MxVS</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>;
&lt;*FATAL Wr.Failure, Thread.Alerted*&gt;

CONST
  End_of_buffer = '\000';
  Buffer_size   = 1024;
  N_stop_chars  = 5;  (* SPACE, NEWLINE, '*', EOB, QUOTE *)

CONST
  SignBit    = Word.LeftShift (1, 31);
  SignExtend = Word.LeftShift (Word.Not (0), 31);

TYPE
  State = RECORD
    cmd       : CHAR;
    input     : File.T        := NIL;
    errors    : Wr.T          := NIL;
    nErrors   : INTEGER       := 0;
    units     : Mx.UnitList   := NIL;
    cur_file  : Mx.File       := NIL;
    cur_unit  : Mx.Unit       := NIL;
    nameMap   : NameMap       := NIL;
    vsMap     : VSMap         := NIL;
    buf_ptr   : CARDINAL      := 0;
    buf_len   : CARDINAL      := 0;
    buf       : ARRAY [0..Buffer_size + N_stop_chars - 1] OF CHAR;
  END;

TYPE
  VSMap    = REF ARRAY OF MxVS.T;
  NameMap  = REF ARRAY OF Mx.Name;

TYPE
  CmdProc = PROCEDURE (VAR s: State): BOOLEAN RAISES {OSError.E};

EXCEPTION
  SyntaxError;

VAR
  HexDigit : ARRAY CHAR OF [0..16];
  CmdMap   : ARRAY CHAR OF CmdProc;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="ReadUnits"><procedure>ReadUnits</procedure></A> (input    : File.T;
                     filename : TEXT;
                     imported : BOOLEAN;
                     errors   : Wr.T): Mx.UnitList =
  VAR s: State;
  BEGIN
    s.input    := input;
    s.errors   := errors;
    s.cur_file := NEW (Mx.File, name := filename, imported := imported);
    s.nameMap  := NEW (NameMap, 256);
    s.vsMap    := NEW (VSMap, 4100);

    TRY
      ReadLinkFile (s);
    EXCEPT
    | OSError.E(args) =&gt; Error (s, &quot;I/O failure&quot;, ErrMsg(args));
    | SyntaxError     =&gt; (* already reported something *)
    END;

    IF (s.nErrors &gt; 0)
      THEN RETURN NIL
      ELSE RETURN s.units;
    END;
  END ReadUnits;

PROCEDURE <A NAME="ErrMsg"><procedure>ErrMsg</procedure></A> (args: AtomList.T): TEXT =
  VAR msg : TEXT := NIL;
  BEGIN
    WHILE (args # NIL) DO
      IF (msg = NIL) THEN  msg := &quot;: &quot;;  ELSE  msg := msg &amp; &quot;  ***  &quot;;  END;
      msg  := msg &amp; Atom.ToText (args.head);
      args := args.tail;
    END;
    RETURN msg;
  END ErrMsg;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="ReadLinkFile"><procedure>ReadLinkFile</procedure></A> (VAR s: State)
  RAISES {OSError.E, SyntaxError} =
  BEGIN
    RefillBuffer (s);
    ReadMagic (s);
    LOOP
      s.cmd := s.buf [s.buf_ptr];
      INC (s.buf_ptr);
      IF CmdMap [s.cmd] (s) THEN EXIT END;
    END;
  END ReadLinkFile;

PROCEDURE <A NAME="ReadMagic"><procedure>ReadMagic</procedure></A> (VAR s: State)
  RAISES {OSError.E, SyntaxError} =
  BEGIN
    FOR i := 0 TO Text.Length (Mx.LinkerMagic) - 1 DO
      Match (s, Text.GetChar (Mx.LinkerMagic, i));
    END;
    Match (s, '\n');
  END ReadMagic;

PROCEDURE <A NAME="Match"><procedure>Match</procedure></A> (VAR s: State;  ch: CHAR)
  RAISES {OSError.E, SyntaxError} =
  VAR c2 := GetC (s);
  BEGIN
    IF (ch # c2) THEN
      Error (s, &quot;bad linkfile (unrecognized header)&quot;);
      RAISE SyntaxError;
    END;
  END Match;

PROCEDURE <A NAME="EndBuffer"><procedure>EndBuffer</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  BEGIN
    IF EOF (s) THEN RETURN TRUE END;
    RefillBuffer (s);
    RETURN FALSE;
  END EndBuffer;

PROCEDURE <A NAME="BadChar"><procedure>BadChar</procedure></A> (VAR s: State): BOOLEAN =
  BEGIN
    Error (s, &quot;unrecognized linker command: &quot;, CharName (s.cmd));
    RETURN TRUE;
  END BadChar;
</PRE>----------------------------------------------------------- global maps ---

<P><PRE>PROCEDURE <A NAME="ReadName"><procedure>ReadName</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* Nx y   --- define id number 'x' to be name 'y' *)
  VAR id := GetInteger (s, ' ');
  VAR nm := GetID      (s, '\n');
  BEGIN
    WHILE (id &gt; LAST (s.nameMap^)) DO ExpandNameMap (s) END;
    s.nameMap [id] := nm;
    RETURN FALSE;
  END ReadName;

PROCEDURE <A NAME="ExpandNameMap"><procedure>ExpandNameMap</procedure></A> (VAR s: State) =
  VAR n := NUMBER (s.nameMap^);  new := NEW (NameMap, n + n);
  BEGIN
    SUBARRAY (new^, 0, n) := s.nameMap^;
    s.nameMap := new;
  END ExpandNameMap;

PROCEDURE <A NAME="ReadVSInfo"><procedure>ReadVSInfo</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* Vx a b c --- define version stamp number 'x' for symbol 'a.b' to be 'c' *)
  VAR vs : MxVS.Info;
  VAR id := GetInteger (s, ' ');
  BEGIN
    vs.source := GetName (s, ' ');
    vs.symbol := GetName (s, ' ');
    GetStamp (s, vs.stamp, '\n');

    WHILE (id &gt; LAST (s.vsMap^)) DO ExpandVSMap (s) END;
    s.vsMap [id] := MxVS.Put (vs);
    RETURN FALSE;
  END ReadVSInfo;

PROCEDURE <A NAME="ExpandVSMap"><procedure>ExpandVSMap</procedure></A> (VAR s: State) =
  VAR n := NUMBER (s.vsMap^);  new := NEW (VSMap, n + n);
  BEGIN
    SUBARRAY (new^, 0, n) := s.vsMap^;
    s.vsMap := new;
  END ExpandVSMap;
</PRE>----------------------------------------------------------------- units ---

<P><PRE>PROCEDURE <A NAME="ReadUnit"><procedure>ReadUnit</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* In  --- Interface 'n'  *)
  (* Mn  --- Module 'n'     *)
  VAR intf                := (s.cmd = 'I');
  VAR nm                  := GetName    (s, ' ');
  VAR n_exported_units    := GetInteger (s, ' ');
  VAR n_imported_units    := GetInteger (s, ' ');
  VAR n_imported_generics := GetInteger (s, ' ');
  VAR n_used_interfaces   := GetInteger (s, ' ');
  VAR n_used_modules      := GetInteger (s, ' ');
  VAR n_import_def_syms   := GetInteger (s, ' ');
  VAR n_import_use_syms   := GetInteger (s, ' ');
  VAR n_export_def_syms   := GetInteger (s, ' ');
  VAR n_export_use_syms   := GetInteger (s, ' ');
  VAR n_imported_types    := GetInteger (s, ' ');
  VAR n_exported_types    := GetInteger (s, ' ');
  VAR n_wishes            := GetInteger (s, '\n');
  VAR unit := NEW (Mx.Unit, name := nm, file := s.cur_file, interface := intf);
  VAR node := NEW (Mx.UnitList, unit := unit, next := s.units);
  VAR n_info := 0;
  BEGIN
    unit.exported_units.start    := n_info;  INC (n_info, n_exported_units);
    unit.imported_units.start    := n_info;  INC (n_info, n_imported_units);
    unit.imported_generics.start := n_info;  INC (n_info, n_imported_generics);
    unit.used_interfaces.start   := n_info;  INC (n_info, n_used_interfaces);
    unit.used_modules.start      := n_info;  INC (n_info, n_used_modules);
    unit.import_def_syms.start   := n_info;  INC (n_info, n_import_def_syms);
    unit.import_use_syms.start   := n_info;  INC (n_info, n_import_use_syms);
    unit.export_def_syms.start   := n_info;  INC (n_info, n_export_def_syms);
    unit.export_use_syms.start   := n_info;  INC (n_info, n_export_use_syms);
    unit.imported_types.start    := n_info;  INC (n_info, n_imported_types);
    unit.exported_types.start    := n_info;  INC (n_info, n_exported_types);
    unit.wishes.start            := n_info;  INC (n_info, n_wishes);

    unit.info  := NEW (Mx.InfoVec, n_info);
    s.units    := node;
    s.cur_unit := unit;
    RETURN FALSE;
  END ReadUnit;

PROCEDURE <A NAME="AddInfo"><procedure>AddInfo</procedure></A> (u: Mx.Unit;  VAR x: Mx.InfoList;  i: INTEGER) =
  BEGIN
    u.info [x.start + x.cnt] := i;
    INC (x.cnt);
  END AddInfo;

PROCEDURE <A NAME="ReadPort"><procedure>ReadPort</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* Am  --- exports interface m *)
  (* Bm  --- imports interface m *)
  VAR export := (s.cmd = 'A');
  VAR nm     := GetName (s, '\n');
  VAR unit   := s.cur_unit;
  BEGIN
    IF (unit = NIL) THEN
      Error (s, &quot;import/export while current unit not defined!&quot;);
    ELSIF (export) THEN
      AddInfo (unit, unit.exported_units, nm);
    ELSE (* import *)
      AddInfo (unit, unit.imported_units, nm);
    END;
    RETURN FALSE;
  END ReadPort;

PROCEDURE <A NAME="ReadUse"><procedure>ReadUse</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* Cm  --- uses magic info from interface m *)
  (* Dm  --- uses magic info from module m  *)
  VAR intf := (s.cmd = 'C');
  VAR nm   := GetName (s, '\n');
  VAR unit := s.cur_unit;
  BEGIN
    IF (unit = NIL) THEN
      Error (s, &quot;magic import while current unit not defined!&quot;);
    ELSIF (intf) THEN
      AddInfo (unit, unit.used_interfaces, nm);
    ELSE (* import *)
      AddInfo (unit, unit.used_modules, nm);
    END;
    RETURN FALSE;
  END ReadUse;

PROCEDURE <A NAME="ReadGeneric"><procedure>ReadGeneric</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* gm    --- imports generic unit m *)
  VAR nm   := GetName (s, '\n');
  VAR unit := s.cur_unit;
  BEGIN
    IF (unit = NIL) THEN
      Error (s, &quot;generic import while current unit not defined!&quot;);
    ELSE
      AddInfo (unit, unit.imported_generics, nm);
    END;
    RETURN FALSE;
  END ReadGeneric;

PROCEDURE <A NAME="ReadVersionStamp"><procedure>ReadVersionStamp</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* ix       --- import version stamp 'x' *)
  (* Jx       --- import &amp; implement version stamp 'x' *)
  (* ex       --- export version stamp 'x' *)
  (* Ex       --- export &amp; implement version stamp 'x' *)
  VAR cmd  := s.cmd;
  VAR vs   := GetVS (s, '\n');
  VAR unit := s.cur_unit;
  BEGIN
    IF (unit = NIL) THEN
      Error (s, &quot;version stamps while current unit not defined!&quot;);
    ELSIF (cmd = 'J') THEN
      AddInfo (unit, unit.import_def_syms, vs);
    ELSIF (cmd = 'i') THEN
      AddInfo (unit, unit.import_use_syms, vs);
    ELSIF (cmd = 'E') THEN
      AddInfo (unit, unit.export_def_syms, vs);
    ELSE (*cmd = 'e'*)
      AddInfo (unit, unit.export_use_syms, vs);
    END;
    RETURN FALSE;
  END ReadVersionStamp;

PROCEDURE <A NAME="ReadRevelation"><procedure>ReadRevelation</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* Rn x y  --- export REVEAL 'x' = 'y'  to interface #n *)
  (* Xn x y  --- export REVEAL 'x' &lt;: 'y' to interface #n *)
  (* rn x y  --- import REVEAL 'x' = 'y'  from interface #n *)
  (* xn x y  --- import REVEAL 'x' &lt;: 'y' from interface #n *)
  VAR export  := (s.cmd = 'R') OR (s.cmd = 'X');
  VAR partial := (s.cmd = 'x') OR (s.cmd = 'X');
  VAR r       := NEW (Mx.Revelation, export := export, partial := partial);
  VAR unit    := s.cur_unit;
  BEGIN
    r.source := GetName (s, ' ');
    r.lhs    := GetTypeName (s, ' ');
    r.rhs    := GetTypeName (s, '\n');
    IF (unit = NIL) THEN
      Error (s, &quot;revelations while current unit not defined!&quot;);
    ELSE
      r.next := unit.revelations;
      unit.revelations := r;
    END;
    RETURN FALSE;
  END ReadRevelation;

PROCEDURE <A NAME="ReadWish"><procedure>ReadWish</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* wt       --- wish to know the object type 't'. *)
  VAR type := GetTypeName (s, '\n');
  VAR unit := s.cur_unit;
  BEGIN
    IF (unit = NIL) THEN
      Error (s, &quot;object wish while current unit not defined!&quot;);
    ELSE
      AddInfo (unit, unit.wishes, type);
    END;
    RETURN FALSE;
  END ReadWish;

PROCEDURE <A NAME="ReadType"><procedure>ReadType</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* tx       --- import type 'x'   *)
  (* Tx       --- export type 'x'   *)
  VAR cmd  := s.cmd;
  VAR type := GetTypeName (s, '\n');
  VAR unit := s.cur_unit;
  BEGIN
    IF (unit = NIL) THEN
      Error (s, &quot;type import/export while current unit not defined!&quot;);
    ELSIF (cmd = 't') THEN
      AddInfo (unit, unit.imported_types, type);
    ELSE
      AddInfo (unit, unit.exported_types, type);
    END;
    RETURN FALSE;
  END ReadType;

PROCEDURE <A NAME="ReadObjectType"><procedure>ReadObjectType</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* on t s ds da ms -- import object type from interface unit n    *)
  (* pn t s ds da ms -- import object type from module unit n       *)
  (* Ot s ds da ms   -- export object type 't' with supertype 's',  *)
  (*                    data size 'ds', data alignment 'da', and    *)
  (*                    method size 'ms' from unit #n               *)
  VAR export := (s.cmd = 'O');
  VAR module := (s.cmd = 'p');
  VAR obj    := NEW (Mx.ObjectType, export := export, from_module := module);
  VAR unit   := s.cur_unit;
  BEGIN
    IF (NOT export) THEN  obj.source := GetName (s, ' ') END;
    obj.type          := GetTypeName (s, ' ');
    obj.super_type    := GetTypeName (s, ' ');
    obj.data_size     := GetInteger (s, ' ');
    obj.data_align    := GetInteger (s, ' ');
    obj.method_size   := GetInteger (s, '\n');

    IF (unit = NIL) THEN
      Error (s, &quot;object info while current unit not defined!&quot;);
    ELSIF (export) THEN
      obj.source := unit.name;
      obj.from_module := NOT unit.interface;
      obj.next := unit.exported_objects;
      unit.exported_objects := obj;
    ELSE
      obj.next := unit.imported_objects;
      unit.imported_objects := obj;
    END;

    RETURN FALSE;
  END ReadObjectType;

PROCEDURE <A NAME="ReadOpaqueType"><procedure>ReadOpaqueType</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  (* Qt s     --- define opaque type 't' with supertype 's'. *)
  VAR opaque := NEW (Mx.OpaqueType);
  VAR unit   := s.cur_unit;
  BEGIN
    opaque.type       := GetTypeName (s, ' ');
    opaque.super_type := GetTypeName (s, '\n');

    IF (unit = NIL) THEN
      Error (s, &quot;opaque type defined while current unit not defined!&quot;);
    ELSE
      opaque.next := unit.opaques;
      unit.opaques := opaque;
    END;

    RETURN FALSE;
  END ReadOpaqueType;

PROCEDURE <A NAME="SkipComment"><procedure>SkipComment</procedure></A> (VAR s: State): BOOLEAN
  RAISES {OSError.E} =
  VAR ch := '/';
  BEGIN
    WHILE (ch # '\n') DO ch := GetC (s) END;
    RETURN FALSE;
  END SkipComment;

PROCEDURE <A NAME="SkipBlank"><procedure>SkipBlank</procedure></A> (&lt;*UNUSED*&gt; VAR s: State): BOOLEAN =
  BEGIN
    RETURN FALSE;
  END SkipBlank;

PROCEDURE <A NAME="GetName"><procedure>GetName</procedure></A> (VAR s: State;  term: CHAR): Mx.Name
  RAISES {OSError.E} =
  VAR id := GetInteger (s, term);
  BEGIN
    IF (0 &lt;= id) AND (id &lt; NUMBER (s.nameMap^)) THEN
      RETURN s.nameMap [id];
    ELSE
      Error (s, &quot;bad unit number: &quot; &amp; Fmt.Int (id));
      RETURN M3ID.NoID;
    END;
  END GetName;

PROCEDURE <A NAME="GetVS"><procedure>GetVS</procedure></A> (VAR s: State;  term: CHAR): MxVS.T
  RAISES {OSError.E} =
  VAR id := GetInteger (s, term);
  BEGIN
    IF (0 &lt;= id) AND (id &lt; NUMBER (s.vsMap^)) THEN
      RETURN s.vsMap [id];
    ELSE
      Error (s, &quot;bad version stamp number: &quot; &amp; Fmt.Int (id));
      RETURN MxVS.NoVS;
    END;
  END GetVS;

PROCEDURE <A NAME="GetInteger"><procedure>GetInteger</procedure></A> (VAR s: State;  term: CHAR): INTEGER
  RAISES {OSError.E} =
  VAR n   := 0;
  VAR len := 0;
  VAR ch: CHAR;
  BEGIN
    LOOP
      ch := s.buf [s.buf_ptr];
      INC (s.buf_ptr);
      IF (ch &lt; '0') OR ('9' &lt; ch) THEN
        (* NOTE: none of the stop characters are legal digits *)
        IF (s.buf_ptr &lt;= s.buf_len) THEN EXIT END;
        ch := GetC (s);
        IF (ch &lt; '0') OR ('9' &lt; ch) THEN EXIT END;
      END;
      n := 10 * n + (ORD (ch) - ORD ('0'));
      INC (len);
    END;
    IF (ch = '\r') THEN ch := GetC (s); END;
    IF (len &lt;= 0)  THEN Error (s, &quot;expected integer&quot;) END;
    IF (ch # term) THEN Error (s, &quot;expecting separator after integer&quot;) END;
    RETURN n;
  END GetInteger;

PROCEDURE <A NAME="GetTypeName"><procedure>GetTypeName</procedure></A> (VAR s: State;  term: CHAR): Mx.TypeName
  RAISES {OSError.E} =
  VAR n   := 0;
  VAR len := 0;
  VAR ch    : CHAR;
  VAR digit : INTEGER;
  BEGIN
    LOOP
      ch := s.buf [s.buf_ptr];
      INC (s.buf_ptr);
      digit := HexDigit [ch];
      IF (digit &gt; 15) THEN
        (* NOTE: none of the stop characters are legal digits *)
        IF (s.buf_ptr &lt;= s.buf_len) THEN EXIT END;
        ch := GetC (s);
        digit := HexDigit [ch];
        IF (digit &gt; 15) THEN EXIT END;
      END;
      n := Word.Plus (Word.Times (n, 16), digit);
      INC (len);
    END;
    IF (ch = '\r') THEN ch := GetC (s); END;
    IF (len &lt;= 0)  THEN Error (s, &quot;expected typename&quot;) END;
    IF (ch # term) THEN Error (s, &quot;expecting separator after typename&quot;) END;
    IF Word.And (n, SignBit) # 0 THEN  n := Word.Or (SignExtend, n);  END;
    RETURN n;
  END GetTypeName;

PROCEDURE <A NAME="GetID"><procedure>GetID</procedure></A> (VAR s: State;  term: CHAR): Mx.Name
  RAISES {OSError.E} =
</PRE><BLOCKQUOTE><EM> Note: we don't need to check for array overruns since all calls
   to GetString include a terminating character that's in the <CODE>stop set</CODE>
   at the end of the buffer </EM></BLOCKQUOTE><PRE>
  VAR stop, start, len: CARDINAL;  overflow: TEXT;  ch: CHAR;
  BEGIN
    start := s.buf_ptr;
    stop  := start;
    LOOP
      ch := s.buf[stop];
      IF (ch = '\r') THEN EXIT END;
      IF (ch = term) THEN EXIT END;
      INC (stop)
    END;

    IF (stop &lt; s.buf_len) THEN
      (* this is the simple case, the string's entirely in the buffer *)
      s.buf_ptr := stop + 1;
      RETURN M3ID.FromStr (SUBARRAY (s.buf,start,stop-start));
    END;

    overflow := &quot;&quot;;
    LOOP
      (* we've overrun the end of the buffer *)
      (* save the current string &amp; refill the buffer *)
      len := MAX (s.buf_len - start, 0);
      overflow := overflow &amp; Text.FromChars (SUBARRAY (s.buf, start, len));
      RefillBuffer (s);
      start := 0;
      stop := 0;

      IF EOF (s) THEN
        RETURN M3ID.Add (overflow);
      END;

      LOOP
        ch := s.buf[stop];
        IF (ch = '\r') THEN EXIT END;
        IF (ch = term) THEN EXIT END;
        INC (stop)
      END;

      IF (stop &lt; s.buf_len) THEN
        (* we terminated inside the buffer *)
        s.buf_ptr := stop + 1;
        len := stop - start;
        overflow := overflow &amp; Text.FromChars (SUBARRAY (s.buf, start, len));
        RETURN M3ID.Add (overflow);
      END;
    END;

  END GetID;

PROCEDURE <A NAME="GetStamp"><procedure>GetStamp</procedure></A> (VAR s: State;  VAR x: M3FP.T;  term: CHAR)
  RAISES {OSError.E} =
  VAR
    ch: CHAR;
    i, j, d1, d0: INTEGER;
    len: INTEGER := 0;
    buf: ARRAY [0..15] OF CHAR;
  BEGIN
    LOOP
      ch := GetC (s);
      IF (ch = term) THEN EXIT END;
      IF (len &gt;= NUMBER (buf)) THEN
        Error (s, &quot;version stamp too long!&quot;); EXIT;
      ELSIF (len &lt; NUMBER (buf)) THEN
        buf[len] := ch;
      END;
      INC (len);
    END;
    len := MIN (len, NUMBER (buf));

    (* convert the buffered characters into a fingerprint *)
    i := 0;  j := 0;
    WHILE (i &lt; len) DO
      d1 := HexDigit [buf[i]];  INC (i);
      d0 := HexDigit [buf[i]];  INC (i);
      IF (d1 &gt; 15) OR (d0 &gt; 15) THEN
        Error (s, &quot;illegal hex digit in version stamp&quot;);
      END;
      x.byte[j] := Word.LeftShift (d1, 4) + d0;  INC (j);
    END;

    WHILE (j &lt;= LAST (x.byte)) DO
      x.byte[j] := 0;  INC (j);
    END;
  END GetStamp;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="GetC"><procedure>GetC</procedure></A> (VAR s: State): CHAR
  RAISES {OSError.E} =
  VAR c: CHAR;
  BEGIN
    REPEAT
      IF (s.buf_ptr &gt;= s.buf_len) THEN RefillBuffer (s) END;
      c := s.buf [s.buf_ptr];
      INC (s.buf_ptr);
    UNTIL (c # '\r');   (* ignore all return characters *)
    RETURN c;
  END GetC;

PROCEDURE <A NAME="EOF"><procedure>EOF</procedure></A> (VAR s: State): BOOLEAN =
  BEGIN
    RETURN (s.buf_ptr &gt;= s.buf_len) AND (s.buf_len = 0);
  END EOF;

PROCEDURE <A NAME="RefillBuffer"><procedure>RefillBuffer</procedure></A> (VAR s: State)
  RAISES {OSError.E} =
  BEGIN
    s.buf_len := M3File.Read (s.input, s.buf, Buffer_size);
    s.buf [s.buf_len + 0] := End_of_buffer;
    s.buf [s.buf_len + 1] := ' ';
    s.buf [s.buf_len + 2] := '\n';
    s.buf [s.buf_len + 3] := '*';
    s.buf [s.buf_len + 4] := '\&quot;';
    s.buf_ptr := 0;
  END RefillBuffer;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="Error"><procedure>Error</procedure></A> (VAR s: State;  a, b, c, d: Text.T := NIL) =
  BEGIN
    INC  (s.nErrors);
    IF (s.errors = NIL) THEN RETURN END;
    IF (s.cur_file # NIL) AND (s.cur_file.name # NIL) THEN
      Wr.PutText (s.errors, s.cur_file.name);
      IF (s.cur_unit # NIL) THEN
        Wr.PutText (s.errors, &quot; (&quot;);
        Wr.PutText (s.errors, MxRep.UnitName (s.cur_unit));
        Wr.PutText (s.errors, &quot;)&quot;);
      END;
      Wr.PutText (s.errors, &quot;: &quot;);
    END;
    Wr.PutText (s.errors, &quot;ERROR: &quot;);
    IF (a # NIL) THEN Wr.PutText (s.errors, a); END;
    IF (b # NIL) THEN Wr.PutText (s.errors, b); END;
    IF (c # NIL) THEN Wr.PutText (s.errors, c); END;
    IF (d # NIL) THEN Wr.PutText (s.errors, d); END;
    Wr.PutText (s.errors, Wr.EOL);
  END Error;

PROCEDURE <A NAME="CharName"><procedure>CharName</procedure></A> (c: CHAR): Text.T =
  BEGIN
    IF (' ' &lt;= c) AND (c &lt;= '~')
      THEN RETURN &quot;\'&quot; &amp; Text.FromChar (c) &amp; &quot;\'&quot; ;
      ELSE RETURN &quot;\'\\&quot; &amp; Fmt.Pad (Fmt.Int (ORD (c), 8), 3, '0') &amp; &quot;\'&quot; ;
    END;
  END CharName;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  BEGIN
    FOR i := FIRST (HexDigit) TO LAST (HexDigit) DO HexDigit[i] := 16 END;
    FOR i := '0' TO '9' DO HexDigit [i] := ORD (i) - ORD ('0') END;
    FOR i := 'a' TO 'f' DO HexDigit [i] := ORD (i) - ORD ('a') + 10 END;
    FOR i := 'A' TO 'F' DO HexDigit [i] := ORD (i) - ORD ('A') + 10 END;

    FOR c := FIRST (CmdMap) TO LAST (CmdMap) DO CmdMap[c] := BadChar END;
    CmdMap ['N'] := ReadName;
    CmdMap ['V'] := ReadVSInfo;
    CmdMap ['I'] := ReadUnit;
    CmdMap ['M'] := ReadUnit;
    CmdMap ['A'] := ReadPort;
    CmdMap ['B'] := ReadPort;
    CmdMap ['C'] := ReadUse;
    CmdMap ['D'] := ReadUse;
    CmdMap ['g'] := ReadGeneric;
    CmdMap ['i'] := ReadVersionStamp;
    CmdMap ['J'] := ReadVersionStamp;
    CmdMap ['e'] := ReadVersionStamp;
    CmdMap ['E'] := ReadVersionStamp;
    CmdMap ['R'] := ReadRevelation;
    CmdMap ['X'] := ReadRevelation;
    CmdMap ['r'] := ReadRevelation;
    CmdMap ['x'] := ReadRevelation;
    CmdMap ['t'] := ReadType;
    CmdMap ['T'] := ReadType;
    CmdMap ['w'] := ReadWish;
    CmdMap ['o'] := ReadObjectType;
    CmdMap ['p'] := ReadObjectType;
    CmdMap ['O'] := ReadObjectType;
    CmdMap ['Q'] := ReadOpaqueType;
    CmdMap ['/'] := SkipComment;
    CmdMap [' '] := SkipBlank;
    CmdMap ['\r'] := SkipBlank;
    CmdMap ['\t'] := SkipBlank;
    CmdMap ['\n'] := SkipBlank;
    CmdMap [End_of_buffer] := EndBuffer;
  END Init;

BEGIN
  Init ();
END MxIn.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
