<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxMap.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxMap.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: MxMap.i3                                              
 Last Modified On Tue Mar 15 15:41:04 PST 1994 By kalsow     

<P><PRE>INTERFACE <interface><A HREF="MxMap.m3">MxMap</A></interface>;

TYPE <A HREF="MxMap.m3#T">T</A>     &lt;: REFANY; (* Key -&gt; Value *)
TYPE Key   = INTEGER;
TYPE Value = REFANY;

PROCEDURE <A HREF="MxMap.m3#New">New</A> (initalSize: CARDINAL): T;
</PRE><BLOCKQUOTE><EM> builds, initializes and returns a new empty map </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MxMap.m3#Get">Get</A> (t: T;  k: Key): Value;
</PRE><BLOCKQUOTE><EM> returns the element of t with key value k, NIL if no such element </EM></BLOCKQUOTE><PRE>

CONST MISSING = -1;
PROCEDURE <A HREF="MxMap.m3#GetIndex">GetIndex</A> (t: T;  k: Key): INTEGER;
</PRE><BLOCKQUOTE><EM> returns the index of the element of t with key value k,
   MISSING if no such element </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MxMap.m3#GetDirect">GetDirect</A> (t: T;  index: INTEGER): Value;
</PRE><BLOCKQUOTE><EM> returns the value of the element in t in slot index. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MxMap.m3#Insert">Insert</A> (t: T;  k: Key;  v: Value);
</PRE><BLOCKQUOTE><EM> inserts (k, v) into t. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MxMap.m3#Delete">Delete</A> (t: T;  k: Key);
</PRE><BLOCKQUOTE><EM> delete the entry of t with key value k </EM></BLOCKQUOTE><PRE>

TYPE Binding  = RECORD key: Key := 0;  value: Value := NIL; END;
TYPE Contents = REF ARRAY OF Binding;

PROCEDURE <A HREF="MxMap.m3#GetData">GetData</A> (t: T): Contents;
</PRE><BLOCKQUOTE><EM> returns the internal hash table </EM></BLOCKQUOTE><PRE>

END MxMap.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
