<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxMap.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxMap.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: MxMap.m3                                              
 Last Modified On Tue Mar 15 15:33:19 PST 1994 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="MxMap.i3">MxMap</A></implements></module>;

REVEAL
  <A NAME="T">T</A> = BRANDED &quot;MxMap.T&quot; REF RECORD
          n_used : INTEGER := 0;
          data   : Contents;
        END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (initialSize: CARDINAL): T =
  VAR t := NEW (T);
  BEGIN
    t.data := NEW (Contents, MAX (16, initialSize));
    RETURN t;
  END New;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (t: T;  k: Key): Value =
  VAR x0 := k MOD NUMBER (t.data^);
  VAR x := x0;
  BEGIN
    LOOP
      WITH z = t.data[x] DO
        IF (z.key = k) THEN RETURN z.value END;
        IF (z.value = NIL) THEN RETURN NIL END;
      END;
      INC (x);
      IF (x &gt; LAST (t.data^)) THEN x := 0 END;
      IF (x = x0) THEN RETURN NIL END;
    END;
  END Get;

PROCEDURE <A NAME="GetDirect"><procedure>GetDirect</procedure></A> (t: T;  index: INTEGER): Value =
  BEGIN
    IF (0 &lt;= index) AND (index &lt;= LAST (t.data^))
      THEN RETURN t.data[index].value;
      ELSE RETURN NIL;
    END;
  END GetDirect;

PROCEDURE <A NAME="GetIndex"><procedure>GetIndex</procedure></A> (t: T;  k: Key): INTEGER =
  VAR x0 := k MOD NUMBER (t.data^);
  VAR x := x0;
  BEGIN
    LOOP
      WITH z = t.data [x] DO
        IF (z.key = k) THEN RETURN x END;
        IF (z.value = NIL) THEN RETURN MISSING END;
      END;
      INC (x);
      IF (x &gt; LAST (t.data^)) THEN x := 0 END;
      IF (x = x0) THEN RETURN MISSING END;
    END;
  END GetIndex;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (t: T;  k: Key;  v: Value) =
  VAR x0 := k MOD NUMBER (t.data^);
  VAR x := x0;
  BEGIN
    LOOP
      WITH z = t.data [x] DO
        IF (z.key = k) THEN (* a new value for an existing key *)
          z.value := v;
          RETURN;
        ELSIF (z.value = NIL) THEN (* an empty hole =&gt; insert it here *)
          z.key   := k;
          z.value := v;
          INC (t.n_used);
          IF (2 * t.n_used &gt; NUMBER (t.data^)) THEN Expand (t) END;
          RETURN;
        END;
      END;
      INC (x);
      IF (x &gt; LAST (t.data^)) THEN x := 0 END;
      IF (x = x0) THEN (* no free slots *) Expand (t) END;
    END;
  END Insert;

PROCEDURE <A NAME="Expand"><procedure>Expand</procedure></A> (t: T) =
  VAR old := t.data;
  VAR n   := NUMBER (old^);
  BEGIN
    t.n_used := 0;
    t.data   := NEW (Contents, 2 * n);
    FOR i := 0 TO n-1 DO
      WITH z = old[i] DO
        IF (z.value # NIL) THEN Insert (t, z.key, z.value) END;
      END;
    END;
  END Expand;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A> (t: T;  k: Key) =
  VAR x0 := k MOD NUMBER (t.data^);
  VAR x := x0;  v: Value;
  BEGIN
    LOOP
      WITH z = t.data [x] DO
        IF (z.key = k) THEN (* a new value for an existing key *)
          (* this is the value to delete *)
          z.value := NIL;  DEC (t.n_used);
          EXIT;
        ELSIF (z.value = NIL) THEN
          (* an empty hole =&gt; nobody to delete *)
          RETURN;
        END;
      END;
      INC (x);
      IF (x &gt; LAST (t.data^)) THEN x := 0 END;
      IF (x = x0) THEN (* no match *) RETURN; END;
    END;

    (* reinsert the elements that may be rehashes of the target *)
    LOOP
      INC (x);
      IF (x &gt; LAST (t.data^)) THEN x := 0; END;
      WITH z = t.data[x] DO
        v := z.value;
        IF (v = NIL) THEN (* the end of the rehash chain *) RETURN; END;
        z.value := NIL;  DEC (t.n_used);
        Insert (t, z.key, v);
      END;
    END;

  END Delete;

PROCEDURE <A NAME="GetData"><procedure>GetData</procedure></A> (t: T): Contents =
  BEGIN
    IF (t = NIL)
      THEN RETURN NIL
      ELSE RETURN t.data;
    END;
  END GetData;

BEGIN
END MxMap.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
