<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxMerge.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxMerge.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: MxMerge.m3                                            
 Last Modified On Thu Jan 26 14:37:15 PST 1995 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="MxMerge.i3">MxMerge</A></implements></module>;

IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../../m3middle/src/M3FP.i3">M3FP</A>, <A HREF="../../m3middle/src/M3Buf.i3">M3Buf</A>;
IMPORT <A HREF="Mx.i3">Mx</A>, <A HREF="MxRep.i3">MxRep</A>, <A HREF="MxMap.i3">MxMap</A>, <A HREF="MxVS.i3">MxVS</A>, <A HREF="MxSet.i3">MxSet</A>, <A HREF="MxVSSet.i3">MxVSSet</A>, <A HREF="MxIO.i3">MxIO</A>;

CONST
  Margin = 72;

TYPE
  State = RECORD
    unit    : Mx.Unit;
    base    : Mx.LinkSet;
    errs    : Wr.T;
    err_buf : M3Buf.T;
    failed  : BOOLEAN;
  END;
</PRE>------------------------------------------------------------------------

<P>
<P><PRE>PROCEDURE <A NAME="MergeUnit"><procedure>MergeUnit</procedure></A> (unit   : Mx.Unit;
                     base   : Mx.LinkSet;
                     errors : Wr.T): Mx.UnitList =
  VAR s: State;  v: Mx.Unit;  map: MxMap.T;  cl: MxSet.T;
  BEGIN
    IF (unit = NIL) THEN RETURN NIL END;
    &lt;*ASSERT base # NIL*&gt;

    s.unit   := unit;
    s.base   := base;
    s.errs   := errors;
    s.failed := FALSE;

    (* check for an existing unit *)
    IF (unit.interface)
      THEN map := s.base.interfaces;
      ELSE map := s.base.modules;
    END;
    v := MxMap.Get (map, unit.name);
    IF (v # NIL) THEN
      RETURN Flush (s, DuplicateUnit (s, unit, v));
    END;

    (* check the existing symbols with the new ones *)
    CheckUnit (s, unit);
    IF (s.failed) THEN
      RETURN Flush (s, NEW (Mx.UnitList, next := NIL, unit := unit));
    END;

    (* add the new unit *)
    MxMap.Insert (map, unit.name, unit);

    (* and merge its symbols *)
    AddStamps (s, unit.export_def_syms, TRUE, TRUE);
    AddStamps (s, unit.export_use_syms, TRUE, FALSE);
    AddStamps (s, unit.import_def_syms, FALSE, TRUE);
    AddStamps (s, unit.import_use_syms, FALSE, FALSE);
    AddObjects (s, unit.imported_objects);
    AddRevelations (s, unit.revelations);
    AddExportedTypes (s, unit.exported_types);

    (* delete any existing virtual unit *)
    MxMap.Delete (s.base.virtuals, unit.name);

    (* and recheck any clients of the old virtual unit *)
    cl := MxMap.Get (s.base.clients, unit.name);
    IF (cl # NIL) THEN
      MxMap.Delete (s.base.clients, unit.name);
      RETURN Flush (s, FilterClients (s, MxSet.ToList (cl)));
    END;

    RETURN Flush (s, NIL);
  END MergeUnit;

PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A> (VAR s: State;  ux: Mx.UnitList): Mx.UnitList =
  BEGIN
    IF (s.errs # NIL) AND (s.err_buf # NIL) THEN
      M3Buf.Flush (s.err_buf, s.errs);
    END;
    RETURN ux;
  END Flush;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="CheckUnit"><procedure>CheckUnit</procedure></A> (VAR s: State;  u: Mx.Unit) =
  BEGIN
    CheckStamps (s, u, u.export_def_syms, TRUE, TRUE);
    IF (s.failed) AND (s.errs = NIL) THEN RETURN END;
    CheckStamps (s, u, u.export_use_syms, TRUE, FALSE);
    IF (s.failed) AND (s.errs = NIL) THEN RETURN END;
    CheckStamps (s, u, u.import_def_syms, FALSE, TRUE);
    IF (s.failed) AND (s.errs = NIL) THEN RETURN END;
    CheckStamps (s, u, u.import_use_syms, FALSE, FALSE);
    IF (s.failed) AND (s.errs = NIL) THEN RETURN END;

    CheckImportedTypes (s, u.imported_types);
    IF (s.failed) AND (s.errs = NIL) THEN RETURN END;
    CheckObjects (s, u.exported_objects);
    IF (s.failed) AND (s.errs = NIL) THEN RETURN END;
    CheckObjects (s, u.imported_objects);
    IF (s.failed) AND (s.errs = NIL) THEN RETURN END;
    CheckRevelations (s, u.revelations);
  END CheckUnit;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="DuplicateUnit"><procedure>DuplicateUnit</procedure></A> (VAR s: State;  u, v: Mx.Unit): Mx.UnitList =
  VAR errs := NEW (Mx.UnitList, next := NIL, unit := u);
  BEGIN
    s.failed := TRUE;
    IF (s.errs = NIL) THEN RETURN errs; END;
    Out (s, &quot;duplicate &quot;, MxRep.UnitName (u), &quot;:&quot;, Wr.EOL);
    Out (s, &quot;  in &quot;, u.file.name, Wr.EOL);
    Out (s, &quot; and &quot;, v.file.name, Wr.EOL);
    RETURN errs;
  END DuplicateUnit;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="CheckStamps"><procedure>CheckStamps</procedure></A> (VAR s: State;  u: Mx.Unit;
                       READONLY z: Mx.InfoList;
                       export, implement: BOOLEAN)=
  VAR uu: Mx.Unit;  vs, x: MxVS.T;
  BEGIN
    FOR i := z.start TO z.start + z.cnt - 1 DO
      vs := u.info[i];
      MxRep.GetStamp (s.base, s.base.vs_exports, vs, uu, x);
      IF (uu = NIL) AND (x = MxVS.NoVS) THEN
        (* ok, we'll add a virtual unit later *)
      ELSIF (x = MxVS.NoVS) THEN
        (* we don't know about this stamp yet *)
        IF (NOT uu.virtual) THEN
          (* it's too late to add another stamp *)
          IF MissingStamp (s, vs) THEN EXIT; END;
        END;
      ELSIF (x # vs) THEN
        IF BadStamps (s, uu, x, vs) THEN EXIT END;
      ELSIF (export) THEN
        (* this is the primary declaration *)
        IF NOT uu.virtual THEN
          IF DuplicateStamp (s, uu, x) THEN EXIT END;
        END;
      END;

      IF (implement) THEN
        (* check for a duplicate implementation *)
        MxRep.GetStamp (s.base, s.base.vs_impls, vs, uu, x);
        IF (x # MxVS.NoVS) THEN
          IF DuplicateStampImpl (s, uu, x) THEN EXIT END;
        END;
      END;
    END;
  END CheckStamps;

PROCEDURE <A NAME="ReCheckStamps"><procedure>ReCheckStamps</procedure></A> (VAR s: State;  client: Mx.Unit;
                         READONLY z: Mx.InfoList)=
  VAR u: Mx.Unit;  vs, x: MxVS.T;  key := s.unit.name;  info: MxVS.Info;
  BEGIN
    FOR i := z.start TO z.start + z.cnt - 1 DO
      vs := client.info[i];
      MxVS.Get (vs, info);
      IF (info.source = key) THEN
        MxRep.GetStamp (s.base, s.base.vs_exports, vs, u, x);
        IF (u = NIL) OR (x = MxVS.NoVS) THEN
          (* we don't have a primary definition for this symbol *)
          IF (s.unit.interface) THEN
            (* it's too late to add a virtual interface... *)
            IF MissingStamp (s, vs) THEN EXIT; END;
          ELSE
            (* re-install the virtual unit &amp; stamp *)
            AddVirtualExport (s, vs, client);
          END;
        END;
      END;
    END;
  END ReCheckStamps;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="AddStamps"><procedure>AddStamps</procedure></A> (VAR s: State;  READONLY z: Mx.InfoList;
                     export, implement: BOOLEAN) =
  VAR x, vs: MxVS.T;
  BEGIN
    FOR i := z.start TO z.start + z.cnt - 1 DO
      vs := s.unit.info [i];
      IF (export) THEN
        (* this is the primary definition *)
        MxVSSet.Insert (s.base.vs_exports, vs);
      ELSE
        x := MxVSSet.Get (s.base.vs_exports, vs);
        IF (x = MxVS.NoVS) THEN
          (* this is the first reference to the stamp *)
          AddVirtualExport (s, vs, s.unit);
        END;
      END;
      IF (implement) THEN
        (* this is the primary implmentation *)
        MxVSSet.Insert (s.base.vs_impls, vs);
      END;
    END;
  END AddStamps;

PROCEDURE <A NAME="AddVirtualExport"><procedure>AddVirtualExport</procedure></A> (VAR s: State;  vs: MxVS.T;  client: Mx.Unit) =
  VAR u: Mx.Unit;  info: MxVS.Info;
  BEGIN
    MxVS.Get (vs, info);
    u := MxRep.GetVirtualUnit (s.base, info.source, client);
    (* MxRep.AddVirtualInfo (u, u.export_use_syms, vs); *)
    MxVSSet.Insert (s.base.vs_exports, vs);
  END AddVirtualExport;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="MissingStamp"><procedure>MissingStamp</procedure></A> (VAR s: State;  vs: MxVS.T): BOOLEAN =
  VAR info: MxVS.Info;
  BEGIN
    s.failed := TRUE;
    IF (s.errs = NIL) THEN RETURN TRUE; END;
    MxVS.Get (vs, info);
    Out (s, &quot;missing export: &quot;, M3ID.ToText (info.source));
    Out (s, &quot;.&quot;, M3ID.ToText (info.symbol), &quot; imported by &quot;);
    Out (s, MxRep.UnitName (s.unit), Wr.EOL);
    RETURN FALSE;
  END MissingStamp;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="DuplicateStamp"><procedure>DuplicateStamp</procedure></A> (VAR s: State;  u: Mx.Unit;  vs: MxVS.T): BOOLEAN =
  VAR info: MxVS.Info;
  BEGIN
    s.failed := TRUE;
    IF (s.errs = NIL) THEN RETURN TRUE; END;
    MxVS.Get (vs, info);
    Out (s, &quot;multiple definitions: &quot;, M3ID.ToText (info.source));
    Out (s, &quot;.&quot;, M3ID.ToText (info.symbol), &quot; implemented by:&quot;, Wr.EOL);
    Out (s, &quot;   &quot;, MxRep.UnitName (u), Wr.EOL);
    Out (s, &quot;   &quot;, MxRep.UnitName (s.unit), Wr.EOL);
    RETURN FALSE;
  END DuplicateStamp;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="DuplicateStampImpl"><procedure>DuplicateStampImpl</procedure></A> (VAR s: State;  u: Mx.Unit;  vs: MxVS.T): BOOLEAN =
  VAR info: MxVS.Info;
  BEGIN
    s.failed := TRUE;
    IF (s.errs = NIL) THEN RETURN TRUE; END;
    MxVS.Get (vs, info);
    Out (s, &quot;multiple implementations: &quot;, M3ID.ToText (info.source));
    Out (s, &quot;.&quot;, M3ID.ToText (info.symbol), &quot; implemented by:&quot;, Wr.EOL);
    Out (s, &quot;   &quot;, MxRep.UnitName (u), Wr.EOL);
    Out (s, &quot;   &quot;, MxRep.UnitName (s.unit), Wr.EOL);
    RETURN FALSE;
  END DuplicateStampImpl;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="BadStamps"><procedure>BadStamps</procedure></A> (VAR s: State;
                         u: Mx.Unit;
                         vs1, vs2: MxVS.T): BOOLEAN =
  VAR width := 20;  ui: Mx.UnitList;  cl: MxSet.T;  info: MxVS.Info;

  PROCEDURE PrintUnit (x: Mx.Unit) =
    VAR name := MxRep.UnitName (x);  len := Text.Length (name);
    BEGIN
      IF (width + len &gt; Margin) THEN Out (s, Wr.EOL, &quot;     &quot;);  width := 5 END;
      Out (s, name, &quot;  &quot;); INC (width, len + 2);
    END PrintUnit;

  PROCEDURE CheckUnitStamps (x: Mx.Unit;  READONLY z: Mx.InfoList;
                             vs: MxVS.T): BOOLEAN =
    BEGIN
      FOR i := z.start TO z.start + z.cnt - 1 DO
        IF (x.info[i] = vs) THEN
          PrintUnit (x);
          RETURN TRUE;
        END;
      END;
      RETURN FALSE;
    END CheckUnitStamps;

  BEGIN
    s.failed := TRUE;
    IF (s.errs = NIL) THEN RETURN TRUE; END;

    MxVS.Get (vs2, info);
    Out  (s, &quot;version stamp mismatch: &quot;, M3ID.ToText (info.source));
    Out  (s, &quot;.&quot;, M3ID.ToText (info.symbol), Wr.EOL);
    OutX (s, info.stamp);
    MxVS.Get (vs1, info);
    Out  (s, &quot; =&gt; &quot;, MxRep.UnitName (s.unit), Wr.EOL);
    OutX (s, info.stamp);
    Out  (s, &quot; =&gt; &quot;);

    IF (NOT u.virtual) THEN PrintUnit (u) END;

    cl := MxMap.Get (s.base.clients, info.source);
    ui := MxSet.ToList (cl);
    WHILE (ui # NIL) DO
      u := ui.unit;
      IF   CheckUnitStamps (u, u.export_def_syms, vs2)
        OR CheckUnitStamps (u, u.export_use_syms, vs2)
        OR CheckUnitStamps (u, u.import_def_syms, vs2)
        OR CheckUnitStamps (u, u.import_use_syms, vs2) THEN
      END;
      ui := ui.next;
    END;
    IF (width &gt; 0) THEN Out (s, Wr.EOL) END;

    RETURN FALSE;
  END BadStamps;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="CheckRevelations"><procedure>CheckRevelations</procedure></A> (VAR s: State;  r: Mx.Revelation) =
  VAR u: Mx.Unit;  x: Mx.Revelation;
  BEGIN
    WHILE (r # NIL) DO
      IF (NOT r.export) THEN
        MxRep.GetExportedRevelation (s.base, r, u, x);
        IF (u = NIL) THEN
          (* Ok, we'll add a virtual unit later *)
        ELSIF (x = NIL) THEN
          (* we don't know about this revelation yet *)
          IF (NOT u.virtual) THEN
            (* it's too late to add another revelation *)
            IF MissingRevelation (s, r) THEN EXIT; END;
          END;
        END;
      END;
      r := r.next;
    END;
  END CheckRevelations;

PROCEDURE <A NAME="ReCheckRevelations"><procedure>ReCheckRevelations</procedure></A> (VAR s: State;  r: Mx.Revelation;
                              client: Mx.Unit) =
  VAR u: Mx.Unit;  x: Mx.Revelation;  key := s.unit.name;
  BEGIN
    WHILE (r # NIL) DO
      IF (r.source = key) AND (NOT r.export) THEN
        MxRep.GetExportedRevelation (s.base, r, u, x);
        IF (x = NIL) OR (NOT x.export) THEN
          (* we don't have a definitive revelation *)
          IF (s.unit.interface) THEN
            (* it's too late to add a virtual interface... *)
            IF MissingRevelation (s, r) THEN EXIT; END;
          ELSE
            (* make sure somebody &quot;exports&quot; this revelation *)
            u := MxRep.GetVirtualUnit (s.base, r.source, client);
            x := NEW (Mx.Revelation);  x^ := r^;
            x.next := u.revelations;  u.revelations := x;
            x.export := TRUE;
          END;
        END;
      END;
      r := r.next;
    END;
  END ReCheckRevelations;

PROCEDURE <A NAME="MissingRevelation"><procedure>MissingRevelation</procedure></A> (VAR s: State;  r: Mx.Revelation): BOOLEAN =
  CONST op = ARRAY BOOLEAN OF TEXT { &quot;= &quot;, &quot;&lt;: &quot; };
  BEGIN
    s.failed := TRUE;
    IF (s.errs = NIL) THEN RETURN TRUE; END;
    Out  (s, MxRep.UnitName (s.unit), &quot;: missing imported revelation: &quot;);
    OutT (s, r.lhs);
    Out  (s, op[r.partial]);
    OutT (s, r.rhs);
    Out  (s, &quot;from &quot;, M3ID.ToText (r.source), &quot;.i3&quot;, Wr.EOL);
    RETURN FALSE;
  END MissingRevelation;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="AddRevelations"><procedure>AddRevelations</procedure></A> (VAR s: State;  r: Mx.Revelation) =
  VAR u: Mx.Unit;  x: Mx.Revelation;
  BEGIN
    WHILE (r # NIL) DO
      IF (NOT r.export) THEN
        MxRep.GetExportedRevelation (s.base, r, u, x);
        IF (x = NIL) THEN
          (* make sure somebody &quot;exports&quot; this revelation *)
          u := MxRep.GetVirtualUnit (s.base, r.source, s.unit);
          x := NEW (Mx.Revelation);  x^ := r^;
          x.next := u.revelations;  u.revelations := x;
          x.export := TRUE;
        END;
      END;
      r := r.next;
    END;
  END AddRevelations;
</PRE>---------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="CheckImportedTypes"><procedure>CheckImportedTypes</procedure></A> (VAR s: State;  READONLY z: Mx.InfoList) =
  VAR t: INTEGER;
  BEGIN
    FOR i := z.start TO z.start + z.cnt - 1 DO
      t := s.unit.info [i];
      IF MxMap.Get (s.base.exported_types, t) = NIL THEN
        s.failed := TRUE;
        IF (s.errs = NIL) THEN RETURN; END;
        Out  (s, MxRep.UnitName (s.unit), &quot;: missing imported type: &quot;);
        OutT (s, t);
        Out  (s, Wr.EOL);
      END;
    END;
  END CheckImportedTypes;

PROCEDURE <A NAME="AddExportedTypes"><procedure>AddExportedTypes</procedure></A> (VAR s: State;  READONLY z: Mx.InfoList) =
  VAR t: INTEGER;
  BEGIN
    FOR i := z.start TO z.start + z.cnt - 1 DO
      t := s.unit.info [i];
      MxMap.Insert (s.base.exported_types, t, s.unit);
    END;
  END AddExportedTypes;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="CheckObjects"><procedure>CheckObjects</procedure></A> (VAR s: State;  o: Mx.ObjectType) =
  VAR u: Mx.Unit;  x: Mx.ObjectType;
  BEGIN
    WHILE (o # NIL) DO
      IF (NOT o.export) THEN
        MxRep.GetExportedObject (s.base, o, u, x);
        IF (u = NIL) THEN
          (* ok, we'll create a virtual unit later *)
        ELSIF (x = NIL) THEN
          (* we don't know about this object type yet *)
          IF (NOT u.virtual) THEN
            (* it's too late to add this object type *)
            IF MissingObject (s, o) THEN EXIT; END;
          END;
        ELSIF (x.super_type # o.super_type)
           OR (x.data_size # o.data_size)
           OR (x.data_align # o.data_align)
           OR (x.method_size # o.method_size)
           OR (x.from_module # o.from_module) THEN
          IF BadObject (s, u, x, o) THEN EXIT; END;
        END;
      END;
      o := o.next;
    END;
  END CheckObjects;

PROCEDURE <A NAME="ReCheckObjects"><procedure>ReCheckObjects</procedure></A> (VAR s: State;  o: Mx.ObjectType;  client: Mx.Unit) =
  VAR u: Mx.Unit;  x: Mx.ObjectType;  key := s.unit.name;
  BEGIN
    WHILE (o # NIL) DO
      IF (o.source = key) AND (NOT o.export) THEN
        MxRep.GetExportedObject (s.base, o, u, x);
        IF (x = NIL) OR (NOT x.export) THEN
          (* we don't know about this object type yet *)
          IF (u # NIL) AND (NOT u.virtual)
            AND (u.interface # o.from_module) THEN
            (* it's too late to add it *)
            IF MissingObject (s, o) THEN EXIT; END;
          ELSE
            (* make sure somebody &quot;exports&quot; this object type *)
            u := MxRep.GetVirtualUnit (s.base, o.source, client);
            x := NEW (Mx.ObjectType);  x^ := o^;
            x.next := u.exported_objects;  u.exported_objects := x;
            x.export := TRUE;
          END;
        END;
      END;
      o := o.next;
    END;
  END ReCheckObjects;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="MissingObject"><procedure>MissingObject</procedure></A> (VAR s: State;  o: Mx.ObjectType): BOOLEAN =
  CONST Tag = ARRAY BOOLEAN OF TEXT { &quot;.i3&quot;, &quot;.m3&quot; };
  BEGIN
    s.failed := TRUE;
    IF (s.errs = NIL) THEN RETURN TRUE; END;

    Out  (s,  MxRep.UnitName (s.unit), &quot;: &quot;);
    Out  (s, &quot;missing opaque object info for type &quot;);
    OutT (s, o.type);
    Out  (s, &quot;from &quot;, M3ID.ToText (o.source), Tag[o.from_module]);
    Out  (s, Wr.EOL);

    RETURN FALSE;
  END MissingObject;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="BadObject"><procedure>BadObject</procedure></A> (VAR s: State;  u: Mx.Unit;  o1, o2: Mx.ObjectType): BOOLEAN =
  VAR width := 4;  ui: Mx.UnitList;  cl: MxSet.T;

  PROCEDURE PrintUnit (x: Mx.Unit) =
    VAR name := MxRep.UnitName (x);  len := Text.Length (name);
    BEGIN
      IF (width + len &gt; Margin) THEN Out (s, Wr.EOL, &quot;     &quot;);  width := 5 END;
      Out (s, name, &quot;  &quot;); INC (width, len + 2);
    END PrintUnit;

  PROCEDURE CheckUnitObjs (x: Mx.Unit;  o1, o2: Mx.ObjectType): BOOLEAN =
    BEGIN
      WHILE (o1 # NIL) DO
        IF (o1.source = o2.source)
          AND (o1.type = o2.type)
          AND (o1.from_module = o2.from_module) THEN
          PrintUnit (x);
          RETURN TRUE;
        END;
        o1 := o1.next;
      END;
      RETURN FALSE;
    END CheckUnitObjs;

  BEGIN
    s.failed := TRUE;
    IF (s.errs = NIL) THEN RETURN TRUE; END;

    Out  (s, &quot;inconsistent opaque object info for type &quot;);
    OutT (s, o1.type);
    Out  (s, Wr.EOL);
    DumpObj (s, o2);
    Out  (s, &quot; =&gt; &quot;, MxRep.UnitName (s.unit), Wr.EOL);
    DumpObj (s, o1);
    Out  (s, &quot; =&gt; &quot;);

    IF (NOT u.virtual) THEN PrintUnit (u) END;

    cl := MxMap.Get (s.base.clients, o1.source);
    ui := MxSet.ToList (cl);
    WHILE (ui # NIL) DO
      u := ui.unit;
      IF NOT CheckUnitObjs (u, u.exported_objects, o2) THEN
        EVAL CheckUnitObjs (u, u.imported_objects, o2);
      END;
      ui := ui.next;
    END;

    RETURN FALSE;
  END BadObject;

PROCEDURE <A NAME="DumpObj"><procedure>DumpObj</procedure></A> (VAR s: State;  o: Mx.ObjectType) =
  BEGIN
    Out  (s, &quot;super type: &quot;);
    OutT (s, o.super_type);
    Out  (s, &quot; data: (&quot;);
    Out  (s, &quot;size: &quot;, Fmt.Int (o.data_size));
    Out  (s, &quot;, align: &quot;, Fmt.Int (o.data_align));
    Out  (s, &quot;)  method: (&quot;);
    Out  (s, &quot;size: &quot;, Fmt.Int (o.method_size));
    Out  (s, &quot;)&quot;, Wr.EOL);
  END DumpObj;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="AddObjects"><procedure>AddObjects</procedure></A> (VAR s: State;  o: Mx.ObjectType) =
  VAR u: Mx.Unit;  x: Mx.ObjectType;
  BEGIN
    WHILE (o # NIL) DO
      IF (NOT o.export) THEN
        MxRep.GetExportedObject (s.base, o, u, x);
        IF (x = NIL) THEN
          (* make sure somebody &quot;exports&quot; this object type *)
          u := MxRep.GetVirtualUnit (s.base, o.source, s.unit);
          x := NEW (Mx.ObjectType);  x^ := o^;
          x.next := u.exported_objects;  u.exported_objects := x;
          x.export := TRUE;
        END;
      END;
      o := o.next;
    END;
  END AddObjects;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="FilterClients"><procedure>FilterClients</procedure></A> (VAR s: State;  ui: Mx.UnitList): Mx.UnitList =
  VAR
    bad_guys: MxSet.T := NIL;
  BEGIN
    WHILE (ui # NIL) DO
      IF ReCheckUnit (s, ui.unit) THEN
        IF (bad_guys = NIL) THEN bad_guys := MxSet.New ();  END;
        MxSet.Insert (bad_guys, ui.unit);
        ui.unit.virtual := TRUE;
      END;
      ui := ui.next;
    END;
    RETURN MxSet.ToList (bad_guys);
  END FilterClients;

PROCEDURE <A NAME="ReCheckUnit"><procedure>ReCheckUnit</procedure></A> (VAR s: State;  u: Mx.Unit): BOOLEAN =
  VAR old_failed := s.failed;  bad_unit := FALSE;
  BEGIN
    s.failed := FALSE;

    (* check the old importers against the new exporter *)
    IF (NOT s.failed) THEN ReCheckStamps (s, u, u.import_def_syms); END;
    IF (NOT s.failed) THEN ReCheckStamps (s, u, u.import_use_syms); END;
    IF (NOT s.failed) THEN ReCheckRevelations (s, u.revelations, u);  END;
    IF (NOT s.failed) THEN ReCheckObjects (s, u.imported_objects, u); END;
    bad_unit := s.failed;

    s.failed := old_failed;
    RETURN bad_unit;
  END ReCheckUnit;
</PRE>------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="OutT"><procedure>OutT</procedure></A> (VAR s: State;  x: INTEGER) =
  BEGIN
    IF (s.errs = NIL) THEN RETURN END;
    IF (s.err_buf = NIL) THEN s.err_buf := M3Buf.New (); END;
    MxIO.PutTxt (s.err_buf, &quot;_t&quot;);
    MxIO.PutHex (s.err_buf, x, &quot; &quot;);
  END OutT;

PROCEDURE <A NAME="OutX"><procedure>OutX</procedure></A> (VAR s: State;  READONLY x: M3FP.T) =
  BEGIN
    IF (s.errs = NIL) THEN RETURN END;
    IF (s.err_buf = NIL) THEN s.err_buf := M3Buf.New (); END;
    MxIO.PutTxt (s.err_buf, &quot;  &lt;&quot;);
    MxIO.PutFP  (s.err_buf, x, &quot;&gt;&quot;);
  END OutX;

PROCEDURE <A NAME="Out"><procedure>Out</procedure></A> (VAR s: State;  a, b, c, d: TEXT := NIL) =
  BEGIN
    IF (s.errs = NIL) THEN RETURN END;
    IF (s.err_buf = NIL) THEN s.err_buf := M3Buf.New (); END;
    IF (a # NIL) THEN MxIO.PutTxt (s.err_buf, a); END;
    IF (b # NIL) THEN MxIO.PutTxt (s.err_buf, b); END;
    IF (c # NIL) THEN MxIO.PutTxt (s.err_buf, c); END;
    IF (d # NIL) THEN MxIO.PutTxt (s.err_buf, d); END;
  END Out;

BEGIN
END MxMerge.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
