<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxOut.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxOut.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: MxOut.m3                                              
 Last Modified On Tue Sep 27 09:35:31 PDT 1994 By kalsow     
      Modified On Wed May 26 15:59:13 PDT 1993 By muller     

<P>
<P><PRE>MODULE <module><implements><A HREF="MxOut.i3">MxOut</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../libm3/derived/IntIntTbl.i3">IntIntTbl</A>;
IMPORT <A HREF="../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="#x1">M3ID</A>, <A HREF="../../m3middle/src/Target.i3">Target</A>;
IMPORT <A HREF="Mx.i3">Mx</A>, <A HREF="MxVS.i3">MxVS</A>, <A HREF="MxIO.i3">MxIO</A>;

TYPE
  State = RECORD
    wr        : Wr.T;
    buf       : M3Buf.T     := NIL;
    nameMap   : IntIntTbl.T := NIL;
    next_name : INTEGER     := 0;
    vsMap     : IntIntTbl.T := NIL;
    next_vs   : INTEGER     := 0;
  END;

PROCEDURE <A NAME="WriteUnits"><procedure>WriteUnits</procedure></A> (units: Mx.UnitList;  output: Wr.T) =
  VAR s: State;
  BEGIN
    IF (units = NIL) THEN RETURN END;
    IF (output = NIL) THEN RETURN END;

    s.wr        := output;
    s.buf       := M3Buf.New ();
    s.nameMap   := NEW (IntIntTbl.Default).init (409);
    s.next_name := 0;
    s.vsMap     := NEW (IntIntTbl.Default).init (709);
    s.next_vs   := 0;

    M3Buf.AttachDrain (s.buf, s.wr);

    MxIO.PutTxt (s.buf,  Mx.LinkerMagic, Target.EOL);
    WHILE (units # NIL) DO
      WriteUnit (s, units.unit);
      units := units.next;
    END;

    M3Buf.Flush (s.buf, s.wr);

    (* give the collector a chance. *)
    s.wr      := NIL;
    s.buf     := NIL;
    s.nameMap := NIL;
    s.vsMap   := NIL;
  END WriteUnits;

PROCEDURE <A NAME="WriteUnit"><procedure>WriteUnit</procedure></A> (VAR s: State;  u: Mx.Unit) =
  CONST Tag = ARRAY BOOLEAN OF TEXT {&quot;M&quot;, &quot;I&quot;};
  VAR nm := WriteName (s, u.name);
  BEGIN
    MxIO.PutTxt (s.buf, Target.EOL, Tag[u.interface]);
    MxIO.PutInt (s.buf, nm, &quot; &quot;);
    MxIO.PutInt (s.buf, u.exported_units.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.imported_units.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.imported_generics.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.used_interfaces.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.used_modules.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.import_def_syms.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.import_use_syms.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.export_def_syms.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.export_use_syms.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.imported_types.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.exported_types.cnt, &quot; &quot;);
    MxIO.PutInt (s.buf, u.wishes.cnt, Target.EOL);

    WriteNameInfo    (s, u, u.exported_units,    &quot;A&quot;);
    WriteNameInfo    (s, u, u.imported_units,    &quot;B&quot;);
    WriteNameInfo    (s, u, u.used_interfaces,   &quot;C&quot;);
    WriteNameInfo    (s, u, u.used_modules,      &quot;D&quot;);
    WriteNameInfo    (s, u, u.imported_generics, &quot;g&quot;);
    WriteVSInfo      (s, u, u.import_def_syms,   &quot;J&quot;);
    WriteVSInfo      (s, u, u.import_use_syms,   &quot;i&quot;);
    WriteVSInfo      (s, u, u.export_def_syms,   &quot;E&quot;);
    WriteVSInfo      (s, u, u.export_use_syms,   &quot;e&quot;);
    WriteTypeInfo    (s, u, u.imported_types,    &quot;t&quot;);
    WriteTypeInfo    (s, u, u.exported_types,    &quot;T&quot;);
    WriteTypeInfo    (s, u, u.wishes,            &quot;w&quot;);
    WriteOpaques     (s, u.opaques);
    WriteObjects     (s, u.imported_objects, FALSE);
    WriteObjects     (s, u.exported_objects, TRUE);
    WriteRevelations (s, u.revelations);
  END WriteUnit;

PROCEDURE <A NAME="WriteNameInfo"><procedure>WriteNameInfo</procedure></A> (VAR s: State;  u: Mx.Unit;
                         READONLY x: Mx.InfoList;  tag: TEXT) =
  VAR nm: INTEGER;
  BEGIN
    FOR i := x.start TO x.start + x.cnt - 1 DO
      nm := WriteName (s, u.info[i]);
      MxIO.PutTxt (s.buf,  tag);
      MxIO.PutInt (s.buf, nm, Target.EOL);
    END;
  END WriteNameInfo;

PROCEDURE <A NAME="WriteVSInfo"><procedure>WriteVSInfo</procedure></A> (VAR s: State;  u: Mx.Unit;
                         READONLY x: Mx.InfoList;  tag: TEXT) =
  VAR vs: INTEGER;
  BEGIN
    FOR i := x.start TO x.start + x.cnt - 1 DO
      vs := WriteVS (s, u.info[i]);
      MxIO.PutTxt (s.buf,  tag);
      MxIO.PutInt (s.buf, vs, Target.EOL);
    END;
  END WriteVSInfo;

PROCEDURE <A NAME="WriteTypeInfo"><procedure>WriteTypeInfo</procedure></A> (VAR s: State;  u: Mx.Unit;
                         READONLY x: Mx.InfoList;  tag: TEXT) =
  BEGIN
    FOR i := x.start TO x.start + x.cnt - 1 DO
      MxIO.PutTxt (s.buf,  tag);
      MxIO.PutHex (s.buf,  u.info[i], Target.EOL);
    END;
  END WriteTypeInfo;

PROCEDURE <A NAME="WriteOpaques"><procedure>WriteOpaques</procedure></A> (VAR s: State;  o: Mx.OpaqueType) =
  BEGIN
    WHILE (o # NIL) DO
      MxIO.PutTxt (s.buf,  &quot;Q&quot;);
      MxIO.PutHex (s.buf,  o.type, &quot; &quot;);
      MxIO.PutHex (s.buf,  o.super_type, Target.EOL);
      o := o.next;
    END;
  END WriteOpaques;

PROCEDURE <A NAME="WriteObjects"><procedure>WriteObjects</procedure></A> (VAR s: State;  obj: Mx.ObjectType;  export: BOOLEAN) =
  VAR nm: INTEGER;
  BEGIN
    WHILE (obj # NIL) DO
      IF (export) THEN
        MxIO.PutTxt (s.buf,  &quot;O&quot;);
      ELSIF (obj.from_module) THEN
        nm := WriteName (s, obj.source);
        MxIO.PutTxt (s.buf,  &quot;p&quot;);
        MxIO.PutInt (s.buf, nm, &quot; &quot;);
      ELSE (* import from interface *)
        nm := WriteName (s, obj.source);
        MxIO.PutTxt (s.buf,  &quot;o&quot;);
        MxIO.PutInt (s.buf, nm, &quot; &quot;);
      END;
      MxIO.PutHex (s.buf, obj.type, &quot; &quot;);
      MxIO.PutHex (s.buf, obj.super_type, &quot; &quot;);
      MxIO.PutInt (s.buf, obj.data_size, &quot; &quot;);
      MxIO.PutInt (s.buf, obj.data_align, &quot; &quot;);
      MxIO.PutInt (s.buf, obj.method_size, Target.EOL);
      obj := obj.next;
    END;
  END WriteObjects;

PROCEDURE <A NAME="WriteRevelations"><procedure>WriteRevelations</procedure></A> (VAR s: State;  r: Mx.Revelation) =
  CONST import_tag = ARRAY BOOLEAN OF TEXT { &quot;r&quot;, &quot;x&quot; };
  CONST export_tag = ARRAY BOOLEAN OF TEXT { &quot;R&quot;, &quot;X&quot; };
  VAR tag: TEXT;  nm: INTEGER;
  BEGIN
    WHILE (r # NIL) DO
      IF (r.export)
        THEN tag := export_tag [r.partial];
        ELSE tag := import_tag [r.partial];
      END;
      nm := WriteName (s, r.source);
      MxIO.PutTxt (s.buf,  tag);
      MxIO.PutInt (s.buf, nm, &quot; &quot;);
      MxIO.PutHex (s.buf, r.lhs, &quot; &quot;);
      MxIO.PutHex (s.buf, r.rhs, Target.EOL);
      r := r.next;
    END;
  END WriteRevelations;

PROCEDURE <A NAME="WriteVS"><procedure>WriteVS</procedure></A> (VAR s: State;  vs: MxVS.T): INTEGER =
  VAR id, src, sym: INTEGER;  info: MxVS.Info;
  BEGIN
    IF NOT s.vsMap.get (vs, id) THEN
      MxVS.Get (vs, info);
      src := WriteName (s, info.source);
      sym := WriteName (s, info.symbol);
      id := s.next_vs;  INC(s.next_vs);
      EVAL s.vsMap.put (vs, id);
      MxIO.PutTxt (s.buf,  &quot;V&quot;);
      MxIO.PutInt (s.buf, id, &quot; &quot;);
      MxIO.PutInt (s.buf, src, &quot; &quot;);
      MxIO.PutInt (s.buf, sym, &quot; &quot;);
      MxIO.PutFP  (s.buf, info.stamp, Target.EOL);
    END;
    RETURN id;
  END WriteVS;

PROCEDURE <A NAME="WriteName"><procedure>WriteName</procedure></A> (VAR s: State;  nm: Mx.Name): INTEGER =
  VAR id: INTEGER;
  BEGIN
    IF NOT s.nameMap.get (nm, id) THEN
      id := s.next_name;  INC (s.next_name);
      EVAL s.nameMap.put (nm, id);
      MxIO.PutTxt (s.buf, &quot;N&quot;);
      MxIO.PutInt (s.buf, id, &quot; &quot;);
      M3ID.Put    (s.buf, nm);
      MxIO.PutTxt (s.buf, Target.EOL);
    END;
    RETURN id;
  END WriteName;

BEGIN
END MxOut.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
