<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxRep.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxRep.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: Mx.m3                                                 
 Last Modified On Tue Aug  2 07:36:17 PDT 1994 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="MxRep.i3">MxRep</A></implements></module>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="Mx.i3">Mx</A>, <A HREF="MxMap.i3">MxMap</A>, <A HREF="MxSet.i3">MxSet</A>, <A HREF="MxVS.i3">MxVS</A>, <A HREF="MxVSSet.i3">MxVSSet</A>;

PROCEDURE <A NAME="UnitName"><procedure>UnitName</procedure></A> (u: Mx.Unit): TEXT =
  CONST Tag = ARRAY BOOLEAN OF TEXT { &quot;.m3&quot;, &quot;.i3&quot; };
  BEGIN
    IF (u = NIL) THEN RETURN &quot;&lt;NIL&gt;&quot; END;
    RETURN M3ID.ToText (u.name) &amp; Tag [u.interface];
  END UnitName;

VAR import_file: Mx.File := NIL;

PROCEDURE <A NAME="GetVirtualUnit"><procedure>GetVirtualUnit</procedure></A> (x: Mx.LinkSet;  nm: Mx.Name;
                          client: Mx.Unit): Mx.Unit =
  VAR
    u: Mx.Unit := MxMap.Get (x.virtuals, nm);
    c: MxSet.T := MxMap.Get (x.clients, nm);
  BEGIN
    IF (import_file = NIL) THEN
      import_file := NEW (Mx.File, name := &quot;*virtual*&quot;, imported := FALSE);
    END;
    IF (u = NIL) THEN
      u := NEW (Mx.Unit, interface := TRUE, name := nm,
                file := import_file, virtual := TRUE);
      MxMap.Insert (x.virtuals, nm, u);
      u.info := NEW (Mx.InfoVec, 20);
    END;
    IF (c = NIL) THEN
      c := MxSet.New ();
      MxMap.Insert (x.clients, nm, c);
    END;
    MxSet.Insert (c, client);
    RETURN u;
  END GetVirtualUnit;
</PRE>*
PROCEDURE AddVirtualInfo (u: Mx.Unit;  VAR z: Mx.InfoList;  i: INTEGER) =
  VAR n := NUMBER (u.info^);  new: Mx.InfoVec;
  BEGIN
    &lt;*ASSERT z.start = 0*&gt;
    IF (z.cnt &gt;= n) THEN
      new := NEW (Mx.InfoVec, n + n);
      SUBARRAY (new^, 0, n) := u.info^;
      u.info := new;
    END;
    u.info [z.cnt] := i;
    INC (z.cnt);
  END AddVirtualInfo;
**

<P><PRE>PROCEDURE <A NAME="GetStamp"><procedure>GetStamp</procedure></A>  (x       : Mx.LinkSet;
                     set     : MxVSSet.T;
                     vs      : MxVS.T;
          VAR(*OUT*) unit    : Mx.Unit;
          VAR(*OUT*) stamp   : MxVS.T) =
  VAR info: MxVS.Info;
  BEGIN
    stamp := MxVSSet.Get (set, vs);
    IF (stamp # MxVS.NoVS) THEN
      MxVS.Get (vs, info);
      unit  := MxMap.Get (x.interfaces, info.source);
      IF (unit = NIL) THEN unit := MxMap.Get (x.virtuals, info.source); END;
    END;
  END GetStamp;

PROCEDURE <A NAME="GetExportedObject"><procedure>GetExportedObject</procedure></A> (x       : Mx.LinkSet;
                             o       : Mx.ObjectType;
                  VAR(*OUT*) unit    : Mx.Unit;
                  VAR(*OUT*) object  : Mx.ObjectType) =
  VAR u: Mx.Unit;  oo: Mx.ObjectType;
  BEGIN
    unit := NIL;
    object := NIL;

    IF (o.from_module)
      THEN u := MxMap.Get (x.modules, o.source);
      ELSE u := MxMap.Get (x.interfaces, o.source);
    END;
    IF (u = NIL) THEN u := MxMap.Get (x.virtuals, o.source); END;
    IF (u = NIL) THEN RETURN; END;
    unit := u;

    oo := u.exported_objects;
    WHILE (oo # NIL) DO
      IF (oo.type = o.type) AND (oo.from_module = o.from_module) THEN
        object := oo;
        RETURN;
      END;
      oo := oo.next;
    END;
  END GetExportedObject;

PROCEDURE <A NAME="GetExportedRevelation"><procedure>GetExportedRevelation</procedure></A> (x       : Mx.LinkSet;
                                 r       : Mx.Revelation;
                      VAR(*OUT*) unit    : Mx.Unit;
                      VAR(*OUT*) rev     : Mx.Revelation) =
  VAR rx: Mx.Revelation;  u: Mx.Unit;
  BEGIN
    unit := NIL;
    rev := NIL;

    u := MxMap.Get (x.interfaces, r.source);
    IF (u = NIL) THEN u := MxMap.Get (x.virtuals, r.source); END;
    IF (u = NIL) THEN RETURN; END;
    unit := u;

    rx := u.revelations;
    WHILE (rx # NIL) DO
      IF (rx.export)
        AND (rx.lhs = r.lhs)
        AND (rx.rhs = r.rhs)
        AND (rx.partial = r.partial) THEN
        rev := rx;
        RETURN;
      END;
      rx := rx.next;
    END;
  END GetExportedRevelation;

BEGIN
END MxRep.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
