<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxSet.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxSet.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: MxSet.m3                                              
 Last Modified On Tue Mar 23 09:20:10 PST 1993 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="MxSet.i3">MxSet</A></implements></module>;

IMPORT <A HREF="Mx.i3">Mx</A>, <A HREF="MxMap.i3">MxMap</A>;

REVEAL
  <A NAME="T">T</A> = BRANDED &quot;LinkSet&quot; REF RECORD
    elts: MxMap.T;
  END;

TYPE
  Pair = REF RECORD
    name : Mx.Name;
    intf : Elt;
    impl : Elt;
  END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (): T =
  BEGIN
    RETURN NEW (T, elts := MxMap.New (17));
  END New;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (t: T;  e: Elt) =
  VAR p: Pair := MxMap.Get (t.elts, e.name);
  BEGIN
    IF (p = NIL) THEN
      p := NEW (Pair, name := e.name);
      MxMap.Insert (t.elts, p.name, p);
    END;
    IF (e.interface)
      THEN p.intf := e;
      ELSE p.impl := e;
    END;
  END Insert;

PROCEDURE <A NAME="IsMember"><procedure>IsMember</procedure></A> (t: T;  e: Elt): BOOLEAN =
  VAR p: Pair := MxMap.Get (t.elts, e.name);
  BEGIN
    IF    (p = NIL)     THEN RETURN FALSE
    ELSIF (e.interface) THEN RETURN (p.intf # NIL);
    ELSE                     RETURN (p.impl # NIL);
    END;
  END IsMember;

PROCEDURE <A NAME="ToList"><procedure>ToList</procedure></A> (t: T): Mx.UnitList =
  VAR x: MxMap.Contents;  u: Mx.UnitList := NIL;  p: Pair;
  BEGIN
    IF (t = NIL) THEN RETURN NIL END;
    x := MxMap.GetData (t.elts);
    IF (x = NIL) THEN RETURN NIL END;
    FOR i := 0 TO LAST (x^) DO
      p := x[i].value;
      IF (p # NIL) THEN
        IF (p.intf # NIL) THEN
          u := NEW (Mx.UnitList, unit := p.intf, next := u);
        END;
        IF (p.impl # NIL) THEN
          u := NEW (Mx.UnitList, unit := p.impl, next := u);
        END;
      END;
    END;
    RETURN u;
  END ToList;

BEGIN
END MxSet.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
