<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxVS.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxVS.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: MxVS.m3                                               
 Last Modified On Mon Aug  1 15:41:51 PDT 1994 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="MxVS.i3">MxVS</A></implements></module>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>;

TYPE
  InfoBuffer = REF ARRAY OF Info;
  HashTable  = REF ARRAY OF T;

VAR
  next_t    : T := NoVS + 1;
  info      := NEW (InfoBuffer, 2000);
  hashMask  : INTEGER := 2047; (* == 2^11-1 == 11 bits on *)
  hashTable := NEW (HashTable, 2048);

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (t: T;  VAR(*OUT*) i: Info) =
  BEGIN
    &lt;*ASSERT 0 &lt; t AND t &lt; next_t*&gt;
    i:= info[t];
  END Get;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (READONLY i: Info): T =
  VAR
    t      : T;
    hash   : INTEGER  := Hash (i);
    bucket : CARDINAL := Word.And (hash, hashMask);
  BEGIN
    (* search the table *)
    LOOP
      t := hashTable[bucket];
      IF (t = NoVS) THEN (* empty! *) EXIT; END;
      IF (info[t] = i) THEN RETURN t; END;
      INC (bucket);
      IF (bucket &gt;= NUMBER (hashTable^)) THEN bucket := 0; END;
    END;

    (* we didn't find a match =&gt; build a new one *)
    t := next_t;  INC (next_t);
    IF (t &gt;= NUMBER (info^)) THEN ExpandInfo (); END;
    hashTable[bucket] := t;
    info[t] := i;

    (* make sure we're not overloading the hash table *)
    IF (next_t + next_t &gt; NUMBER (hashTable^)) THEN ExpandHashTable (); END;

    RETURN t;
  END Put;
</PRE>-------------------------------------------------------------- internal ---

<P><PRE>PROCEDURE <A NAME="ExpandInfo"><procedure>ExpandInfo</procedure></A> () =
  VAR n := NUMBER (info^);  new := NEW (InfoBuffer, n+n);
  BEGIN
    SUBARRAY (new^, 0, n) := info^;
    info := new;
  END ExpandInfo;

PROCEDURE <A NAME="ExpandHashTable"><procedure>ExpandHashTable</procedure></A> () =
  VAR
    n_old   := NUMBER (hashTable^);
    n_new   := n_old + n_old;
    new     := NEW (REF ARRAY OF T, n_new);
    newMask := hashMask + hashMask + 1;
    t       : T;
    bucket  : INTEGER;
  BEGIN
    FOR i := 0 TO n_new - 1 DO new[i] := NoVS END;

    FOR i := 0 TO n_old - 1 DO
      t := hashTable [i];
      IF (t # NoVS) THEN
        bucket := Word.And (Hash (info[t]), newMask);
        WHILE (new[bucket] # NoVS) DO
          INC (bucket);
          IF (bucket &gt;= n_new) THEN bucket := 0; END;
        END;
        new[bucket] := t;
      END;
    END;

    hashMask := newMask;
    hashTable := new;
  END ExpandHashTable;

PROCEDURE <A NAME="Hash"><procedure>Hash</procedure></A> (READONLY i: Info): INTEGER =
  BEGIN
    RETURN Word.Plus (Word.Plus (Word.Times (i.source, 37),
                                 Word.Times (i.symbol, 17)),
                      Word.Plus (Word.Times (i.stamp.byte[0], 73),
                                 Word.Times (i.stamp.byte[1], 91)));
  END Hash;

BEGIN
END MxVS.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
