<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3linker/src/MxVSSet.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3linker/src/MxVSSet.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: MxVSSet.m3                                            
 Last Modified On Mon Nov 21 16:51:35 PST 1994 By kalsow     

<P><PRE>MODULE <module><implements><A HREF="MxVSSet.i3">MxVSSet</A></implements></module>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="MxVS.i3">MxVS</A>;

REVEAL
  <A NAME="T">T</A> = BRANDED &quot;MxVSMap.T&quot; REF RECORD
          n_used : INTEGER := 0;
          data   : Contents;
        END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (initialSize: CARDINAL): T =
  VAR t := NEW (T);
  BEGIN
    t.data := NEW (Contents, MAX (16, initialSize));
    RETURN t;
  END New;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (t: T;  key: Elt): Elt =
  VAR e: Elt;  k_info, e_info: MxVS.Info;  x, x0: INTEGER;
  BEGIN
    MxVS.Get (key, k_info);
    x0 := Word.Xor (17 * k_info.symbol, k_info.source) MOD NUMBER (t.data^);
    x := x0;
    LOOP
      e := t.data[x];
      IF (e = MxVS.NoVS) THEN RETURN MxVS.NoVS END;
      MxVS.Get (e, e_info);
      IF (e_info.symbol = k_info.symbol)
        AND (e_info.source = k_info.source) THEN RETURN e END;
      INC (x);
      IF (x &gt; LAST (t.data^)) THEN x := 0 END;
      IF (x = x0) THEN RETURN MxVS.NoVS END;
    END;
  END Get;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (t: T;  key: Elt) =
  VAR e: Elt;  k_info, e_info: MxVS.Info;  x, x0: INTEGER;
  BEGIN
    MxVS.Get (key, k_info);
    x0 := Word.Xor (17 * k_info.symbol, k_info.source) MOD NUMBER (t.data^);
    x := x0;
    LOOP
      e := t.data[x];
      IF (e = MxVS.NoVS) THEN
        (* an empty hole =&gt; insert it here *)
        t.data[x] := key;
        INC (t.n_used);
        IF (2 * t.n_used &gt; NUMBER (t.data^)) THEN Expand (t) END;
        RETURN;
      END;
      MxVS.Get (e, e_info);
      IF (e_info.symbol = k_info.symbol)
        AND (e_info.source = k_info.source) THEN
        (* a new value for an existing key *)
        t.data[x] := key;
        RETURN;
      END;
      INC (x);
      IF (x &gt; LAST (t.data^)) THEN x := 0 END;
      IF (x = x0) THEN (* no free slots *) Expand (t) END;
    END;
  END Insert;

PROCEDURE <A NAME="Expand"><procedure>Expand</procedure></A> (t: T) =
  VAR old := t.data;
  VAR n   := NUMBER (old^);
  VAR e : Elt;
  BEGIN
    t.n_used := 0;
    t.data   := NEW (Contents, 2 * n);
    FOR i := 0 TO n-1 DO
      e := old[i];
      IF (e # MxVS.NoVS) THEN Insert (t, e) END;
    END;
  END Expand;

PROCEDURE <A NAME="GetData"><procedure>GetData</procedure></A> (t: T): Contents =
  BEGIN
    IF (t = NIL)
      THEN RETURN NIL
      ELSE RETURN t.data;
    END;
  END GetData;

BEGIN
  &lt;*ASSERT MxVS.NoVS = 0 *&gt; (* =&gt; new hash tables are initialized *)
END MxVSSet.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
