<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/M3Buf.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/M3Buf.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: M3Buf.i3                                              

<P><PRE>INTERFACE <interface><A HREF="M3Buf.m3">M3Buf</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="Target.i3">Target</A>, <A HREF="M3FP.i3">M3FP</A>;
</PRE> An <CODE>M3Buf.T</CODE> is an in-memory, append-only buffer.  It's
   cheaper to write strings and numbers to an <CODE>M3Buf.T</CODE> than
   a <CODE>Wr.T</CODE>.
<P>
   It's an unchecked runtime error to concurrently call procedures
   in this interface on a single <CODE>M3Buf.T</CODE>.


<P><PRE>TYPE <A HREF="M3Buf.m3#T">T</A> &lt;: REFANY;

PROCEDURE <A HREF="M3Buf.m3#New">New</A> (): T;

PROCEDURE <A HREF="M3Buf.m3#PutChar">PutChar</A>  (t: T;  ch: CHAR);
PROCEDURE <A HREF="M3Buf.m3#PutText">PutText</A>  (t: T;  txt: TEXT);
PROCEDURE <A HREF="M3Buf.m3#PutInt">PutInt</A>   (t: T;  i: INTEGER);
PROCEDURE <A HREF="M3Buf.m3#PutIntt">PutIntt</A>  (t: T;  READONLY i: Target.Int);
PROCEDURE <A HREF="M3Buf.m3#PutFloat">PutFloat</A> (t: T;  READONLY f: Target.Float);
PROCEDURE <A HREF="M3Buf.m3#PutSub">PutSub</A>   (t: T;  READONLY x: ARRAY OF CHAR);

PROCEDURE <A HREF="M3Buf.m3#ToText">ToText</A>   (t: T): TEXT;
PROCEDURE <A HREF="M3Buf.m3#ToFP">ToFP</A>     (t: T): M3FP.T;
PROCEDURE <A HREF="M3Buf.m3#Flush">Flush</A>    (t: T;  wr: Wr.T);

PROCEDURE <A HREF="M3Buf.m3#AttachDrain">AttachDrain</A> (t: T;  wr: Wr.T);
</PRE><BLOCKQUOTE><EM> Buffers with non-NIL drains attached will dump their contents to the
   drain rather than allocate more memory.  ToText and ToFP are not useful
   on buffers with non-NIL drains. </EM></BLOCKQUOTE><PRE>

END M3Buf.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
