<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/M3Buf.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/M3Buf.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: M3Buf.m3                                              

<P><PRE>MODULE <module><implements><A HREF="M3Buf.i3">M3Buf</A></implements></module>;

IMPORT <A HREF="../../text/src/TextF.i3">TextF</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../convert/src/Convert.i3">Convert</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="Target.i3">Target</A>, <A HREF="TInt.i3">TInt</A>, <A HREF="M3FP.i3">M3FP</A>;

CONST
  ChunkSize = 2 * 1024 - 3 * BYTESIZE (INTEGER);
  (* leave some slop for the 'next' pointer &amp; the allocator overhead *)

TYPE
  Chunk = REF RECORD
            next : Chunk := NIL;
            buf  : ARRAY [0..ChunkSize-1] OF CHAR;
          END;

REVEAL
  <A NAME="T">T</A> = BRANDED &quot;MBuf.T&quot; REF RECORD
        nFull : INTEGER;
        next  : INTEGER;
        head  : Chunk;
        tail  : Chunk;
        drain : Wr.T;
      END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (): T =
  VAR t := NEW (T);
  BEGIN
    t.nFull := 0;
    t.next  := 0;
    t.head  := NEW (Chunk);
    t.tail  := t.head;
    t.drain := NIL;
    RETURN t;
  END New;

PROCEDURE <A NAME="PutChar"><procedure>PutChar</procedure></A> (t: T;  ch: CHAR) =
  BEGIN
    IF (t.next &gt;= ChunkSize) THEN Expand (t) END;
    t.tail.buf[t.next] := ch;
    INC (t.next);
  END PutChar;

PROCEDURE <A NAME="PutSub"><procedure>PutSub</procedure></A> (t: T;  READONLY x: ARRAY OF CHAR) =
  VAR
    next := 0;
    len  := NUMBER (x);
    n : INTEGER;
  BEGIN
    IF (len &lt; ChunkSize - t.next) THEN
      SUBARRAY (t.tail.buf, t.next, len) := x;
      INC (t.next, len);
    ELSE
      WHILE (len &gt; 0) DO
        n := MIN (len, ChunkSize - t.next);
        SUBARRAY (t.tail.buf, t.next, n) := SUBARRAY (x, next, n);
        DEC (len, n);
        INC (next, n);
        INC (t.next, n);
        IF (len &gt; 0) THEN Expand (t) END;
      END;
    END;
  END PutSub;

PROCEDURE <A NAME="PutText"><procedure>PutText</procedure></A> (t: T;  txt: TEXT) =
  BEGIN
    PutSub (t, SUBARRAY (txt^, 0, LAST (txt^)));
  END PutText;

CONST digits = ARRAY [0..9] OF CHAR {'0','1','2','3','4','5','6','7','8','9'};

CONST digits_100A = ARRAY [0..99] OF CHAR {
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
  };

CONST digits_100B = ARRAY [0..99] OF CHAR {
  '0', '0', '0', '0', '0', '0', '0', '0', '0', '0',
  '1', '1', '1', '1', '1', '1', '1', '1', '1', '1',
  '2', '2', '2', '2', '2', '2', '2', '2', '2', '2',
  '3', '3', '3', '3', '3', '3', '3', '3', '3', '3',
  '4', '4', '4', '4', '4', '4', '4', '4', '4', '4',
  '5', '5', '5', '5', '5', '5', '5', '5', '5', '5',
  '6', '6', '6', '6', '6', '6', '6', '6', '6', '6',
  '7', '7', '7', '7', '7', '7', '7', '7', '7', '7',
  '8', '8', '8', '8', '8', '8', '8', '8', '8', '8',
  '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'
  };

PROCEDURE <A NAME="PutInt"><procedure>PutInt</procedure></A>  (t: T;  i: INTEGER) =
  &lt;*FATAL Convert.Failed*&gt;
  VAR len: INTEGER;  buf: ARRAY [0..BITSIZE(INTEGER) + 3] OF CHAR;
  BEGIN
    IF (0 &lt;= i) THEN
      IF (i &lt; 10) THEN
        PutChar (t, digits[i]);
        RETURN;
      ELSIF (i &lt; 100) THEN
        PutChar (t, digits_100B[i]);
        PutChar (t, digits_100A[i]);
        RETURN;
      ELSIF (i &lt; 1000) THEN
        PutChar (t, digits[i DIV 100]);
        PutChar (t, digits[(i DIV 10) MOD 10]);
        PutChar (t, digits[i MOD 10]);
        RETURN;
      END;
    END;
    len := Convert.FromInt (buf, i, 10);
    PutSub (t, SUBARRAY (buf, 0, len));
  END PutInt;

PROCEDURE <A NAME="PutIntt"><procedure>PutIntt</procedure></A> (t: T;  READONLY i: Target.Int) =
  VAR j: INTEGER;  buf: ARRAY [0..BITSIZE (Target.Int)] OF CHAR;
  BEGIN
    IF TInt.ToInt (i, j) THEN
      PutInt (t, j);
    ELSE
      j := TInt.ToChars (i, buf);
      PutSub (t, SUBARRAY (buf, 0, j));
    END;
  END PutIntt;

PROCEDURE <A NAME="PutFloat"><procedure>PutFloat</procedure></A> (t: T;  READONLY f: Target.Float) =
  &lt;*FATAL Convert.Failed*&gt;
  VAR len: INTEGER;  buf: ARRAY [0..BITSIZE(EXTENDED) + 3] OF CHAR;
  BEGIN
    &lt;*ASSERT f.exponent = 0*&gt;
    len := Convert.FromExtended (buf, f.fraction, 13, Convert.Style.Sci);
    PutSub (t, SUBARRAY (buf, 0, len));
  END PutFloat;

PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A> (t: T): TEXT =
  VAR txt := NEW (TEXT, t.nFull * ChunkSize + t.next + 1);
  VAR c := t.head;   n := 0;
  BEGIN
    FOR i := 1 TO t.nFull DO
      SUBARRAY (txt^, n, ChunkSize) := c.buf;
      c := c.next;
      INC (n, ChunkSize);
    END;
    IF (t.next # 0) THEN
      SUBARRAY (txt^, n, t.next) := SUBARRAY (c.buf, 0, t.next);
    END;
    txt [LAST (txt^)] := '\000';
    Reset (t);
    RETURN txt;
  END ToText;

PROCEDURE <A NAME="ToFP"><procedure>ToFP</procedure></A> (t: T): M3FP.T =
  VAR fp := M3FP.OfEmpty;
  VAR c := t.head;
  BEGIN
    FOR i := 1 TO t.nFull DO
      fp := M3FP.FromChars (c.buf, fp);
      c := c.next;
    END;
    IF (t.next # 0) THEN
      fp := M3FP.FromChars (SUBARRAY (c.buf, 0, t.next), fp);
    END;
    Reset (t);
    RETURN fp;
  END ToFP;

PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A> (t: T;  wr: Wr.T) =
  &lt;*FATAL Wr.Failure, Thread.Alerted*&gt;
  VAR c := t.head;
  BEGIN
    FOR i := 1 TO t.nFull DO  Wr.PutString (wr, c.buf);  c := c.next;  END;
    IF (t.next # 0) THEN Wr.PutString (wr, SUBARRAY (c.buf, 0, t.next)) END;
    Reset (t);
  END Flush;
</PRE>*******
PROCEDURE Append (src, dest: T) =
  VAR c := src.head;
  BEGIN
    FOR i := 1 TO src.nFull DO  PutSub (dest, c.buf);  c := c.next;  END;
    IF (src.next # 0) THEN PutSub (dest, SUBARRAY (c.buf, 0, src.next)) END;
    Reset (src);
  END Append;
*********

<P><PRE>PROCEDURE <A NAME="AttachDrain"><procedure>AttachDrain</procedure></A> (t: T;  wr: Wr.T) =
  BEGIN
    t.drain := wr;
  END AttachDrain;
</PRE>------------------------------------ internal ----------------------------

<P><PRE>PROCEDURE <A NAME="Expand"><procedure>Expand</procedure></A> (t: T) =
  BEGIN
    &lt;* ASSERT t.next = ChunkSize *&gt;
    IF (t.drain # NIL) THEN
      t.next := 0;
      INC (t.nFull);
      Flush(t, t.drain);
    ELSE
      IF (t.tail.next = NIL) THEN t.tail.next := NEW (Chunk); END;
      t.tail := t.tail.next;
      t.next := 0;
      INC (t.nFull);
    END;
  END Expand;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A> (t: T) =
  BEGIN
    (* NOTE: we're not freeing the allocated chunks... *)
    t.tail  := t.head;
    t.nFull := 0;
    t.next  := 0;
  END Reset;

BEGIN
END M3Buf.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
