<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/M3CG.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/M3CG.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE>  Modula-3 code generator interface
<P>
This interface in conjunction with M3CG_Ops provides an intermediate
language for compiler front ends to generate Modula-3 procedures
and object modules.   Its primary client is the Modula-3 compiler.
The bulk of this interface was derived (i.e. stolen) from <CODE>M2CG</CODE> by
John Ellis and John DeTreville.
<P>
The intermediate language (this interface) allows for different actual
code generators, providing two degrees of freedom:
<P>
    - multiple target architectures
    - code generators optimized for different goals (code quality
      versus fast turn-around)
<P>
The interface to the intermediate language is procedural: clients call
methods to construct intermediate-language programs.  Thus a
fast-turn-around code generator can compile the intermediate language
on the fly without much consing, while a high-quality slower code
generator may construct an entire intermediate-language module before
compiling it.
<P>
This interface defines a single object type, M3CG.T.  The operations
available on an M3CG.T are defined in M3CG_Ops.


<P><PRE>INTERFACE <interface><A HREF="M3CG.m3">M3CG</A></interface>;

IMPORT <A HREF="Target.i3">Target</A>, <A HREF="#x1">M3ID</A>;

TYPE <A HREF="M3CG.m3#T">T</A> &lt;: ROOT; (* a code generator *)

TYPE
  Type = Target.CGType;
  MType = [ Type.Addr .. Type.Word_D ];  (* &quot;memory&quot; types *)
  IType = [ Type.Word .. Type.Int ];     (* &quot;integer&quot; types *)
  RType = [ Type.Reel .. Type.XReel ];   (* &quot;real&quot; types *)
  AType = [ Type.Word .. Type.XReel ];   (* &quot;arithmetic&quot; types *)
  ZType = [ Type.Addr .. Type.XReel ];   (* &quot;operator&quot; types *)
  (* The code generator manipulates scalar values of the types
     listed above.  The notation &quot;sN.B&quot; denotes the stack value
     that is &quot;N&quot; elements from the top of stack and has the type
     whose first letter is &quot;B&quot;.  Only loads and stores manipulate
     MTypes, when loaded values are sign or zero extended as necessary
     to produce ZTypes.  *)

TYPE
  Sign = { Positive, Negative, Unknown };
  (* extra compile-time information for DIV and MOD *)

TYPE
  Name = M3ID.T;

TYPE
  Var    = BRANDED &quot;M3CG.Var&quot;  OBJECT END; (* represents a variable *)
  Proc   = BRANDED &quot;M3CG.Proc&quot; OBJECT END; (* represents a procedure *)

TYPE
  BitOffset  = INTEGER;  (* bit offset of a field *)
  BitSize    = CARDINAL; (* bit size of a memory reference or variable *)
  ByteOffset = INTEGER;  (* byte offset of a field *)
  ByteSize   = CARDINAL; (* byte size of a memory reference or variable *)
  Alignment  = CARDINAL; (* minimum byte alignment *)

TYPE
  Frequency = [0..100];
  (* estimated frequency that a branch will be taken or variable referenced. *)

CONST
  Never  : Frequency = FIRST (Frequency);
  Maybe  : Frequency = (Never + Always) DIV 2;
  Likely : Frequency = (Never + 8 * Always) DIV 10;
  Always : Frequency = LAST (Frequency);

TYPE
  TypeUID = BITS 32 FOR [-16_7fffffff-1 .. 16_7fffffff];
  (* a 32-bit unique id (fingerprint) for each type.  *)

TYPE
  Label = INTEGER;
  (* a unique value for each label.  The client is responsible for
     allocating these id's with the 'next_label' field declared below. *)

CONST
  No_label: Label = -1;

TYPE
  CallingConvention = Target.CallingConvention;

END M3CG.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
