<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/M3CG.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/M3CG.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module>M3CG</module> EXPORTS <A HREF="M3CG.i3"><implements>M3CG</A></implements>, <A HREF="M3CG_Ops.i3"><implements>M3CG_Ops</A></implements>;

IMPORT <A HREF="Target.i3">Target</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED &quot;M3CG.T&quot; OBJECT OVERRIDES
    next_label := next_label;
    set_error_handler := set_error_handler;
    begin_unit := begin_unit;
    end_unit := end_unit;
    import_unit := import_unit;
    export_unit := export_unit;
    set_source_file := set_source_file;
    set_source_line := set_source_line;
    declare_typename := declare_typename;
    declare_array := declare_array;
    declare_open_array := declare_open_array;
    declare_enum := declare_enum;
    declare_enum_elt := declare_enum_elt;
    declare_packed := declare_packed;
    declare_record := declare_record;
    declare_field := declare_field;
    declare_set := declare_set;
    declare_subrange := declare_subrange;
    declare_pointer := declare_pointer;
    declare_indirect := declare_indirect;
    declare_proctype := declare_proctype;
    declare_formal := declare_formal;
    declare_raises := declare_raises;
    declare_object := declare_object;
    declare_method := declare_method;
    declare_opaque := declare_opaque;
    reveal_opaque := reveal_opaque;
    declare_exception := declare_exception;
    set_runtime_hook := set_runtime_hook;
    get_runtime_hook := get_runtime_hook;
    import_global := import_global;
    declare_segment := declare_segment;
    bind_segment := bind_segment;
    declare_global := declare_global;
    declare_constant := declare_constant;
    declare_local := declare_local;
    declare_param := declare_param;
    declare_temp :=declare_temp;
    free_temp := free_temp;
    begin_init := begin_init;
    end_init := end_init;
    init_int := init_int;
    init_proc := init_proc;
    init_label := init_label;
    init_var := init_var;
    init_offset := init_offset;
    init_chars := init_chars;
    init_float := init_float;
    import_procedure := import_procedure;
    declare_procedure := declare_procedure;
    begin_procedure := begin_procedure;
    end_procedure := end_procedure;
    begin_block := begin_block;
    end_block := end_block;
    note_procedure_origin := note_procedure_origin;
    set_label := set_label;
    jump := jump;
    if_true := if_true;
    if_false := if_false;
    if_eq := if_eq;
    if_ne := if_ne;
    if_gt := if_gt;
    if_ge := if_ge;
    if_lt := if_lt;
    if_le := if_le;
    case_jump := case_jump;
    exit_proc := exit_proc;
    load := load;
    load_address := load_address;
    load_indirect := load_indirect;
    store := store;
    store_indirect := store_indirect;
    store_ref := store_ref;
    store_ref_indirect := store_ref_indirect;
    load_nil := load_nil;
    load_integer := load_integer;
    load_float := load_float;
    eq := eq;
    ne := ne;
    gt := gt;
    ge := ge;
    lt := lt;
    le := le;
    add := add;
    subtract := subtract;
    multiply := multiply;
    divide := divide;
    negate := negate;
    abs := abs;
    max := max;
    min := min;
    round := round;
    trunc := trunc;
    floor := floor;
    ceiling := ceiling;
    cvt_float := cvt_float;
    div := div;
    mod := mod;
    set_union := set_union;
    set_difference := set_difference;
    set_intersection := set_intersection;
    set_sym_difference := set_sym_difference;
    set_member := set_member;
    set_eq := set_eq;
    set_ne := set_ne;
    set_lt := set_lt;
    set_le := set_le;
    set_gt := set_gt;
    set_ge := set_ge;
    set_range := set_range;
    set_singleton := set_singleton;
    not := not;
    and := and;
    or := or;
    xor := xor;
    shift := shift;
    shift_left := shift_left;
    shift_right := shift_right;
    rotate := rotate;
    rotate_left := rotate_left;
    rotate_right := rotate_right;
    extract := extract;
    extract_n := extract_n;
    extract_mn := extract_mn;
    insert := insert;
    insert_n := insert_n;
    insert_mn := insert_mn;
    swap := swap;
    pop := pop;
    copy_n := copy_n;
    copy := copy;
    zero_n := zero_n;
    zero := zero;
    loophole := loophole;
    assert_fault := assert_fault;
    narrow_fault := narrow_fault;
    return_fault := return_fault;
    case_fault := case_fault;
    typecase_fault := typecase_fault;
    check_nil := check_nil;
    check_lo := check_lo;
    check_hi := check_hi;
    check_range := check_range;
    check_index := check_index;
    check_eq := check_eq;
    add_offset := add_offset;
    index_address := index_address;
    start_call_direct := start_call_direct;
    call_direct := call_direct;
    start_call_indirect := start_call_indirect;
    call_indirect := call_indirect;
    pop_param := pop_param;
    pop_struct := pop_struct;
    pop_static_link := pop_static_link;
    load_procedure := load_procedure;
    load_static_link := load_static_link;
    comment := comment;
  END;
</PRE>----------------------------------------------------------- ID counters ---

<P><PRE>PROCEDURE <A NAME="next_label"><procedure>next_label</procedure></A> (xx: T;  n: INTEGER := 1): Label =
  BEGIN
    RETURN xx.child.next_label (n);
  END next_label;
</PRE>------------------------------------------------ READONLY configuration ---

<P><PRE>PROCEDURE <A NAME="set_error_handler"><procedure>set_error_handler</procedure></A> (xx: T;  p: PROCEDURE (msg: TEXT)) =
  BEGIN
    xx.child.set_error_handler (p);
  END set_error_handler;
</PRE>----------------------------------------------------- compilation units ---

<P><PRE>PROCEDURE <A NAME="begin_unit"><procedure>begin_unit</procedure></A> (xx: T;  optimize : INTEGER) =
  BEGIN
    xx.child.begin_unit (optimize);
  END begin_unit;

PROCEDURE <A NAME="end_unit"><procedure>end_unit</procedure></A> (xx: T) =
  BEGIN
    xx.child.end_unit ();
  END end_unit;

PROCEDURE <A NAME="import_unit"><procedure>import_unit</procedure></A> (xx: T;  n: Name) =
  BEGIN
    xx.child.import_unit (n);
  END import_unit;

PROCEDURE <A NAME="export_unit"><procedure>export_unit</procedure></A> (xx: T;  n: Name) =
  BEGIN
    xx.child.export_unit (n);
  END export_unit;
</PRE>------------------------------------------------ debugging line numbers ---

<P><PRE>PROCEDURE <A NAME="set_source_file"><procedure>set_source_file</procedure></A> (xx: T;  file: TEXT) =
  BEGIN
    xx.child.set_source_file (file);
  END set_source_file;

PROCEDURE <A NAME="set_source_line"><procedure>set_source_line</procedure></A> (xx: T; line: INTEGER) =
  BEGIN
    xx.child.set_source_line (line);
  END set_source_line;
</PRE>------------------------------------------- debugging type declarations ---

<P><PRE>PROCEDURE <A NAME="declare_typename"><procedure>declare_typename</procedure></A> (xx: T;  t: TypeUID;  n: Name) =
  BEGIN
    xx.child.declare_typename (t, n);
  END declare_typename;

PROCEDURE <A NAME="declare_array"><procedure>declare_array</procedure></A> (xx: T;  t, index, elt: TypeUID;  s: BitSize) =
  BEGIN
    xx.child.declare_array (t, index, elt, s);
  END declare_array;

PROCEDURE <A NAME="declare_open_array"><procedure>declare_open_array</procedure></A> (xx: T;  t, elt: TypeUID;  s: BitSize) =
  BEGIN
    xx.child.declare_open_array (t, elt, s);
  END declare_open_array;

PROCEDURE <A NAME="declare_enum"><procedure>declare_enum</procedure></A> (xx: T;  t: TypeUID;  n_elts: INTEGER;  s: BitSize) =
  BEGIN
    xx.child.declare_enum (t, n_elts, s);
  END declare_enum;

PROCEDURE <A NAME="declare_enum_elt"><procedure>declare_enum_elt</procedure></A> (xx: T;  n: Name) =
  BEGIN
    xx.child.declare_enum_elt (n);
  END declare_enum_elt;

PROCEDURE <A NAME="declare_packed"><procedure>declare_packed</procedure></A> (xx: T;  t: TypeUID;  s: BitSize;  base: TypeUID) =
  BEGIN
    xx.child.declare_packed (t, s, base);
  END declare_packed;

PROCEDURE <A NAME="declare_record"><procedure>declare_record</procedure></A> (xx: T; t: TypeUID;  s: BitSize;
                          n_fields: INTEGER)=
  BEGIN
    xx.child.declare_record (t, s, n_fields);
  END declare_record;

PROCEDURE <A NAME="declare_field"><procedure>declare_field</procedure></A> (xx: T;  n: Name;  o: BitOffset;  s: BitSize;
                         t: TypeUID)=
  BEGIN
    xx.child.declare_field (n, o, s, t);
  END declare_field;

PROCEDURE <A NAME="declare_set"><procedure>declare_set</procedure></A> (xx: T;  t, domain: TypeUID;  s: BitSize) =
  BEGIN
    xx.child.declare_set (t, domain, s);
  END declare_set;

PROCEDURE <A NAME="declare_subrange"><procedure>declare_subrange</procedure></A> (xx: T; t, domain: TypeUID;
                            READONLY min, max: Target.Int;
                            s: BitSize) =
  BEGIN
    xx.child.declare_subrange (t, domain, min, max, s);
  END declare_subrange;

PROCEDURE <A NAME="declare_pointer"><procedure>declare_pointer</procedure></A> (xx: T;  t, target: TypeUID;  brand: TEXT;
                           traced: BOOLEAN) =
  BEGIN
    xx.child.declare_pointer (t, target, brand, traced);
  END declare_pointer;

PROCEDURE <A NAME="declare_indirect"><procedure>declare_indirect</procedure></A> (xx: T;  t, target: TypeUID) =
  BEGIN
    xx.child.declare_indirect (t, target);
  END declare_indirect;

PROCEDURE <A NAME="declare_proctype"><procedure>declare_proctype</procedure></A> (xx: T; t: TypeUID; n_formals: INTEGER;
                            result: TypeUID;  n_raises: INTEGER;
                            cc: CallingConvention) =
  BEGIN
    xx.child.declare_proctype (t, n_formals, result, n_raises, cc);
  END declare_proctype;

PROCEDURE <A NAME="declare_formal"><procedure>declare_formal</procedure></A> (xx: T;  n: Name;  t: TypeUID) =
  BEGIN
    xx.child.declare_formal (n, t);
  END declare_formal;

PROCEDURE <A NAME="declare_raises"><procedure>declare_raises</procedure></A> (xx: T;  n: Name) =
  BEGIN
    xx.child.declare_raises (n);
  END declare_raises;

PROCEDURE <A NAME="declare_object"><procedure>declare_object</procedure></A> (xx: T; t, super: TypeUID;
                          brand: TEXT;  traced: BOOLEAN;
                          n_fields, n_methods: INTEGER;
                          field_size: BitSize) =
  BEGIN
    xx.child.declare_object (t, super, brand, traced,
                             n_fields, n_methods, field_size);
  END declare_object;

PROCEDURE <A NAME="declare_method"><procedure>declare_method</procedure></A> (xx: T;  n: Name;  signature: TypeUID) =
  BEGIN
    xx.child.declare_method (n, signature);
  END declare_method;

PROCEDURE <A NAME="declare_opaque"><procedure>declare_opaque</procedure></A> (xx: T;  t, super: TypeUID) =
  BEGIN
    xx.child.declare_opaque (t, super);
  END declare_opaque;

PROCEDURE <A NAME="reveal_opaque"><procedure>reveal_opaque</procedure></A> (xx: T;  lhs, rhs: TypeUID) =
  BEGIN
    xx.child.reveal_opaque (lhs, rhs);
  END reveal_opaque;

PROCEDURE <A NAME="declare_exception"><procedure>declare_exception</procedure></A> (xx: T;  n: Name;  arg_type: TypeUID;
                           raise_proc: BOOLEAN;  base: Var;  offset: INTEGER) =
  BEGIN
    xx.child.declare_exception (n, arg_type, raise_proc, base, offset);
  END declare_exception;
</PRE>--------------------------------------------------------- runtime hooks ---

<P><PRE>PROCEDURE <A NAME="set_runtime_hook"><procedure>set_runtime_hook</procedure></A> (xx: T;  n: Name;  v: Var;  o: ByteOffset) =
  BEGIN
    xx.child.set_runtime_hook (n, v, o);
  END set_runtime_hook;

PROCEDURE <A NAME="get_runtime_hook"><procedure>get_runtime_hook</procedure></A> (xx: T;  n: Name; VAR v: Var; VAR o: ByteOffset) =
  BEGIN
    xx.child.get_runtime_hook (n, v, o);
  END get_runtime_hook;
</PRE>------------------------------------------------- variable declarations ---

<P><PRE>PROCEDURE <A NAME="import_global"><procedure>import_global</procedure></A> (xx: T;  n: Name;  s: ByteSize;  a: Alignment;
                         t: Type;  m3t: TypeUID): Var =
  BEGIN
    RETURN xx.child.import_global (n, s, a, t, m3t);
  END import_global;

PROCEDURE <A NAME="declare_segment"><procedure>declare_segment</procedure></A> (xx: T;  n: Name;  m3t: TypeUID): Var =
  BEGIN
    RETURN xx.child.declare_segment (n, m3t);
  END declare_segment;

PROCEDURE <A NAME="bind_segment"><procedure>bind_segment</procedure></A> (xx: T;  seg: Var;  s: ByteSize;  a: Alignment;
                        t: Type;  exported, inited: BOOLEAN) =
  BEGIN
    xx.child.bind_segment (seg, s, a, t, exported, inited);
  END bind_segment;

PROCEDURE <A NAME="declare_global"><procedure>declare_global</procedure></A> (xx: T;  n: Name;  s: ByteSize;  a: Alignment;
                     t: Type;  m3t: TypeUID;  exported, inited: BOOLEAN): Var =
  BEGIN
    RETURN xx.child.declare_global (n, s, a, t, m3t, exported, inited);
  END declare_global;

PROCEDURE <A NAME="declare_constant"><procedure>declare_constant</procedure></A> (xx: T;  n: Name;  s: ByteSize;  a: Alignment;
                     t: Type;  m3t: TypeUID;  exported, inited: BOOLEAN): Var =
  BEGIN
    RETURN xx.child.declare_constant (n, s, a, t, m3t, exported, inited);
  END declare_constant;

PROCEDURE <A NAME="declare_local"><procedure>declare_local</procedure></A> (xx: T;  n: Name;  s: ByteSize;  a: Alignment;
                         t: Type;  m3t: TypeUID;  in_memory, up_level: BOOLEAN;
                         f: Frequency): Var =
  BEGIN
    RETURN xx.child.declare_local (n, s, a, t, m3t, in_memory, up_level, f);
  END declare_local;

PROCEDURE <A NAME="declare_param"><procedure>declare_param</procedure></A> (xx: T;  n: Name;  s: ByteSize;  a: Alignment;
                         t: Type;  m3t: TypeUID;  in_memory, up_level: BOOLEAN;
                         f: Frequency): Var =
  BEGIN
    RETURN xx.child.declare_param (n, s, a, t, m3t, in_memory, up_level, f);
  END declare_param;

PROCEDURE <A NAME="declare_temp"><procedure>declare_temp</procedure></A> (xx: T;  s: ByteSize;  a: Alignment;  t: Type;
                        in_memory:BOOLEAN): Var =
  BEGIN
    RETURN xx.child.declare_temp (s, a, t, in_memory);
  END declare_temp;

PROCEDURE <A NAME="free_temp"><procedure>free_temp</procedure></A> (xx: T;  v: Var) =
  BEGIN
    xx.child.free_temp (v);
  END free_temp;
</PRE>---------------------------------------- static variable initialization ---

<P><PRE>PROCEDURE <A NAME="begin_init"><procedure>begin_init</procedure></A> (xx: T;  v: Var) =
  BEGIN
    xx.child.begin_init (v);
  END begin_init;

PROCEDURE <A NAME="end_init"><procedure>end_init</procedure></A> (xx: T;  v: Var) =
  BEGIN
    xx.child.end_init (v);
  END end_init;

PROCEDURE <A NAME="init_int"><procedure>init_int</procedure></A> (xx: T;  o: ByteOffset;  READONLY value: Target.Int;
                    t: Type) =
  BEGIN
    xx.child.init_int (o, value, t);
  END init_int;

PROCEDURE <A NAME="init_proc"><procedure>init_proc</procedure></A> (xx: T;  o: ByteOffset;  value: Proc) =
  BEGIN
    xx.child.init_proc (o, value);
  END init_proc;

PROCEDURE <A NAME="init_label"><procedure>init_label</procedure></A> (xx: T;  o: ByteOffset;  value: Label) =
  BEGIN
    xx.child.init_label (o, value);
  END init_label;

PROCEDURE <A NAME="init_var"><procedure>init_var</procedure></A> (xx: T;  o: ByteOffset;  value: Var;  bias: ByteOffset) =
  BEGIN
    xx.child.init_var (o, value, bias);
  END init_var;

PROCEDURE <A NAME="init_offset"><procedure>init_offset</procedure></A> (xx: T;  o: ByteOffset;  value: Var) =
  BEGIN
    xx.child.init_offset (o, value);
  END init_offset;

PROCEDURE <A NAME="init_chars"><procedure>init_chars</procedure></A> (xx: T;  o: ByteOffset;  value: TEXT) =
  BEGIN
    xx.child.init_chars (o, value);
  END init_chars;

PROCEDURE <A NAME="init_float"><procedure>init_float</procedure></A> (xx: T;  o: ByteOffset;  READONLY f: Target.Float) =
  BEGIN
    xx.child.init_float (o, f);
  END init_float;
</PRE>------------------------------------------------------------ procedures ---

<P><PRE>PROCEDURE <A NAME="import_procedure"><procedure>import_procedure</procedure></A> (xx: T;  n: Name;  n_params: INTEGER;
                          ret_type: Type;  cc: CallingConvention): Proc =
  BEGIN
    RETURN xx.child.import_procedure (n, n_params, ret_type, cc);
  END import_procedure;

PROCEDURE <A NAME="declare_procedure"><procedure>declare_procedure</procedure></A> (xx: T;  n: Name;  n_params: INTEGER;
                             return_type: Type;  lev: INTEGER;
                             cc: CallingConvention;
                             exported: BOOLEAN;  parent: Proc): Proc =
  BEGIN
    RETURN xx.child.declare_procedure (n, n_params, return_type,
                                       lev, cc, exported, parent);
  END declare_procedure;

PROCEDURE <A NAME="begin_procedure"><procedure>begin_procedure</procedure></A> (xx: T;  p: Proc) =
  BEGIN
    xx.child.begin_procedure (p);
  END begin_procedure;

PROCEDURE <A NAME="end_procedure"><procedure>end_procedure</procedure></A> (xx: T;  p: Proc) =
  BEGIN
    xx.child.end_procedure (p);
  END end_procedure;

PROCEDURE <A NAME="begin_block"><procedure>begin_block</procedure></A> (xx: T) =
  BEGIN
    xx.child.begin_block ();
  END begin_block;

PROCEDURE <A NAME="end_block"><procedure>end_block</procedure></A> (xx: T) =
  BEGIN
    xx.child.end_block ();
  END end_block;

PROCEDURE <A NAME="note_procedure_origin"><procedure>note_procedure_origin</procedure></A> (xx: T;  p: Proc) =
  BEGIN
    xx.child.note_procedure_origin (p);
  END note_procedure_origin;
</PRE>------------------------------------------------------------ statements ---

<P><PRE>PROCEDURE <A NAME="set_label"><procedure>set_label</procedure></A> (xx: T;  l: Label;  barrier: BOOLEAN) =
  BEGIN
    xx.child.set_label (l, barrier);
  END set_label;

PROCEDURE <A NAME="jump"><procedure>jump</procedure></A> (xx: T; l: Label) =
  BEGIN
    xx.child.jump (l);
  END jump;

PROCEDURE <A NAME="if_true"><procedure>if_true</procedure></A> (xx: T; l: Label;  f: Frequency) =
  BEGIN
    xx.child.if_true (l, f);
  END if_true;

PROCEDURE <A NAME="if_false"><procedure>if_false</procedure></A> (xx: T; l: Label;  f: Frequency) =
  BEGIN
    xx.child.if_false (l, f);
  END if_false;

PROCEDURE <A NAME="if_eq"><procedure>if_eq</procedure></A> (xx: T;  l: Label;  t: ZType;  f: Frequency) =
  BEGIN
    xx.child.if_eq (l, t, f);
  END if_eq;

PROCEDURE <A NAME="if_ne"><procedure>if_ne</procedure></A> (xx: T;  l: Label;  t: ZType;  f: Frequency) =
  BEGIN
    xx.child.if_ne (l, t, f);
  END if_ne;

PROCEDURE <A NAME="if_gt"><procedure>if_gt</procedure></A> (xx: T;  l: Label;  t: ZType;  f: Frequency) =
  BEGIN
    xx.child.if_gt (l, t, f);
  END if_gt;

PROCEDURE <A NAME="if_ge"><procedure>if_ge</procedure></A> (xx: T;  l: Label;  t: ZType;  f: Frequency) =
  BEGIN
    xx.child.if_ge (l, t, f);
  END if_ge;

PROCEDURE <A NAME="if_lt"><procedure>if_lt</procedure></A> (xx: T;  l: Label;  t: ZType;  f: Frequency) =
  BEGIN
    xx.child.if_lt (l, t, f);
  END if_lt;

PROCEDURE <A NAME="if_le"><procedure>if_le</procedure></A> (xx: T;  l: Label;  t: ZType;  f: Frequency) =
  BEGIN
    xx.child.if_le (l, t, f);
  END if_le;

PROCEDURE <A NAME="case_jump"><procedure>case_jump</procedure></A> (xx: T; READONLY labels: ARRAY OF Label) =
  BEGIN
    xx.child.case_jump (labels);
  END case_jump;

PROCEDURE <A NAME="exit_proc"><procedure>exit_proc</procedure></A> (xx: T;  t: Type) =
  BEGIN
    xx.child.exit_proc (t);
  END exit_proc;
</PRE>------------------------------------------------------------ load/store ---

<P><PRE>PROCEDURE <A NAME="load"><procedure>load</procedure></A> (xx: T;  v: Var;  o: ByteOffset;  t: MType) =
  BEGIN
    xx.child.load (v, o, t);
  END load;

PROCEDURE <A NAME="store"><procedure>store</procedure></A> (xx: T;  v: Var;  o: ByteOffset;  t: MType) =
  BEGIN
    xx.child.store (v, o, t);
  END store;

PROCEDURE <A NAME="store_ref"><procedure>store_ref</procedure></A> (xx: T;  v: Var;  o: ByteOffset) =
  BEGIN
    xx.child.store_ref (v, o);
  END store_ref;

PROCEDURE <A NAME="load_address"><procedure>load_address</procedure></A> (xx: T;  v: Var;  o: ByteOffset) =
  BEGIN
    xx.child.load_address (v, o);
  END load_address;

PROCEDURE <A NAME="load_indirect"><procedure>load_indirect</procedure></A> (xx: T;  o: ByteOffset;  t: MType) =
  BEGIN
    xx.child.load_indirect (o, t);
  END load_indirect;

PROCEDURE <A NAME="store_indirect"><procedure>store_indirect</procedure></A> (xx: T;  o: ByteOffset;  t: MType) =
  BEGIN
    xx.child.store_indirect (o, t);
  END store_indirect;

PROCEDURE <A NAME="store_ref_indirect"><procedure>store_ref_indirect</procedure></A> (xx: T;  o: ByteOffset;  var: BOOLEAN) =
  BEGIN
    xx.child.store_ref_indirect (o, var);
  END store_ref_indirect;
</PRE>-------------------------------------------------------------- literals ---

<P><PRE>PROCEDURE <A NAME="load_nil"><procedure>load_nil</procedure></A> (xx: T) =
  BEGIN
    xx.child.load_nil ();
  END load_nil;

PROCEDURE <A NAME="load_integer"><procedure>load_integer</procedure></A> (xx: T;  READONLY i: Target.Int) =
  BEGIN
    xx.child.load_integer (i);
  END load_integer;

PROCEDURE <A NAME="load_float"><procedure>load_float</procedure></A> (xx: T;  READONLY f: Target.Float) =
  BEGIN
    xx.child.load_float (f);
  END load_float;
</PRE>------------------------------------------------------------ arithmetic ---

<P><PRE>PROCEDURE <A NAME="eq"><procedure>eq</procedure></A> (xx: T;  t: ZType) =
  BEGIN
    xx.child.eq (t);
  END eq;

PROCEDURE <A NAME="ne"><procedure>ne</procedure></A> (xx: T;  t: ZType) =
  BEGIN
    xx.child.ne (t);
  END ne;

PROCEDURE <A NAME="gt"><procedure>gt</procedure></A> (xx: T;  t: ZType) =
  BEGIN
    xx.child.gt (t);
  END gt;

PROCEDURE <A NAME="ge"><procedure>ge</procedure></A> (xx: T;  t: ZType) =
  BEGIN
    xx.child.ge (t);
  END ge;

PROCEDURE <A NAME="lt"><procedure>lt</procedure></A> (xx: T;  t: ZType) =
  BEGIN
    xx.child.lt (t);
  END lt;

PROCEDURE <A NAME="le"><procedure>le</procedure></A> (xx: T;  t: ZType) =
  BEGIN
    xx.child.le (t);
  END le;

PROCEDURE <A NAME="add"><procedure>add</procedure></A> (xx: T;  t: AType) =
  BEGIN
    xx.child.add (t);
  END add;

PROCEDURE <A NAME="subtract"><procedure>subtract</procedure></A> (xx: T;  t: AType) =
  BEGIN
    xx.child.subtract (t);
  END subtract;

PROCEDURE <A NAME="multiply"><procedure>multiply</procedure></A> (xx: T;  t: AType) =
  BEGIN
    xx.child.multiply (t);
  END multiply;

PROCEDURE <A NAME="divide"><procedure>divide</procedure></A> (xx: T;  t: RType) =
  BEGIN
    xx.child.divide (t);
  END divide;

PROCEDURE <A NAME="div"><procedure>div</procedure></A> (xx: T;  t: IType;  a, b: Sign) =
  BEGIN
    xx.child.div (t, a, b);
  END div;

PROCEDURE <A NAME="mod"><procedure>mod</procedure></A> (xx: T;  t: IType;  a, b: Sign) =
  BEGIN
    xx.child.mod (t, a, b);
  END mod;

PROCEDURE <A NAME="negate"><procedure>negate</procedure></A> (xx: T;  t: AType) =
  BEGIN
    xx.child.negate (t);
  END negate;

PROCEDURE <A NAME="abs"><procedure>abs</procedure></A> (xx: T;  t: AType) =
  BEGIN
    xx.child.abs (t);
  END abs;

PROCEDURE <A NAME="max"><procedure>max</procedure></A> (xx: T;  t: ZType) =
  BEGIN
    xx.child.max (t);
  END max;

PROCEDURE <A NAME="min"><procedure>min</procedure></A> (xx: T;  t: ZType) =
  BEGIN
    xx.child.min (t);
  END min;

PROCEDURE <A NAME="round"><procedure>round</procedure></A> (xx: T;  t: RType) =
  BEGIN
    xx.child.round (t);
  END round;

PROCEDURE <A NAME="trunc"><procedure>trunc</procedure></A> (xx: T;  t: RType) =
  BEGIN
    xx.child.trunc (t);
  END trunc;

PROCEDURE <A NAME="floor"><procedure>floor</procedure></A> (xx: T;  t: RType) =
  BEGIN
    xx.child.floor (t);
  END floor;

PROCEDURE <A NAME="ceiling"><procedure>ceiling</procedure></A> (xx: T;  t: RType) =
  BEGIN
    xx.child.ceiling (t);
  END ceiling;

PROCEDURE <A NAME="cvt_float"><procedure>cvt_float</procedure></A> (xx: T;  t: AType;  u: RType) =
  BEGIN
    xx.child.cvt_float (t, u);
  END cvt_float;
</PRE>------------------------------------------------------------------ sets ---

<P><PRE>PROCEDURE <A NAME="set_union"><procedure>set_union</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_union (s);
  END set_union;

PROCEDURE <A NAME="set_difference"><procedure>set_difference</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_difference (s);
  END set_difference;

PROCEDURE <A NAME="set_intersection"><procedure>set_intersection</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_intersection (s);
  END set_intersection;

PROCEDURE <A NAME="set_sym_difference"><procedure>set_sym_difference</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_sym_difference (s);
  END set_sym_difference;

PROCEDURE <A NAME="set_member"><procedure>set_member</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_member (s);
  END set_member;

PROCEDURE <A NAME="set_eq"><procedure>set_eq</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_eq (s);
  END set_eq;

PROCEDURE <A NAME="set_ne"><procedure>set_ne</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_ne (s);
  END set_ne;

PROCEDURE <A NAME="set_gt"><procedure>set_gt</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_gt (s);
  END set_gt;

PROCEDURE <A NAME="set_ge"><procedure>set_ge</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_ge (s);
  END set_ge;

PROCEDURE <A NAME="set_lt"><procedure>set_lt</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_lt (s);
  END set_lt;

PROCEDURE <A NAME="set_le"><procedure>set_le</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_le (s);
  END set_le;

PROCEDURE <A NAME="set_range"><procedure>set_range</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_range (s);
  END set_range;

PROCEDURE <A NAME="set_singleton"><procedure>set_singleton</procedure></A> (xx: T;  s: ByteSize) =
  BEGIN
    xx.child.set_singleton (s);
  END set_singleton;
</PRE>------------------------------------------------- Word.T bit operations ---

<P><PRE>PROCEDURE <A NAME="not"><procedure>not</procedure></A> (xx: T) =
  BEGIN
    xx.child.not ();
  END not;

PROCEDURE <A NAME="and"><procedure>and</procedure></A> (xx: T) =
  BEGIN
    xx.child.and ();
  END and;

PROCEDURE <A NAME="or"><procedure>or</procedure></A> (xx: T) =
  BEGIN
    xx.child.or ();
  END or;

PROCEDURE <A NAME="xor"><procedure>xor</procedure></A> (xx: T) =
  BEGIN
    xx.child.xor ();
  END xor;

PROCEDURE <A NAME="shift"><procedure>shift</procedure></A> (xx: T) =
  BEGIN
    xx.child.shift ();
  END shift;

PROCEDURE <A NAME="shift_left"><procedure>shift_left</procedure></A> (xx: T) =
  BEGIN
    xx.child.shift_left ();
  END shift_left;

PROCEDURE <A NAME="shift_right"><procedure>shift_right</procedure></A> (xx: T) =
  BEGIN
    xx.child.shift_right ();
  END shift_right;

PROCEDURE <A NAME="rotate"><procedure>rotate</procedure></A> (xx: T) =
  BEGIN
    xx.child.rotate ();
  END rotate;

PROCEDURE <A NAME="rotate_left"><procedure>rotate_left</procedure></A> (xx: T) =
  BEGIN
    xx.child.rotate_left ();
  END rotate_left;

PROCEDURE <A NAME="rotate_right"><procedure>rotate_right</procedure></A> (xx: T) =
  BEGIN
    xx.child.rotate_right ();
  END rotate_right;

PROCEDURE <A NAME="extract"><procedure>extract</procedure></A> (xx: T;  sign: BOOLEAN) =
  BEGIN
    xx.child.extract (sign);
  END extract;

PROCEDURE <A NAME="extract_n"><procedure>extract_n</procedure></A> (xx: T;  sign: BOOLEAN;  n: INTEGER) =
  BEGIN
    xx.child.extract_n (sign, n);
  END extract_n;

PROCEDURE <A NAME="extract_mn"><procedure>extract_mn</procedure></A> (xx: T;  sign: BOOLEAN;  m, n: INTEGER) =
  BEGIN
    xx.child.extract_mn (sign, m, n);
  END extract_mn;

PROCEDURE <A NAME="insert"><procedure>insert</procedure></A> (xx: T) =
  BEGIN
    xx.child.insert ();
  END insert;

PROCEDURE <A NAME="insert_n"><procedure>insert_n</procedure></A> (xx: T;  n: INTEGER) =
  BEGIN
    xx.child.insert_n (n);
  END insert_n;

PROCEDURE <A NAME="insert_mn"><procedure>insert_mn</procedure></A> (xx: T;  m, n: INTEGER) =
  BEGIN
    xx.child.insert_mn (m, n);
  END insert_mn;
</PRE>------------------------------------------------ misc. stack/memory ops ---

<P><PRE>PROCEDURE <A NAME="swap"><procedure>swap</procedure></A> (xx: T;  a, b: Type) =
  BEGIN
    xx.child.swap (a, b);
  END swap;

PROCEDURE <A NAME="pop"><procedure>pop</procedure></A> (xx: T;  t: Type) =
  BEGIN
    xx.child.pop (t);
  END pop;

PROCEDURE <A NAME="copy_n"><procedure>copy_n</procedure></A> (xx: T;  t: MType;  overlap: BOOLEAN) =
  BEGIN
    xx.child.copy_n (t, overlap);
  END copy_n;

PROCEDURE <A NAME="copy"><procedure>copy</procedure></A> (xx: T;  n: INTEGER;  t: MType;  overlap: BOOLEAN) =
  BEGIN
    xx.child.copy (n, t, overlap);
  END copy;

PROCEDURE <A NAME="zero_n"><procedure>zero_n</procedure></A> (xx: T;  t: MType) =
  BEGIN
    xx.child.zero_n (t);
  END zero_n;

PROCEDURE <A NAME="zero"><procedure>zero</procedure></A> (xx: T;  n: INTEGER;  t: MType) =
  BEGIN
    xx.child.zero (n, t);
  END zero;
</PRE>----------------------------------------------------------- conversions ---

<P><PRE>PROCEDURE <A NAME="loophole"><procedure>loophole</procedure></A> (xx: T;  from, two: ZType) =
  BEGIN
    xx.child.loophole (from, two);
  END loophole;
</PRE>------------------------------------------------ traps &amp; runtime checks ---

<P><PRE>PROCEDURE <A NAME="assert_fault"><procedure>assert_fault</procedure></A> (xx: T) =
  BEGIN
    xx.child.assert_fault ();
  END assert_fault;

PROCEDURE <A NAME="narrow_fault"><procedure>narrow_fault</procedure></A> (xx: T) =
  BEGIN
    xx.child.narrow_fault ();
  END narrow_fault;

PROCEDURE <A NAME="return_fault"><procedure>return_fault</procedure></A> (xx: T) =
  BEGIN
    xx.child.return_fault ();
  END return_fault;

PROCEDURE <A NAME="case_fault"><procedure>case_fault</procedure></A> (xx: T) =
  BEGIN
    xx.child.case_fault ();
  END case_fault;

PROCEDURE <A NAME="typecase_fault"><procedure>typecase_fault</procedure></A> (xx: T) =
  BEGIN
    xx.child.typecase_fault ();
  END typecase_fault;

PROCEDURE <A NAME="check_nil"><procedure>check_nil</procedure></A> (xx: T) =
  BEGIN
    xx.child.check_nil ();
  END check_nil;

PROCEDURE <A NAME="check_lo"><procedure>check_lo</procedure></A> (xx: T;  READONLY i: Target.Int) =
  BEGIN
    xx.child.check_lo (i);
  END check_lo;

PROCEDURE <A NAME="check_hi"><procedure>check_hi</procedure></A> (xx: T;  READONLY i: Target.Int) =
  BEGIN
    xx.child.check_hi (i);
  END check_hi;

PROCEDURE <A NAME="check_range"><procedure>check_range</procedure></A> (xx: T;  READONLY a, b: Target.Int) =
  BEGIN
    xx.child.check_range (a, b);
  END check_range;

PROCEDURE <A NAME="check_index"><procedure>check_index</procedure></A> (xx: T) =
  BEGIN
    xx.child.check_index ();
  END check_index;

PROCEDURE <A NAME="check_eq"><procedure>check_eq</procedure></A> (xx: T) =
  BEGIN
    xx.child.check_eq ();
  END check_eq;
</PRE>---------------------------------------------------- address arithmetic ---

<P><PRE>PROCEDURE <A NAME="add_offset"><procedure>add_offset</procedure></A> (xx: T; i: INTEGER) =
  BEGIN
    xx.child.add_offset (i);
  END add_offset;

PROCEDURE <A NAME="index_address"><procedure>index_address</procedure></A> (xx: T;  size: INTEGER) =
  BEGIN
    xx.child.index_address (size);
  END index_address;
</PRE>------------------------------------------------------- procedure calls ---

<P><PRE>PROCEDURE <A NAME="start_call_direct"><procedure>start_call_direct</procedure></A> (xx: T;  p: Proc;  lev: INTEGER;  t: Type) =
  BEGIN
    xx.child.start_call_direct (p, lev, t);
  END start_call_direct;

PROCEDURE <A NAME="start_call_indirect"><procedure>start_call_indirect</procedure></A> (xx: T;  t: Type;  cc: CallingConvention) =
  BEGIN
    xx.child.start_call_indirect (t, cc);
  END start_call_indirect;

PROCEDURE <A NAME="pop_param"><procedure>pop_param</procedure></A> (xx: T;  t: ZType) =
  BEGIN
    xx.child.pop_param (t);
  END pop_param;

PROCEDURE <A NAME="pop_struct"><procedure>pop_struct</procedure></A> (xx: T;  s: ByteSize;  a: Alignment) =
  BEGIN
    xx.child.pop_struct (s, a);
  END pop_struct;

PROCEDURE <A NAME="pop_static_link"><procedure>pop_static_link</procedure></A> (xx: T) =
  BEGIN
    xx.child.pop_static_link ();
  END pop_static_link;

PROCEDURE <A NAME="call_direct"><procedure>call_direct</procedure></A> (xx: T; p: Proc;  t: Type) =
  BEGIN
    xx.child.call_direct (p, t);
  END call_direct;

PROCEDURE <A NAME="call_indirect"><procedure>call_indirect</procedure></A> (xx: T;  t: Type;  cc: CallingConvention) =
  BEGIN
    xx.child.call_indirect (t, cc);
  END call_indirect;
</PRE>------------------------------------------- procedure and closure types ---

<P><PRE>PROCEDURE <A NAME="load_procedure"><procedure>load_procedure</procedure></A> (xx: T;  p: Proc) =
  BEGIN
    xx.child.load_procedure (p);
  END load_procedure;

PROCEDURE <A NAME="load_static_link"><procedure>load_static_link</procedure></A> (xx: T;  p: Proc) =
  BEGIN
    xx.child.load_static_link (p);
  END load_static_link;
</PRE>----------------------------------------------------------------- misc. ---

<P><PRE>PROCEDURE <A NAME="comment"><procedure>comment</procedure></A> (xx: T;  a, b, c, d: TEXT := NIL) =
  BEGIN
    xx.child.comment (a, b, c, d);
  END comment;

BEGIN
END M3CG.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
