<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/M3CG_Check.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/M3CG_Check.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="M3CG_Check.i3">M3CG_Check</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="M3CG.i3">M3CG</A>, <A HREF="M3CG_Ops.i3">M3CG_Ops</A>, <A HREF="Target.i3">Target</A>, <A HREF="TargetMap.i3">TargetMap</A>;

FROM <A HREF="M3CG.i3">M3CG</A> IMPORT Name, ByteOffset, CallingConvention;
FROM <A HREF="M3CG.i3">M3CG</A> IMPORT ByteSize, Alignment, Frequency;
FROM <A HREF="M3CG.i3">M3CG</A> IMPORT Var, Proc, Label, Sign;
FROM <A HREF="M3CG.i3">M3CG</A> IMPORT Type, ZType, AType, RType, IType, MType;

TYPE (* stack data types *)
  ST = { Addr, Word, Int, Reel, LReel, XReel, Void,
         IType, RType, AType,
         Any, Missing, DontCare, Match };

CONST
  T_to_ST = ARRAY Type OF ST {
    ST.Addr, ST.Int (*ST.Word*), ST.Int,
    ST.Reel, ST.LReel, ST.XReel,
    ST.Int, ST.Int, ST.Int, ST.Int,  (* Int_? *)
    ST.Int, ST.Int, ST.Int, ST.Int,  (* Word_? *)
    ST.Addr, (*Struct*)
    ST.Void
  };

CONST
  ST_name = ARRAY ST OF TEXT {
    &quot;Addr &quot;, &quot;Word &quot;, &quot;Int &quot;, &quot;Real &quot;, &quot;LReal &quot;, &quot;ExReal &quot;, &quot;Void &quot;,
    &quot;W,I &quot;, &quot;R,L,E &quot;, &quot;W,I,R,L,E &quot;,
    &quot;any &quot;, &quot;&quot;, &quot;&quot;, &quot;&lt;=match &quot;
  };

TYPE
  U = M3CG.T OBJECT
        clean_stores := FALSE;
        clean_jumps  := FALSE;
        nested_calls := TRUE;
        nested_procs := FALSE;
        cur_line     : INTEGER := 0;
        next_var     := 1;
        next_proc    := 1;
        next_scope   := 1;
        n_errors     := 0;
        proc_count   := 0;
        block_count  := 0;
        call_count   := 0;
        top_of_stack := 0;
        in_init      := 0;
        init_cursor  := 0;
        note_error   : M3CG_Ops.ErrorHandler := NIL;
        runtime      : IntRefTbl.T := NIL;  (* Name -&gt; RuntimeHook *)
</PRE><BLOCKQUOTE><EM>        temps        : IntIntTbl.T  := NIL; (* Var -&gt; line number </EM></BLOCKQUOTE><PRE> *)
        stack        : ARRAY [0..50] OF Type;
      METHODS
        s_pop (s0, s1, s2, s3 := ST.DontCare) := Stack_Pop;
        s_push (t: Type) := Stack_Push;
        s_repush () := Stack_Repush;
        s_empty () := Stack_Empty;
      OVERRIDES
        set_error_handler := set_error_handler;
        begin_unit := begin_unit;
        end_unit   := end_unit;
        set_source_line := set_source_line;
        set_runtime_hook := set_runtime_hook;
        get_runtime_hook := get_runtime_hook;
        bind_segment := bind_segment;
        declare_temp   := declare_temp;
        free_temp := free_temp;
        begin_init := begin_init;
        end_init := end_init;
        init_int := init_int;
        init_proc := init_proc;
        init_label := init_label;
        init_var := init_var;
        init_offset := init_offset;
        init_chars := init_chars;
        init_float := init_float;
        begin_procedure := begin_procedure;
        end_procedure := end_procedure;
        begin_block := begin_block;
        end_block := end_block;
        note_procedure_origin := note_procedure_origin;
        set_label := set_label;
        jump := jump;
        if_true  := if_true;
        if_false := if_false;
        if_eq := if_eq;
        if_ne := if_ne;
        if_gt := if_gt;
        if_ge := if_ge;
        if_lt := if_lt;
        if_le := if_le;
        case_jump := case_jump;
        exit_proc := exit_proc;
        load  := load;
        store := store;
        store_ref := store_ref;
        load_address := load_address;
        load_indirect := load_indirect;
        store_indirect := store_indirect;
        store_ref_indirect := store_ref_indirect;
        load_nil      := load_nil;
        load_integer  := load_integer;
        load_float    := load_float;
        eq       := eq;
        ne       := ne;
        gt       := gt;
        ge       := ge;
        lt       := lt;
        le       := le;
        add      := add;
        subtract := subtract;
        multiply := multiply;
        divide   := divide;
        div      := div;
        mod      := mod;
        negate   := negate;
        abs      := abs;
        max      := max;
        min      := min;
        round    := round;
        trunc    := trunc;
        floor    := floor;
        ceiling  := ceiling;
        cvt_float := cvt_float;
        set_union          := set_union;
        set_difference     := set_difference;
        set_intersection   := set_intersection;
        set_sym_difference := set_sym_difference;
        set_member         := set_member;
        set_eq       := set_eq;
        set_ne       := set_ne;
        set_gt       := set_gt;
        set_ge       := set_ge;
        set_lt       := set_lt;
        set_le       := set_le;
        set_range    := set_range;
        set_singleton := set_singleton;
        not := not;
        and := and;
        or  := or;
        xor := xor;
        shift        := shift;
        shift_left   := shift_left;
        shift_right  := shift_right;
        rotate       := rotate;
        rotate_left  := rotate_left;
        rotate_right := rotate_right;
        extract := extract;
        extract_n := extract_n;
        extract_mn := extract_mn;
        insert  := insert;
        insert_n  := insert_n;
        insert_mn  := insert_mn;
        swap := swap;
        pop  := pop;
        copy := copy;
        copy_n := copy_n;
        zero := zero;
        zero_n := zero_n;
        loophole := loophole;
        assert_fault := assert_fault;
        narrow_fault := narrow_fault;
        return_fault := return_fault;
        case_fault := case_fault;
        typecase_fault := typecase_fault;
        check_nil := check_nil;
        check_lo := check_lo;
        check_hi := check_hi;
        check_range := check_range;
        check_index := check_index;
        check_eq := check_eq;
        add_offset := add_offset;
        index_address := index_address;
        start_call_direct := start_call_direct;
        call_direct := call_direct;
        start_call_indirect := start_call_indirect;
        call_indirect := call_indirect;
        pop_param := pop_param;
        pop_struct := pop_struct;
        pop_static_link := pop_static_link;
        load_procedure := load_procedure;
        load_static_link := load_static_link;
      END;
</PRE>----------------------------------------------- binary/ASCII conversion ---

<P>
<P><PRE>VAR Ints := ARRAY [0..1023] OF TEXT { NIL, .. };

PROCEDURE <A NAME="Int"><procedure>Int</procedure></A> (i: INTEGER): TEXT =
  BEGIN
    IF (FIRST (Ints) &lt;= i) AND (i &lt;= LAST (Ints)) THEN
      IF (Ints[i] = NIL) THEN Ints [i] := &quot; &quot; &amp; Fmt.Int (i) END;
      RETURN Ints [i];
    ELSE
      RETURN &quot; &quot; &amp; Fmt.Int (i);
    END;
  END Int;
</PRE>--------------------------------------------------------- low level I/O ---

<P><PRE>PROCEDURE <A NAME="PutErr"><procedure>PutErr</procedure></A> (u: U;  a, b, c: TEXT := NIL) =
  BEGIN
    u.child.comment (&quot;********* M3CG_Check ERROR *********** &quot;, a, b, c);
    INC (u.n_errors);
  END PutErr;
</PRE>-------------------------------------------------------- stack checking ---

<P><PRE>PROCEDURE <A NAME="Stack_Get"><procedure>Stack_Get</procedure></A> (self: U;  depth: INTEGER): ST =
  VAR x := self.top_of_stack - depth - 1;
  BEGIN
    IF (FIRST (self.stack) &lt;= x) AND (x &lt;= LAST (self.stack))
      THEN RETURN T_to_ST [self.stack [x]];
      ELSE RETURN ST.Missing;
    END;
  END Stack_Get;

PROCEDURE <A NAME="IsOK"><procedure>IsOK</procedure></A> (need, got, prev: ST): BOOLEAN =
  CONST
    min_IType = T_to_ST [FIRST (IType)];
    max_IType = T_to_ST [LAST  (IType)];
    min_RType = T_to_ST [FIRST (RType)];
    max_RType = T_to_ST [LAST  (RType)];
    min_AType = T_to_ST [FIRST (AType)];
    max_AType = T_to_ST [LAST  (AType)];
    min_Type  = T_to_ST [FIRST (Type)];
    max_Type  = T_to_ST [LAST  (Type)];
  BEGIN
    CASE need OF
    | ST.Void     =&gt; RETURN (got = ST.Missing);
    | ST.IType    =&gt; RETURN (min_IType &lt;= got) AND (got &lt;= max_IType);
    | ST.RType    =&gt; RETURN (min_RType &lt;= got) AND (got &lt;= max_RType);
    | ST.AType    =&gt; RETURN (min_AType &lt;= got) AND (got &lt;= max_AType);
    | ST.Any      =&gt; RETURN (min_Type  &lt;= got) AND (got &lt;= max_Type);
    | ST.DontCare =&gt; RETURN TRUE;
    | ST.Match    =&gt; RETURN got = prev;
    ELSE             RETURN (got = need);
    END;
  END IsOK;

PROCEDURE <A NAME="ST_Name"><procedure>ST_Name</procedure></A> (a, prev: ST): TEXT =
  BEGIN
    IF (a = ST.Match) THEN a := prev END;
    RETURN ST_name [a];
  END ST_Name;

PROCEDURE <A NAME="Stack_Pop"><procedure>Stack_Pop</procedure></A> (self: U;  a, b, c, d: ST) =
  VAR
    s0 := Stack_Get (self, 0);
    s1 := Stack_Get (self, 1);
    s2 := Stack_Get (self, 2);
    s3 := Stack_Get (self, 3);
  BEGIN
    IF IsOK (a, s0, a) AND IsOK (b, s1, a)
      AND IsOK (c, s2, b) AND IsOK (d, s3, c) THEN
      (* no error *)
    ELSE
      PutErr (self, &quot;bad stack:  expected [ &quot;,
        ST_Name (a, a) &amp; ST_Name (b, a)
          &amp; ST_Name (c, b) &amp; ST_Name (d, c),
        &quot;] got [ &quot; &amp;
        ST_Name (s0, s0) &amp; ST_Name (s1, s0)
          &amp; ST_Name (s2, s1) &amp; ST_Name (s3, s2) &amp; &quot;]&quot;);
    END;
    IF    (d # ST.DontCare) THEN DEC (self.top_of_stack, 4)
    ELSIF (c # ST.DontCare) THEN DEC (self.top_of_stack, 3)
    ELSIF (b # ST.DontCare) THEN DEC (self.top_of_stack, 2)
    ELSE (*a # ST.DontCare*)     DEC (self.top_of_stack)
    END;
    IF (self.top_of_stack &lt; 0) THEN self.top_of_stack := 0 END;
  END Stack_Pop;

PROCEDURE <A NAME="Stack_Push"><procedure>Stack_Push</procedure></A> (self: U;  t: Type) =
  BEGIN
    IF (self.top_of_stack &lt;= LAST (self.stack))
      THEN self.stack [self.top_of_stack] := t;
      ELSE PutErr (self, &quot;stack overflow&quot;);
    END;
    INC (self.top_of_stack);
  END Stack_Push;

PROCEDURE <A NAME="Stack_Repush"><procedure>Stack_Repush</procedure></A> (self: U) =
  BEGIN
    INC (self.top_of_stack);
  END Stack_Repush;

PROCEDURE <A NAME="Stack_Empty"><procedure>Stack_Empty</procedure></A> (self: U) =
  BEGIN
    IF (self.top_of_stack &gt; 0) THEN
      PutErr (self, &quot;non-empty stack: &quot;, Stack_Dump (self));
      self.top_of_stack := 0;
    END;
  END Stack_Empty;
</PRE>************** DEBUGGING ********
PROCEDURE SDump (self: U) =
  BEGIN
    self.child.comment (<CODE>**** </CODE>, Stack_Dump (self));
  END SDump;
***************************************

<P><PRE>PROCEDURE <A NAME="Stack_Dump"><procedure>Stack_Dump</procedure></A> (self: U): TEXT =
  VAR s := &quot;[ &quot;;
  BEGIN
    FOR i := 0 TO MIN (self.top_of_stack - 1, 4) DO
      s := s &amp; ST_name [Stack_Get (self, i)];
    END;
    IF (self.top_of_stack &gt; 5) THEN
      s := s &amp; &quot;... &quot;;
    END;
    s := s &amp; &quot;]&quot;;
    RETURN s;
  END Stack_Dump;
</PRE>---------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A> (child: M3CG.T;
               clean_jumps, clean_stores: BOOLEAN;
               nested_calls, nested_procs: BOOLEAN): M3CG.T =
  BEGIN
    child.set_error_handler (CrashAndBurn);
    RETURN NEW (U,
                child        := child,
                note_error   := CrashAndBurn,
                runtime      := NEW (IntRefTbl.Default).init (20),
                clean_jumps  := clean_jumps,
                clean_stores := clean_stores,
                nested_calls := nested_calls,
                nested_procs := nested_procs
               );
  END New;

PROCEDURE <A NAME="CrashAndBurn"><procedure>CrashAndBurn</procedure></A> (msg: TEXT) =
  &lt;*FATAL Wr.Failure, Thread.Alerted*&gt;
  BEGIN
    Wr.PutText (Stdio.stdout, &quot;Unhandled M3CG_Check error: &quot; &amp; msg);
    Wr.Flush (Stdio.stdout);
    Wr.Flush (Stdio.stderr);
    &lt;*ASSERT FALSE*&gt;
  END CrashAndBurn;
</PRE>------------------------------------------------ READONLY configuration ---

<P><PRE>PROCEDURE <A NAME="set_error_handler"><procedure>set_error_handler</procedure></A> (self: U;  p: M3CG_Ops.ErrorHandler) =
  BEGIN
    self.note_error := p;
    self.child.set_error_handler (p);
  END set_error_handler;
</PRE>----------------------------------------------------- compilation units ---

<P><PRE>PROCEDURE <A NAME="begin_unit"><procedure>begin_unit</procedure></A> (self: U;  optimize : INTEGER) =
  (* called before any other method to initialize the compilation unit *)
  BEGIN
    self.s_empty ();
    self.child.begin_unit (optimize);
  END begin_unit;

PROCEDURE <A NAME="end_unit"><procedure>end_unit</procedure></A>   (self: U) =
  (* called after all other methods to finalize the unit and write the
     resulting object *)
  BEGIN
    self.s_empty ();
    self.child.end_unit ();
    IF (self.n_errors &lt;= 0) THEN
      (* ok *)
    ELSIF (self.n_errors = 1) THEN
      self.note_error (&quot;1 code generation error&quot;);
    ELSE (*self.n_errors &gt; 1 *)
      self.note_error (Int (self.n_errors) &amp; &quot; code generation errors&quot;);
    END;
  END end_unit;
</PRE>------------------------------------------------ debugging line numbers ---

<P><PRE>PROCEDURE <A NAME="set_source_line"><procedure>set_source_line</procedure></A> (self: U; line: INTEGER) =
  BEGIN
    self.cur_line := line;
    self.child.set_source_line (line);
  END set_source_line;
</PRE>--------------------------------------------------------- runtime hooks ---

<P><PRE>PROCEDURE <A NAME="set_runtime_hook"><procedure>set_runtime_hook</procedure></A> (self: U;  n: Name;  v: Var;  o: ByteOffset) =
  BEGIN
    CheckVar (self, v);
    IF self.runtime.put (n, NIL) THEN
      PutErr (self, &quot;redefined runtime hook: &quot;, M3ID.ToText (n));
    END;
    self.child.set_runtime_hook (n, v, o);
  END set_runtime_hook;

PROCEDURE <A NAME="get_runtime_hook"><procedure>get_runtime_hook</procedure></A> (self: U;  n: Name; VAR v: Var; VAR o: ByteOffset) =
  VAR ref: REFANY;
  BEGIN
    IF NOT self.runtime.get (n, ref) THEN
      PutErr (self, &quot;undefined runtime hook: &quot;, M3ID.ToText (n));
    END;
    self.child.get_runtime_hook (n, v, o);
  END get_runtime_hook;
</PRE>------------------------------------------------- variable declarations ---

<P><PRE>PROCEDURE <A NAME="CheckVar"><procedure>CheckVar</procedure></A> (self: U;  v: Var) =
  BEGIN
    IF (v = NIL) THEN
      PutErr (self, &quot;NIL variable&quot;);
    END;
  END CheckVar;

PROCEDURE <A NAME="bind_segment"><procedure>bind_segment</procedure></A> (self: U;  seg: Var;  s: ByteSize;  a: Alignment;
                        t: Type;  exported, inited: BOOLEAN) =
  BEGIN
    CheckVar (self, seg);
    self.child.bind_segment (seg, s, a, t, exported, inited);
  END bind_segment;

PROCEDURE <A NAME="declare_temp"><procedure>declare_temp</procedure></A>   (self: U;  s: ByteSize;  a: Alignment;  t: Type;
                          in_memory:BOOLEAN): Var =
  VAR v: Var;
  BEGIN
</PRE><BLOCKQUOTE><EM><P>
    IF (self.temps = NIL) THEN 
      self.temps := NEW (IntIntTbl.Default).init (); END;
</EM></BLOCKQUOTE><PRE>
    v := self.child.declare_temp (s, a, t, in_memory);
</PRE><BLOCKQUOTE><EM><P>
    IF self.temps.put (v, self.cur_line) THEN
      PutErr (self, <CODE>temporary reused while live!</CODE>);
    END;
</EM></BLOCKQUOTE><PRE>
    RETURN v;
  END declare_temp;

PROCEDURE <A NAME="free_temp"><procedure>free_temp</procedure></A> (self: U;  v: Var) =
  (* VAR line: INTEGER; *)
  BEGIN
    CheckVar (self, v);
</PRE><BLOCKQUOTE><EM><P>
    IF (self.temps = NIL) THEN 
      self.temps := NEW (IntIntTbl.Default).init (); END;
    IF NOT self.temps.delete (v, line) THEN
      PutErr (self, <CODE>temp freed twice</CODE>);
    END;
</EM></BLOCKQUOTE><PRE>
    self.child.free_temp (v);
  END free_temp;
</PRE>---------------------------------------- static variable initialization ---

<P><PRE>PROCEDURE <A NAME="begin_init"><procedure>begin_init</procedure></A> (self: U;  v: Var) =
  BEGIN
    CheckVar (self, v);
    IF (self.in_init &gt; 0) THEN
      PutErr (self, &quot;nested static initialization&quot;);
    END;
    INC (self.in_init);
    self.init_cursor := 0;
    self.child.begin_init (v);
  END begin_init;

PROCEDURE <A NAME="end_init"><procedure>end_init</procedure></A> (self: U;  v: Var) =
  BEGIN
    CheckVar (self, v);
    IF (self.in_init &gt; 0)
      THEN DEC (self.in_init);  self.init_cursor := 0;
      ELSE PutErr (self, &quot;missing begin_init&quot;);
    END;
    self.child.end_init (v);
  END end_init;

PROCEDURE <A NAME="DoInit"><procedure>DoInit</procedure></A> (self: U;  o: ByteOffset;  s: ByteSize) =
  BEGIN
    IF (self.in_init &lt;= 0) THEN PutErr (self, &quot;missing begin_init&quot;) END;
    IF (o &gt;= self.init_cursor)
      THEN self.init_cursor := o + s;
      ELSE PutErr (self, &quot;decreasing offsets&quot;);
    END;
  END DoInit;

PROCEDURE <A NAME="init_int"><procedure>init_int</procedure></A> (self: U;  o: ByteOffset;  READONLY value: Target.Int;
                    t: Type) =
  BEGIN
    DoInit (self, o, TargetMap.CG_Bytes[t]);
    self.child.init_int (o, value, t);
  END init_int;

PROCEDURE <A NAME="init_proc"><procedure>init_proc</procedure></A> (self: U;  o: ByteOffset;  value: Proc) =
  BEGIN
    DoInit (self, o, Target.Address.bytes);
    self.child.init_proc (o, value);
  END init_proc;

PROCEDURE <A NAME="init_label"><procedure>init_label</procedure></A> (self: U;  o: ByteOffset;  value: Label) =
  BEGIN
    DoInit (self, o, Target.Address.bytes);
    self.child.init_label (o, value);
  END init_label;

PROCEDURE <A NAME="init_var"><procedure>init_var</procedure></A> (self: U;  o: ByteOffset;  value: Var;  bias: ByteOffset) =
  BEGIN
    DoInit (self, o, Target.Address.bytes);
    self.child.init_var (o, value, bias);
  END init_var;

PROCEDURE <A NAME="init_offset"><procedure>init_offset</procedure></A> (self: U;  o: ByteOffset;  value: Var) =
  BEGIN
    DoInit (self, o, Target.Integer.bytes);
    self.child.init_offset (o, value);
  END init_offset;

PROCEDURE <A NAME="init_chars"><procedure>init_chars</procedure></A> (self: U;  o: ByteOffset;  value: TEXT) =
  BEGIN
    DoInit (self, o, Text.Length (value) * Target.Char.bytes);
    self.child.init_chars (o, value);
  END init_chars;

PROCEDURE <A NAME="init_float"><procedure>init_float</procedure></A> (self: U;  o: ByteOffset;  READONLY f: Target.Float) =
  BEGIN
    DoInit (self, o, TargetMap.Float_types[f.pre].bytes);
    self.child.init_float (o, f);
  END init_float;
</PRE>------------------------------------------------------------ procedures ---

<P><PRE>PROCEDURE <A NAME="CheckProc"><procedure>CheckProc</procedure></A> (self: U;  p: Proc) =
  BEGIN
    IF (p = NIL) THEN
      PutErr (self, &quot;NIL procedure&quot;);
    END;
  END CheckProc;

PROCEDURE <A NAME="begin_procedure"><procedure>begin_procedure</procedure></A> (self: U;  p: Proc) =
  BEGIN
    CheckProc (self, p);
    IF (self.proc_count &gt; 0) AND (NOT self.nested_procs) THEN
      PutErr (self, &quot;nested procedure declaration&quot;);
    END;
    INC (self.proc_count);
    self.child.begin_procedure (p);
  END begin_procedure;

PROCEDURE <A NAME="end_procedure"><procedure>end_procedure</procedure></A> (self: U;  p: Proc) =
  BEGIN
    CheckProc (self, p);
    IF (self.proc_count &gt; 0)
      THEN DEC (self.proc_count);
      ELSE PutErr (self, &quot;missing begin_procedure&quot;);
    END;
    IF (self.block_count &gt; 0) AND (NOT self.nested_procs) THEN
      PutErr (self, &quot;missing end_blocks: &quot;, Int (self.block_count));
      self.block_count := 0;
    END;
    self.s_empty ();
</PRE><BLOCKQUOTE><EM><P>
    IF (self.temps # NIL) THEN
      VAR it := self.temps.iterate (); k: REFANY; line: INTEGER; BEGIN
        WHILE it.next (tag, line) DO
          PutErr (self, <CODE>temp not freed, created on line </CODE>, Int (line));
        END;
      END;
    END;
</EM></BLOCKQUOTE><PRE>
    self.child.end_procedure (p);
  END end_procedure;

PROCEDURE <A NAME="begin_block"><procedure>begin_block</procedure></A> (self: U) =
  (* marks the beginning of a nested anonymous block *)
  BEGIN
    IF (self.proc_count &lt;= 0) THEN
      PutErr (self, &quot;begin_block not in procedure&quot;);
    END;
    self.s_empty ();
    INC (self.block_count);
    self.child.begin_block ();
  END begin_block;

PROCEDURE <A NAME="end_block"><procedure>end_block</procedure></A> (self: U) =
  (* marks the ending of a nested anonymous block *)
  BEGIN
    IF (self.block_count &gt; 0)
      THEN DEC (self.block_count);
      ELSE PutErr (self, &quot;missing begin_block&quot;);
    END;
    self.s_empty ();
    self.child.end_block ();
  END end_block;

PROCEDURE <A NAME="note_procedure_origin"><procedure>note_procedure_origin</procedure></A> (self: U;  p: Proc) =
  BEGIN
    CheckProc (self, p);
    self.s_empty ();
    self.child.note_procedure_origin (p);
  END note_procedure_origin;
</PRE>------------------------------------------------------------ statements ---

<P><PRE>PROCEDURE <A NAME="CheckLabel"><procedure>CheckLabel</procedure></A> (self: U;  l: Label) =
  BEGIN
    IF (l &lt; 0) (*OR (self.next_label &lt;= l)*) THEN
      PutErr (self, &quot;undefined label: &quot;, Int (l));
    END;
  END CheckLabel;

PROCEDURE <A NAME="set_label"><procedure>set_label</procedure></A> (self: U;  l: Label;  barrier: BOOLEAN) =
  (* define 'l' to be at the current pc *)
  BEGIN
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.set_label (l, barrier);
  END set_label;

PROCEDURE <A NAME="jump"><procedure>jump</procedure></A> (self: U; l: Label) =
  (* GOTO l *)
  BEGIN
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.jump (l);
  END jump;

PROCEDURE <A NAME="if_true"><procedure>if_true</procedure></A>  (self: U; l: Label;  f: Frequency) =
  (* IF (s0.I # 0) GOTO l ; pop *)
  BEGIN
    self.s_pop (ST.Int);
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.if_true (l, f);
  END if_true;

PROCEDURE <A NAME="if_false"><procedure>if_false</procedure></A> (self: U; l: Label;  f: Frequency) =
  (* IF (s0.I = 0) GOTO l ; pop *)
  BEGIN
    self.s_pop (ST.Int);
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.if_false (l, f);
  END if_false;

PROCEDURE <A NAME="if_eq"><procedure>if_eq</procedure></A> (self: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t = s0.t) GOTO l ; pop(2) *)
  BEGIN
    self.s_pop (T_to_ST [t], ST.Match);
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.if_eq (l, t, f);
  END if_eq;

PROCEDURE <A NAME="if_ne"><procedure>if_ne</procedure></A> (self: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t # s0.t) GOTO l ; pop(2) *)
  BEGIN
    self.s_pop (T_to_ST [t], ST.Match);
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.if_ne (l, t, f);
  END if_ne;

PROCEDURE <A NAME="if_gt"><procedure>if_gt</procedure></A> (self: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t &gt; s0.t) GOTO l ; pop(2) *)
  BEGIN
    self.s_pop (T_to_ST [t], ST.Match);
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.if_gt (l, t, f);
  END if_gt;

PROCEDURE <A NAME="if_ge"><procedure>if_ge</procedure></A> (self: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t &gt;= s0.t) GOTO l ; pop(2) *)
  BEGIN
    self.s_pop (T_to_ST [t], ST.Match);
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.if_ge (l, t, f);
  END if_ge;

PROCEDURE <A NAME="if_lt"><procedure>if_lt</procedure></A> (self: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t &lt; s0.t) GOTO l ; pop(2) *)
  BEGIN
    self.s_pop (T_to_ST [t], ST.Match);
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.if_lt (l, t, f);
  END if_lt;

PROCEDURE <A NAME="if_le"><procedure>if_le</procedure></A> (self: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t &lt;= s0.t) GOTO l ; pop(2) *)
  BEGIN
    self.s_pop (T_to_ST [t], ST.Match);
    IF (self.clean_jumps) THEN self.s_empty () END;
    CheckLabel (self, l);
    self.child.if_le (l, t, f);
  END if_le;

PROCEDURE <A NAME="case_jump"><procedure>case_jump</procedure></A> (self: U; READONLY labels: ARRAY OF Label) =
  (* &quot;GOTO labels[s0.I] ; pop&quot; with no range checking on s0.I *)
  BEGIN
    self.s_pop (ST.Int);
    IF (self.clean_jumps) THEN self.s_empty () END;
    FOR i := FIRST (labels) TO LAST (labels) DO
      CheckLabel (self, labels [i]);
    END;
    self.child.case_jump (labels);
  END case_jump;

PROCEDURE <A NAME="exit_proc"><procedure>exit_proc</procedure></A> (self: U; t: Type) =
  (* Returns s0.t if the stack is non-empty, otherwise returns no value. *)
  BEGIN
    IF (t # Type.Void) THEN self.s_pop (T_to_ST [t]) END;
    self.s_empty ();
    self.child.exit_proc (t);
  END exit_proc;
</PRE>------------------------------------------------------------ load/store ---

<P><PRE>PROCEDURE <A NAME="load"><procedure>load</procedure></A>  (self: U;  v: Var;  o: ByteOffset;  t: MType) =
  BEGIN
    CheckVar (self, v);
    self.s_push (t);
    self.child.load (v, o, t);
  END load;

PROCEDURE <A NAME="store"><procedure>store</procedure></A>  (self: U;  v: Var;  o: ByteOffset;  t: MType) =
  BEGIN
    CheckVar (self, v);
    self.s_pop (T_to_ST [t]);
    IF (self.clean_stores) THEN self.s_empty () END;
    self.child.store (v, o, t);
  END store;

PROCEDURE <A NAME="store_ref"><procedure>store_ref</procedure></A> (self: U;  v: Var;  o: ByteOffset) =
  BEGIN
    CheckVar (self, v);
    self.s_pop (ST.Addr);
    IF (self.clean_stores) THEN self.s_empty () END;
    self.child.store_ref (v, o);
  END store_ref;

PROCEDURE <A NAME="load_address"><procedure>load_address</procedure></A> (self: U;  v: Var;  o: ByteOffset) =
  BEGIN
    CheckVar (self, v);
    self.s_push (Type.Addr);
    self.child.load_address (v, o);
  END load_address;

PROCEDURE <A NAME="load_indirect"><procedure>load_indirect</procedure></A> (self: U;  o: ByteOffset;  t: MType) =
  BEGIN
    self.s_pop (ST.Addr);
    self.s_push (t);
    self.child.load_indirect (o, t);
  END load_indirect;

PROCEDURE <A NAME="store_indirect"><procedure>store_indirect</procedure></A> (self: U;  o: ByteOffset;  t: MType) =
  BEGIN
    self.s_pop (T_to_ST [t], ST.Addr);
    IF (self.clean_stores) THEN self.s_empty () END;
    self.child.store_indirect (o, t);
  END store_indirect;

PROCEDURE <A NAME="store_ref_indirect"><procedure>store_ref_indirect</procedure></A> (self: U;  o: ByteOffset;  var: BOOLEAN) =
  BEGIN
    self.s_pop (ST.Addr, ST.Addr);
    IF (self.clean_stores) THEN self.s_empty () END;
    self.child.store_ref_indirect (o, var);
  END store_ref_indirect;
</PRE>-------------------------------------------------------------- literals ---

<P><PRE>PROCEDURE <A NAME="load_nil"><procedure>load_nil</procedure></A> (self: U) =
  (* push ; s0.A := a *)
  BEGIN
    self.s_push (Type.Addr);
    self.child.load_nil ();
  END load_nil;

PROCEDURE <A NAME="load_integer"><procedure>load_integer</procedure></A>  (self: U;  READONLY i: Target.Int) =
  (* push ; s0.I := i *)
  BEGIN
    self.s_push (Type.Int);
    self.child.load_integer (i);
  END load_integer;

PROCEDURE <A NAME="load_float"><procedure>load_float</procedure></A>    (self: U;  READONLY f: Target.Float) =
  (* push ; s0.t := f *)
  CONST FType = ARRAY Target.Precision OF Type
                { Type.Reel, Type.LReel, Type.XReel };
  VAR t := FType [f.pre];
  BEGIN
    self.s_push (t);
    self.child.load_float (f);
  END load_float;
</PRE>------------------------------------------------------------ arithmetic ---

<P><PRE>PROCEDURE <A NAME="Binary"><procedure>Binary</procedure></A> (self: U;  lhs, rhs: Type) =
  (* s1.lhs := s1.rhs 'op' s0.rhs ; pop *)
  BEGIN
    self.s_pop (T_to_ST [rhs], ST.Match);
    self.s_push (lhs);
  END Binary;

PROCEDURE <A NAME="Unary"><procedure>Unary</procedure></A> (self: U;  lhs, rhs: Type) =
  (* s1.lhs := 'op' (s1.rhs) *)
  BEGIN
    self.s_pop (T_to_ST [rhs]);
    self.s_push (lhs);
  END Unary;

PROCEDURE <A NAME="eq"><procedure>eq</procedure></A> (self: U;  t: ZType) =
  (* s1.I := (s1.t = s0.t)  ; pop *)
  BEGIN
    Binary (self, Type.Int, t);
    self.child.eq (t);
  END eq;

PROCEDURE <A NAME="ne"><procedure>ne</procedure></A> (self: U;  t: ZType) =
  (* s1.I := (s1.t # s0.t)  ; pop *)
  BEGIN
    Binary (self, Type.Int, t);
    self.child.ne (t);
  END ne;

PROCEDURE <A NAME="gt"><procedure>gt</procedure></A> (self: U;  t: ZType) =
  (* s1.I := (s1.t &gt; s0.t)  ; pop *)
  BEGIN
    Binary (self, Type.Int, t);
    self.child.gt (t);
  END gt;

PROCEDURE <A NAME="ge"><procedure>ge</procedure></A> (self: U;  t: ZType) =
  (* s1.I := (s1.t &gt;= s0.t) ; pop *)
  BEGIN
    Binary (self, Type.Int, t);
    self.child.ge (t);
  END ge;

PROCEDURE <A NAME="lt"><procedure>lt</procedure></A> (self: U;  t: ZType) =
  (* s1.I := (s1.t &lt; s0.t)  ; pop *)
  BEGIN
    Binary (self, Type.Int, t);
    self.child.lt (t);
  END lt;

PROCEDURE <A NAME="le"><procedure>le</procedure></A> (self: U;  t: ZType) =
  (* s1.I := (s1.t &lt;= s0.t) ; pop *)
  BEGIN
    Binary (self, Type.Int, t);
    self.child.le (t);
  END le;

PROCEDURE <A NAME="add"><procedure>add</procedure></A> (self: U;  t: AType) =
  (* s1.t := s1.t + s0.t ; pop *)
  BEGIN
    Binary (self, t, t);
    self.child.add (t);
  END add;

PROCEDURE <A NAME="subtract"><procedure>subtract</procedure></A> (self: U;  t: AType) =
  (* s1.t := s1.t - s0.t ; pop *)
  BEGIN
    Binary (self, t, t);
    self.child.subtract (t);
  END subtract;

PROCEDURE <A NAME="multiply"><procedure>multiply</procedure></A> (self: U;  t: AType) =
  (* s1.t := s1.t * s0.t ; pop *)
  BEGIN
    Binary (self, t, t);
    self.child.multiply (t);
  END multiply;

PROCEDURE <A NAME="divide"><procedure>divide</procedure></A> (self: U;  t: RType) =
  (* s1.t := s1.t / s0.t ; pop *)
  BEGIN
    Binary (self, t, t);
    self.child.divide (t);
  END divide;

PROCEDURE <A NAME="div"><procedure>div</procedure></A> (self: U;  t: IType;  a, b: Sign) =
  (* s1.t := s1.t DIV s0.t ; pop *)
  BEGIN
    self.s_pop (T_to_ST [t], ST.Match);
    self.s_push (t);
    self.child.div (t, a, b);
  END div;

PROCEDURE <A NAME="mod"><procedure>mod</procedure></A> (self: U;  t: IType;  a, b: Sign) =
  (* s1.t := s1.t MOD s0.t ; pop *)
  BEGIN
    self.s_pop (T_to_ST [t], ST.Match);
    self.s_push (t);
    self.child.mod (t, a, b);
  END mod;

PROCEDURE <A NAME="negate"><procedure>negate</procedure></A> (self: U;  t: AType) =
  (* s0.t := - s0.t *)
  BEGIN
    Unary (self, t, t);
    self.child.negate (t);
  END negate;

PROCEDURE <A NAME="abs"><procedure>abs</procedure></A>      (self: U;  t: AType) =
  (* s0.t := ABS (s0.t) (noop on Words) *)
  BEGIN
    Unary (self, t, t);
    self.child.abs (t);
  END abs;

PROCEDURE <A NAME="max"><procedure>max</procedure></A>      (self: U;  t: ZType) =
  (* s1.t := MAX (s1.t, s0.t) ; pop *)
  BEGIN
    Binary (self, t, t);
    self.child.max (t);
  END max;

PROCEDURE <A NAME="min"><procedure>min</procedure></A>      (self: U;  t: ZType) =
  (* s1.t := MIN (s1.t, s0.t) ; pop *)
  BEGIN
    Binary (self, t, t);
    self.child.min (t);
  END min;

PROCEDURE <A NAME="round"><procedure>round</procedure></A>    (self: U;  t: RType) =
  (* s0.I := ROUND (s0.t) *)
  BEGIN
    Unary (self, Type.Int, t);
    self.child.round (t);
  END round;

PROCEDURE <A NAME="trunc"><procedure>trunc</procedure></A>    (self: U;  t: RType) =
  (* s0.I := TRUNC (s0.t) *)
  BEGIN
    Unary (self, Type.Int, t);
    self.child.trunc (t);
  END trunc;

PROCEDURE <A NAME="floor"><procedure>floor</procedure></A>    (self: U;  t: RType) =
  (* s0.I := FLOOR (s0.t) *)
  BEGIN
    Unary (self, Type.Int, t);
    self.child.floor (t);
  END floor;

PROCEDURE <A NAME="ceiling"><procedure>ceiling</procedure></A>  (self: U;  t: RType) =
  (* s0.I := CEILING (s0.t) *)
  BEGIN
    Unary (self, Type.Int, t);
    self.child.ceiling (t);
  END ceiling;

PROCEDURE <A NAME="cvt_float"><procedure>cvt_float</procedure></A>    (self: U;  t: AType;  u: RType) =
  (* s0.u := FLOAT (s0.t, u) *)
  BEGIN
    self.s_pop (T_to_ST [t]);
    self.s_push (u);
    self.child.cvt_float (t, u);
  END cvt_float;
</PRE>------------------------------------------------------------------ sets ---

<P><PRE>PROCEDURE <A NAME="set_union"><procedure>set_union</procedure></A> (self: U;  s: ByteSize) =
  (* s2.B := s1.B + s0.B ; pop(3) *)
  BEGIN
    self.s_pop (ST.Addr, ST.Addr, ST.Addr);
    self.child.set_union (s);
  END set_union;

PROCEDURE <A NAME="set_difference"><procedure>set_difference</procedure></A> (self: U;  s: ByteSize) =
  (* s2.B := s1.B - s0.B ; pop(3) *)
  BEGIN
    self.s_pop (ST.Addr, ST.Addr, ST.Addr);
    self.child.set_difference (s);
  END set_difference;

PROCEDURE <A NAME="set_intersection"><procedure>set_intersection</procedure></A> (self: U;  s: ByteSize) =
  (* s2.B := s1.B * s0.B ; pop(3) *)
  BEGIN
    self.s_pop (ST.Addr, ST.Addr, ST.Addr);
    self.child.set_intersection (s);
  END set_intersection;

PROCEDURE <A NAME="set_sym_difference"><procedure>set_sym_difference</procedure></A> (self: U;  s: ByteSize) =
  (* s2.B := s1.B / s0.B ; pop(3) *)
  BEGIN
    self.s_pop (ST.Addr, ST.Addr, ST.Addr);
    self.child.set_sym_difference (s);
  END set_sym_difference;

PROCEDURE <A NAME="set_member"><procedure>set_member</procedure></A>       (self: U;  s: ByteSize) =
  (* s1.I := (s0.I IN s1.B) ; pop *)
  BEGIN
    self.s_pop (ST.Int, ST.Addr);
    self.s_push (Type.Int);
    self.child.set_member (s);
  END set_member;

PROCEDURE <A NAME="set_eq"><procedure>set_eq</procedure></A>       (self: U;  s: ByteSize) =
  (* s1.I := (s1.B = s0.B)  ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Addr);
    self.child.set_eq (s);
  END set_eq;

PROCEDURE <A NAME="set_ne"><procedure>set_ne</procedure></A> (self: U;  s: ByteSize) =
  (* s1.I := (s1.B # s0.B)  ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Addr);
    self.child.set_ne (s);
  END set_ne;

PROCEDURE <A NAME="set_gt"><procedure>set_gt</procedure></A> (self: U;  s: ByteSize) =
  (* s1.I := (s1.B &gt; s0.B)  ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Addr);
    self.child.set_gt (s);
  END set_gt;

PROCEDURE <A NAME="set_ge"><procedure>set_ge</procedure></A> (self: U;  s: ByteSize) =
  (* s1.I := (s1.B &gt;= s0.B) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Addr);
    self.child.set_ge (s);
  END set_ge;

PROCEDURE <A NAME="set_lt"><procedure>set_lt</procedure></A> (self: U;  s: ByteSize) =
  (* s1.I := (s1.B &lt; s0.B)  ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Addr);
    self.child.set_lt (s);
  END set_lt;

PROCEDURE <A NAME="set_le"><procedure>set_le</procedure></A> (self: U;  s: ByteSize) =
  (* s1.I := (s1.B &lt;= s0.B) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Addr);
    self.child.set_le (s);
  END set_le;

PROCEDURE <A NAME="set_range"><procedure>set_range</procedure></A> (self: U;  s: ByteSize) =
  (* s2.A [s1.I .. s0.I] := 1's; pop(3)*)
  BEGIN
    self.s_pop (ST.Int, ST.Int, ST.Addr);
    self.child.set_range (s);
  END set_range;

PROCEDURE <A NAME="set_singleton"><procedure>set_singleton</procedure></A> (self: U;  s: ByteSize) =
  (* s1.A [s0.I] := 1; pop(2) *)
  BEGIN
    self.s_pop (ST.Int, ST.Addr);
    self.child.set_singleton (s);
  END set_singleton;
</PRE>------------------------------------------------- Word.T bit operations ---

<P><PRE>PROCEDURE <A NAME="not"><procedure>not</procedure></A> (self: U) =
  (* s0.I := Word.Not (s0.I) *)
  BEGIN
    Unary (self, Type.Int, Type.Int);
    self.child.not ();
  END not;

PROCEDURE <A NAME="and"><procedure>and</procedure></A> (self: U) =
  (* s1.I := Word.And (s1.I, s0.I) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Int);
    self.child.and ();
  END and;

PROCEDURE <A NAME="or"><procedure>or</procedure></A>  (self: U) =
  (* s1.I := Word.Or  (s1.I, s0.I) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Int);
    self.child.or ();
  END or;

PROCEDURE <A NAME="xor"><procedure>xor</procedure></A> (self: U) =
  (* s1.I := Word.Xor (s1.I, s0.I) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Int);
    self.child.xor ();
  END xor;

PROCEDURE <A NAME="shift"><procedure>shift</procedure></A>        (self: U) =
  (* s1.I := Word.Shift  (s1.I, s0.I) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Int);
    self.child.shift ();
  END shift;

PROCEDURE <A NAME="shift_left"><procedure>shift_left</procedure></A>   (self: U) =
  (* s1.I := Word.Shift  (s1.I, s0.I) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Int);
    self.child.shift_left ();
  END shift_left;

PROCEDURE <A NAME="shift_right"><procedure>shift_right</procedure></A>  (self: U) =
  (* s1.I := Word.Shift  (s1.I, -s0.I) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Int);
    self.child.shift_right ();
  END shift_right;

PROCEDURE <A NAME="rotate"><procedure>rotate</procedure></A>       (self: U) =
  (* s1.I := Word.Rotate (s1.I, s0.I) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Int);
    self.child.rotate ();
  END rotate;

PROCEDURE <A NAME="rotate_left"><procedure>rotate_left</procedure></A>  (self: U) =
  (* s1.I := Word.Rotate (s1.I, s0.I) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Int);
    self.child.rotate_left ();
  END rotate_left;

PROCEDURE <A NAME="rotate_right"><procedure>rotate_right</procedure></A> (self: U) =
  (* s1.I := Word.Rotate (s1.I, -s0.I) ; pop *)
  BEGIN
    Binary (self, Type.Int, Type.Int);
    self.child.rotate_right ();
  END rotate_right;

PROCEDURE <A NAME="extract"><procedure>extract</procedure></A> (self: U;  sign: BOOLEAN) =
  (* s2.I := Word.Extract(s2.I, s1.I, s0.I);
     IF sign THEN SignExtend s2 END; pop(2) *)
  BEGIN
    self.s_pop (ST.Int, ST.Int, ST.Int);
    self.s_push (Type.Int);
    self.child.extract (sign);
  END extract;

PROCEDURE <A NAME="extract_n"><procedure>extract_n</procedure></A> (self: U;  sign: BOOLEAN;  n: INTEGER) =
  (* s1.I := Word.Extract(s1.I, s0.I, n);
     IF sign THEN SignExtend s1 END; pop(1) *)
  BEGIN
    self.s_pop (ST.Int, ST.Int);
    self.s_push (Type.Int);
    self.child.extract_n (sign, n);
  END extract_n;

PROCEDURE <A NAME="extract_mn"><procedure>extract_mn</procedure></A> (self: U;  sign: BOOLEAN;  m, n: INTEGER) =
  (* s0.I := Word.Extract(s0.I, m, n);
     IF sign THEN SignExtend s0 END; *)
  BEGIN
    self.s_pop (ST.Int);
    self.s_push (Type.Int);
    self.child.extract_mn (sign, m, n);
  END extract_mn;

PROCEDURE <A NAME="insert"><procedure>insert</procedure></A>  (self: U) =
  (* s3.I := Word.Insert (s3.I, s2.I, s1.I, s0.I) ; pop(3) *)
  BEGIN
    self.s_pop (ST.Int, ST.Int, ST.Int, ST.Int);
    self.s_push (Type.Int);
    self.child.insert ();
  END insert;

PROCEDURE <A NAME="insert_n"><procedure>insert_n</procedure></A>  (self: U;  n: INTEGER) =
  (* s2.I := Word.Insert (s2.I, s1.I, s0.I, n) ; pop(2) *)
  BEGIN
    self.s_pop (ST.Int, ST.Int, ST.Int);
    self.s_push (Type.Int);
    self.child.insert_n (n);
  END insert_n;

PROCEDURE <A NAME="insert_mn"><procedure>insert_mn</procedure></A>  (self: U;  m, n: INTEGER) =
  (* s1.I := Word.Insert (s1.I, s0.I, m, n) ; pop(2) *)
  BEGIN
    self.s_pop (ST.Int, ST.Int);
    self.s_push (Type.Int);
    self.child.insert_mn (m, n);
  END insert_mn;
</PRE>------------------------------------------------ misc. stack/memory ops ---

<P><PRE>PROCEDURE <A NAME="swap"><procedure>swap</procedure></A> (self: U;  a, b: Type) =
  (* tmp := s1 ; s1 := s0 ; s0 := tmp *)
  BEGIN
    self.s_pop (T_to_ST [b], T_to_ST [a]);
    self.s_push (b);
    self.s_push (a);
    self.child.swap (a, b);
  END swap;

PROCEDURE <A NAME="pop"><procedure>pop</procedure></A>  (self: U;  t: Type) =
  (* pop(1) (i.e. discard s0) *)
  BEGIN
    self.s_pop (T_to_ST [t]);
    self.child.pop (t);
  END pop;

PROCEDURE <A NAME="copy_n"><procedure>copy_n</procedure></A> (self: U;  t: MType;  overlap: BOOLEAN) =
  (* Mem[s2.A:s0.I] := Mem[s1.A:s0.I]; pop(3)*)
  BEGIN
    self.s_pop (ST.Int, ST.Addr, ST.Addr);
    self.child.copy_n (t, overlap);
  END copy_n;

PROCEDURE <A NAME="copy"><procedure>copy</procedure></A> (self: U;  n: INTEGER;  t: MType;  overlap: BOOLEAN) =
  (* Mem[s2.A:sz] := Mem[s1.A:sz]; pop(2)*)
  BEGIN
    self.s_pop (ST.Addr, ST.Addr);
    self.child.copy (n, t, overlap);
  END copy;

PROCEDURE <A NAME="zero_n"><procedure>zero_n</procedure></A> (self: U;  t: MType) =
  (* Mem[s1.A:s0.I] := 0; pop(2) *)
  BEGIN
    self.s_pop (ST.Int, ST.Addr);
    self.child.zero_n (t);
  END zero_n;

PROCEDURE <A NAME="zero"><procedure>zero</procedure></A> (self: U;  n: INTEGER;  t: MType) =
  (* Mem[s1.A:sz] := 0; pop(1) *)
  BEGIN
    self.s_pop (ST.Addr);
    self.child.zero (n, t);
  END zero;
</PRE>----------------------------------------------------------- conversions ---

<P><PRE>PROCEDURE <A NAME="loophole"><procedure>loophole</procedure></A> (self: U;  from, two: ZType) =
  (* s0.to := LOOPHOLE(s0.from, to) *)
  BEGIN
    self.s_pop (T_to_ST [from]);
    self.s_push (two);
    self.child.loophole (from, two);
  END loophole;
</PRE>------------------------------------------------ traps &amp; runtime checks ---

<P><PRE>PROCEDURE <A NAME="assert_fault"><procedure>assert_fault</procedure></A> (self: U) =
  BEGIN
    self.s_empty ();
    self.child.assert_fault ();
  END assert_fault;

PROCEDURE <A NAME="narrow_fault"><procedure>narrow_fault</procedure></A> (self: U) =
  BEGIN
    self.child.narrow_fault ();
  END narrow_fault;

PROCEDURE <A NAME="return_fault"><procedure>return_fault</procedure></A> (self: U) =
  BEGIN
    self.s_empty ();
    self.child.return_fault ();
  END return_fault;

PROCEDURE <A NAME="case_fault"><procedure>case_fault</procedure></A> (self: U) =
  BEGIN
    self.s_empty ();
    self.child.case_fault ();
  END case_fault;

PROCEDURE <A NAME="typecase_fault"><procedure>typecase_fault</procedure></A> (self: U) =
  (* Abort *)
  BEGIN
    self.s_empty ();
    self.child.typecase_fault ();
  END typecase_fault;

PROCEDURE <A NAME="check_nil"><procedure>check_nil</procedure></A> (self: U) =
  (* IF (s0.A = NIL) THEN Abort *)
  BEGIN
    self.s_pop (ST.Addr);
    self.s_push (Type.Addr);
    self.child.check_nil ();
  END check_nil;

PROCEDURE <A NAME="check_lo"><procedure>check_lo</procedure></A> (self: U;  READONLY i: Target.Int) =
  (* IF (s0.I &lt; i) THEN Abort *)
  BEGIN
    self.s_pop (ST.Int);
    self.s_push (Type.Int);
    self.child.check_lo (i);
  END check_lo;

PROCEDURE <A NAME="check_hi"><procedure>check_hi</procedure></A> (self: U;  READONLY i: Target.Int) =
  (* IF (i &lt; s0.I) THEN Abort *)
  BEGIN
    self.s_pop (ST.Int);
    self.s_push (Type.Int);
    self.child.check_hi (i);
  END check_hi;

PROCEDURE <A NAME="check_range"><procedure>check_range</procedure></A> (self: U;  READONLY a, b: Target.Int) =
  (* IF (s0.I &lt; a) OR (b &lt; s0.I) THEN Abort *)
  BEGIN
    self.s_pop (ST.Int);
    self.s_push (Type.Int);
    self.child.check_range (a, b);
  END check_range;

PROCEDURE <A NAME="check_index"><procedure>check_index</procedure></A> (self: U) =
  BEGIN
    self.s_pop (ST.Int, ST.Int);
    self.s_push (Type.Int);
    self.child.check_index ();
  END check_index;

PROCEDURE <A NAME="check_eq"><procedure>check_eq</procedure></A> (self: U) =
  (* IF (s0.I # s1.I) THEN Abort;  Pop (2) *)
  BEGIN
    self.s_pop (ST.Int, ST.Int);
    self.child.check_eq ();
  END check_eq;
</PRE>---------------------------------------------------- address arithmetic ---

<P><PRE>PROCEDURE <A NAME="add_offset"><procedure>add_offset</procedure></A> (self: U; i: INTEGER) =
  (* s0.A := s0.A + i *)
  BEGIN
    self.s_pop (ST.Addr);
    self.s_push (Type.Addr);
    self.child.add_offset (i);
  END add_offset;

PROCEDURE <A NAME="index_address"><procedure>index_address</procedure></A> (self: U;  size: INTEGER) =
  (* s1.A := s1.A + s0.I * size ; pop *)
  BEGIN
    self.s_pop (ST.Int, ST.Addr);
    self.s_push (Type.Addr);
    self.child.index_address (size);
  END index_address;
</PRE>------------------------------------------------------- procedure calls ---

<P><PRE>PROCEDURE <A NAME="start_call_direct"><procedure>start_call_direct</procedure></A> (self: U;  p: Proc;  lev: INTEGER;  t: Type) =
  (* begin a procedure call to a procedure at static level 'lev'. *)
  BEGIN
    CheckProc (self, p);
    IF (self.clean_jumps) THEN self.s_empty () END;
    IF (self.call_count &gt; 0) AND (NOT self.nested_calls) THEN
      PutErr (self, &quot;nested procedure call&quot;);
    END;
    INC (self.call_count);
    self.child.start_call_direct (p, lev, t);
  END start_call_direct;

PROCEDURE <A NAME="start_call_indirect"><procedure>start_call_indirect</procedure></A> (self: U;  t: Type;  cc: CallingConvention) =
  (* begin a procedure call to a procedure at static level 'lev'. *)
  BEGIN
    IF (self.clean_jumps) THEN self.s_empty () END;
    IF (self.call_count &gt; 0) AND (NOT self.nested_calls) THEN
      PutErr (self, &quot;nested procedure call&quot;);
    END;
    INC (self.call_count);
    self.child.start_call_indirect (t, cc);
  END start_call_indirect;

PROCEDURE <A NAME="pop_param"><procedure>pop_param</procedure></A> (self: U;  t: ZType) =
  (* pop s0 and make it the &quot;next&quot; parameter in the current call *)
  BEGIN
    IF (self.call_count &lt;= 0) THEN PutErr (self, &quot;missing start_call&quot;) END;
    self.s_pop (T_to_ST [t]);
    IF (self.clean_stores) THEN self.s_empty () END;
    self.child.pop_param (t);
  END pop_param;

PROCEDURE <A NAME="pop_struct"><procedure>pop_struct</procedure></A> (self: U;  s: ByteSize;  a: Alignment) =
  (* pop s0 and make it the &quot;next&quot; parameter in the current call *)
  BEGIN
    IF (self.call_count &lt;= 0) THEN PutErr (self, &quot;missing start_call&quot;) END;
    self.s_pop (ST.Addr);
    IF (self.clean_stores) THEN self.s_empty () END;
    self.child.pop_struct (s, a);
  END pop_struct;

PROCEDURE <A NAME="pop_static_link"><procedure>pop_static_link</procedure></A> (self: U) =
  BEGIN
    IF (self.call_count &lt;= 0) THEN PutErr (self, &quot;missing start_call&quot;) END;
    self.s_pop (ST.Addr);
    IF (self.clean_stores) THEN self.s_empty () END;
    self.child.pop_static_link ();
  END pop_static_link;

PROCEDURE <A NAME="DoCall"><procedure>DoCall</procedure></A> (self: U) =
  BEGIN
    IF (self.clean_jumps) THEN self.s_empty () END;
    IF (self.call_count &gt; 0)
      THEN DEC (self.call_count);
      ELSE PutErr (self, &quot;missing start_call&quot;);
    END;
  END DoCall;

PROCEDURE <A NAME="call_direct"><procedure>call_direct</procedure></A> (self: U; p: Proc;  t: Type) =
  (* call the procedure identified by block b.  The procedure
     returns a value of type t. *)
  BEGIN
    CheckProc (self, p);
    DoCall (self);
    IF (t # Type.Void) THEN self.s_push (t) END;
    self.child.call_direct (p, t);
  END call_direct;

PROCEDURE <A NAME="call_indirect"><procedure>call_indirect</procedure></A> (self: U; t: Type;  cc: CallingConvention) =
  (* call the procedure whose address is in s0.A and pop s0.  The
     procedure returns a value of type t. *)
  BEGIN
    self.s_pop (ST.Addr);
    DoCall (self);
    IF (t # Type.Void) THEN self.s_push (t) END;
    self.child.call_indirect (t, cc);
  END call_indirect;
</PRE>------------------------------------------- procedure and closure types ---

<P><PRE>PROCEDURE <A NAME="load_procedure"><procedure>load_procedure</procedure></A> (self: U;  p: Proc) =
  (* push; s0.A := ADDR (p's body) *)
  BEGIN
    CheckProc (self, p);
    self.s_push (Type.Addr);
    self.child.load_procedure (p);
  END load_procedure;

PROCEDURE <A NAME="load_static_link"><procedure>load_static_link</procedure></A> (self: U;  p: Proc) =
  (* push; s0.A := (static link needed to call p, NIL for top-level procs) *)
  BEGIN
    CheckProc (self, p);
    self.s_push (Type.Addr);
    self.child.load_static_link (p);
  END load_static_link;

BEGIN
END M3CG_Check.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
