<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/M3CG_Rd.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/M3CG_Rd.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="M3CG_Rd.i3">M3CG_Rd</A></implements></module>;

IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../libm3/derived/IntIntTbl.i3">IntIntTbl</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../convert/src/Convert.i3">Convert</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="M3CG.i3">M3CG</A>, <A HREF="M3CG_Ops.i3">M3CG_Ops</A>, <A HREF="Target.i3">Target</A>, <A HREF="TInt.i3">TInt</A>, <A HREF="TFloat.i3">TFloat</A>;

CONST
  EOF = '\000';
  BufSize = 4096;

TYPE
  InputBuffer = REF ARRAY [0..BufSize-1] OF CHAR;

TYPE
  State = RECORD
    rd     : Rd.T;
    cg     : M3CG.T;
    ch     : CHAR;  (* current scan character *)
    buf    : InputBuffer;
    buf_len: CARDINAL;
    buf_ptr: CARDINAL;
    vars   : REF ARRAY OF M3CG.Var;
    procs  : REF ARRAY OF M3CG.Proc;
    labels : REF ARRAY OF M3CG.Label;
  END;

TYPE
  Cmd = RECORD
    op   : TEXT;
    proc : PROCEDURE (VAR s: State);
  END;

CONST
  CmdMap = ARRAY [0..154] OF Cmd {
    Cmd {&quot;begin_unit&quot;, begin_unit},
    Cmd {&quot;end_unit&quot;, end_unit},
    Cmd {&quot;import_unit&quot;, import_unit},
    Cmd {&quot;export_unit&quot;, export_unit},
    Cmd {&quot;-----FILE&quot;, set_source_file},
    Cmd {&quot;-----LINE&quot;, set_source_line},
    Cmd {&quot;declare_typename&quot;, declare_typename},
    Cmd {&quot;declare_array&quot;, declare_array},
    Cmd {&quot;declare_open_array&quot;, declare_open_array},
    Cmd {&quot;declare_enum&quot;, declare_enum},
    Cmd {&quot;declare_enum_elt&quot;, declare_enum_elt},
    Cmd {&quot;declare_packed&quot;, declare_packed},
    Cmd {&quot;declare_record&quot;, declare_record},
    Cmd {&quot;declare_field&quot;, declare_field},
    Cmd {&quot;declare_set&quot;, declare_set},
    Cmd {&quot;declare_subrange&quot;, declare_subrange},
    Cmd {&quot;declare_pointer&quot;, declare_pointer},
    Cmd {&quot;declare_indirect&quot;, declare_indirect},
    Cmd {&quot;declare_proctype&quot;, declare_proctype},
    Cmd {&quot;declare_formal&quot;, declare_formal},
    Cmd {&quot;declare_raises&quot;, declare_raises},
    Cmd {&quot;declare_object&quot;, declare_object},
    Cmd {&quot;declare_method&quot;, declare_method},
    Cmd {&quot;declare_opaque&quot;, declare_opaque},
    Cmd {&quot;reveal_opaque&quot;, reveal_opaque},
    Cmd {&quot;declare_exception&quot;, declare_exception},
    Cmd {&quot;set_runtime_hook&quot;, set_runtime_hook},
    Cmd {&quot;get_runtime_hook&quot;, get_runtime_hook},
    Cmd {&quot;import_global&quot;, import_global},
    Cmd {&quot;declare_segment&quot;, declare_segment},
    Cmd {&quot;bind_segment&quot;, bind_segment},
    Cmd {&quot;declare_global&quot;, declare_global},
    Cmd {&quot;declare_constant&quot;, declare_constant},
    Cmd {&quot;declare_local&quot;, declare_local},
    Cmd {&quot;declare_param&quot;, declare_param},
    Cmd {&quot;declare_temp&quot;, declare_temp},
    Cmd {&quot;free_temp&quot;, free_temp},
    Cmd {&quot;begin_init&quot;, begin_init},
    Cmd {&quot;end_init&quot;, end_init},
    Cmd {&quot;init_int&quot;, init_int},
    Cmd {&quot;init_proc&quot;, init_proc},
    Cmd {&quot;init_label&quot;, init_label},
    Cmd {&quot;init_var&quot;, init_var},
    Cmd {&quot;init_offset&quot;, init_offset},
    Cmd {&quot;init_chars&quot;, init_chars},
    Cmd {&quot;init_float&quot;, init_float},
    Cmd {&quot;import_procedure&quot;, import_procedure},
    Cmd {&quot;declare_procedure&quot;, declare_procedure},
    Cmd {&quot;begin_procedure&quot;, begin_procedure},
    Cmd {&quot;end_procedure&quot;, end_procedure},
    Cmd {&quot;begin_block&quot;, begin_block},
    Cmd {&quot;end_block&quot;, end_block},
    Cmd {&quot;note_procedure_origin&quot;, note_procedure_origin},
    Cmd {&quot;.&quot;, set_label},
    Cmd {&quot;jump&quot;, jump},
    Cmd {&quot;if_true&quot;, if_true},
    Cmd {&quot;if_false&quot;, if_false},
    Cmd {&quot;if_eq&quot;, if_eq},
    Cmd {&quot;if_ne&quot;, if_ne},
    Cmd {&quot;if_gt&quot;, if_gt},
    Cmd {&quot;if_ge&quot;, if_ge},
    Cmd {&quot;if_lt&quot;, if_lt},
    Cmd {&quot;if_le&quot;, if_le},
    Cmd {&quot;case_jump&quot;, case_jump},
    Cmd {&quot;exit_proc&quot;, exit_proc},
    Cmd {&quot;load&quot;, load},
    Cmd {&quot;store&quot;, store},
    Cmd {&quot;store_ref&quot;, store_ref},
    Cmd {&quot;load_address&quot;, load_address},
    Cmd {&quot;load_indirect&quot;, load_indirect},
    Cmd {&quot;store_indirect&quot;, store_indirect},
    Cmd {&quot;store_ref_indirect&quot;, store_ref_indirect},
    Cmd {&quot;load_nil&quot;, load_nil},
    Cmd {&quot;load_integer&quot;, load_integer},
    Cmd {&quot;load_float&quot;, load_float},
    Cmd {&quot;eq&quot;, eq},
    Cmd {&quot;ne&quot;, ne},
    Cmd {&quot;gt&quot;, gt},
    Cmd {&quot;ge&quot;, ge},
    Cmd {&quot;lt&quot;, lt},
    Cmd {&quot;le&quot;, le},
    Cmd {&quot;add&quot;, add},
    Cmd {&quot;subtract&quot;, subtract},
    Cmd {&quot;multiply&quot;, multiply},
    Cmd {&quot;divide&quot;, divide},
    Cmd {&quot;div&quot;, div},
    Cmd {&quot;mod&quot;, mod},
    Cmd {&quot;negate&quot;, negate},
    Cmd {&quot;abs&quot;, abs},
    Cmd {&quot;max&quot;, max},
    Cmd {&quot;min&quot;, min},
    Cmd {&quot;round&quot;, round},
    Cmd {&quot;trunc&quot;, trunc},
    Cmd {&quot;floor&quot;, floor},
    Cmd {&quot;ceiling&quot;, ceiling},
    Cmd {&quot;cvt_float&quot;, cvt_float},
    Cmd {&quot;set_union&quot;, set_union},
    Cmd {&quot;set_difference&quot;, set_difference},
    Cmd {&quot;set_intersection&quot;, set_intersection},
    Cmd {&quot;set_sym_difference&quot;, set_sym_difference},
    Cmd {&quot;set_member&quot;, set_member},
    Cmd {&quot;set_eq&quot;, set_eq},
    Cmd {&quot;set_ne&quot;, set_ne},
    Cmd {&quot;set_gt&quot;, set_gt},
    Cmd {&quot;set_ge&quot;, set_ge},
    Cmd {&quot;set_lt&quot;, set_lt},
    Cmd {&quot;set_le&quot;, set_le},
    Cmd {&quot;set_range&quot;, set_range},
    Cmd {&quot;set_singleton&quot;, set_singleton},
    Cmd {&quot;not&quot;, not},
    Cmd {&quot;and&quot;, and},
    Cmd {&quot;or&quot;, or},
    Cmd {&quot;xor&quot;, xor},
    Cmd {&quot;shift&quot;, shift},
    Cmd {&quot;shift_left&quot;, shift_left},
    Cmd {&quot;shift_right&quot;, shift_right},
    Cmd {&quot;rotate&quot;, rotate},
    Cmd {&quot;rotate_left&quot;, rotate_left},
    Cmd {&quot;rotate_right&quot;, rotate_right},
    Cmd {&quot;extract&quot;, extract},
    Cmd {&quot;extract_n&quot;, extract_n},
    Cmd {&quot;extract_mn&quot;, extract_mn},
    Cmd {&quot;insert&quot;, insert},
    Cmd {&quot;insert_n&quot;, insert_n},
    Cmd {&quot;insert_mn&quot;, insert_mn},
    Cmd {&quot;swap&quot;, swap},
    Cmd {&quot;pop&quot;, pop},
    Cmd {&quot;copy&quot;, copy},
    Cmd {&quot;copy_n&quot;, copy_n},
    Cmd {&quot;zero&quot;, zero},
    Cmd {&quot;zero_n&quot;, zero_n},
    Cmd {&quot;loophole&quot;, loophole},
    Cmd {&quot;assert_fault&quot;, assert_fault},
    Cmd {&quot;narrow_fault&quot;, narrow_fault},
    Cmd {&quot;return_fault&quot;, return_fault},
    Cmd {&quot;case_fault&quot;, case_fault},
    Cmd {&quot;typecase_fault&quot;, typecase_fault},
    Cmd {&quot;check_nil&quot;, check_nil},
    Cmd {&quot;check_lo&quot;, check_lo},
    Cmd {&quot;check_hi&quot;, check_hi},
    Cmd {&quot;check_range&quot;, check_range},
    Cmd {&quot;check_index&quot;, check_index},
    Cmd {&quot;check_eq&quot;, check_eq},
    Cmd {&quot;add_offset&quot;, add_offset},
    Cmd {&quot;index_address&quot;, index_address},
    Cmd {&quot;start_call_direct&quot;, start_call_direct},
    Cmd {&quot;call_direct&quot;, call_direct},
    Cmd {&quot;start_call_indirect&quot;, start_call_indirect},
    Cmd {&quot;call_indirect&quot;, call_indirect},
    Cmd {&quot;pop_param&quot;, pop_param},
    Cmd {&quot;pop_struct&quot;, pop_struct},
    Cmd {&quot;pop_static_link&quot;, pop_static_link},
    Cmd {&quot;load_procedure&quot;, load_procedure},
    Cmd {&quot;load_static_link&quot;, load_static_link},
    Cmd {&quot;#&quot;, comment}
  };

CONST
  Type_names = ARRAY [0..15] OF TEXT {
    &quot;Addr&quot;, &quot;Word&quot;, &quot;Int&quot;,
    &quot;Reel&quot;, &quot;LReel&quot;, &quot;XReel&quot;,
    &quot;Int.8&quot;, &quot;Int.16&quot;, &quot;Int.32&quot;, &quot;Int.64&quot;,
    &quot;Word.8&quot;, &quot;Word.16&quot;, &quot;Word.32&quot;, &quot;Word.64&quot;,
    &quot;Struct&quot;,
    &quot;Void&quot;
  };

VAR
  cmds: IntIntTbl.T := NIL;
  types: IntIntTbl.T := NIL;

PROCEDURE <A NAME="Inhale"><procedure>Inhale</procedure></A> (rd: Rd.T;  cg: M3CG.T) =
  VAR s: State;  op: M3CG.Name;  cmd: INTEGER;
  BEGIN
    s.rd      := rd;
    s.cg      := cg;
    s.ch      := ' ';
    s.buf     := NEW (InputBuffer);
    s.buf_len := 0;
    s.buf_ptr := 0;
    s.vars    := NEW (REF ARRAY OF M3CG.Var, 400);
    s.procs   := NEW (REF ARRAY OF M3CG.Proc, 50);
    s.labels  := NEW (REF ARRAY OF M3CG.Label, 400);
    FOR i := 0 TO LAST(s.labels^) DO s.labels[i] := M3CG.No_label END;
    IF (cmds = NIL) THEN Init () END;
    LOOP
      Skip_white_space (s);
      op := Scan_id (s);
      IF (op = M3ID.NoID) THEN EXIT END;
      IF cmds.get (op, cmd)
        THEN CmdMap [cmd].proc (s);
        ELSE Error (s, &quot;** undefined operator: &quot;, M3ID.ToText (op));
      END;
      Skip_line (s);
    END;
  END Inhale;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  BEGIN
    cmds := NEW (IntIntTbl.Default).init (2 * NUMBER (CmdMap));
    FOR i := FIRST (CmdMap) TO LAST (CmdMap) DO
      EVAL cmds.put (M3ID.Add (CmdMap[i].op), i);
    END;
    types := NEW (IntIntTbl.Default).init (2 * NUMBER (Type_names));
    FOR i := FIRST (Type_names) TO LAST (Type_names) DO
      EVAL types.put (M3ID.Add (Type_names[i]), i);
    END;
  END Init;

PROCEDURE <A NAME="Error"><procedure>Error</procedure></A> (&lt;*UNUSED*&gt; VAR s: State;  a, b, c: TEXT := NIL) =
  &lt;*FATAL Wr.Failure, Thread.Alerted*&gt;
  VAR msg := Target.EOL &amp; &quot;** ERROR in M3CG_Rd.Inhale: &quot;;
  BEGIN
    IF (a # NIL) THEN msg := msg &amp; a END;
    IF (b # NIL) THEN msg := msg &amp; b END;
    IF (c # NIL) THEN msg := msg &amp; c END;
    msg := msg &amp; &quot; **&quot; &amp; Target.EOL;
    Wr.PutText (Stdio.stdout, msg);
  END Error;
</PRE>--------------------------------------------------------------- parsing ---

<P><PRE>PROCEDURE <A NAME="Scan_word"><procedure>Scan_word</procedure></A> (VAR s: State): TEXT =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
  BEGIN
    IF (len = 0) THEN RETURN NIL END;
    RETURN Text.FromChars (SUBARRAY (buf, 0, len));
  END Scan_word;

PROCEDURE <A NAME="Scan_id"><procedure>Scan_id</procedure></A> (VAR s: State): M3CG.Name =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
  BEGIN
    IF (len = 0) THEN RETURN M3ID.NoID END;
    RETURN M3ID.FromStr (SUBARRAY (buf, 0, len));
  END Scan_id;

PROCEDURE <A NAME="Scan_name"><procedure>Scan_name</procedure></A> (VAR s: State): M3CG.Name =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
  BEGIN
    IF (len = 0) THEN Error (s, &quot;missing name!&quot;);  RETURN M3ID.NoID END;
    IF (len = 1) AND (buf[0] = '*') THEN RETURN M3ID.NoID END;
    RETURN M3ID.FromStr (SUBARRAY (buf, 0, len));
  END Scan_name;

PROCEDURE <A NAME="Scan_text"><procedure>Scan_text</procedure></A> (VAR s: State): TEXT =
  CONST Quote = '&quot;';   Escape = '\134';
  VAR buf: ARRAY [0..255] OF CHAR;  len, d0,d1,d2: INTEGER;  overflow := &quot;&quot;;
  BEGIN
    Skip_blanks (s);

    IF (s.ch = '*') THEN GetCh (s);  RETURN NIL END;

    IF (s.ch # Quote) THEN
      Error (s, &quot;bad text&quot;);
      RETURN Scan_word (s);
    END;
    GetCh (s); (* eat the quote *)

    len := 0;
    LOOP
      IF (s.ch = Quote) THEN GetCh (s);  EXIT END;
      IF (s.ch = EOF) THEN EXIT END;

      IF (s.ch = Escape) THEN
        (* escaped character *)
        IF GetDigit (s, d0) AND GetDigit (s, d1) AND GetDigit (s, d2) THEN
          s.ch := VAL (d0 * 64 + d1 * 8 + d2, CHAR);
        END;
      END;

      IF (len &gt; LAST (buf)) THEN
        overflow := overflow &amp; Text.FromChars (SUBARRAY (buf, 0, len));
        len := 0;
      END;

      buf[len] := s.ch; INC (len);
      GetCh (s);
    END;
    RETURN overflow &amp; Text.FromChars (SUBARRAY (buf, 0, len));
  END Scan_text;

PROCEDURE <A NAME="GetDigit"><procedure>GetDigit</procedure></A> (VAR s: State;  VAR val: INTEGER): BOOLEAN =
  BEGIN
    GetCh (s);
    IF (s.ch &lt; '0') OR ('7' &lt; s.ch) THEN
      Error (s, &quot;bad octal digit: &quot;, Text.FromChar (s.ch));
      val := 0;
      RETURN FALSE;
    ELSE
      val := ORD (s.ch) - ORD ('0');
      RETURN TRUE;
    END;
  END GetDigit;

PROCEDURE <A NAME="CvtInt"><procedure>CvtInt</procedure></A> (VAR s: State;  READONLY buf: ARRAY OF CHAR): INTEGER =
  VAR value, used: INTEGER;
  BEGIN
    value := Convert.ToInt (buf, used);
    IF (used # NUMBER (buf)) THEN
      Error (s, &quot;bad integer: &quot;, Text.FromChars (buf));
    END;
    RETURN value;
  END CvtInt;

PROCEDURE <A NAME="Scan_int"><procedure>Scan_int</procedure></A> (VAR s: State): INTEGER =
  VAR buf : ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
  BEGIN
    RETURN CvtInt (s, SUBARRAY (buf, 0, len));
  END Scan_int;

PROCEDURE <A NAME="Scan_Tint"><procedure>Scan_Tint</procedure></A> (VAR s: State): Target.Int =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
      result, tmp: Target.Int;   value, used: INTEGER;
  BEGIN
    value := Convert.ToInt (SUBARRAY (buf, 0, len), used);
    IF (used = len) AND TInt.FromInt (value, result) THEN
      RETURN result;
    ELSIF (buf[0] # '-') THEN
      IF TInt.New (SUBARRAY (buf, 0, len), result) THEN RETURN result END;
    ELSE (* Target doesn't handle negative values *)
      IF TInt.New (SUBARRAY (buf, 1, len-1), tmp)
        AND TInt.Subtract (TInt.Zero, tmp, result) THEN
        RETURN result;
      END;
    END;
    Error (s, &quot;illegal integer: &quot;, Text.FromChars (SUBARRAY (buf, 0, len)));
    RETURN TInt.Zero;
  END Scan_Tint;

PROCEDURE <A NAME="Scan_float"><procedure>Scan_float</procedure></A> (VAR s: State): Target.Float =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
      pre := Target.Precision.Short;  result: Target.Float;
  BEGIN
    IF    (len # 1) THEN BadPrec (s, buf, len);
    ELSIF (buf[0] = 'R') THEN pre := Target.Precision.Short;
    ELSIF (buf[0] = 'L') THEN pre := Target.Precision.Long;
    ELSIF (buf[0] = 'X') THEN pre := Target.Precision.Extended;
    ELSE BadPrec (s, buf, len);
    END;
    len := Scan_buf (s, buf);
    IF TFloat.New (SUBARRAY(buf,0,len), pre, result) THEN RETURN result END;
    Error (s, &quot;illegal float: &quot;, Text.FromChars (SUBARRAY (buf, 0, len)));
    RETURN TFloat.ZeroR;
  END Scan_float;

PROCEDURE <A NAME="BadPrec"><procedure>BadPrec</procedure></A> (VAR s: State;  READONLY buf: ARRAY OF CHAR;  len: INTEGER) =
  BEGIN
    Error (s, &quot;bad floating-point precision: &quot;,
                Text.FromChars (SUBARRAY (buf, 0, len)));
  END BadPrec;

PROCEDURE <A NAME="Scan_type"><procedure>Scan_type</procedure></A> (VAR s: State): M3CG.Type =
  VAR name := Scan_id (s);  val: INTEGER;
  BEGIN
    IF types.get (name, val) THEN RETURN VAL (val, M3CG.Type) END;
    Error (s, &quot;illegal type: &quot;, M3ID.ToText (name));
    RETURN M3CG.Type.Int;
  END Scan_type;

PROCEDURE <A NAME="Scan_bool"><procedure>Scan_bool</procedure></A> (VAR s: State): BOOLEAN =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
  BEGIN
    IF (len = 1) THEN
      IF (buf [0] = 'T') THEN RETURN TRUE;
      ELSIF (buf[0] = 'F') THEN RETURN FALSE;
      END;
    END;
    Error (s, &quot;illegal boolean: &quot;, Text.FromChars (SUBARRAY (buf, 0, len)));
    RETURN TRUE;
  END Scan_bool;

PROCEDURE <A NAME="Scan_label"><procedure>Scan_label</procedure></A> (VAR s: State): INTEGER =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);  val, x: INTEGER;
  BEGIN
    IF (len = 1) AND (buf[0] = '*') THEN
      RETURN M3CG.No_label;
    ELSIF (len &lt; 3) OR (buf[0] # 'L') OR (buf[1] # '.') THEN
      Error (s, &quot;Bad label: &quot;, Text.FromChars(SUBARRAY (buf, 0, len)));
      RETURN M3CG.No_label;
    END;

    val := CvtInt (s, SUBARRAY (buf, 2, len - 2));
    IF (val &lt; 0) THEN
      Error (s, &quot;Bad label: &quot;, Text.FromChars(SUBARRAY (buf, 0, len)));
      RETURN M3CG.No_label;
    END;

    WHILE (val &gt; LAST (s.labels^)) DO ExpandLabels (s) END;

    x := s.labels[val];
    IF (x = M3CG.No_label) THEN
      x := s.cg.next_label ();
      s.labels[val] := x;
    END;
    RETURN x;
  END Scan_label;

PROCEDURE <A NAME="ExpandLabels"><procedure>ExpandLabels</procedure></A> (VAR s: State) =
  VAR new := NEW (REF ARRAY OF M3CG.Label, 2 * NUMBER (s.labels^));
  BEGIN
    SUBARRAY (new^, 0, NUMBER (s.labels^)) := s.labels^;
    FOR i := NUMBER (s.labels^) TO LAST (new^) DO new[i] := M3CG.No_label END;
    s.labels := new;
  END ExpandLabels;

PROCEDURE <A NAME="Scan_tipe"><procedure>Scan_tipe</procedure></A> (VAR s: State): M3CG.TypeUID =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
  BEGIN
    RETURN CvtInt (s, SUBARRAY (buf, 0, len));
  END Scan_tipe;

PROCEDURE <A NAME="Scan_varName"><procedure>Scan_varName</procedure></A> (VAR s: State): INTEGER =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
  BEGIN
    IF (len = 1) AND (buf[0] = '*') THEN
      RETURN -1;
    ELSIF (len &lt; 3) OR (buf[0] # 'v') OR (buf[1] # '.') THEN
      Error (s, &quot;Bad variable name: &quot;, Text.FromChars(SUBARRAY (buf, 0, len)));
      RETURN -1;
    ELSE
      RETURN CvtInt (s, SUBARRAY (buf, 2, len - 2));
    END;
  END Scan_varName;

PROCEDURE <A NAME="Scan_var"><procedure>Scan_var</procedure></A> (VAR s: State): M3CG.Var =
  VAR id := Scan_varName (s);
  BEGIN
    IF (id &lt; 0)
      THEN RETURN NIL;
      ELSE RETURN s.vars[id];
    END;
  END Scan_var;

PROCEDURE <A NAME="Scan_procName"><procedure>Scan_procName</procedure></A> (VAR s: State): INTEGER =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
  BEGIN
    IF (len = 1) AND (buf[0] = '*') THEN
      RETURN -1;
    ELSIF (len &lt; 3) OR (buf[0] # 'p') OR (buf[1] # '.') THEN
      Error (s, &quot;Bad procedure name: &quot;, Text.FromChars (SUBARRAY (buf,0,len)));
      RETURN -1;
    ELSE
      RETURN CvtInt (s, SUBARRAY (buf, 2, len - 2));
    END;
  END Scan_procName;

PROCEDURE <A NAME="Scan_proc"><procedure>Scan_proc</procedure></A> (VAR s: State): M3CG.Proc =
  VAR id := Scan_procName (s);
  BEGIN
    IF (id &lt; 0)
      THEN RETURN NIL;
      ELSE RETURN s.procs[id];
    END;
  END Scan_proc;

PROCEDURE <A NAME="Scan_sign"><procedure>Scan_sign</procedure></A> (VAR s: State): M3CG.Sign =
  VAR buf: ARRAY [0..99] OF CHAR;  len := Scan_buf (s, buf);
  BEGIN
    IF (len # 1) THEN
      Error (s, &quot;bad sign: &quot;, Text.FromChars (SUBARRAY (buf, 0, len)));
    ELSIF (buf[0] = 'X') THEN  RETURN M3CG.Sign.Unknown;
    ELSIF (buf[0] = 'N') THEN  RETURN M3CG.Sign.Negative;
    ELSIF (buf[0] = 'P') THEN  RETURN M3CG.Sign.Positive;
    ELSE Error (s, &quot;bad sign: &quot;, Text.FromChars (SUBARRAY (buf, 0, len)));
    END;
    RETURN M3CG.Sign.Unknown;
  END Scan_sign;

PROCEDURE <A NAME="Scan_callConv"><procedure>Scan_callConv</procedure></A> (VAR s: State): Target.CallingConvention =
  VAR
    id := Scan_int (s);
    cc := Target.ConventionFromID (id);
  BEGIN
    IF (cc = NIL) THEN
      Error (s, &quot;unknown calling convention: &quot;, Fmt.Int (id));
    END;
    RETURN cc;
  END Scan_callConv;

PROCEDURE <A NAME="Scan_line"><procedure>Scan_line</procedure></A> (VAR s: State): TEXT =
  VAR buf: ARRAY [0..511] OF CHAR;  len: INTEGER;
  BEGIN
    len := 0;
    LOOP
      IF (s.ch = '\n') OR (s.ch = EOF) THEN EXIT END;
      IF (len &lt;= LAST (buf)) THEN buf[len] := s.ch; INC (len); END;
      GetCh (s);
    END;
    RETURN Text.FromChars (SUBARRAY (buf, 0, len));
  END Scan_line;

PROCEDURE <A NAME="Scan_buf"><procedure>Scan_buf</procedure></A> (VAR s: State;  VAR buf: ARRAY OF CHAR): INTEGER =
  VAR len: INTEGER;
  BEGIN
    Skip_blanks (s);
    len := 0;
    LOOP
      IF (s.ch = EOF) THEN EXIT END;
      IF (s.ch = ' ') OR (s.ch = '\t') OR (s.ch = '\n') THEN EXIT; END;
      IF (len &lt;= LAST (buf)) THEN  buf[len] := s.ch; INC (len);  END;
      GetCh (s);
    END;
    RETURN len;
  END Scan_buf;

PROCEDURE <A NAME="Skip_blanks"><procedure>Skip_blanks</procedure></A> (VAR s: State) =
  BEGIN
    WHILE (s.ch = ' ') OR (s.ch = '\t') DO GetCh (s) END;
  END Skip_blanks;

PROCEDURE <A NAME="Skip_white_space"><procedure>Skip_white_space</procedure></A> (VAR s: State) =
  BEGIN
    WHILE (s.ch = ' ') OR (s.ch = '\n') OR (s.ch = '\t') DO GetCh (s); END;
  END Skip_white_space;

PROCEDURE <A NAME="Skip_line"><procedure>Skip_line</procedure></A> (VAR s: State) =
  BEGIN
    WHILE (s.ch # '\n') AND (s.ch # EOF) DO GetCh (s) END;
    GetCh (s);
  END Skip_line;

PROCEDURE <A NAME="GetCh"><procedure>GetCh</procedure></A> (VAR s: State) =
  BEGIN
    REPEAT
      IF (s.buf_ptr &gt;= s.buf_len) THEN RefillBuffer (s) END;
      s.ch := s.buf[s.buf_ptr];
      INC (s.buf_ptr);
    UNTIL (s.ch # '\r');
  END GetCh;

PROCEDURE <A NAME="RefillBuffer"><procedure>RefillBuffer</procedure></A> (VAR s: State) =
  &lt;*FATAL Rd.Failure, Thread.Alerted*&gt;
  BEGIN
    s.buf_ptr := 0;
    s.buf_len := Rd.GetSub (s.rd, s.buf^);
    IF (s.buf_len &lt; NUMBER (s.buf^)) THEN
      (* add an EOF character *)
      s.buf[s.buf_len] := EOF;
      INC (s.buf_len);
    END;
  END RefillBuffer;
</PRE>----------------------------------------------------- compilation units ---

<P><PRE>PROCEDURE <A NAME="begin_unit"><procedure>begin_unit</procedure></A> (VAR s: State) =
  VAR optimize := Scan_int (s);
  BEGIN
    s.cg.begin_unit (optimize);
  END begin_unit;

PROCEDURE <A NAME="end_unit"><procedure>end_unit</procedure></A>   (VAR s: State) =
  BEGIN
    s.cg.end_unit ();
  END end_unit;

PROCEDURE <A NAME="import_unit"><procedure>import_unit</procedure></A> (VAR s: State) =
  VAR name := Scan_name (s);
  BEGIN
    s.cg.import_unit (name);
  END import_unit;

PROCEDURE <A NAME="export_unit"><procedure>export_unit</procedure></A> (VAR s: State) =
  VAR name := Scan_name (s);
  BEGIN
    s.cg.export_unit (name);
  END export_unit;
</PRE>------------------------------------------------ debugging line numbers ---

<P><PRE>PROCEDURE <A NAME="set_source_file"><procedure>set_source_file</procedure></A> (VAR s: State) =
  VAR file := Scan_word (s);
  BEGIN
    s.cg.set_source_file (file);
  END set_source_file;

PROCEDURE <A NAME="set_source_line"><procedure>set_source_line</procedure></A> (VAR s: State) =
  VAR line := Scan_int (s);
  BEGIN
    s.cg.set_source_line (line);
  END set_source_line;
</PRE>------------------------------------------- debugging type declarations ---

<P><PRE>PROCEDURE <A NAME="declare_typename"><procedure>declare_typename</procedure></A> (VAR s: State) =
  VAR type := Scan_tipe (s);
      name := Scan_name (s);
  BEGIN
    s.cg.declare_typename (type, name);
  END declare_typename;

PROCEDURE <A NAME="declare_array"><procedure>declare_array</procedure></A> (VAR s: State)=
  VAR type  := Scan_tipe (s);
      index := Scan_tipe (s);
      elt   := Scan_tipe (s);
      size  := Scan_int (s);
  BEGIN
    s.cg.declare_array (type, index, elt, size);
  END declare_array;

PROCEDURE <A NAME="declare_open_array"><procedure>declare_open_array</procedure></A> (VAR s: State)=
  VAR type  := Scan_tipe (s);
      elt   := Scan_tipe (s);
      size  := Scan_int (s);
  BEGIN
    s.cg.declare_open_array (type, elt, size);
  END declare_open_array;

PROCEDURE <A NAME="declare_enum"><procedure>declare_enum</procedure></A> (VAR s: State) =
  VAR type   := Scan_tipe (s);
      n_elts := Scan_int (s);
      size   := Scan_int (s);
  BEGIN
    s.cg.declare_enum (type, n_elts, size);
  END declare_enum;

PROCEDURE <A NAME="declare_enum_elt"><procedure>declare_enum_elt</procedure></A> (VAR s: State) =
  VAR name := Scan_name (s);
  BEGIN
    s.cg.declare_enum_elt (name);
  END declare_enum_elt;

PROCEDURE <A NAME="declare_packed"><procedure>declare_packed</procedure></A>  (VAR s: State) =
  VAR type := Scan_tipe (s);
      size := Scan_int (s);
      base := Scan_tipe (s);
  BEGIN
    s.cg.declare_packed (type, size, base);
  END declare_packed;

PROCEDURE <A NAME="declare_record"><procedure>declare_record</procedure></A> (VAR s: State) =
  VAR type     := Scan_tipe (s);
      size     := Scan_int (s);
      n_fields := Scan_int (s);
  BEGIN
    s.cg.declare_record (type, size, n_fields);
  END declare_record;

PROCEDURE <A NAME="declare_field"><procedure>declare_field</procedure></A> (VAR s: State) =
  VAR name   := Scan_name (s);
      offset := Scan_int (s);
      size   := Scan_int (s);
      type   := Scan_tipe (s);
  BEGIN
    s.cg.declare_field (name, offset, size, type);
  END declare_field;

PROCEDURE <A NAME="declare_set"><procedure>declare_set</procedure></A> (VAR s: State) =
  VAR type   := Scan_tipe (s);
      domain := Scan_tipe (s);
      size   := Scan_int (s);
  BEGIN
    s.cg.declare_set (type, domain, size);
  END declare_set;

PROCEDURE <A NAME="declare_subrange"><procedure>declare_subrange</procedure></A> (VAR s: State) =
  VAR type   := Scan_tipe (s);
      domain := Scan_tipe (s);
      min    := Scan_Tint (s);
      max    := Scan_Tint (s);
      size   := Scan_int (s);
  BEGIN
    s.cg.declare_subrange (type, domain, min, max, size);
  END declare_subrange;

PROCEDURE <A NAME="declare_pointer"><procedure>declare_pointer</procedure></A> (VAR s: State) =
  VAR type   := Scan_tipe (s);
      target := Scan_tipe (s);
      brand  := Scan_text (s);
      traced := Scan_bool (s);
  BEGIN
    s.cg.declare_pointer (type, target, brand, traced);
  END declare_pointer;

PROCEDURE <A NAME="declare_indirect"><procedure>declare_indirect</procedure></A> (VAR s: State) =
  VAR type   := Scan_tipe (s);
      target := Scan_tipe (s);
  BEGIN
    s.cg.declare_indirect (type, target);
  END declare_indirect;

PROCEDURE <A NAME="declare_proctype"><procedure>declare_proctype</procedure></A> (VAR s: State) =
  VAR type      := Scan_tipe (s);
      n_formals := Scan_int (s);
      result    := Scan_tipe (s);
      n_raises  := Scan_int (s);
      calling   := Scan_callConv (s);
  BEGIN
    s.cg.declare_proctype (type, n_formals, result, n_raises, calling);
  END declare_proctype;

PROCEDURE <A NAME="declare_formal"><procedure>declare_formal</procedure></A> (VAR s: State) =
  VAR name := Scan_name (s);
      type := Scan_tipe (s);
  BEGIN
    s.cg.declare_formal (name, type);
  END declare_formal;

PROCEDURE <A NAME="declare_raises"><procedure>declare_raises</procedure></A> (VAR s: State) =
  VAR name := Scan_name (s);
  BEGIN
    s.cg.declare_raises (name);
  END declare_raises;

PROCEDURE <A NAME="declare_object"><procedure>declare_object</procedure></A> (VAR s: State) =
  VAR type       := Scan_tipe (s);
      super      := Scan_tipe (s);
      brand      := Scan_text (s);
      traced     := Scan_bool (s);
      n_fields   := Scan_int (s);
      n_methods  := Scan_int (s);
      field_size := Scan_int (s);
  BEGIN
    s.cg.declare_object (type, super, brand, traced,
                         n_fields, n_methods, field_size);
  END declare_object;

PROCEDURE <A NAME="declare_method"><procedure>declare_method</procedure></A> (VAR s: State) =
  VAR name := Scan_name (s);
      type := Scan_tipe (s);
  BEGIN
    s.cg.declare_method (name, type);
  END declare_method;

PROCEDURE <A NAME="declare_opaque"><procedure>declare_opaque</procedure></A> (VAR s: State) =
  VAR type    := Scan_tipe (s);
      super   := Scan_tipe (s);
  BEGIN
    s.cg.declare_opaque (type, super);
  END declare_opaque;

PROCEDURE <A NAME="reveal_opaque"><procedure>reveal_opaque</procedure></A> (VAR s: State) =
  VAR lhs     := Scan_tipe (s);
      rhs     := Scan_tipe (s);
  BEGIN
    s.cg.reveal_opaque (lhs, rhs);
  END reveal_opaque;

PROCEDURE <A NAME="declare_exception"><procedure>declare_exception</procedure></A> (VAR s: State) =
  VAR name       := Scan_name (s);
      arg_type   := Scan_tipe (s);
      raise_proc := Scan_bool (s);
      base       := Scan_var (s);
      offset     := Scan_int (s);
  BEGIN
    s.cg.declare_exception (name, arg_type, raise_proc, base, offset);
  END declare_exception;
</PRE>--------------------------------------------------------- runtime hooks ---

<P><PRE>PROCEDURE <A NAME="set_runtime_hook"><procedure>set_runtime_hook</procedure></A> (VAR s: State) =
  VAR name   := Scan_name (s);
      var    := Scan_var (s);
      offset := Scan_int (s);
  BEGIN
    s.cg.set_runtime_hook (name, var, offset);
  END set_runtime_hook;

PROCEDURE <A NAME="get_runtime_hook"><procedure>get_runtime_hook</procedure></A> (VAR s: State) =
  BEGIN
    Error (s, &quot;unexpected get_runtime_hook&quot;);
  END get_runtime_hook;
</PRE>------------------------------------------------- variable declarations ---

<P><PRE>PROCEDURE <A NAME="AddVar"><procedure>AddVar</procedure></A> (VAR s: State;  id: INTEGER;  v: M3CG.Var) =
  BEGIN
    WHILE (id &gt;= NUMBER (s.vars^)) DO ExpandVars (s) END;
    s.vars[id] := v;
  END AddVar;

PROCEDURE <A NAME="ExpandVars"><procedure>ExpandVars</procedure></A> (VAR s: State) =
  VAR new := NEW (REF ARRAY OF M3CG.Var, 2 * NUMBER (s.vars^));
  BEGIN
    SUBARRAY (new^, 0, NUMBER (s.vars^)) := s.vars^;
    s.vars := new;
  END ExpandVars;

PROCEDURE <A NAME="import_global"><procedure>import_global</procedure></A> (VAR s: State) =
  VAR name  := Scan_name (s);
      size  := Scan_int (s);
      align := Scan_int (s);
      type  := Scan_type (s);
      m3t   := Scan_tipe (s);
      v     := Scan_varName (s);
  BEGIN
    AddVar (s, v, s.cg.import_global (name, size, align, type, m3t));
  END import_global;

PROCEDURE <A NAME="declare_segment"><procedure>declare_segment</procedure></A> (VAR s: State) =
  VAR name := Scan_name (s);
      m3t  := Scan_tipe (s);
      v    := Scan_varName (s);
  BEGIN
    AddVar (s, v, s.cg.declare_segment (name, m3t));
  END declare_segment;

PROCEDURE <A NAME="bind_segment"><procedure>bind_segment</procedure></A> (VAR s: State) =
  VAR v      := Scan_var (s);
      size   := Scan_int (s);
      align  := Scan_int (s);
      type   := Scan_type (s);
      export := Scan_bool (s);
      init   := Scan_bool (s);
  BEGIN
    s.cg.bind_segment (v, size, align, type, export, init);
  END bind_segment;

PROCEDURE <A NAME="declare_global"><procedure>declare_global</procedure></A> (VAR s: State) =
  VAR name   := Scan_name (s);
      size   := Scan_int (s);
      align  := Scan_int (s);
      type   := Scan_type (s);
      m3t    := Scan_tipe (s);
      export := Scan_bool (s);
      init   := Scan_bool (s);
      v      := Scan_varName (s);
  BEGIN
    AddVar (s, v, s.cg.declare_global (name, size, align, type,
                                       m3t, export, init));
  END declare_global;

PROCEDURE <A NAME="declare_constant"><procedure>declare_constant</procedure></A> (VAR s: State) =
  VAR name   := Scan_name (s);
      size   := Scan_int (s);
      align  := Scan_int (s);
      type   := Scan_type (s);
      m3t    := Scan_tipe (s);
      export := Scan_bool (s);
      init   := Scan_bool (s);
      v      := Scan_varName (s);
  BEGIN
    AddVar (s, v, s.cg.declare_constant (name, size, align, type,
                                         m3t, export,init));
  END declare_constant;

PROCEDURE <A NAME="declare_local"><procedure>declare_local</procedure></A> (VAR s: State) =
  VAR name   := Scan_name (s);
      size   := Scan_int (s);
      align  := Scan_int (s);
      type   := Scan_type (s);
      m3t    := Scan_tipe (s);
      in_mem := Scan_bool (s);
      up_lev := Scan_bool (s);
      freq   := Scan_int (s);
      v      := Scan_varName (s);
  BEGIN
    AddVar (s, v, s.cg.declare_local (name, size, align, type, m3t,
                                      in_mem, up_lev, freq));
  END declare_local;

PROCEDURE <A NAME="declare_param"><procedure>declare_param</procedure></A> (VAR s: State) =
  VAR name   := Scan_name (s);
      size   := Scan_int (s);
      align  := Scan_int (s);
      type   := Scan_type (s);
      m3t    := Scan_tipe (s);
      in_mem := Scan_bool (s);
      up_lev := Scan_bool (s);
      freq   := Scan_int (s);
      v      := Scan_varName (s);
  BEGIN
    AddVar (s, v, s.cg.declare_param (name, size, align, type, m3t,
                                      in_mem, up_lev, freq));
  END declare_param;

PROCEDURE <A NAME="declare_temp"><procedure>declare_temp</procedure></A> (VAR s: State) =
  VAR size   := Scan_int (s);
      align  := Scan_int (s);
      type   := Scan_type (s);
      in_mem := Scan_bool (s);
      v      := Scan_varName (s);
  BEGIN
    AddVar (s, v, s.cg.declare_temp (size, align, type, in_mem));
  END declare_temp;

PROCEDURE <A NAME="free_temp"><procedure>free_temp</procedure></A> (VAR s: State) =
  VAR v := Scan_var (s);
  BEGIN
    s.cg.free_temp (v);
  END free_temp;
</PRE>---------------------------------------- static variable initialization ---

<P><PRE>PROCEDURE <A NAME="begin_init"><procedure>begin_init</procedure></A> (VAR s: State) =
  VAR v := Scan_var (s);
  BEGIN
    s.cg.begin_init (v);
  END begin_init;

PROCEDURE <A NAME="end_init"><procedure>end_init</procedure></A> (VAR s: State) =
  VAR v := Scan_var (s);
  BEGIN
    s.cg.end_init (v);
  END end_init;

PROCEDURE <A NAME="init_int"><procedure>init_int</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      value  := Scan_Tint (s);
      type   := Scan_type (s);
  BEGIN
    s.cg.init_int (offset, value, type);
  END init_int;

PROCEDURE <A NAME="init_proc"><procedure>init_proc</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      value  := Scan_proc (s);
  BEGIN
    s.cg.init_proc (offset, value);
  END init_proc;

PROCEDURE <A NAME="init_label"><procedure>init_label</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      value  := Scan_label (s);
  BEGIN
    s.cg.init_label (offset, value);
  END init_label;

PROCEDURE <A NAME="init_var"><procedure>init_var</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      value  := Scan_var (s);
      bias   := Scan_int (s);
  BEGIN
    s.cg.init_var (offset, value, bias);
  END init_var;

PROCEDURE <A NAME="init_offset"><procedure>init_offset</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      value  := Scan_var (s);
  BEGIN
    s.cg.init_offset (offset, value);
  END init_offset;

PROCEDURE <A NAME="init_chars"><procedure>init_chars</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      value  := Scan_text (s);
  BEGIN
    s.cg.init_chars (offset, value);
  END init_chars;

PROCEDURE <A NAME="init_float"><procedure>init_float</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      value  := Scan_float (s);
  BEGIN
    s.cg.init_float (offset, value);
  END init_float;
</PRE>------------------------------------------------------------ procedures ---

<P><PRE>PROCEDURE <A NAME="AddProc"><procedure>AddProc</procedure></A> (VAR s: State;  id: INTEGER;  p: M3CG.Proc) =
  BEGIN
    WHILE (id &gt;= NUMBER (s.procs^)) DO ExpandProcs (s) END;
    s.procs[id] := p;
  END AddProc;

PROCEDURE <A NAME="ExpandProcs"><procedure>ExpandProcs</procedure></A> (VAR s: State) =
  VAR new := NEW (REF ARRAY OF M3CG.Proc, 2 * NUMBER (s.procs^));
  BEGIN
    SUBARRAY (new^, 0, NUMBER (s.procs^)) := s.procs^;
    s.procs := new;
  END ExpandProcs;

PROCEDURE <A NAME="import_procedure"><procedure>import_procedure</procedure></A> (VAR s: State) =
  VAR name     := Scan_name (s);
      n_params := Scan_int (s);
      ret_type := Scan_type (s);
      calling  := Scan_callConv (s);
      p        := Scan_procName (s);
  BEGIN
    AddProc (s, p, s.cg.import_procedure (name, n_params, ret_type, calling));
  END import_procedure;

PROCEDURE <A NAME="declare_procedure"><procedure>declare_procedure</procedure></A> (VAR s: State) =
  VAR name     := Scan_name (s);
      n_params := Scan_int (s);
      ret_type := Scan_type (s);
      level    := Scan_int (s);
      calling  := Scan_callConv (s);
      export   := Scan_bool (s);
      parent   := Scan_proc (s);
      p        := Scan_procName (s);
  BEGIN
    AddProc (s, p, s.cg.declare_procedure (name, n_params, ret_type,
                                           level, calling, export, parent));
  END declare_procedure;

PROCEDURE <A NAME="begin_procedure"><procedure>begin_procedure</procedure></A> (VAR s: State) =
  VAR p := Scan_proc (s);
  BEGIN
    s.cg.begin_procedure (p);
  END begin_procedure;

PROCEDURE <A NAME="end_procedure"><procedure>end_procedure</procedure></A> (VAR s: State) =
  VAR p := Scan_proc (s);
  BEGIN
    s.cg.end_procedure (p);
  END end_procedure;

PROCEDURE <A NAME="begin_block"><procedure>begin_block</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.begin_block ();
  END begin_block;

PROCEDURE <A NAME="end_block"><procedure>end_block</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.end_block ();
  END end_block;

PROCEDURE <A NAME="note_procedure_origin"><procedure>note_procedure_origin</procedure></A> (VAR s: State) =
  VAR p := Scan_proc (s);
  BEGIN
    s.cg.note_procedure_origin (p);
  END note_procedure_origin;
</PRE>------------------------------------------------------------ statements ---

<P><PRE>PROCEDURE <A NAME="set_label"><procedure>set_label</procedure></A> (VAR s: State) =
  VAR label   := Scan_label (s);
      barrier := Scan_bool (s);
  BEGIN
    s.cg.set_label (label, barrier);
  END set_label;

PROCEDURE <A NAME="jump"><procedure>jump</procedure></A> (VAR s: State) =
  VAR label := Scan_label (s);
  BEGIN
    s.cg.jump (label);
  END jump;

PROCEDURE <A NAME="if_true"><procedure>if_true</procedure></A>  (VAR s: State) =
  VAR label := Scan_label (s);
      freq  := Scan_int (s);
  BEGIN
    s.cg.if_true (label, freq);
  END if_true;

PROCEDURE <A NAME="if_false"><procedure>if_false</procedure></A> (VAR s: State) =
  VAR label := Scan_label (s);
      freq  := Scan_int (s);
  BEGIN
    s.cg.if_false (label, freq);
  END if_false;

PROCEDURE <A NAME="if_eq"><procedure>if_eq</procedure></A> (VAR s: State) =
  VAR label := Scan_label (s);
      type  := Scan_type (s);
      freq  := Scan_int (s);
  BEGIN
    s.cg.if_eq (label, type, freq);
  END if_eq;

PROCEDURE <A NAME="if_ne"><procedure>if_ne</procedure></A> (VAR s: State) =
  VAR label := Scan_label (s);
      type  := Scan_type (s);
      freq  := Scan_int (s);
  BEGIN
    s.cg.if_ne (label, type, freq);
  END if_ne;

PROCEDURE <A NAME="if_gt"><procedure>if_gt</procedure></A> (VAR s: State) =
  VAR label := Scan_label (s);
      type  := Scan_type (s);
      freq  := Scan_int (s);
  BEGIN
    s.cg.if_gt (label, type, freq);
  END if_gt;

PROCEDURE <A NAME="if_ge"><procedure>if_ge</procedure></A> (VAR s: State) =
  VAR label := Scan_label (s);
      type  := Scan_type (s);
      freq  := Scan_int (s);
  BEGIN
    s.cg.if_ge (label, type, freq);
  END if_ge;

PROCEDURE <A NAME="if_lt"><procedure>if_lt</procedure></A> (VAR s: State) =
  VAR label := Scan_label (s);
      type  := Scan_type (s);
      freq  := Scan_int (s);
  BEGIN
    s.cg.if_lt (label, type, freq);
  END if_lt;

PROCEDURE <A NAME="if_le"><procedure>if_le</procedure></A> (VAR s: State) =
  VAR label := Scan_label (s);
      type  := Scan_type (s);
      freq  := Scan_int (s);
  BEGIN
    s.cg.if_le (label, type, freq);
  END if_le;

PROCEDURE <A NAME="case_jump"><procedure>case_jump</procedure></A> (VAR s: State) =
  VAR n := Scan_int (s);
      x := NEW (REF ARRAY OF M3CG.Label, n);
  BEGIN
    FOR i := 0 TO n-1 DO x[i] := Scan_label (s) END;
    s.cg.case_jump (x^);
  END case_jump;

PROCEDURE <A NAME="exit_proc"><procedure>exit_proc</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.exit_proc (type);
  END exit_proc;
</PRE>------------------------------------------------------------ load/store ---

<P><PRE>PROCEDURE <A NAME="load"><procedure>load</procedure></A>  (VAR s: State) =
  VAR v      := Scan_var (s);
      offset := Scan_int (s);
      type   := Scan_type (s);
  BEGIN
    s.cg.load (v, offset, type);
  END load;

PROCEDURE <A NAME="store"><procedure>store</procedure></A>  (VAR s: State) =
  VAR v      := Scan_var (s);
      offset := Scan_int (s);
      type   := Scan_type (s);
  BEGIN
    s.cg.store (v, offset, type);
  END store;

PROCEDURE <A NAME="store_ref"><procedure>store_ref</procedure></A> (VAR s: State) =
  VAR v      := Scan_var (s);
      offset := Scan_int (s);
  BEGIN
    s.cg.store_ref (v, offset);
  END store_ref;

PROCEDURE <A NAME="load_address"><procedure>load_address</procedure></A> (VAR s: State) =
  VAR v      := Scan_var (s);
      offset := Scan_int (s);
  BEGIN
    s.cg.load_address (v, offset);
  END load_address;

PROCEDURE <A NAME="load_indirect"><procedure>load_indirect</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      type   := Scan_type (s);
  BEGIN
    s.cg.load_indirect (offset, type);
  END load_indirect;

PROCEDURE <A NAME="store_indirect"><procedure>store_indirect</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      type   := Scan_type (s);
  BEGIN
    s.cg.store_indirect (offset, type);
  END store_indirect;

PROCEDURE <A NAME="store_ref_indirect"><procedure>store_ref_indirect</procedure></A> (VAR s: State) =
  VAR offset := Scan_int (s);
      is_var := Scan_bool (s);
  BEGIN
    s.cg.store_ref_indirect (offset, is_var);
  END store_ref_indirect;
</PRE>-------------------------------------------------------------- literals ---

<P><PRE>PROCEDURE <A NAME="load_nil"><procedure>load_nil</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.load_nil ();
  END load_nil;

PROCEDURE <A NAME="load_integer"><procedure>load_integer</procedure></A>  (VAR s: State) =
  VAR value := Scan_Tint (s);
  BEGIN
    s.cg.load_integer (value);
  END load_integer;

PROCEDURE <A NAME="load_float"><procedure>load_float</procedure></A>    (VAR s: State) =
  VAR value := Scan_float (s);
  BEGIN
    s.cg.load_float (value);
  END load_float;
</PRE>------------------------------------------------------------ arithmetic ---

<P><PRE>PROCEDURE <A NAME="eq"><procedure>eq</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.eq (type);
  END eq;

PROCEDURE <A NAME="ne"><procedure>ne</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.ne (type);
  END ne;

PROCEDURE <A NAME="gt"><procedure>gt</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.gt (type);
  END gt;

PROCEDURE <A NAME="ge"><procedure>ge</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.ge (type);
  END ge;

PROCEDURE <A NAME="lt"><procedure>lt</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.lt (type);
  END lt;

PROCEDURE <A NAME="le"><procedure>le</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.le (type);
  END le;

PROCEDURE <A NAME="add"><procedure>add</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.add (type);
  END add;

PROCEDURE <A NAME="subtract"><procedure>subtract</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.subtract (type);
  END subtract;

PROCEDURE <A NAME="multiply"><procedure>multiply</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.multiply (type);
  END multiply;

PROCEDURE <A NAME="divide"><procedure>divide</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.divide (type);
  END divide;

PROCEDURE <A NAME="div"><procedure>div</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
      a := Scan_sign (s);
      b := Scan_sign (s);
  BEGIN
    s.cg.div (type, a, b);
  END div;

PROCEDURE <A NAME="mod"><procedure>mod</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
      a := Scan_sign (s);
      b := Scan_sign (s);
  BEGIN
    s.cg.mod (type, a, b);
  END mod;

PROCEDURE <A NAME="negate"><procedure>negate</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.negate (type);
  END negate;

PROCEDURE <A NAME="abs"><procedure>abs</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.abs (type);
  END abs;

PROCEDURE <A NAME="max"><procedure>max</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.max (type);
  END max;

PROCEDURE <A NAME="min"><procedure>min</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.min (type);
  END min;

PROCEDURE <A NAME="round"><procedure>round</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.round (type);
  END round;

PROCEDURE <A NAME="trunc"><procedure>trunc</procedure></A>    (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.trunc (type);
  END trunc;

PROCEDURE <A NAME="floor"><procedure>floor</procedure></A>    (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.floor (type);
  END floor;

PROCEDURE <A NAME="ceiling"><procedure>ceiling</procedure></A>  (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.ceiling (type);
  END ceiling;

PROCEDURE <A NAME="cvt_float"><procedure>cvt_float</procedure></A>    (VAR s: State) =
  VAR src  := Scan_type (s);
      dest := Scan_type (s);
  BEGIN
    s.cg.cvt_float (src, dest);
  END cvt_float;
</PRE>------------------------------------------------------------------ sets ---

<P><PRE>PROCEDURE <A NAME="set_union"><procedure>set_union</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_union (size);
  END set_union;

PROCEDURE <A NAME="set_difference"><procedure>set_difference</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_difference (size);
  END set_difference;

PROCEDURE <A NAME="set_intersection"><procedure>set_intersection</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_intersection (size);
  END set_intersection;

PROCEDURE <A NAME="set_sym_difference"><procedure>set_sym_difference</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_sym_difference (size);
  END set_sym_difference;

PROCEDURE <A NAME="set_member"><procedure>set_member</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_member (size);
  END set_member;

PROCEDURE <A NAME="set_eq"><procedure>set_eq</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_eq (size);
  END set_eq;

PROCEDURE <A NAME="set_ne"><procedure>set_ne</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_ne (size);
  END set_ne;

PROCEDURE <A NAME="set_gt"><procedure>set_gt</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_gt (size);
  END set_gt;

PROCEDURE <A NAME="set_ge"><procedure>set_ge</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_ge (size);
  END set_ge;

PROCEDURE <A NAME="set_lt"><procedure>set_lt</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_lt (size);
  END set_lt;

PROCEDURE <A NAME="set_le"><procedure>set_le</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_le (size);
  END set_le;

PROCEDURE <A NAME="set_range"><procedure>set_range</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_range (size);
  END set_range;

PROCEDURE <A NAME="set_singleton"><procedure>set_singleton</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.set_singleton (size);
  END set_singleton;
</PRE>------------------------------------------------- Word.T bit operations ---

<P><PRE>PROCEDURE <A NAME="not"><procedure>not</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.not ();
  END not;

PROCEDURE <A NAME="and"><procedure>and</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.and ();
  END and;

PROCEDURE <A NAME="or"><procedure>or</procedure></A>  (VAR s: State) =
  BEGIN
    s.cg.or ();
  END or;

PROCEDURE <A NAME="xor"><procedure>xor</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.xor ();
  END xor;

PROCEDURE <A NAME="shift"><procedure>shift</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.shift ();
  END shift;

PROCEDURE <A NAME="shift_left"><procedure>shift_left</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.shift_left ();
  END shift_left;

PROCEDURE <A NAME="shift_right"><procedure>shift_right</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.shift_right ();
  END shift_right;

PROCEDURE <A NAME="rotate"><procedure>rotate</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.rotate ();
  END rotate;

PROCEDURE <A NAME="rotate_left"><procedure>rotate_left</procedure></A>  (VAR s: State) =
  BEGIN
    s.cg.rotate_left ();
  END rotate_left;

PROCEDURE <A NAME="rotate_right"><procedure>rotate_right</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.rotate_right ();
  END rotate_right;

PROCEDURE <A NAME="extract"><procedure>extract</procedure></A> (VAR s: State) =
  VAR sign_extend := Scan_bool (s);
  BEGIN
    s.cg.extract (sign_extend);
  END extract;

PROCEDURE <A NAME="extract_n"><procedure>extract_n</procedure></A> (VAR s: State) =
  VAR sign_extend := Scan_bool (s);
      width := Scan_int (s);
  BEGIN
    s.cg.extract_n (sign_extend, width);
  END extract_n;

PROCEDURE <A NAME="extract_mn"><procedure>extract_mn</procedure></A> (VAR s: State) =
  VAR sign_extend := Scan_bool (s);
      offset := Scan_int (s);
      width := Scan_int (s);
  BEGIN
    s.cg.extract_mn (sign_extend, offset, width);
  END extract_mn;

PROCEDURE <A NAME="insert"><procedure>insert</procedure></A>  (VAR s: State) =
  BEGIN
    s.cg.insert ();
  END insert;

PROCEDURE <A NAME="insert_n"><procedure>insert_n</procedure></A>  (VAR s: State) =
  VAR width := Scan_int (s);
  BEGIN
    s.cg.insert_n (width);
  END insert_n;

PROCEDURE <A NAME="insert_mn"><procedure>insert_mn</procedure></A>  (VAR s: State) =
  VAR offset := Scan_int (s);
      width := Scan_int (s);
  BEGIN
    s.cg.insert_mn (offset, width);
  END insert_mn;
</PRE>------------------------------------------------ misc. stack/memory ops ---

<P><PRE>PROCEDURE <A NAME="swap"><procedure>swap</procedure></A> (VAR s: State) =
  VAR a := Scan_type (s);
      b := Scan_type (s);
  BEGIN
    s.cg.swap (a, b);
  END swap;

PROCEDURE <A NAME="pop"><procedure>pop</procedure></A>  (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.pop (type);
  END pop;

PROCEDURE <A NAME="copy_n"><procedure>copy_n</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
      overlap := Scan_bool (s);
  BEGIN
    s.cg.copy_n (type, overlap);
  END copy_n;

PROCEDURE <A NAME="copy"><procedure>copy</procedure></A> (VAR s: State) =
  VAR cnt  := Scan_int (s);
      type := Scan_type (s);
      overlap := Scan_bool (s);
  BEGIN
    s.cg.copy (cnt, type, overlap);
  END copy;

PROCEDURE <A NAME="zero_n"><procedure>zero_n</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.zero_n (type);
  END zero_n;

PROCEDURE <A NAME="zero"><procedure>zero</procedure></A> (VAR s: State) =
  VAR cnt  := Scan_int (s);
      type := Scan_type (s);
  BEGIN
    s.cg.zero (cnt, type);
  END zero;
</PRE>----------------------------------------------------------- conversions ---

<P><PRE>PROCEDURE <A NAME="loophole"><procedure>loophole</procedure></A> (VAR s: State) =
  VAR from := Scan_type (s);
      two  := Scan_type (s);
  BEGIN
    s.cg.loophole (from, two);
  END loophole;
</PRE>------------------------------------------------ traps &amp; runtime checks ---

<P><PRE>PROCEDURE <A NAME="assert_fault"><procedure>assert_fault</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.assert_fault ();
  END assert_fault;

PROCEDURE <A NAME="narrow_fault"><procedure>narrow_fault</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.narrow_fault ();
  END narrow_fault;

PROCEDURE <A NAME="return_fault"><procedure>return_fault</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.return_fault ();
  END return_fault;

PROCEDURE <A NAME="case_fault"><procedure>case_fault</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.case_fault ();
  END case_fault;

PROCEDURE <A NAME="typecase_fault"><procedure>typecase_fault</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.typecase_fault ();
  END typecase_fault;

PROCEDURE <A NAME="check_nil"><procedure>check_nil</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.check_nil ();
  END check_nil;

PROCEDURE <A NAME="check_lo"><procedure>check_lo</procedure></A> (VAR s: State) =
  VAR i := Scan_Tint (s);
  BEGIN
    s.cg.check_lo (i);
  END check_lo;

PROCEDURE <A NAME="check_hi"><procedure>check_hi</procedure></A> (VAR s: State) =
  VAR i := Scan_Tint (s);
  BEGIN
    s.cg.check_hi (i);
  END check_hi;

PROCEDURE <A NAME="check_range"><procedure>check_range</procedure></A> (VAR s: State) =
  VAR a := Scan_Tint (s);
      b := Scan_Tint (s);
  BEGIN
    s.cg.check_range (a, b);
  END check_range;

PROCEDURE <A NAME="check_index"><procedure>check_index</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.check_index ();
  END check_index;

PROCEDURE <A NAME="check_eq"><procedure>check_eq</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.check_eq ();
  END check_eq;
</PRE>---------------------------------------------------- address arithmetic ---

<P><PRE>PROCEDURE <A NAME="add_offset"><procedure>add_offset</procedure></A> (VAR s: State) =
  VAR i := Scan_int (s);
  BEGIN
    s.cg.add_offset (i);
  END add_offset;

PROCEDURE <A NAME="index_address"><procedure>index_address</procedure></A> (VAR s: State) =
  VAR size := Scan_int (s);
  BEGIN
    s.cg.index_address (size);
  END index_address;
</PRE>------------------------------------------------------- procedure calls ---

<P><PRE>PROCEDURE <A NAME="start_call_direct"><procedure>start_call_direct</procedure></A> (VAR s: State) =
  VAR p     := Scan_proc (s);
      level := Scan_int (s);
      type  := Scan_type (s);
  BEGIN
    s.cg.start_call_direct (p, level, type);
  END start_call_direct;

PROCEDURE <A NAME="start_call_indirect"><procedure>start_call_indirect</procedure></A> (VAR s: State) =
  VAR type    := Scan_type (s);
      calling := Scan_callConv (s);
  BEGIN
    s.cg.start_call_indirect (type, calling);
  END start_call_indirect;

PROCEDURE <A NAME="pop_param"><procedure>pop_param</procedure></A> (VAR s: State) =
  VAR type := Scan_type (s);
  BEGIN
    s.cg.pop_param (type);
  END pop_param;

PROCEDURE <A NAME="pop_struct"><procedure>pop_struct</procedure></A> (VAR s: State) =
  VAR size  := Scan_int (s);
      align := Scan_int (s);
  BEGIN
    s.cg.pop_struct (size, align);
  END pop_struct;

PROCEDURE <A NAME="pop_static_link"><procedure>pop_static_link</procedure></A> (VAR s: State) =
  BEGIN
    s.cg.pop_static_link ();
  END pop_static_link;

PROCEDURE <A NAME="call_direct"><procedure>call_direct</procedure></A> (VAR s: State) =
  VAR p    := Scan_proc (s);
      type := Scan_type (s);
  BEGIN
    s.cg.call_direct (p, type);
  END call_direct;

PROCEDURE <A NAME="call_indirect"><procedure>call_indirect</procedure></A> (VAR s: State) =
  VAR type    := Scan_type (s);
      calling := Scan_callConv (s);
  BEGIN
    s.cg.call_indirect (type, calling);
  END call_indirect;
</PRE>------------------------------------------- procedure and closure types ---

<P><PRE>PROCEDURE <A NAME="load_procedure"><procedure>load_procedure</procedure></A> (VAR s: State) =
  VAR p := Scan_proc (s);
  BEGIN
    s.cg.load_procedure (p);
  END load_procedure;

PROCEDURE <A NAME="load_static_link"><procedure>load_static_link</procedure></A> (VAR s: State) =
  VAR p := Scan_proc (s);
  BEGIN
    s.cg.load_static_link (p);
  END load_static_link;
</PRE>----------------------------------------------------------------- misc. ---

<P><PRE>PROCEDURE <A NAME="comment"><procedure>comment</procedure></A> (VAR s: State) =
  VAR x: TEXT;
  BEGIN
    GetCh (s);  (* eat the blank that the writer inserts *)
    x := Scan_line (s);
    s.cg.comment (x);
  END comment;

BEGIN
END M3CG_Rd.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
