<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/M3CG_Wr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/M3CG_Wr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="M3CG_Wr.i3">M3CG_Wr</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>;
IMPORT <A HREF="M3Buf.i3">M3Buf</A>, <A HREF="#x1">M3ID</A>, <A HREF="M3CG.i3">M3CG</A>, <A HREF="M3CG_Ops.i3">M3CG_Ops</A>, <A HREF="Target.i3">Target</A>, <A HREF="TInt.i3">TInt</A> AS TargetInt, <A HREF="TFloat.i3">TFloat</A>;

FROM <A HREF="M3CG.i3">M3CG</A> IMPORT Name, ByteOffset, TypeUID, CallingConvention;
FROM <A HREF="M3CG.i3">M3CG</A> IMPORT BitSize, ByteSize, Alignment, Frequency;
FROM <A HREF="M3CG.i3">M3CG</A> IMPORT Var, Proc, Label, Sign, BitOffset, No_label;
FROM <A HREF="M3CG.i3">M3CG</A> IMPORT Type, ZType, AType, RType, IType, MType;

TYPE WrVar    = Var    OBJECT tag: INTEGER END;
TYPE WrProc   = Proc   OBJECT tag: INTEGER END;

TYPE
  RuntimeHook = REF RECORD  name: Name;  var: Var;  offset: ByteOffset;  END;

TYPE
  U = M3CG.T OBJECT
        wr            : Wr.T := NIL;
        buf           : M3Buf.T := NIL;
        buf_len       : INTEGER := 0;
        runtime       : IntRefTbl.T := NIL;  (* Name -&gt; RuntimeHook *)
        next_label_id := 1;
        next_var      := 1;
        next_proc     := 1;
        next_scope    := 1;
      OVERRIDES
        next_label := next_label;
        set_error_handler := set_error_handler;
        begin_unit := begin_unit;
        end_unit   := end_unit;
        import_unit := import_unit;
        export_unit := export_unit;
        set_source_file := set_source_file;
        set_source_line := set_source_line;
        declare_typename := declare_typename;
        declare_array := declare_array;
        declare_open_array := declare_open_array;
        declare_enum := declare_enum;
        declare_enum_elt := declare_enum_elt;
        declare_packed  := declare_packed;
        declare_record := declare_record;
        declare_field := declare_field;
        declare_set := declare_set;
        declare_subrange := declare_subrange;
        declare_pointer := declare_pointer;
        declare_indirect := declare_indirect;
        declare_proctype := declare_proctype;
        declare_formal := declare_formal;
        declare_raises := declare_raises;
        declare_object := declare_object;
        declare_method := declare_method;
        declare_opaque := declare_opaque;
        reveal_opaque := reveal_opaque;
        set_runtime_hook := set_runtime_hook;
        get_runtime_hook := get_runtime_hook;
        import_global  := import_global;
        declare_segment := declare_segment;
        bind_segment := bind_segment;
        declare_global := declare_global;
        declare_constant := declare_constant;
        declare_local  := declare_local;
        declare_param  := declare_param;
        declare_temp   := declare_temp;
        free_temp := free_temp;
        declare_exception := declare_exception;
        begin_init := begin_init;
        end_init := end_init;
        init_int := init_int;
        init_proc := init_proc;
        init_label := init_label;
        init_var := init_var;
        init_offset := init_offset;
        init_chars := init_chars;
        init_float := init_float;
        import_procedure := import_procedure;
        declare_procedure := declare_procedure;
        begin_procedure := begin_procedure;
        end_procedure := end_procedure;
        begin_block := begin_block;
        end_block := end_block;
        note_procedure_origin := note_procedure_origin;
        set_label := set_label;
        jump := jump;
        if_true  := if_true;
        if_false := if_false;
        if_eq := if_eq;
        if_ne := if_ne;
        if_gt := if_gt;
        if_ge := if_ge;
        if_lt := if_lt;
        if_le := if_le;
        case_jump := case_jump;
        exit_proc := exit_proc;
        load  := load;
        store := store;
        store_ref := store_ref;
        load_address := load_address;
        load_indirect := load_indirect;
        store_indirect := store_indirect;
        store_ref_indirect := store_ref_indirect;
        load_nil      := load_nil;
        load_integer  := load_integer;
        load_float    := load_float;
        eq       := eq;
        ne       := ne;
        gt       := gt;
        ge       := ge;
        lt       := lt;
        le       := le;
        add      := add;
        subtract := subtract;
        multiply := multiply;
        divide   := divide;
        div      := div;
        mod      := mod;
        negate   := negate;
        abs      := abs;
        max      := max;
        min      := min;
        round    := round;
        trunc    := trunc;
        floor    := floor;
        ceiling  := ceiling;
        cvt_float := cvt_float;
        set_union          := set_union;
        set_difference     := set_difference;
        set_intersection   := set_intersection;
        set_sym_difference := set_sym_difference;
        set_member         := set_member;
        set_eq       := set_eq;
        set_ne       := set_ne;
        set_gt       := set_gt;
        set_ge       := set_ge;
        set_lt       := set_lt;
        set_le       := set_le;
        set_range    := set_range;
        set_singleton := set_singleton;
        not := not;
        and := and;
        or  := or;
        xor := xor;
        shift        := shift;
        shift_left   := shift_left;
        shift_right  := shift_right;
        rotate       := rotate;
        rotate_left  := rotate_left;
        rotate_right := rotate_right;
        extract := extract;
        extract_n := extract_n;
        extract_mn := extract_mn;
        insert  := insert;
        insert_n  := insert_n;
        insert_mn  := insert_mn;
        swap := swap;
        pop  := pop;
        copy := copy;
        copy_n := copy_n;
        zero := zero;
        zero_n := zero_n;
        loophole := loophole;
        assert_fault := assert_fault;
        narrow_fault := narrow_fault;
        return_fault := return_fault;
        case_fault := case_fault;
        typecase_fault := typecase_fault;
        check_nil := check_nil;
        check_lo := check_lo;
        check_hi := check_hi;
        check_range := check_range;
        check_index := check_index;
        check_eq := check_eq;
        add_offset := add_offset;
        index_address := index_address;
        start_call_direct := start_call_direct;
        call_direct := call_direct;
        start_call_indirect := start_call_indirect;
        call_indirect := call_indirect;
        pop_param := pop_param;
        pop_struct := pop_struct;
        pop_static_link := pop_static_link;
        load_procedure := load_procedure;
        load_static_link := load_static_link;
        comment := comment;
      END;
</PRE>------------------------------------------------------------------- I/O ---

<P><PRE>PROCEDURE <A NAME="NL"><procedure>NL</procedure></A> (u: U) =
  BEGIN
    OutT (u, Target.EOL);
  END NL;

PROCEDURE <A NAME="Cmd"><procedure>Cmd</procedure></A> (u: U; cmd: TEXT) =
  VAR len := Text.Length (cmd);
  BEGIN
    OutC (u, '\t');
    OutT (u, cmd);
    OutC (u, '\t');
    IF (len &lt; 8) THEN OutC (u, '\t'); END;

    (****
    FOR i := 0 TO 14-len DO OutC (u, ' ') END;
    OutC (u, ' ');
    OutC (u, ' ');
    ***)
  END Cmd;

PROCEDURE <A NAME="ZName"><procedure>ZName</procedure></A> (u: U;  n: Name) =
  BEGIN
    OutC (u, ' ');
    IF (n = M3ID.NoID)
      THEN OutC (u, '*');
      ELSE OutN (u, n);
    END;
  END ZName;

PROCEDURE <A NAME="VName"><procedure>VName</procedure></A> (u: U;  v: Var) =
  BEGIN
    TYPECASE v OF
    | NULL     =&gt; OutT (u, &quot; *&quot;);
    | WrVar(x) =&gt; OutT (u, &quot; v.&quot;);  OutI (u, x.tag);
    ELSE          OutT (u, &quot; v.???&quot;);
    END;
  END VName;

PROCEDURE <A NAME="PName"><procedure>PName</procedure></A> (u: U;  p: Proc) =
  BEGIN
    TYPECASE p OF
    | NULL      =&gt; OutT (u, &quot; *&quot;);
    | WrProc(x) =&gt; OutT (u, &quot; p.&quot;);  OutI (u, x.tag);
    ELSE           OutT (u, &quot; p.???&quot;);
    END;
  END PName;

PROCEDURE <A NAME="TName"><procedure>TName</procedure></A> (u: U;  t: Type) =
  CONST type_names = ARRAY Type OF TEXT {
                       &quot; Addr&quot;, &quot; Word&quot;, &quot; Int&quot;,
                       &quot; Reel&quot;, &quot; LReel&quot;, &quot; XReel&quot;,
                       &quot; Int.8&quot;, &quot; Int.16&quot;, &quot; Int.32&quot;, &quot; Int.32D&quot;,
                       &quot; Word.8&quot;, &quot; Word.16&quot;, &quot; Word.32&quot;, &quot; Word.32D&quot;,
                       &quot; Struct&quot;, &quot; Void&quot;
                     };
  BEGIN
    OutT (u, type_names[t]);
  END TName;

PROCEDURE <A NAME="Flt"><procedure>Flt</procedure></A> (u: U;  READONLY f: Target.Float) =
  CONST FType = ARRAY Target.Precision OF TEXT { &quot; R &quot;, &quot; L &quot;, &quot; X &quot; };
  VAR
    buf : ARRAY [0..BITSIZE (Target.Extended)] OF CHAR;
    len := TFloat.ToChars (f, buf);
  BEGIN
    OutT (u, FType [TFloat.Prec (f)]);
    OutS (u, SUBARRAY (buf, 0, len));
  END Flt;

PROCEDURE <A NAME="Bool"><procedure>Bool</procedure></A> (u: U;  b: BOOLEAN) =
  CONST Tags = ARRAY BOOLEAN OF CHAR { 'F', 'T' };
  BEGIN
    OutC (u, ' ');
    OutC (u, Tags[b]);
  END Bool;

PROCEDURE <A NAME="Lab"><procedure>Lab</procedure></A> (u: U;  i: Label) =
  BEGIN
    OutC (u, ' ');
    IF (i = No_label)
      THEN OutC (u, '*');
      ELSE OutT (u, &quot;L.&quot;); OutI (u, i);
    END;
  END Lab;

PROCEDURE <A NAME="Tipe"><procedure>Tipe</procedure></A> (u: U;  t: TypeUID) =
  BEGIN
    OutT (u, &quot; &quot;);
    OutI (u, t);
  END Tipe;

PROCEDURE <A NAME="Int"><procedure>Int</procedure></A> (u: U;  i: INTEGER) =
  BEGIN
    OutC (u, ' ');
    OutI (u, i);
  END Int;

PROCEDURE <A NAME="TInt"><procedure>TInt</procedure></A> (u: U;  READONLY i: Target.Int) =
  VAR
    buf : ARRAY [0..BITSIZE (Target.Integer)] OF CHAR;
    len := TargetInt.ToChars (i, buf);
  BEGIN
    OutC (u, ' ');
    OutS (u, SUBARRAY (buf, 0, len));
  END TInt;

PROCEDURE <A NAME="BInt"><procedure>BInt</procedure></A> (u: U;  i: INTEGER) =
  BEGIN
    Int (u, i);
     (* since the reader doesn't know how to read 'bytes+bits' *)
  END BInt;
</PRE>********
PROCEDURE BInt (u: U;  i: INTEGER) =
  VAR x := i MOD Target.Byte;
      y := i DIV Target.Byte;
  BEGIN
    IF (x = 0)
      THEN Int (u, y);
      ELSE Int (u, y);  OutC (u, '+');  OutI (u, x);
    END;
  END BInt;
**************

<P><PRE>CONST
  VanillaChars = SET OF CHAR { ' ', '!', '#' .. '[', ']' .. '~' };
  Digits = ARRAY [0..7] OF CHAR { '0', '1', '2', '3', '4', '5', '6', '7' };

PROCEDURE <A NAME="Txt"><procedure>Txt</procedure></A> (u: U;  t: TEXT) =
  VAR c: CHAR;
  BEGIN
    OutC (u, ' ');
    IF (t = NIL) THEN
      OutC (u, '*');
      RETURN;
    END;
    OutC (u, '&quot;');
    FOR i := 0 TO Text.Length (t)-1 DO
      c := Text.GetChar (t, i);
      IF (c IN VanillaChars) THEN
        OutC (u, c);
      ELSE
        OutC (u, '\\');
        OutC (u, Digits [ORD(c) DIV 64]);
        OutC (u, Digits [ORD(c) MOD 64 DIV 8]);
        OutC (u, Digits [ORD(c) MOD 8]);
      END;
    END;
    OutC (u, '&quot;');
  END Txt;
</PRE>--------------------------------------------------------- low level I/O ---

<P><PRE>PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A> (u: U) =
  BEGIN
    M3Buf.Flush (u.buf, u.wr);
    u.buf_len := 0;
  END Flush;

PROCEDURE <A NAME="OutC"><procedure>OutC</procedure></A> (u: U;  c: CHAR) =
  BEGIN
    M3Buf.PutChar (u.buf, c);
    INC (u.buf_len);
    IF (u.buf_len &gt;= 1024) THEN Flush (u) END;
  END OutC;

PROCEDURE <A NAME="OutT"><procedure>OutT</procedure></A> (u: U;  txt: TEXT) =
  BEGIN
    M3Buf.PutText (u.buf, txt);
    INC (u.buf_len, Text.Length (txt));
    IF (u.buf_len &gt;= 1024) THEN Flush (u) END;
  END OutT;

PROCEDURE <A NAME="OutN"><procedure>OutN</procedure></A> (u: U;  n: Name) =
  BEGIN
    M3ID.Put (u.buf, n);
    INC (u.buf_len, 10); (* we don't really care if it's accurate *)
    IF (u.buf_len &gt;= 1024) THEN Flush (u) END;
  END OutN;

PROCEDURE <A NAME="OutS"><procedure>OutS</procedure></A> (u: U;  READONLY buf: ARRAY OF CHAR) =
  BEGIN
    M3Buf.PutSub (u.buf, buf);
    INC (u.buf_len, NUMBER (buf));
    IF (u.buf_len &gt;= 1024) THEN Flush (u) END;
  END OutS;

PROCEDURE <A NAME="OutI"><procedure>OutI</procedure></A>  (u: U;  i: INTEGER) =
  BEGIN
    M3Buf.PutInt (u.buf, i);
    INC (u.buf_len, 4); (* we don't really care if it's accurate *)
    IF (u.buf_len &gt;= 1024) THEN Flush (u) END;
  END OutI;
</PRE>---------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A> (output: Wr.T): M3CG.T =
  VAR mbuf := M3Buf.New ();
  BEGIN
    M3Buf.AttachDrain (mbuf, output);
    RETURN NEW (U, wr := output, buf := mbuf, buf_len := 0,
                runtime := NEW (IntRefTbl.Default).init (20));
  END New;
</PRE>----------------------------------------------------------- ID counters ---

<P><PRE>PROCEDURE <A NAME="next_label"><procedure>next_label</procedure></A> (u: U;  n: INTEGER := 1): Label =
  VAR x := u.next_label_id;
  BEGIN
    INC (u.next_label_id, n);
    RETURN x;
  END next_label;
</PRE>------------------------------------------------ READONLY configuration ---

<P><PRE>PROCEDURE <A NAME="set_error_handler"><procedure>set_error_handler</procedure></A> (&lt;*UNUSED*&gt; u: U;
                             &lt;*UNUSED*&gt; p: M3CG_Ops.ErrorHandler) =
  BEGIN
    (* skip -- we don't generate any errors *)
  END set_error_handler;
</PRE>----------------------------------------------------- compilation units ---

<P><PRE>PROCEDURE <A NAME="begin_unit"><procedure>begin_unit</procedure></A> (u: U;  optimize : INTEGER) =
  (* called before any other method to initialize the compilation unit *)
  BEGIN
    Cmd (u, &quot;begin_unit&quot;);
    Int (u, optimize);
    NL  (u);
  END begin_unit;

PROCEDURE <A NAME="end_unit"><procedure>end_unit</procedure></A>   (u: U) =
  (* called after all other methods to finalize the unit and write the
     resulting object *)
  BEGIN
    Cmd (u, &quot;end_unit&quot;);
    NL  (u);
    Flush (u);
  END end_unit;

PROCEDURE <A NAME="import_unit"><procedure>import_unit</procedure></A> (u: U;  n: Name) =
  (* note that the current compilation unit imports the interface 'n' *)
  BEGIN
    Cmd   (u, &quot;import_unit&quot;);
    ZName (u, n);
    NL    (u);
  END import_unit;

PROCEDURE <A NAME="export_unit"><procedure>export_unit</procedure></A> (u: U;  n: Name) =
  (* note that the current compilation unit exports the interface 'n' *)
  BEGIN
    Cmd   (u, &quot;export_unit&quot;);
    ZName (u, n);
    NL    (u);
  END export_unit;
</PRE>------------------------------------------------ debugging line numbers ---

<P><PRE>PROCEDURE <A NAME="set_source_file"><procedure>set_source_file</procedure></A> (u: U; file: TEXT) =
  (* Sets the current source file name.  Subsequent statements
     and expressions are associated with this source location. *)
  BEGIN
    OutT (u, &quot;\t\t\t\t\t-----FILE &quot;);
    OutT (u, file);
    OutT (u, &quot;  -----&quot;);
    OutT (u, Target.EOL);
  END set_source_file;

PROCEDURE <A NAME="set_source_line"><procedure>set_source_line</procedure></A> (u: U; line: INTEGER) =
  (* Sets the current source line number.  Subsequent statements
   and expressions are associated with this source location. *)
  BEGIN
    OutT (u, &quot;\t\t\t\t\t-----LINE&quot;);
    Int  (u, line);
    OutT (u, &quot;  -----&quot;);
    OutT (u, Target.EOL);
  END set_source_line;
</PRE>------------------------------------------- debugging type declarations ---

<P><PRE>PROCEDURE <A NAME="declare_typename"><procedure>declare_typename</procedure></A> (u: U;  t: TypeUID;  n: Name) =
  BEGIN
    Cmd   (u, &quot;declare_typename&quot;);
    Tipe  (u, t);
    ZName (u, n);
    NL    (u);
  END declare_typename;

PROCEDURE <A NAME="declare_array"><procedure>declare_array</procedure></A> (u: U;  t, index, elt: TypeUID;  s: BitSize) =
  BEGIN
    Cmd  (u, &quot;declare_array&quot;);
    Tipe (u, t);
    Tipe (u, index);
    Tipe (u, elt);
    BInt (u, s);
    NL   (u);
  END declare_array;

PROCEDURE <A NAME="declare_open_array"><procedure>declare_open_array</procedure></A> (u: U;  t, elt: TypeUID;  s: BitSize) =
  BEGIN
    Cmd  (u, &quot;declare_open_array&quot;);
    Tipe (u, t);
    Tipe (u, elt);
    BInt (u, s);
    NL   (u);
  END declare_open_array;

PROCEDURE <A NAME="declare_enum"><procedure>declare_enum</procedure></A> (u: U;  t: TypeUID;  n_elts: INTEGER;  s: BitSize) =
  BEGIN
    Cmd  (u, &quot;declare_enum&quot;);
    Tipe (u, t);
    Int  (u, n_elts);
    BInt (u, s);
    NL   (u);
  END declare_enum;

PROCEDURE <A NAME="declare_enum_elt"><procedure>declare_enum_elt</procedure></A> (u: U;  n: Name) =
  BEGIN
    Cmd   (u, &quot;declare_enum_elt&quot;);
    ZName (u, n);
    NL    (u);
  END declare_enum_elt;

PROCEDURE <A NAME="declare_packed"><procedure>declare_packed</procedure></A>  (u: U;  t: TypeUID;  s: BitSize;  base: TypeUID) =
  BEGIN
    Cmd  (u, &quot;declare_packed&quot;);
    Tipe (u, t);
    BInt (u, s);
    Tipe (u, base);
    NL   (u);
  END declare_packed;

PROCEDURE <A NAME="declare_record"><procedure>declare_record</procedure></A> (u: U; t: TypeUID;  s: BitSize;
                          n_fields: INTEGER)=
  BEGIN
    Cmd  (u, &quot;declare_record&quot;);
    Tipe (u, t);
    BInt (u, s);
    Int  (u, n_fields);
    NL   (u);
  END declare_record;

PROCEDURE <A NAME="declare_field"><procedure>declare_field</procedure></A> (u: U;  n: Name;  o: BitOffset;  s: BitSize;
                         t: TypeUID)=
  BEGIN
    Cmd   (u, &quot;declare_field&quot;);
    ZName (u, n);
    BInt  (u, o);
    BInt  (u, s);
    Tipe  (u, t);
    NL    (u);
  END declare_field;

PROCEDURE <A NAME="declare_set"><procedure>declare_set</procedure></A> (u: U;  t, domain: TypeUID;  s: BitSize) =
  BEGIN
    Cmd  (u, &quot;declare_set&quot;);
    Tipe (u, t);
    Tipe (u, domain);
    BInt (u, s);
    NL    (u);
  END declare_set;

PROCEDURE <A NAME="declare_subrange"><procedure>declare_subrange</procedure></A> (u: U; t, domain: TypeUID;
                            READONLY min, max: Target.Int;
                            s: BitSize) =
  BEGIN
    Cmd  (u, &quot;declare_subrange&quot;);
    Tipe (u, t);
    Tipe (u, domain);
    TInt (u, min);
    TInt (u, max);
    BInt (u, s);
    NL   (u);
  END declare_subrange;

PROCEDURE <A NAME="declare_pointer"><procedure>declare_pointer</procedure></A> (u: U;  t, target: TypeUID;  brand: TEXT;
                           traced: BOOLEAN) =
  BEGIN
    Cmd  (u, &quot;declare_pointer&quot;);
    Tipe (u, t);
    Tipe (u, target);
    Txt  (u, brand);
    Bool (u, traced);
    NL   (u);
  END declare_pointer;

PROCEDURE <A NAME="declare_indirect"><procedure>declare_indirect</procedure></A> (u: U;  t, target: TypeUID) =
  BEGIN
    Cmd  (u, &quot;declare_indirect&quot;);
    Tipe (u, t);
    Tipe (u, target);
    NL   (u);
  END declare_indirect;

PROCEDURE <A NAME="declare_proctype"><procedure>declare_proctype</procedure></A> (u: U;  t: TypeUID;  n_formals: INTEGER;
                            result: TypeUID;  n_raises: INTEGER;
                            cc: CallingConvention) =
  BEGIN
    Cmd  (u, &quot;declare_proctype&quot;);
    Tipe (u, t);
    Int  (u, n_formals);
    Tipe (u, result);
    Int  (u, n_raises);
    Int  (u, cc.m3cg_id);
    NL   (u);
  END declare_proctype;

PROCEDURE <A NAME="declare_formal"><procedure>declare_formal</procedure></A> (u: U;  n: Name;  t: TypeUID) =
  BEGIN
    Cmd   (u, &quot;declare_formal&quot;);
    ZName (u, n);
    Tipe  (u, t);
    NL    (u);
  END declare_formal;

PROCEDURE <A NAME="declare_raises"><procedure>declare_raises</procedure></A> (u: U;  n: Name) =
  BEGIN
    Cmd   (u, &quot;declare_raises&quot;);
    ZName (u, n);
    NL    (u);
  END declare_raises;

PROCEDURE <A NAME="declare_object"><procedure>declare_object</procedure></A> (u: U;  t, super: TypeUID;
                          brand: TEXT;  traced: BOOLEAN;
                          n_fields, n_methods: INTEGER;
                          field_size: BitSize) =
  BEGIN
    Cmd  (u, &quot;declare_object&quot;);
    Tipe (u, t);
    Tipe (u, super);
    Txt  (u, brand);
    Bool (u, traced);
    Int  (u, n_fields);
    Int  (u, n_methods);
    BInt (u, field_size);
    NL   (u);
  END declare_object;

PROCEDURE <A NAME="declare_method"><procedure>declare_method</procedure></A> (u: U;  n: Name;  signature: TypeUID) =
  BEGIN
    Cmd   (u, &quot;declare_method&quot;);
    ZName (u, n);
    Tipe  (u, signature);
    NL    (u);
  END declare_method;

PROCEDURE <A NAME="declare_opaque"><procedure>declare_opaque</procedure></A> (u: U;  t, super: TypeUID) =
  BEGIN
    Cmd   (u, &quot;declare_opaque&quot;);
    Tipe  (u, t);
    Tipe  (u, super);
    NL    (u);
  END declare_opaque;

PROCEDURE <A NAME="reveal_opaque"><procedure>reveal_opaque</procedure></A> (u: U;  lhs, rhs: TypeUID) =
  BEGIN
    Cmd   (u, &quot;reveal_opaque&quot;);
    Tipe  (u, lhs);
    Tipe  (u, rhs);
    NL    (u);
  END reveal_opaque;

PROCEDURE <A NAME="declare_exception"><procedure>declare_exception</procedure></A> (u: U;  n: Name;  arg_type: TypeUID;
                           raise_proc: BOOLEAN;  base: Var;  offset: INTEGER) =
  BEGIN
    Cmd   (u, &quot;declare_exception&quot;);
    ZName (u, n);
    Tipe  (u, arg_type);
    Bool  (u, raise_proc);
    VName (u, base);
    Int   (u, offset);
    NL    (u);
  END declare_exception;
</PRE>--------------------------------------------------------- runtime hooks ---

<P><PRE>PROCEDURE <A NAME="set_runtime_hook"><procedure>set_runtime_hook</procedure></A> (u: U;  n: Name;  v: Var;  o: ByteOffset) =
  VAR e := NEW (RuntimeHook, name := n, var := v,  offset := o);
  BEGIN
    Cmd   (u, &quot;set_runtime_hook&quot;);
    ZName (u, n);
    VName (u, v);
    Int   (u, o);
    NL    (u);
    EVAL u.runtime.put (n, e);
  END set_runtime_hook;

PROCEDURE <A NAME="get_runtime_hook"><procedure>get_runtime_hook</procedure></A> (u: U;  n: Name; VAR v: Var; VAR o: ByteOffset) =
  VAR ref: REFANY;  e: RuntimeHook;
  BEGIN
    (* no ASCII output is generated ... *)
    IF u.runtime.get (n, ref) THEN
      e := ref;
      v := e.var;
      o := e.offset;
    ELSE
      v := NIL;
      o := 0;
    END;
  END get_runtime_hook;
</PRE>------------------------------------------------- variable declarations ---

<P><PRE>PROCEDURE <A NAME="NewVar"><procedure>NewVar</procedure></A> (u: U): Var =
  VAR v := NEW (WrVar, tag := u.next_var);
  BEGIN
    INC (u.next_var);
    RETURN v;
  END NewVar;

PROCEDURE <A NAME="import_global"><procedure>import_global</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                         t: Type;  m3t: TypeUID): Var =
  VAR v := NewVar (u);
  BEGIN
    Cmd   (u, &quot;import_global&quot;);
    ZName (u, n);
    Int   (u, s);
    Int   (u, a);
    TName (u, t);
    Tipe  (u, m3t);
    VName (u, v);
    NL    (u);
    RETURN v;
  END import_global;

PROCEDURE <A NAME="declare_segment"><procedure>declare_segment</procedure></A> (u: U;  n: Name;  m3t: TypeUID): Var =
  VAR v := NewVar (u);
  BEGIN
    Cmd   (u, &quot;declare_segment&quot;);
    ZName (u, n);
    Tipe  (u, m3t);
    VName (u, v);
    NL    (u);
    RETURN v;
  END declare_segment;

PROCEDURE <A NAME="bind_segment"><procedure>bind_segment</procedure></A> (u: U;  seg: Var;  s: ByteSize;  a: Alignment;
                        t: Type;  exported, inited: BOOLEAN) =
  BEGIN
    Cmd   (u, &quot;bind_segment&quot;);
    VName (u, seg);
    Int   (u, s);
    Int   (u, a);
    TName (u, t);
    Bool  (u, exported);
    Bool  (u, inited);
    NL    (u);
  END bind_segment;

PROCEDURE <A NAME="declare_global"><procedure>declare_global</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                     t: Type;  m3t: TypeUID;  exported, inited: BOOLEAN): Var =
  VAR v := NewVar (u);
  BEGIN
    Cmd   (u, &quot;declare_global&quot;);
    ZName (u, n);
    Int   (u, s);
    Int   (u, a);
    TName (u, t);
    Tipe  (u, m3t);
    Bool  (u, exported);
    Bool  (u, inited);
    VName (u, v);
    NL    (u);
    RETURN v;
  END declare_global;

PROCEDURE <A NAME="declare_constant"><procedure>declare_constant</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                     t: Type;  m3t: TypeUID;  exported, inited: BOOLEAN): Var =
  VAR v := NewVar (u);
  BEGIN
    Cmd   (u, &quot;declare_constant&quot;);
    ZName (u, n);
    Int   (u, s);
    Int   (u, a);
    TName (u, t);
    Tipe  (u, m3t);
    Bool  (u, exported);
    Bool  (u, inited);
    VName (u, v);
    NL    (u);
    RETURN v;
  END declare_constant;

PROCEDURE <A NAME="declare_local"><procedure>declare_local</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                         t: Type;  m3t: TypeUID;  in_memory, up_level: BOOLEAN;
                         f: Frequency): Var =
  VAR v := NewVar (u);
  BEGIN
    Cmd   (u, &quot;declare_local&quot;);
    ZName (u, n);
    Int   (u, s);
    Int   (u, a);
    TName (u, t);
    Tipe  (u, m3t);
    Bool  (u, in_memory);
    Bool  (u, up_level);
    Int   (u, f);
    VName (u, v);
    NL    (u);
    RETURN v;
  END declare_local;

PROCEDURE <A NAME="declare_param"><procedure>declare_param</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                         t: Type;  m3t: TypeUID;  in_memory, up_level: BOOLEAN;
                         f: Frequency): Var =
  VAR v := NewVar (u);
  BEGIN
    Cmd   (u, &quot;declare_param&quot;);
    ZName (u, n);
    Int   (u, s);
    Int   (u, a);
    TName (u, t);
    Tipe  (u, m3t);
    Bool  (u, in_memory);
    Bool  (u, up_level);
    Int   (u, f);
    VName (u, v);
    NL    (u);
    RETURN v;
  END declare_param;

PROCEDURE <A NAME="declare_temp"><procedure>declare_temp</procedure></A>   (u: U;  s: ByteSize;  a: Alignment;  t: Type;
                          in_memory:BOOLEAN): Var =
  VAR v := NewVar (u);
  BEGIN
    Cmd   (u, &quot;declare_temp&quot;);
    Int   (u, s);
    Int   (u, a);
    TName (u, t);
    Bool  (u, in_memory);
    VName (u, v);
    NL    (u);
    RETURN v;
  END declare_temp;

PROCEDURE <A NAME="free_temp"><procedure>free_temp</procedure></A> (u: U;  v: Var) =
  BEGIN
    Cmd   (u, &quot;free_temp&quot;);
    VName (u, v);
    NL    (u);
  END free_temp;
</PRE>---------------------------------------- static variable initialization ---

<P><PRE>PROCEDURE <A NAME="begin_init"><procedure>begin_init</procedure></A> (u: U;  v: Var) =
  BEGIN
    Cmd   (u, &quot;begin_init&quot;);
    VName (u, v);
    NL    (u);
  END begin_init;

PROCEDURE <A NAME="end_init"><procedure>end_init</procedure></A> (u: U;  v: Var) =
  BEGIN
    Cmd   (u, &quot;end_init&quot;);
    VName (u, v);
    NL    (u);
  END end_init;

PROCEDURE <A NAME="init_int"><procedure>init_int</procedure></A> (u: U;  o: ByteOffset;  READONLY value: Target.Int;
                    t: Type) =
  BEGIN
    Cmd   (u, &quot;init_int&quot;);
    Int   (u, o);
    TInt  (u, value);
    TName (u, t);
    NL    (u);
  END init_int;

PROCEDURE <A NAME="init_proc"><procedure>init_proc</procedure></A> (u: U;  o: ByteOffset;  value: Proc) =
  BEGIN
    Cmd   (u, &quot;init_proc&quot;);
    Int   (u, o);
    PName (u, value);
    NL    (u);
  END init_proc;

PROCEDURE <A NAME="init_label"><procedure>init_label</procedure></A> (u: U;  o: ByteOffset;  value: Label) =
  BEGIN
    Cmd   (u, &quot;init_label&quot;);
    Int   (u, o);
    Lab   (u, value);
    NL    (u);
  END init_label;

PROCEDURE <A NAME="init_var"><procedure>init_var</procedure></A> (u: U;  o: ByteOffset;  value: Var;  bias: ByteOffset) =
  BEGIN
    Cmd   (u, &quot;init_var&quot;);
    Int   (u, o);
    VName (u, value);
    Int   (u, bias);
    NL    (u);
  END init_var;

PROCEDURE <A NAME="init_offset"><procedure>init_offset</procedure></A> (u: U;  o: ByteOffset;  value: Var) =
  BEGIN
    Cmd   (u, &quot;init_offset&quot;);
    Int   (u, o);
    VName (u, value);
    NL    (u);
  END init_offset;

PROCEDURE <A NAME="init_chars"><procedure>init_chars</procedure></A> (u: U;  o: ByteOffset;  value: TEXT) =
  BEGIN
    Cmd   (u, &quot;init_chars&quot;);
    Int   (u, o);
    Txt   (u, value);
    NL    (u);
  END init_chars;

PROCEDURE <A NAME="init_float"><procedure>init_float</procedure></A> (u: U;  o: ByteOffset;  READONLY f: Target.Float) =
  BEGIN
    Cmd   (u, &quot;init_float&quot;);
    Int   (u, o);
    Flt   (u, f);
    NL    (u);
  END init_float;
</PRE>------------------------------------------------------------ procedures ---

<P><PRE>PROCEDURE <A NAME="NewProc"><procedure>NewProc</procedure></A> (u: U): Proc =
  VAR p := NEW (WrProc, tag := u.next_proc);
  BEGIN
    INC (u.next_proc);
    RETURN p;
  END NewProc;

PROCEDURE <A NAME="import_procedure"><procedure>import_procedure</procedure></A> (u: U;  n: Name;  n_params: INTEGER;
                          ret_type: Type;  cc: CallingConvention): Proc =
  VAR p := NewProc (u);
  BEGIN
    Cmd   (u, &quot;import_procedure&quot;);
    ZName (u, n);
    Int   (u, n_params);
    TName (u, ret_type);
    Int   (u, cc.m3cg_id);
    PName (u, p);
    NL    (u);
    RETURN p;
  END import_procedure;

PROCEDURE <A NAME="declare_procedure"><procedure>declare_procedure</procedure></A> (u: U;  n: Name;  n_params: INTEGER;
                             return_type: Type;  lev: INTEGER;
                             cc: CallingConvention;
                             exported: BOOLEAN;  parent: Proc): Proc =
  VAR p := NewProc (u);
  BEGIN
    Cmd   (u, &quot;declare_procedure&quot;);
    ZName (u, n);
    Int   (u, n_params);
    TName (u, return_type);
    Int   (u, lev);
    Int   (u, cc.m3cg_id);
    Bool  (u, exported);
    PName (u, parent);
    PName (u, p);
    NL    (u);
    RETURN p;
  END declare_procedure;

PROCEDURE <A NAME="begin_procedure"><procedure>begin_procedure</procedure></A> (u: U;  p: Proc) =
  BEGIN
    Cmd   (u, &quot;begin_procedure&quot;);
    PName (u, p);
    NL    (u);
  END begin_procedure;

PROCEDURE <A NAME="end_procedure"><procedure>end_procedure</procedure></A> (u: U;  p: Proc) =
  BEGIN
    Cmd   (u, &quot;end_procedure&quot;);
    PName (u, p);
    NL    (u);
  END end_procedure;

PROCEDURE <A NAME="begin_block"><procedure>begin_block</procedure></A> (u: U) =
  (* marks the beginning of a nested anonymous block *)
  BEGIN
    Cmd   (u, &quot;begin_block&quot;);
    NL    (u);
  END begin_block;

PROCEDURE <A NAME="end_block"><procedure>end_block</procedure></A> (u: U) =
  (* marks the ending of a nested anonymous block *)
  BEGIN
    Cmd   (u, &quot;end_block&quot;);
    NL    (u);
  END end_block;

PROCEDURE <A NAME="note_procedure_origin"><procedure>note_procedure_origin</procedure></A> (u: U;  p: Proc) =
  BEGIN
    Cmd   (u, &quot;note_procedure_origin&quot;);
    PName (u, p);
    NL    (u);
  END note_procedure_origin;
</PRE>------------------------------------------------------------ statements ---

<P><PRE>PROCEDURE <A NAME="set_label"><procedure>set_label</procedure></A> (u: U;  l: Label;  barrier: BOOLEAN) =
  (* define 'l' to be at the current pc *)
  BEGIN
    OutT  (u, &quot;.&quot;);
    Lab   (u, l);
    Bool  (u, barrier);
    NL    (u);
  END set_label;

PROCEDURE <A NAME="jump"><procedure>jump</procedure></A> (u: U; l: Label) =
  (* GOTO l *)
  BEGIN
    Cmd   (u, &quot;jump&quot;);
    Lab   (u, l);
    NL    (u);
  END jump;

PROCEDURE <A NAME="if_true"><procedure>if_true</procedure></A>  (u: U; l: Label;  f: Frequency) =
  (* IF (s0.I # 0) GOTO l ; pop *)
  BEGIN
    Cmd   (u, &quot;if_true&quot;);
    Lab   (u, l);
    Int   (u, f);
    NL    (u);
  END if_true;

PROCEDURE <A NAME="if_false"><procedure>if_false</procedure></A> (u: U; l: Label;  f: Frequency) =
  (* IF (s0.I = 0) GOTO l ; pop *)
  BEGIN
    Cmd   (u, &quot;if_false&quot;);
    Lab   (u, l);
    Int   (u, f);
    NL    (u);
  END if_false;

PROCEDURE <A NAME="if_eq"><procedure>if_eq</procedure></A> (u: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t = s0.t) GOTO l ; pop(2) *)
  BEGIN
    Cmd   (u, &quot;if_eq&quot;);
    Lab   (u, l);
    TName (u, t);
    Int   (u, f);
    NL    (u);
  END if_eq;

PROCEDURE <A NAME="if_ne"><procedure>if_ne</procedure></A> (u: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t # s0.t) GOTO l ; pop(2) *)
  BEGIN
    Cmd   (u, &quot;if_ne&quot;);
    Lab   (u, l);
    TName (u, t);
    Int   (u, f);
    NL    (u);
  END if_ne;

PROCEDURE <A NAME="if_gt"><procedure>if_gt</procedure></A> (u: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t &gt; s0.t) GOTO l ; pop(2) *)
  BEGIN
    Cmd   (u, &quot;if_gt&quot;);
    Lab   (u, l);
    TName (u, t);
    Int   (u, f);
    NL    (u);
  END if_gt;

PROCEDURE <A NAME="if_ge"><procedure>if_ge</procedure></A> (u: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t &gt;= s0.t) GOTO l ; pop(2) *)
  BEGIN
    Cmd   (u, &quot;if_ge&quot;);
    Lab   (u, l);
    TName (u, t);
    Int   (u, f);
    NL    (u);
  END if_ge;

PROCEDURE <A NAME="if_lt"><procedure>if_lt</procedure></A> (u: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t &lt; s0.t) GOTO l ; pop(2) *)
  BEGIN
    Cmd   (u, &quot;if_lt&quot;);
    Lab   (u, l);
    TName (u, t);
    Int   (u, f);
    NL    (u);
  END if_lt;

PROCEDURE <A NAME="if_le"><procedure>if_le</procedure></A> (u: U;  l: Label;  t: ZType;  f: Frequency) =
  (* IF (s1.t &lt;= s0.t) GOTO l ; pop(2) *)
  BEGIN
    Cmd   (u, &quot;if_le&quot;);
    Lab   (u, l);
    TName (u, t);
    Int   (u, f);
    NL    (u);
  END if_le;

PROCEDURE <A NAME="case_jump"><procedure>case_jump</procedure></A> (u: U; READONLY labels: ARRAY OF Label) =
  (* &quot;GOTO labels[s0.I] ; pop&quot; with no range checking on s0.I *)
  BEGIN
    Cmd   (u, &quot;case_jump&quot;);
    Int   (u, NUMBER(labels));
    FOR i := FIRST (labels) TO LAST (labels) DO  Lab (u, labels [i]);  END;
    NL    (u);
  END case_jump;

PROCEDURE <A NAME="exit_proc"><procedure>exit_proc</procedure></A> (u: U; t: Type) =
  (* Returns s0.t if the stack is non-empty, otherwise returns no value. *)
  BEGIN
    Cmd   (u, &quot;exit_proc&quot;);
    TName (u, t);
    NL    (u);
  END exit_proc;
</PRE>------------------------------------------------------------ load/store ---

<P><PRE>PROCEDURE <A NAME="load"><procedure>load</procedure></A>  (u: U;  v: Var;  o: ByteOffset;  t: MType) =
  BEGIN
    Cmd   (u, &quot;load&quot;);
    VName (u, v);
    Int   (u, o);
    TName (u, t);
    NL    (u);
  END load;

PROCEDURE <A NAME="store"><procedure>store</procedure></A>  (u: U;  v: Var;  o: ByteOffset;  t: MType) =
  BEGIN
    Cmd   (u, &quot;store&quot;);
    VName (u, v);
    Int   (u, o);
    TName (u, t);
    NL    (u);
  END store;

PROCEDURE <A NAME="store_ref"><procedure>store_ref</procedure></A> (u: U;  v: Var;  o: ByteOffset) =
  BEGIN
    Cmd   (u, &quot;store_ref&quot;);
    VName (u, v);
    Int   (u, o);
    NL    (u);
  END store_ref;

PROCEDURE <A NAME="load_address"><procedure>load_address</procedure></A> (u: U;  v: Var;  o: ByteOffset) =
  BEGIN
    Cmd   (u, &quot;load_address&quot;);
    VName (u, v);
    Int   (u, o);
    NL    (u);
  END load_address;

PROCEDURE <A NAME="load_indirect"><procedure>load_indirect</procedure></A> (u: U;  o: ByteOffset;  t: MType) =
  BEGIN
    Cmd   (u, &quot;load_indirect&quot;);
    Int   (u, o);
    TName (u, t);
    NL    (u);
  END load_indirect;

PROCEDURE <A NAME="store_indirect"><procedure>store_indirect</procedure></A> (u: U;  o: ByteOffset;  t: MType) =
  BEGIN
    Cmd   (u, &quot;store_indirect&quot;);
    Int   (u, o);
    TName (u, t);
    NL    (u);
  END store_indirect;

PROCEDURE <A NAME="store_ref_indirect"><procedure>store_ref_indirect</procedure></A> (u: U;  o: ByteOffset;  var: BOOLEAN) =
  BEGIN
    Cmd   (u, &quot;store_ref_indirect&quot;);
    Int   (u, o);
    Bool  (u, var);
    NL    (u);
  END store_ref_indirect;
</PRE>-------------------------------------------------------------- literals ---

<P><PRE>PROCEDURE <A NAME="load_nil"><procedure>load_nil</procedure></A> (u: U) =
  (* push ; s0.A := a *)
  BEGIN
    Cmd   (u, &quot;load_nil&quot;);
    NL    (u);
  END load_nil;

PROCEDURE <A NAME="load_integer"><procedure>load_integer</procedure></A>  (u: U;  READONLY i: Target.Int) =
  (* push ; s0.I := i *)
  BEGIN
    Cmd   (u, &quot;load_integer&quot;);
    TInt  (u, i);
    NL    (u);
  END load_integer;

PROCEDURE <A NAME="load_float"><procedure>load_float</procedure></A>    (u: U;  READONLY f: Target.Float) =
  (* push ; s0.t := f *)
  BEGIN
    Cmd   (u, &quot;load_float&quot;);
    Flt   (u, f);
    NL    (u);
  END load_float;
</PRE>------------------------------------------------------------ arithmetic ---

<P><PRE>PROCEDURE <A NAME="eq"><procedure>eq</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t = s0.t)  ; pop *)
  BEGIN
    Cmd   (u, &quot;eq&quot;);
    TName (u, t);
    NL    (u);
  END eq;

PROCEDURE <A NAME="ne"><procedure>ne</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t # s0.t)  ; pop *)
  BEGIN
    Cmd   (u, &quot;ne&quot;);
    TName (u, t);
    NL    (u);
  END ne;

PROCEDURE <A NAME="gt"><procedure>gt</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t &gt; s0.t)  ; pop *)
  BEGIN
    Cmd   (u, &quot;gt&quot;);
    TName (u, t);
    NL    (u);
  END gt;

PROCEDURE <A NAME="ge"><procedure>ge</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t &gt;= s0.t) ; pop *)
  BEGIN
    Cmd   (u, &quot;ge&quot;);
    TName (u, t);
    NL    (u);
  END ge;

PROCEDURE <A NAME="lt"><procedure>lt</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t &lt; s0.t)  ; pop *)
  BEGIN
    Cmd   (u, &quot;lt&quot;);
    TName (u, t);
    NL    (u);
  END lt;

PROCEDURE <A NAME="le"><procedure>le</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t &lt;= s0.t) ; pop *)
  BEGIN
    Cmd   (u, &quot;le&quot;);
    TName (u, t);
    NL    (u);
  END le;

PROCEDURE <A NAME="add"><procedure>add</procedure></A> (u: U;  t: AType) =
  (* s1.t := s1.t + s0.t ; pop *)
  BEGIN
    Cmd   (u, &quot;add&quot;);
    TName (u, t);
    NL    (u);
  END add;

PROCEDURE <A NAME="subtract"><procedure>subtract</procedure></A> (u: U;  t: AType) =
  (* s1.t := s1.t - s0.t ; pop *)
  BEGIN
    Cmd   (u, &quot;subtract&quot;);
    TName (u, t);
    NL    (u);
  END subtract;

PROCEDURE <A NAME="multiply"><procedure>multiply</procedure></A> (u: U;  t: AType) =
  (* s1.t := s1.t * s0.t ; pop *)
  BEGIN
    Cmd   (u, &quot;multiply&quot;);
    TName (u, t);
    NL    (u);
  END multiply;

PROCEDURE <A NAME="divide"><procedure>divide</procedure></A> (u: U;  t: RType) =
  (* s1.t := s1.t / s0.t ; pop *)
  BEGIN
    Cmd   (u, &quot;divide&quot;);
    TName (u, t);
    NL    (u);
  END divide;

CONST SignName = ARRAY Sign OF TEXT { &quot; P&quot;, &quot; N&quot;, &quot; X&quot; };

PROCEDURE <A NAME="div"><procedure>div</procedure></A> (u: U;  t: IType;  a, b: Sign) =
  (* s1.t := s1.t DIV s0.t ; pop *)
  BEGIN
    Cmd   (u, &quot;div&quot;);
    TName (u, t);
    OutT  (u, SignName [a]);
    OutT  (u, SignName [b]);
    NL    (u);
  END div;

PROCEDURE <A NAME="mod"><procedure>mod</procedure></A> (u: U;  t: IType;  a, b: Sign) =
  (* s1.t := s1.t MOD s0.t ; pop *)
  BEGIN
    Cmd   (u, &quot;mod&quot;);
    TName (u, t);
    OutT  (u, SignName [a]);
    OutT  (u, SignName [b]);
    NL    (u);
  END mod;

PROCEDURE <A NAME="negate"><procedure>negate</procedure></A> (u: U;  t: AType) =
  (* s0.t := - s0.t *)
  BEGIN
    Cmd   (u, &quot;negate&quot;);
    TName (u, t);
    NL    (u);
  END negate;

PROCEDURE <A NAME="abs"><procedure>abs</procedure></A>      (u: U;  t: AType) =
  (* s0.t := ABS (s0.t) (noop on Words) *)
  BEGIN
    Cmd   (u, &quot;abs&quot;);
    TName (u, t);
    NL    (u);
  END abs;

PROCEDURE <A NAME="max"><procedure>max</procedure></A>      (u: U;  t: ZType) =
  (* s1.t := MAX (s1.t, s0.t) ; pop *)
  BEGIN
    Cmd   (u, &quot;max&quot;);
    TName (u, t);
    NL    (u);
  END max;

PROCEDURE <A NAME="min"><procedure>min</procedure></A>      (u: U;  t: ZType) =
  (* s1.t := MIN (s1.t, s0.t) ; pop *)
  BEGIN
    Cmd   (u, &quot;min&quot;);
    TName (u, t);
    NL    (u);
  END min;

PROCEDURE <A NAME="round"><procedure>round</procedure></A>    (u: U;  t: RType) =
  (* s0.I := ROUND (s0.t) *)
  BEGIN
    Cmd   (u, &quot;round&quot;);
    TName (u, t);
    NL    (u);
  END round;

PROCEDURE <A NAME="trunc"><procedure>trunc</procedure></A>    (u: U;  t: RType) =
  (* s0.I := TRUNC (s0.t) *)
  BEGIN
    Cmd   (u, &quot;trunc&quot;);
    TName (u, t);
    NL    (u);
  END trunc;

PROCEDURE <A NAME="floor"><procedure>floor</procedure></A>    (u: U;  t: RType) =
  (* s0.I := FLOOR (s0.t) *)
  BEGIN
    Cmd   (u, &quot;floor&quot;);
    TName (u, t);
    NL    (u);
  END floor;

PROCEDURE <A NAME="ceiling"><procedure>ceiling</procedure></A>  (u: U;  t: RType) =
  (* s0.I := CEILING (s0.t) *)
  BEGIN
    Cmd   (u, &quot;ceiling&quot;);
    TName (u, t);
    NL    (u);
  END ceiling;

PROCEDURE <A NAME="cvt_float"><procedure>cvt_float</procedure></A> (u: U;  t: AType;  x: RType) =
  (* s0.x := FLOAT (s0.t, x) *)
  BEGIN
    Cmd   (u, &quot;cvt_float&quot;);
    TName (u, t);
    TName (u, x);
    NL    (u);
  END cvt_float;
</PRE>------------------------------------------------------------------ sets ---

<P><PRE>PROCEDURE <A NAME="set_union"><procedure>set_union</procedure></A> (u: U;  s: ByteSize) =
  (* s1.B := s1.B + s0.B ; pop *)
  BEGIN
    Cmd   (u, &quot;set_union&quot;);
    Int   (u, s);
    NL    (u);
  END set_union;

PROCEDURE <A NAME="set_difference"><procedure>set_difference</procedure></A> (u: U;  s: ByteSize) =
  (* s1.B := s1.B - s0.B ; pop *)
  BEGIN
    Cmd   (u, &quot;set_difference&quot;);
    Int   (u, s);
    NL    (u);
  END set_difference;

PROCEDURE <A NAME="set_intersection"><procedure>set_intersection</procedure></A> (u: U;  s: ByteSize) =
  (* s1.B := s1.B * s0.B ; pop *)
  BEGIN
    Cmd   (u, &quot;set_intersection&quot;);
    Int   (u, s);
    NL    (u);
  END set_intersection;

PROCEDURE <A NAME="set_sym_difference"><procedure>set_sym_difference</procedure></A> (u: U;  s: ByteSize) =
  (* s1.B := s1.B / s0.B ; pop *)
  BEGIN
    Cmd   (u, &quot;set_sym_difference&quot;);
    Int   (u, s);
    NL    (u);
  END set_sym_difference;

PROCEDURE <A NAME="set_member"><procedure>set_member</procedure></A>       (u: U;  s: ByteSize) =
  (* s1.I := (s0.I IN s1.B) ; pop *)
  BEGIN
    Cmd   (u, &quot;set_member&quot;);
    Int   (u, s);
    NL    (u);
  END set_member;

PROCEDURE <A NAME="set_eq"><procedure>set_eq</procedure></A>       (u: U;  s: ByteSize) =
  (* s1.I := (s1.B = s0.B)  ; pop *)
  BEGIN
    Cmd   (u, &quot;set_eq&quot;);
    Int   (u, s);
    NL    (u);
  END set_eq;

PROCEDURE <A NAME="set_ne"><procedure>set_ne</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B # s0.B)  ; pop *)
  BEGIN
    Cmd   (u, &quot;set_ne&quot;);
    Int   (u, s);
    NL    (u);
  END set_ne;

PROCEDURE <A NAME="set_gt"><procedure>set_gt</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B &gt; s0.B)  ; pop *)
  BEGIN
    Cmd   (u, &quot;set_gt&quot;);
    Int   (u, s);
    NL    (u);
  END set_gt;

PROCEDURE <A NAME="set_ge"><procedure>set_ge</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B &gt;= s0.B) ; pop *)
  BEGIN
    Cmd   (u, &quot;set_ge&quot;);
    Int   (u, s);
    NL    (u);
  END set_ge;

PROCEDURE <A NAME="set_lt"><procedure>set_lt</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B &lt; s0.B)  ; pop *)
  BEGIN
    Cmd   (u, &quot;set_lt&quot;);
    Int   (u, s);
    NL    (u);
  END set_lt;

PROCEDURE <A NAME="set_le"><procedure>set_le</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B &lt;= s0.B) ; pop *)
  BEGIN
    Cmd   (u, &quot;set_le&quot;);
    Int   (u, s);
    NL    (u);
  END set_le;

PROCEDURE <A NAME="set_range"><procedure>set_range</procedure></A> (u: U;  s: ByteSize) =
  (* s2.A [s1.I .. s0.I] := 1's; pop(3)*)
  BEGIN
    Cmd   (u, &quot;set_range&quot;);
    Int   (u, s);
    NL    (u);
  END set_range;

PROCEDURE <A NAME="set_singleton"><procedure>set_singleton</procedure></A> (u: U;  s: ByteSize) =
  (* s1.A [s0.I] := 1; pop(2) *)
  BEGIN
    Cmd   (u, &quot;set_singleton&quot;);
    Int   (u, s);
    NL    (u);
  END set_singleton;
</PRE>------------------------------------------------- Word.T bit operations ---

<P><PRE>PROCEDURE <A NAME="not"><procedure>not</procedure></A> (u: U) =
  (* s0.I := Word.Not (s0.I) *)
  BEGIN
    Cmd   (u, &quot;not&quot;);
    TName (u, Type.Int);
    NL    (u);
  END not;

PROCEDURE <A NAME="and"><procedure>and</procedure></A> (u: U) =
  (* s1.I := Word.And (s1.I, s0.I) ; pop *)
  BEGIN
    Cmd   (u, &quot;and&quot;);
    TName (u, Type.Int);
    NL    (u);
  END and;

PROCEDURE <A NAME="or"><procedure>or</procedure></A>  (u: U) =
  (* s1.I := Word.Or  (s1.I, s0.I) ; pop *)
  BEGIN
    Cmd   (u, &quot;or&quot;);
    TName (u, Type.Int);
    NL    (u);
  END or;

PROCEDURE <A NAME="xor"><procedure>xor</procedure></A> (u: U) =
  (* s1.I := Word.Xor (s1.I, s0.I) ; pop *)
  BEGIN
    Cmd   (u, &quot;xor&quot;);
    TName (u, Type.Int);
    NL    (u);
  END xor;

PROCEDURE <A NAME="shift"><procedure>shift</procedure></A>        (u: U) =
  (* s1.I := Word.Shift  (s1.I, s0.I) ; pop *)
  BEGIN
    Cmd   (u, &quot;shift&quot;);
    TName (u, Type.Int);
    NL    (u);
  END shift;

PROCEDURE <A NAME="shift_left"><procedure>shift_left</procedure></A>   (u: U) =
  (* s1.I := Word.Shift  (s1.I, s0.I) ; pop *)
  BEGIN
    Cmd   (u, &quot;shift_left&quot;);
    TName (u, Type.Int);
    NL    (u);
  END shift_left;

PROCEDURE <A NAME="shift_right"><procedure>shift_right</procedure></A>  (u: U) =
  (* s1.I := Word.Shift  (s1.I, -s0.I) ; pop *)
  BEGIN
    Cmd   (u, &quot;shift_right&quot;);
    TName (u, Type.Int);
    NL    (u);
  END shift_right;

PROCEDURE <A NAME="rotate"><procedure>rotate</procedure></A>       (u: U) =
  (* s1.I := Word.Rotate (s1.I, s0.I) ; pop *)
  BEGIN
    Cmd   (u, &quot;rotate&quot;);
    TName (u, Type.Int);
    NL    (u);
  END rotate;

PROCEDURE <A NAME="rotate_left"><procedure>rotate_left</procedure></A>  (u: U) =
  (* s1.I := Word.Rotate (s1.I, s0.I) ; pop *)
  BEGIN
    Cmd   (u, &quot;rotate_left&quot;);
    TName (u, Type.Int);
    NL    (u);
  END rotate_left;

PROCEDURE <A NAME="rotate_right"><procedure>rotate_right</procedure></A> (u: U) =
  (* s1.I := Word.Rotate (s1.I, -s0.I) ; pop *)
  BEGIN
    Cmd   (u, &quot;rotate_right&quot;);
    TName (u, Type.Int);
    NL    (u);
  END rotate_right;

PROCEDURE <A NAME="extract"><procedure>extract</procedure></A> (u: U;  sign: BOOLEAN) =
  (* s2.I := Word.Extract(s2.I, s1.I, s0.I);
     IF sign THEN SignExtend s2 END; pop(2) *)
  BEGIN
    Cmd   (u, &quot;extract&quot;);
    Bool  (u, sign);
    NL    (u);
  END extract;

PROCEDURE <A NAME="extract_n"><procedure>extract_n</procedure></A> (u: U;  sign: BOOLEAN;  n: INTEGER) =
  (* s1.I := Word.Extract(s1.I, s0.I, n);
     IF sign THEN SignExtend s1 END; pop(1) *)
  BEGIN
    Cmd   (u, &quot;extract_n&quot;);
    Bool  (u, sign);
    Int   (u, n);
    NL    (u);
  END extract_n;

PROCEDURE <A NAME="extract_mn"><procedure>extract_mn</procedure></A> (u: U;  sign: BOOLEAN;  m, n: INTEGER) =
  (* s0.I := Word.Extract(s0.I, m, n);
     IF sign THEN SignExtend s0 END; *)
  BEGIN
    Cmd   (u, &quot;extract_mn&quot;);
    Bool  (u, sign);
    Int   (u, m);
    Int   (u, n);
    NL    (u);
  END extract_mn;

PROCEDURE <A NAME="insert"><procedure>insert</procedure></A>  (u: U) =
  (* s3.I := Word.Insert (s3.I, s2.I, s1.I, s0.I) ; pop(3) *)
  BEGIN
    Cmd   (u, &quot;insert&quot;);
    NL    (u);
  END insert;

PROCEDURE <A NAME="insert_n"><procedure>insert_n</procedure></A>  (u: U;  n: INTEGER) =
  (* s2.I := Word.Insert (s2.I, s1.I, s0.I, n) ; pop(2) *)
  BEGIN
    Cmd   (u, &quot;insert_n&quot;);
    Int   (u, n);
    NL    (u);
  END insert_n;

PROCEDURE <A NAME="insert_mn"><procedure>insert_mn</procedure></A>  (u: U;  m, n: INTEGER) =
  (* s1.I := Word.Insert (s1.I, s0.I, m, n) ; pop(2) *)
  BEGIN
    Cmd   (u, &quot;insert_mn&quot;);
    Int   (u, m);
    Int   (u, n);
    NL    (u);
  END insert_mn;
</PRE>------------------------------------------------ misc. stack/memory ops ---

<P><PRE>PROCEDURE <A NAME="swap"><procedure>swap</procedure></A> (u: U;  a, b: Type) =
  (* tmp := s1 ; s1 := s0 ; s0 := tmp *)
  BEGIN
    Cmd   (u, &quot;swap&quot;);
    TName (u, a);
    TName (u, b);
    NL    (u);
  END swap;

PROCEDURE <A NAME="pop"><procedure>pop</procedure></A>  (u: U;  t: Type) =
  (* pop(1) (i.e. discard s0) *)
  BEGIN
    Cmd   (u, &quot;pop&quot;);
    TName (u, t);
    NL    (u);
  END pop;

PROCEDURE <A NAME="copy_n"><procedure>copy_n</procedure></A> (u: U;  t: MType;  overlap: BOOLEAN) =
  (* Mem[s2.A:s0.I] := Mem[s1.A:s0.I]; pop(3)*)
  BEGIN
    Cmd   (u, &quot;copy_n&quot;);
    TName (u, t);
    Bool  (u, overlap);
    NL    (u);
  END copy_n;

PROCEDURE <A NAME="copy"><procedure>copy</procedure></A> (u: U;  n: INTEGER;  t: MType;  overlap: BOOLEAN) =
  (* Mem[s2.A:sz] := Mem[s1.A:sz]; pop(2)*)
  BEGIN
    Cmd   (u, &quot;copy&quot;);
    Int   (u, n);
    TName (u, t);
    Bool  (u, overlap);
    NL    (u);
  END copy;

PROCEDURE <A NAME="zero_n"><procedure>zero_n</procedure></A> (u: U;  t: MType) =
  (* Mem[s1.A:s0.I] := 0; pop(2) *)
  BEGIN
    Cmd   (u, &quot;zero_n&quot;);
    TName (u, t);
    NL    (u);
  END zero_n;

PROCEDURE <A NAME="zero"><procedure>zero</procedure></A> (u: U;  n: INTEGER;  t: MType) =
  (* Mem[s1.A:sz] := 0; pop(1) *)
  BEGIN
    Cmd   (u, &quot;zero&quot;);
    Int   (u, n);
    TName (u, t);
    NL    (u);
  END zero;
</PRE>----------------------------------------------------------- conversions ---

<P><PRE>PROCEDURE <A NAME="loophole"><procedure>loophole</procedure></A> (u: U;  from, two: ZType) =
  (* s0.to := LOOPHOLE(s0.from, to) *)
  BEGIN
    Cmd   (u, &quot;loophole&quot;);
    TName (u, from);
    TName (u, two);
    NL    (u);
  END loophole;
</PRE>------------------------------------------------ traps &amp; runtime checks ---

<P><PRE>PROCEDURE <A NAME="assert_fault"><procedure>assert_fault</procedure></A> (u: U) =
  BEGIN
    Cmd   (u, &quot;assert_fault&quot;);
    NL    (u);
  END assert_fault;

PROCEDURE <A NAME="narrow_fault"><procedure>narrow_fault</procedure></A> (u: U) =
  BEGIN
    Cmd   (u, &quot;narrow_fault&quot;);
    NL    (u);
  END narrow_fault;

PROCEDURE <A NAME="return_fault"><procedure>return_fault</procedure></A> (u: U) =
  BEGIN
    Cmd   (u, &quot;return_fault&quot;);
    NL    (u);
  END return_fault;

PROCEDURE <A NAME="case_fault"><procedure>case_fault</procedure></A> (u: U) =
  BEGIN
    Cmd   (u, &quot;case_fault&quot;);
    NL    (u);
  END case_fault;

PROCEDURE <A NAME="typecase_fault"><procedure>typecase_fault</procedure></A> (u: U) =
  (* Abort *)
  BEGIN
    Cmd   (u, &quot;typecase_fault&quot;);
    NL    (u);
  END typecase_fault;

PROCEDURE <A NAME="check_nil"><procedure>check_nil</procedure></A> (u: U) =
  (* IF (s0.A = NIL) THEN Abort *)
  BEGIN
    Cmd   (u, &quot;check_nil&quot;);
    NL    (u);
  END check_nil;

PROCEDURE <A NAME="check_lo"><procedure>check_lo</procedure></A> (u: U;  READONLY i: Target.Int) =
  (* IF (s0.I &lt; i) THEN Abort *)
  BEGIN
    Cmd   (u, &quot;check_lo&quot;);
    TInt (u, i);
    NL    (u);
  END check_lo;

PROCEDURE <A NAME="check_hi"><procedure>check_hi</procedure></A> (u: U;  READONLY i: Target.Int) =
  (* IF (i &lt; s0.I) THEN Abort *)
  BEGIN
    Cmd   (u, &quot;check_hi&quot;);
    TInt (u, i);
    NL    (u);
  END check_hi;

PROCEDURE <A NAME="check_range"><procedure>check_range</procedure></A> (u: U;  READONLY a, b: Target.Int) =
  (* IF (s0.I &lt; a) OR (b &lt; s0.I) THEN Abort *)
  BEGIN
    Cmd   (u, &quot;check_range&quot;);
    TInt (u, a);
    TInt (u, b);
    NL    (u);
  END check_range;

PROCEDURE <A NAME="check_index"><procedure>check_index</procedure></A> (u: U) =
  BEGIN
    Cmd   (u, &quot;check_index&quot;);
    NL    (u);
  END check_index;

PROCEDURE <A NAME="check_eq"><procedure>check_eq</procedure></A> (u: U) =
  (* IF (s0.I # s1.I) THEN Abort;  Pop (2) *)
  BEGIN
    Cmd   (u, &quot;check_eq&quot;);
    NL    (u);
  END check_eq;
</PRE>---------------------------------------------------- address arithmetic ---

<P><PRE>PROCEDURE <A NAME="add_offset"><procedure>add_offset</procedure></A> (u: U; i: INTEGER) =
  (* s0.A := s0.A + i *)
  BEGIN
    Cmd   (u, &quot;add_offset&quot;);
    Int   (u, i);
    NL    (u);
  END add_offset;

PROCEDURE <A NAME="index_address"><procedure>index_address</procedure></A> (u: U;  size: INTEGER) =
  (* s1.A := s1.A + s0.I * size ; pop *)
  BEGIN
    Cmd   (u, &quot;index_address&quot;);
    Int   (u, size);
    NL    (u);
  END index_address;
</PRE>------------------------------------------------------- procedure calls ---

<P><PRE>PROCEDURE <A NAME="start_call_direct"><procedure>start_call_direct</procedure></A> (u: U;  p: Proc;  lev: INTEGER;  t: Type) =
  (* begin a procedure call to a procedure at static level 'lev'. *)
  BEGIN
    Cmd   (u, &quot;start_call_direct&quot;);
    PName (u, p);
    Int   (u, lev);
    TName (u, t);
    NL    (u);
  END start_call_direct;

PROCEDURE <A NAME="start_call_indirect"><procedure>start_call_indirect</procedure></A> (u: U;  t: Type;  cc: CallingConvention) =
  (* begin a procedure call to a procedure at static level 'lev'. *)
  BEGIN
    Cmd   (u, &quot;start_call_indirect&quot;);
    TName (u, t);
    Int   (u, cc.m3cg_id);
    NL    (u);
  END start_call_indirect;

PROCEDURE <A NAME="pop_param"><procedure>pop_param</procedure></A> (u: U;  t: ZType) =
  (* pop s0 and make it the &quot;next&quot; paramter in the current call *)
  BEGIN
    Cmd   (u, &quot;pop_param&quot;);
    TName (u, t);
    NL    (u);
  END pop_param;

PROCEDURE <A NAME="pop_struct"><procedure>pop_struct</procedure></A> (u: U;  s: ByteSize;  a: Alignment) =
  (* pop s0 and make it the &quot;next&quot; paramter in the current call *)
  BEGIN
    Cmd   (u, &quot;pop_struct&quot;);
    Int   (u, s);
    Int   (u, a);
    NL    (u);
  END pop_struct;

PROCEDURE <A NAME="pop_static_link"><procedure>pop_static_link</procedure></A> (u: U) =
  BEGIN
    Cmd   (u, &quot;pop_static_link&quot;);
    NL    (u);
  END pop_static_link;

PROCEDURE <A NAME="call_direct"><procedure>call_direct</procedure></A> (u: U; p: Proc;  t: Type) =
  (* call the procedure identified by block b.  The procedure
     returns a value of type t. *)
  BEGIN
    Cmd   (u, &quot;call_direct&quot;);
    PName (u, p);
    TName (u, t);
    NL    (u);
  END call_direct;

PROCEDURE <A NAME="call_indirect"><procedure>call_indirect</procedure></A> (u: U;  t: Type;  cc: CallingConvention) =
  (* call the procedure whose address is in s0.A and pop s0.  The
     procedure returns a value of type t. *)
  BEGIN
    Cmd   (u, &quot;call_indirect&quot;);
    TName (u, t);
    Int   (u, cc.m3cg_id);
    NL    (u);
  END call_indirect;
</PRE>------------------------------------------- procedure and closure types ---

<P><PRE>PROCEDURE <A NAME="load_procedure"><procedure>load_procedure</procedure></A> (u: U;  p: Proc) =
  (* push; s0.A := ADDR (p's body) *)
  BEGIN
    Cmd   (u, &quot;load_procedure&quot;);
    PName (u, p);
    NL    (u);
  END load_procedure;

PROCEDURE <A NAME="load_static_link"><procedure>load_static_link</procedure></A> (u: U;  p: Proc) =
  (* push; s0.A := (static link needed to call p, NIL for top-level procs) *)
  BEGIN
    Cmd   (u, &quot;load_static_link&quot;);
    PName (u, p);
    NL    (u);
  END load_static_link;
</PRE>----------------------------------------------------------------- misc. ---

<P><PRE>PROCEDURE <A NAME="comment"><procedure>comment</procedure></A> (u: U;  a, b, c, d: TEXT := NIL) =
  VAR i: INTEGER := -1;
  BEGIN
    Cmt (u, a, i);
    Cmt (u, b, i);
    Cmt (u, c, i);
    Cmt (u, d, i);
    Cmt (u, Target.EOL, i);
  END comment;

PROCEDURE <A NAME="Cmt"><procedure>Cmt</procedure></A> (u: U;  t: TEXT;  VAR width: INTEGER) =
  VAR ch: CHAR;
  BEGIN
    IF (t = NIL) THEN RETURN END;
    FOR i := 0 TO Text.Length (t) - 1 DO
      ch := Text.GetChar (t, i);
      IF (width = -1) THEN OutT (u, &quot;\t# &quot;); width := 0; END;
      IF (ch = '\r') THEN
        (* eat carriage returns *)
      ELSIF (ch = '\n') THEN
        OutT (u, Target.EOL);
        width := -1;
      ELSE
        OutC (u, ch);
      END;
    END;
  END Cmt;

BEGIN
END M3CG_Wr.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
