<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/M3ID.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/M3ID.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: M3ID.i3                                               

<P><PRE>INTERFACE <interface><A HREF="#x1">M3ID</A></interface>;
</PRE> An <CODE>M3ID.T</CODE> represents a Modula-3 identifier.  Equal identifiers
   are represented by the same M3ID.T.  Any non-NULL character
   may be included in an <CODE>M3ID.T</CODE>.  

<P><PRE>IMPORT <A HREF="M3Buf.i3">M3Buf</A>;

TYPE  T    = [-16_7fffffff-1 .. 16_7fffffff]; (* a 32-bit integer *)
CONST NoID = 0;  (* an illegal ID, never returned by Add or FromStr *)

PROCEDURE <A HREF="M3ID.m3#Add">Add</A> (x: TEXT;  class: [0..255] := 0): T;
</PRE><BLOCKQUOTE><EM> Returns the ID representing <CODE>x</CODE> and sets the class of the ID to <CODE>class</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ID.m3#FromStr">FromStr</A> (READONLY buf: ARRAY OF CHAR;  length: INTEGER := 99999): T;
</PRE><BLOCKQUOTE><EM> Returns the ID representing buf[0 .. MIN(HIGH(buf), length-1)]. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ID.m3#ToText">ToText</A> (t: T): TEXT;
</PRE><BLOCKQUOTE><EM> Returns a text equal to the one <CODE>t</CODE> represents. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ID.m3#GetClass">GetClass</A> (t: T): INTEGER;
</PRE><BLOCKQUOTE><EM> Returns the class assigned to <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ID.m3#Hash">Hash</A> (t: T): INTEGER;
</PRE><BLOCKQUOTE><EM> Returns the hash value of <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ID.m3#Put">Put</A> (wr: M3Buf.T;  t: T);
</PRE><BLOCKQUOTE><EM> == M3Buf.PutText (ToText(t)), without the impiled TEXT allocation </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ID.m3#AdvanceMarks">AdvanceMarks</A> ();
</PRE><BLOCKQUOTE><EM> start using a <CODE>new</CODE> set of marks.  They're recycled after 256 advances. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ID.m3#SetMark">SetMark</A> (t: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> if <CODE>SetMark(t)</CODE> hash been called since the last call
   to <CODE>AdvanceMarks</CODE>.  There's a chance for false positives, so clients
   must be prepared to check that <CODE>t</CODE> was indeed marked twice. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ID.m3#IsLT">IsLT</A> (a, b: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> if the text represented by <CODE>a</CODE> is lexicographically
   less than the one represented by <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

END M3ID.
</PRE>
</inInterface>
<HR>
<A NAME="x1">M3ID's implementation  is in:
</A><UL>
<LI><A HREF="M3ID.m3#0TOP0">m3middle/src/M3ID.m3</A>
<LI><A HREF="../../m3tools/src/M3ID.m3#0TOP0">m3tools/src/M3ID.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
