<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/M3RT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/M3RT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE>  Modula-3 runtime interface
<P>
    This interface defines the data structures needed by the compiler
    to interface to the Modula-3 runtime.
<P>
    Note that all runtime structures have their fields naturally aligned.


<P><PRE>INTERFACE <interface><A HREF="M3RT.m3">M3RT</A></interface>;
</PRE>------------------------------------------- procedure and closure types ---

<P> closure offsets 
<PRE>VAR
  CL_marker : CARDINAL;   (* : INTEGER *)
  CL_proc   : CARDINAL;   (* : PROCEDURE() *)
  CL_frame  : CARDINAL;   (* : ADDRESS *)
  CL_SIZE   : CARDINAL;

CONST
  CL_marker_value = -1;
</PRE>------------------------------------------------------ exception support --
 Exception scope descriptors for systems with stack walkers. 

<P><PRE>TYPE
  HandlerClass = { Except, ExceptElse,
                   Finally, FinallyProc,
                   Raises, RaisesNone,
                   Lock };

VAR
  EX_class       : CARDINAL; (* : CHAR(HandlerClass)*)
  EX_outermost   : CARDINAL; (* : CHAR(BOOLEAN)     *)
  EX_end_of_list : CARDINAL; (* : CHAR(BOOLEAN)     *)
  EX_pad         : CARDINAL; (* : CHAR(BOOLEAN)     *)
  EX_start       : CARDINAL; (* : ADDRESS           *)
  EX_stop        : CARDINAL; (* : ADDRESS           *)
  EX_excepts     : CARDINAL; (* : ADDRESS           *)
  EX_offset      : CARDINAL; (* : INTEGER           *)
  EX_SIZE        : CARDINAL;

VAR
  EI_exception   : CARDINAL; (* : ADDRESS *)
  EI_arg         : CARDINAL; (* : ADDRESS *)
  EI_SIZE        : CARDINAL;
</PRE>------------------------------------------------------- exception frames --
 Explicit exception frames for systems without stack walkers.  

<P><PRE>VAR (* all frames  (== all of a RaisesNone frame) *)
  EF_next        : CARDINAL;  (* : ADDRESS *)
  EF_class       : CARDINAL;  (* : INTEGER(HandlerClass) *)
  EF_SIZE        : CARDINAL;

VAR (* Except, ExceptElse, and Finally  frames *)
  EF1_handles    : CARDINAL;  (* : ADDRESS *)
  EF1_exception  : CARDINAL;  (* : ADDRESS *)
  EF1_arg        : CARDINAL;  (* : ADDRESS *)
  EF1_jmpbuf     : CARDINAL;  (* : jmp_buf *)
  EF1_SIZE       : CARDINAL;
  EF1_ALIGN      : CARDINAL;  (* because of the jmp_buf alignment... *)

VAR (* FinallyProc frames *)
  EF2_handler    : CARDINAL;  (* : ADDRESS (PROC) *)
  EF2_frame      : CARDINAL;  (* : ADDRESS *)
  EF2_SIZE       : CARDINAL;

VAR (* Raises frames *)
  EF3_raises     : CARDINAL;   (* : ADDRESS *)
  EF3_SIZE       : CARDINAL;

VAR (* Lock frames *)
  EF4_mutex      : CARDINAL;   (* : MUTEX *)
  EF4_SIZE       : CARDINAL;
</PRE>---------------------------------------------------- runtime type system --
 Reference types are represented by global variables call <CODE>typecells</CODE>. 

<P><PRE>VAR (* typecell offsets *)
  TC_typecode       : CARDINAL; (* : INTEGER *)
  TC_lastSubTypeTC  : CARDINAL; (* : INTEGER *)
  TC_selfID         : CARDINAL; (* : INTEGER *)
  TC_fp             : CARDINAL; (* : 64-bit fingerprint *)
  TC_traced         : CARDINAL; (* : BOOLEAN *)
  TC_dataOffset     : CARDINAL; (* : INTEGER *)
  TC_dataSize       : CARDINAL; (* : INTEGER *)
  TC_dataAlignment  : CARDINAL; (* : INTEGER *)
  TC_methodOffset   : CARDINAL; (* : INTEGER *)
  TC_methodSize     : CARDINAL; (* : INTEGER *)
  TC_nDimensions    : CARDINAL; (* : INTEGER *)
  TC_elementSize    : CARDINAL; (* : INTEGER *)
  TC_defaultMethods : CARDINAL; (* : ADDRESS *)
  TC_type_map       : CARDINAL; (* : ADDRESS *)
  TC_gc_map         : CARDINAL; (* : ADDRESS *)
  TC_type_desc      : CARDINAL; (* : ADDRESS *)
  TC_initProc       : CARDINAL; (* : PROC()  *)
  TC_linkProc       : CARDINAL; (* : PROC()  *)
  TC_parentID       : CARDINAL; (* : INTEGER *)
  TC_parent         : CARDINAL; (* : ADDRESS *)
  TC_children       : CARDINAL; (* : ADDRESS *)
  TC_sibling        : CARDINAL; (* : ADDRESS *)
  TC_brand          : CARDINAL; (* : ADDRESS *)
  TC_name           : CARDINAL; (* : ADDRESS *)
  TC_next           : CARDINAL; (* : ADDRESS *)
  TC_SIZE           : CARDINAL;
  TC_ALIGN          : CARDINAL;

VAR (* opaque revelations *)
  RV_lhs_id         : CARDINAL; (* : INTEGER *)
  RV_rhs_id         : CARDINAL; (* : INTEGER *)
  RV_SIZE           : CARDINAL;
</PRE>------------------------------------------------------------ open arrays --

<P><PRE>VAR (* dope vector offsets *)
  OA_elt_ptr : CARDINAL; (*: ADDRESS *)
  OA_sizes   : CARDINAL; (*: ARRAY [0..depth] OF INT*)
  OA_size_0  : CARDINAL; (*: INTEGER *)
  OA_size_1  : CARDINAL; (*: INTEGER *)
</PRE>----------------------------------------------------------- module info ---

<P><PRE>VAR (* offsets and size of an RT0.ModuleInfo record *)
  MI_file           : CARDINAL; (* : ADDRESS *)
  MI_type_cells     : CARDINAL; (* : ADDRESS *)
  MI_type_cell_ptrs : CARDINAL; (* : ADDRESS *)
  MI_full_rev       : CARDINAL; (* : ADDRESS *)
  MI_part_rev       : CARDINAL; (* : ADDRESS *)
  MI_proc_info      : CARDINAL; (* : ADDRESS *)
  MI_try_scopes     : CARDINAL; (* : ADDRESS *)
  MI_var_map        : CARDINAL; (* : ADDRESS *)
  MI_gc_map         : CARDINAL; (* : ADDRESS *)
  MI_link           : CARDINAL; (* : ADDRESS *)
  MI_main           : CARDINAL; (* : ADDRESS *)
  MI_SIZE           : CARDINAL;

VAR (* offsets and size of an RT0.ProcInfo record *)
  PI_proc       : CARDINAL; (*: ADDRESS *)
  PI_name       : CARDINAL; (*: ADDRESS *)
  PI_export     : CARDINAL; (*: ADDRESS *)
  PI_SIZE       : CARDINAL;
</PRE>----------------------------------------------------------- ref headers ---

<P><PRE>CONST (* bit offsets and sizes of the fields within a REF's header word *)
  RH_typecode_offset  = 1;
  RH_typecode_size    = 20;

CONST (* builtin, constant typecodes *)
  NULL_typecode = 0;
  TEXT_typecode = 1;
</PRE>-------------------------------------------------------- initialization ---

<P><PRE>PROCEDURE <A HREF="M3RT.m3#Init">Init</A> ();
</PRE><BLOCKQUOTE><EM> initializes the values above to reflect the values exported by Target </EM></BLOCKQUOTE><PRE>

END M3RT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
