<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/TFloat.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/TFloat.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: TFloat.i3                                             
 Last Modified On Thu Mar 10 14:34:10 PST 1994 By kalsow     
      Modified On Thu May 20 08:20:38 PDT 1993 By muller     

<P><PRE>INTERFACE <interface><A HREF="TFloat.m3">TFloat</A></interface>;
</PRE>  Modula-3 target description
<P>
    This interface provides simulations of the target machine's
    floating-point operations.
<P>
    Unless otherwise specified, the arithmetic operations defined
    below return TRUE if they succeed in producing a new target value,
    otherwise they return FALSE.


<P><PRE>FROM <A HREF="Target.i3">Target</A> IMPORT Int, Float, Precision;

CONST
  ZeroR = Float { Precision.Short,    0, 0.0x0 };
  ZeroL = Float { Precision.Long,     0, 0.0x0 };
  ZeroX = Float { Precision.Extended, 0, 0.0x0 };

PROCEDURE <A HREF="TFloat.m3#New">New</A> (READONLY chars: ARRAY OF CHAR;  pre: Precision;
                                                      VAR f: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> converts 'chars' to a floating point value with the specified
   precision.  Note: regardless of the precision, the exponent must
   be started by the character 'e'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Prec">Prec</A> (READONLY f: Float): Precision;
</PRE><BLOCKQUOTE><EM> returns the precision of 'f' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Add">Add</A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a + b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Subtract">Subtract</A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a - b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Multiply">Multiply</A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a * b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Divide">Divide</A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a / b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Mod">Mod</A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a MOD b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#EQ">EQ</A> (READONLY a, b: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a = b' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#LT">LT</A> (READONLY a, b: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a &lt; b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#LE">LE</A> (READONLY a, b: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a &lt;= b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#FloatF">FloatF</A> (READONLY a: Float;  p: Precision;  VAR f: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'FLOAT (a, p)' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#FloatI">FloatI</A> (READONLY i: Int;  p: Precision;  VAR f: Float): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'FLOAT (i, p)' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Trunc">Trunc</A> (READONLY a: Float;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'TRUNC(a)' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Round">Round</A> (READONLY a: Float;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'ROUND(a)' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Floor">Floor</A> (READONLY a: Float;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'FLOOR(a)' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#Ceiling">Ceiling</A> (READONLY a: Float;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'CEILING(a)' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#ToChars">ToChars</A> (READONLY f: Float;  VAR buf: ARRAY OF CHAR): INTEGER;
</PRE><BLOCKQUOTE><EM> converts 'f' to a printable string in 'buf'.  Returns the
   number of characters in the string.  Returns -1 if 'buf' is too short. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TFloat.m3#ToInts">ToInts</A> (READONLY f: Float;  VAR buf: ARRAY OF INTEGER): INTEGER;
</PRE><BLOCKQUOTE><EM> converts 'f' to an array of host integers in 'buf'.  Returns the
   number of integers in 'buf'.  Returns -1 if 'buf' is too short. </EM></BLOCKQUOTE><PRE>

END TFloat.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
