<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/TFloat.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/TFloat.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: TFloat.m3                                             
 Last Modified On Thu Jul 28 10:18:03 PDT 1994 By kalsow     
      Modified On Thu May 20 08:46:32 PDT 1993 By muller     

<P><PRE>UNSAFE MODULE <module><implements><A HREF="TFloat.i3">TFloat</A></implements></module>;

IMPORT <A HREF="../../convert/src/Convert.i3">Convert</A>, <A HREF="TInt.i3">TInt</A>, <A HREF="TargetMap.i3">TargetMap</A>;
FROM <A HREF="Target.i3">Target</A> IMPORT Int, Float, Precision;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (READONLY chars: ARRAY OF CHAR;  pre: Precision;
                                                       VAR f: Float): BOOLEAN =
  VAR used: INTEGER;
  BEGIN
    f.pre      := pre;
    f.exponent := 0;
    TRY f.fraction := Convert.ToExtended (chars, used);
    EXCEPT Convert.Failed =&gt; RETURN FALSE;
    END;
    RETURN (used = NUMBER (chars)) AND Normalize (f);
  END New;

PROCEDURE <A NAME="Prec"><procedure>Prec</procedure></A> (READONLY f: Float): Precision =
  BEGIN
    RETURN f.pre;
  END Prec;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN =
  BEGIN
    IF (a.pre # b.pre) THEN RETURN FALSE END;
    f.pre      := a.pre;
    f.exponent := 0;
    f.fraction := a.fraction + b.fraction;
    RETURN Normalize (f);
  END Add;

PROCEDURE <A NAME="Subtract"><procedure>Subtract</procedure></A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN =
  BEGIN
    IF (a.pre # b.pre) THEN RETURN FALSE END;
    f.pre      := a.pre;
    f.exponent := 0;
    f.fraction := a.fraction - b.fraction;
    RETURN Normalize (f);
  END Subtract;

PROCEDURE <A NAME="Multiply"><procedure>Multiply</procedure></A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN =
  BEGIN
    IF (a.pre # b.pre) THEN RETURN FALSE END;
    f.pre      := a.pre;
    f.exponent := 0;
    f.fraction := a.fraction * b.fraction;
    RETURN Normalize (f);
  END Multiply;

PROCEDURE <A NAME="Divide"><procedure>Divide</procedure></A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN =
  BEGIN
    IF (a.pre # b.pre) THEN RETURN FALSE END;
    IF (b.fraction = 0.0x+0) THEN RETURN FALSE END;
    f.pre      := a.pre;
    f.exponent := 0;
    f.fraction := a.fraction / b.fraction;
    RETURN Normalize (f);
  END Divide;

PROCEDURE <A NAME="Mod"><procedure>Mod</procedure></A> (READONLY a, b: Float;  VAR f: Float): BOOLEAN =
  VAR x, y: EXTENDED;
  BEGIN
    IF (a.pre # b.pre) THEN RETURN FALSE END;
    x := a.fraction;
    y := b.fraction;
    IF (y = 0.0x+0) THEN RETURN FALSE END;
    f.pre      := a.pre;
    f.exponent := 0;
    f.fraction := x - y * FLOAT (FLOOR (x / y), EXTENDED);
    RETURN Normalize (f);
  END Mod;

PROCEDURE <A NAME="EQ"><procedure>EQ</procedure></A> (READONLY a, b: Float): BOOLEAN =
  BEGIN
    IF (a.pre # b.pre) THEN RETURN FALSE END;
    IF (a.exponent # b.exponent) THEN RETURN FALSE END;
    IF (a.fraction # b.fraction) THEN RETURN FALSE END;
    RETURN TRUE;
  END EQ;

PROCEDURE <A NAME="LT"><procedure>LT</procedure></A> (READONLY a, b: Float): BOOLEAN =
  BEGIN
    IF (a.pre # b.pre) THEN RETURN FALSE END;
    RETURN (a.fraction &lt; b.fraction);
  END LT;

PROCEDURE <A NAME="LE"><procedure>LE</procedure></A> (READONLY a, b: Float): BOOLEAN =
  BEGIN
    IF (a.pre # b.pre) THEN RETURN FALSE END;
    RETURN (a.fraction &lt;= b.fraction);
  END LE;

PROCEDURE <A NAME="FloatF"><procedure>FloatF</procedure></A> (READONLY a: Float;  p: Precision;  VAR f: Float): BOOLEAN =
  BEGIN
    f.pre      := p;
    f.exponent := a.exponent;
    f.fraction := a.fraction;
    RETURN Normalize (f);
  END FloatF;

PROCEDURE <A NAME="FloatI"><procedure>FloatI</procedure></A> (READONLY iI: Int;  p: Precision;  VAR f: Float): BOOLEAN =
  VAR i: INTEGER;
  BEGIN
    IF NOT TInt.ToInt (iI, i) THEN RETURN FALSE; END;
    f.pre      := p;
    f.exponent := 0;
    f.fraction := FLOAT (i, EXTENDED);
    RETURN Normalize (f);
  END FloatI;

PROCEDURE <A NAME="Trunc"><procedure>Trunc</procedure></A> (READONLY a: Float;  VAR r: Int): BOOLEAN =
  BEGIN
    IF (a.pre = Precision.Short) THEN
      RETURN TInt.FromInt (TRUNC (ToReal (a)), r);
    ELSIF (a.pre = Precision.Long) THEN
      RETURN TInt.FromInt (TRUNC (ToLongreal (a)), r);
    ELSE
      RETURN TInt.FromInt (TRUNC (ToExtended (a)), r);
    END;
  END Trunc;

PROCEDURE <A NAME="Round"><procedure>Round</procedure></A> (READONLY a: Float;  VAR r: Int): BOOLEAN =
  BEGIN
    IF (a.pre = Precision.Short) THEN
      RETURN TInt.FromInt (ROUND (ToReal (a)), r);
    ELSIF (a.pre = Precision.Long) THEN
      RETURN TInt.FromInt (ROUND (ToLongreal (a)), r);
    ELSE
      RETURN TInt.FromInt (ROUND (ToExtended (a)), r);
    END;
  END Round;

PROCEDURE <A NAME="Floor"><procedure>Floor</procedure></A> (READONLY a: Float;  VAR r: Int): BOOLEAN =
  BEGIN
    IF (a.pre = Precision.Short) THEN
      RETURN TInt.FromInt (FLOOR (ToReal (a)), r);
    ELSIF (a.pre = Precision.Long) THEN
      RETURN TInt.FromInt (FLOOR (ToLongreal (a)), r);
    ELSE
      RETURN TInt.FromInt (FLOOR (ToExtended (a)), r);
    END;
  END Floor;

PROCEDURE <A NAME="Ceiling"><procedure>Ceiling</procedure></A> (READONLY a: Float;  VAR r: Int): BOOLEAN =
  BEGIN
    IF (a.pre = Precision.Short) THEN
      RETURN TInt.FromInt (CEILING (ToReal (a)), r);
    ELSIF (a.pre = Precision.Long) THEN
      RETURN TInt.FromInt (CEILING (ToLongreal (a)), r);
    ELSE
      RETURN TInt.FromInt (CEILING (ToExtended (a)), r);
    END;
  END Ceiling;

PROCEDURE <A NAME="ToChars"><procedure>ToChars</procedure></A> (READONLY f: Float;  VAR buf: ARRAY OF CHAR): INTEGER =
  &lt;*FATAL Convert.Failed *&gt;
  VAR zz: ARRAY [0..31] OF CHAR;  len: INTEGER;
  BEGIN
    &lt;*ASSERT f.exponent = 0*&gt;
    len := Convert.FromExtended (zz, f.fraction, 13, Convert.Style.Sci);
    IF (len &gt; NUMBER (buf)) THEN RETURN -1 END;
    SUBARRAY (buf, 0, len) := SUBARRAY (zz, 0, len);
    RETURN len;
  END ToChars;
</PRE>******* OLD ********************
PROCEDURE ToInts (READONLY f: Float;  VAR buf: ARRAY OF INTEGER): INTEGER =
  CONST
    Buf_size = BITSIZE (f.fraction) DIV BITSIZE (INTEGER);
  VAR
    zz := LOOPHOLE (f.fraction, ARRAY [0..Buf_size-1] OF INTEGER);
    len := TargetMap.Float_types[f.pre].size DIV BITSIZE (INTEGER);
  BEGIN
    IF (NUMBER (buf) &lt; len) THEN RETURN -1 END;
    FOR i := 0 TO len-1 DO buf[i] := zz[i] END;
    RETURN len;
  END ToInts;
***********************************

<P><PRE>PROCEDURE <A NAME="ToInts"><procedure>ToInts</procedure></A> (READONLY f: Float;  VAR buf: ARRAY OF INTEGER): INTEGER =
  TYPE
    Ptr = UNTRACED REF ARRAY [0..BITSIZE (Float)] OF INTEGER;
  VAR
    x1  : REAL;
    x2  : LONGREAL;
    x3  : EXTENDED;
    adr : ADDRESS;
    ptr : Ptr;
    len := TargetMap.Float_types[f.pre].size DIV BITSIZE (INTEGER);
  BEGIN
    IF (NUMBER (buf) &lt; len) THEN RETURN -1 END;
    IF    (f.pre = Precision.Short) THEN x1 := ToReal (f);     adr := ADR (x1);
    ELSIF (f.pre = Precision.Long)  THEN x2 := ToLongreal (f); adr := ADR (x2);
    ELSE                                 x3 := ToExtended (f); adr := ADR (x3);
    END;
    ptr := adr;
    SUBARRAY (buf, 0, len) := SUBARRAY (ptr^, 0, len);
    RETURN len;
  END ToInts;
</PRE>-------------------------------------------------------------- internal ---

<P><PRE>PROCEDURE <A NAME="Normalize"><procedure>Normalize</procedure></A> (VAR f: Float): BOOLEAN =
  BEGIN
    RETURN (f.exponent = 0);
  END Normalize;

PROCEDURE <A NAME="ToReal"><procedure>ToReal</procedure></A> (READONLY f: Float): REAL =
  BEGIN
    RETURN FLOAT (f.fraction, REAL);
  END ToReal;

PROCEDURE <A NAME="ToLongreal"><procedure>ToLongreal</procedure></A> (READONLY f: Float): LONGREAL =
  BEGIN
    RETURN FLOAT (f.fraction, LONGREAL);
  END ToLongreal;

PROCEDURE <A NAME="ToExtended"><procedure>ToExtended</procedure></A> (READONLY f: Float): EXTENDED =
  BEGIN
    RETURN f.fraction;
  END ToExtended;

BEGIN
END TFloat.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
