<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/TInt.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/TInt.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: TInt.i3                                               
 Last Modified On Thu Mar 10 13:42:53 PST 1994 By kalsow     
      Modified On Thu May 20 08:20:38 PDT 1993 By muller     

<P><PRE>INTERFACE <interface><A HREF="TInt.m3">TInt</A></interface>;
</PRE>  Modula-3 target description
<P>
    This interface provides simulations of the target machine's
    signed integer operations.
<P>
    Unless otherwise specified, the arithmetic operations defined
    below return TRUE if they succeed in producing a new target value,
    otherwise they return FALSE.


<P><PRE>FROM <A HREF="Target.i3">Target</A> IMPORT Int, IChunks;

CONST
  Zero = Int { IChunks {16_0000, 16_0000, 16_0000, 16_0000}};
  One  = Int { IChunks {16_0001, 16_0000, 16_0000, 16_0000}};
  MOne = Int { IChunks {16_ffff, 16_ffff, 16_ffff, 16_ffff}};

PROCEDURE <A HREF="TInt.m3#FromInt">FromInt</A> (x: INTEGER;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> converts a host integer 'x' to a target integer 'i' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#ToInt">ToInt</A> (READONLY i: Int;  VAR x: INTEGER): BOOLEAN;
</PRE><BLOCKQUOTE><EM> converts a target integer 'i' to a host integer 'x' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#New">New</A> (READONLY chars: ARRAY OF CHAR;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> converts the string of decimal characters in 'chars' to an integer
   value in 'i' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#Add">Add</A> (READONLY a, b: Int;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a + b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#Subtract">Subtract</A> (READONLY a, b: Int;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a - b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#Multiply">Multiply</A> (READONLY a, b: Int;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a * b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#Div">Div</A> (READONLY a, b: Int;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a DIV b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#Mod">Mod</A> (READONLY a, b: Int;  VAR i: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a MOD b' unless there's an overflow </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#EQ">EQ</A> (READONLY a, b: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a = b' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#LT">LT</A> (READONLY a, b: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a &lt; b' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#LE">LE</A> (READONLY a, b: Int): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns 'a &lt;= b' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TInt.m3#ToChars">ToChars</A> (READONLY i: Int;  VAR buf: ARRAY OF CHAR): INTEGER;
</PRE><BLOCKQUOTE><EM> converts 'i' to a printable string in 'buf'.  Returns the
   number of characters in the string.  Returns -1 if 'buf' is too short. </EM></BLOCKQUOTE><PRE>

TYPE ByteArray = ARRAY [0..7] OF [0..255];
PROCEDURE <A HREF="TInt.m3#ToBytes">ToBytes</A> (READONLY i: Int;  VAR buf: ByteArray): INTEGER;
</PRE><BLOCKQUOTE><EM> converts 'i' to the shortest sequence of bytes in little-endian order
   which when sign-extended equal 'i'.  Returns the number of
   significant bytes in the result. </EM></BLOCKQUOTE><PRE>

END TInt.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
