<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/Target.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/Target.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> File: Target.i3                                             
 Last Modified On Tue Dec 20 14:03:42 PST 1994 By kalsow     
      Modified On Thu May 20 08:20:38 PDT 1993 By muller     

<P><PRE>INTERFACE <interface><A HREF="Target.m3">Target</A></interface>;
</PRE>  Modula-3 target description
<P>
    This interface defines the host representation of target
    values and the target architecture.  Its primary client
    is the Modula-3 compiler.
<P>
    Unless otherwise specified, all sizes and alignments are
    specified in bits.
<P>
    'pack' is defined to be 'size' rounded up to an alignment
    boundary (i.e. (size + align - 1) DIV align * align).


<P>-------------------------------------------------------- initialization ---

<P><PRE>PROCEDURE <A HREF="Target.m3#Init">Init</A> (system: TEXT): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Initialize the variables of this interface to reflect the architecture
   of <CODE>system</CODE>.  Returns TRUE iff the <CODE>system</CODE> was known and the initialization
   was successful.  </EM></BLOCKQUOTE><PRE>

VAR (*CONST*)
  System_name: TEXT := NIL; (* initialized by &quot;Init&quot; *)
</PRE>------------------------------------------ machine/code generator types ---

<P><PRE>TYPE (* machine supported types *)
  CGType = {
    Addr,    (* addresses *)
    Word,    (* the machine's most natural, unsigned integer type *)
    Int,     (* the machine's most natural, signed integer type   *)
    Reel,    (* single precision reals *)
    LReel,   (* double precision reals *)
    XReel,   (* extended precision reals *)
    Int_A,   (* the smallest signed integer type (usually 8 bits) *)
    Int_B,   (* a larger signed integer  (usually 16 bits) *)
    Int_C,   (* a larger signed integer  (usually 32 bits) *)
    Int_D,   (* the largest signed integer  (usually 32 or 64 bits) *)
    Word_A,  (* the smallest unsigned integer type (usually 8 bits) *)
    Word_B,  (* a larger unsigned integer  (usually 16 bits) *)
    Word_C,  (* a larger unsigned integer  (usually 32 bits) *)
    Word_D,  (* the largest unsigned integer  (usually 32 or 64 bits) *)
    Struct,  (* a block of memory *)
    Void     (* not-a-type *)
  };
</PRE>-------------------------------------------------------- integer values ---

<P> The bits of a target INTEGER (in 2's complement) are stored in
   an array of small host values, with the low order bits in the first
   element of the array. 

<P><PRE>CONST
  ChunkSize = 16;  (* # of bits per array element *)

TYPE
  Int = (* OPAQUE *) RECORD x: IChunks END;
  IChunks = ARRAY [0..3] OF IChunk;
  IChunk = BITS ChunkSize FOR [0..16_ffff];

VAR
  last_chunk: [0..LAST(IChunks)];
  (* only chunks in the range [0..last_chunk] contain valid bits. *)

TYPE
  Int_type = RECORD
    cg_type : CGType;    (* representation *)
    size    : CARDINAL;  (* bit size *)
    align   : CARDINAL;  (* minimum bit alignment *)
    pack    : CARDINAL;  (* minimum width bit packing *)
    bytes   : CARDINAL;  (* byte size *)
    min     : Int;       (* minimum value of this type *)
    max     : Int;       (* maximum value of this type *)
  END;
</PRE>------------------------------------------------- floating point values ---

<P><PRE>TYPE
  Precision = { Short, Long, Extended };

  Float = (*OPAQUE*) RECORD
    pre      : Precision;
    exponent : INTEGER;
    fraction : EXTENDED;
  END;

  Float_type = RECORD
    cg_type : CGType;     (* representation *)
    pre     : Precision;  (* precision *)
    size    : CARDINAL;   (* bit size *)
    align   : CARDINAL;   (* minimum bit alignment *)
    bytes   : CARDINAL;   (* byte size *)
    min     : Float;      (* minimum value of this type *)
    max     : Float;      (* maximum value of this type *)
  END;
</PRE>----------------------------------------------- machine supported types ---

<P><PRE>VAR (*CONST*)
  Address   : Int_type;
  Integer   : Int_type;
  Real      : Float_type;
  Longreal  : Float_type;
  Extended  : Float_type;
  Int_A     : Int_type;
  Int_B     : Int_type;
  Int_C     : Int_type;
  Int_D     : Int_type;
  Word_A    : Int_type;
  Word_B    : Int_type;
  Word_C    : Int_type;
  Word_D    : Int_type;
  Void      : Int_type;
  Char      : Int_type;

VAR (*CONST*) (* sorted list of supported machine alignments *)
  Alignments: ARRAY [0..3] OF CARDINAL;
</PRE>------------------------------------------------------- procedure calls ---

<P><PRE>TYPE
  CallingConvention = REF RECORD
    name               : TEXT;
    m3cg_id            : INTEGER;
    args_left_to_right : BOOLEAN;
    results_on_left    : BOOLEAN;
    standard_structs   : BOOLEAN;
  END;

VAR (*CONST*)
  DefaultCall: CallingConvention := NIL;

PROCEDURE <A HREF="Target.m3#FindConvention">FindConvention</A> (nm: TEXT): CallingConvention;
</PRE><BLOCKQUOTE><EM> Return the convention with name <CODE>nm</CODE>.  Otherwise, return NIL. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Target.m3#ConventionFromID">ConventionFromID</A> (id: INTEGER): CallingConvention;
</PRE><BLOCKQUOTE><EM> Return the convention with <CODE>m3cg_id</CODE> <CODE>id</CODE>.  Otherwise, return NIL. </EM></BLOCKQUOTE><PRE>
</PRE><P>
  name =&gt; the name recognized in an &lt;*EXTERNAL*&gt; pragma, or as a prefix
          to a PROCEDURE declaration. 
<P>
  m3cg_id =&gt; tag used to indicate convention to the back end.
<P>
  args_left_to_right =&gt; Procedure arguments should be pushed
                        left-&gt;right or right-&gt;left.
<P>
  results_on_left =&gt; when the front-end is passing structures the return
                     result is the left-most parameter.  Otherwise, it's
                     the right-most parameter.
<P>
  standard_structs =&gt;
     TRUE =&gt; the front-end will take care of all structure passing:
       by VALUE parameters: callers pass the address of the structure
          and the callee copies it into a temporary.
       return results: the caller passes as the left-most or right-most
          parameter the address of the temporary that will hold the result
          and the callee copies the value there.
     FALSE =&gt;
       by VALUE parameters: the back-end is responsible.
          (ie. M3CG.T.Pop_struct will be called)
       return results: the caller passes as the left-most or right-most
          parameter the address of the temporary that will hold the result
          and the callee copies the value there.  The start_call, call,
          and exit_proc methods are called with t=Struct.


<P>--------------------------------------------------- misc. configuration ---

<P><PRE>CONST
  Byte = 8;  (* minimum addressable unit (in bits) *)

VAR (*CONST*)
  Set_grain : CARDINAL; (* allocation unit for large sets *)
  Set_align : CARDINAL; (* alignment for large sets *)

  Little_endian : BOOLEAN;
  (* TRUE =&gt; byte[0] of an integer contains its least-significant bits *)

  PCC_bitfield_type_matters: BOOLEAN;
  (* TRUE =&gt; the C compiler uses the type rather than the size of
     a bit-field to compute the alignment of the struct *)

  Structure_size_boundary: CARDINAL;
  (* every structure size must be a multiple of this *)

  Bitfield_can_overlap: BOOLEAN;
  (* a C bit field cannot overlap two adjacent storage units *)

  (* NIL checking *)
  First_readable_addr: CARDINAL;
  (* Read or write references to addresses in the range [0..First_readable-1]
     will cause an address faults.  Hence, no explicit NIL checks are needed
     for dereferencing with offsets in this range. *)

  (* Thread stacks *)
  Jumpbuf_size     : CARDINAL; (* size of a &quot;jmp_buf&quot; *)
  Jumpbuf_align    : CARDINAL; (* alignment of a &quot;jmp_buf&quot; *)
  Fixed_frame_size : CARDINAL; (* size of an &quot;empty&quot; stack frame *)
  Guard_page_size  : CARDINAL; (* size of the &quot;unmapped&quot; region at the
                                            end of a thread stack *)
  (* These parameters are used to estimate the size each procedure's
     frame.  If the estimated size of a procedure's frame is less
     than the guard page's size, no explict check for stack overflow
     is needed.  *)

  (* floating point values *)
  All_floats_legal : BOOLEAN;
  (* If all bit patterns are &quot;legal&quot; floating point values (i.e. they can
     be assigned without causing traps or faults). *)

  Has_stack_walker: BOOLEAN;
  (* TRUE =&gt; generate PC-tables for exception scopes.  Otherwise, generate
       an explicit stack of exception handler frames. *)

  Setjmp: TEXT;
  (* The C name of the routine used to capture the machine state in
       an exception handler frame. *)

  Checks_integer_ops: BOOLEAN;
  (* TRUE =&gt; integer overflow checking is possible *)

  Global_handler_stack: BOOLEAN;
  (* TRUE =&gt; exception frames are linked through RTThread.handlerStack.
     Otherwise, call RTHooks.{Push,Pop}EFrame to manipulate the stack. *)

  Aligned_procedures: BOOLEAN;
  (* TRUE =&gt; all procedure values are aligned to at least Integer.align
     and can be safely dereferenced.  Otherwise, the code generated to
     test for nested procedures passed as parameters must be more
     elaborate (e.g. HPPA). *)

  EOL: TEXT;
  (* The sequence of characters that conventionally terminate a
     text line on the target system:  '\n' on Unix, '\r\n' on DOS *)

END Target.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
