<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3middle/src/WIN32/CoffTime.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3middle/src/WIN32/CoffTime.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="#x1">CoffTime</A></implements></module>;

IMPORT <A HREF="../../../time/src/Common/Time.i3">Time</A>, <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="../../../os/src/Common/FS.i3">FS</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>;

PROCEDURE <A NAME="Now"><procedure>Now</procedure></A> (): INTEGER =
  VAR now := Time.Now ();
  BEGIN
    RETURN ROUND (now - EpochAdjust);
  END Now;

PROCEDURE <A NAME="OfFile"><procedure>OfFile</procedure></A> (file: TEXT): INTEGER =
  VAR s: File.Status;
  BEGIN
    TRY
      s := FS.Status (file);
    EXCEPT OSError.E =&gt;
      RETURN 0;
    END;
    RETURN ROUND (s.modificationTime - EpochAdjust);
  END OfFile;

BEGIN
END CoffTime.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface CoffTime is in:
</A><UL>
<LI><A HREF="../POSIX/CoffTime.i3#0TOP0">m3middle/src/POSIX/CoffTime.i3</A>
<LI><A HREF="CoffTime.i3#0TOP0">m3middle/src/WIN32/CoffTime.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
