<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3objfile/src/M3ObjFile.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3objfile/src/M3ObjFile.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> An <CODE>M3ObjFile.T</CODE> represents a conventional <CODE>object file</CODE> with
   text and data segments, symbol tables, and relocation information. 

<P><PRE>INTERFACE <interface><A HREF="M3ObjFile.m3">M3ObjFile</A></interface>;

IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../../m3middle/src/Target.i3">Target</A>;
FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Name, BitOffset, BitSize, ByteOffset, ByteSize, TypeUID;

TYPE
  T = OBJECT METHODS
    cursor (s: Seg): INTEGER;
    append (s: Seg;  value, length: INTEGER);
    patch  (s: Seg;  offset, value, length: INTEGER);

    relocate (src_sym, src_offset, target_sym: INTEGER);

    import_symbol     (id: M3ID.T): INTEGER;
    define_symbol     (id: M3ID.T;  s: Seg;  offset: INTEGER): INTEGER;
    define_bss_symbol (id: M3ID.T;  size, align: INTEGER): INTEGER;

    move_symbol   (sym: INTEGER;  new_offset: INTEGER);
    export_symbol (sym: INTEGER);

    set_source_file (filename: TEXT);
    set_source_line (line: INTEGER);

    declare_typename (t: TypeUID;  n: Name);
    declare_array (t, index, elt: TypeUID;  s: BitSize);
    declare_open_array (t, elt: TypeUID;  s: BitSize);
    declare_enum (t: TypeUID; n_elts: INTEGER;  s: BitSize);
    declare_enum_elt (n: Name);
    declare_packed  (t: TypeUID;  s: BitSize;  base: TypeUID);
    declare_record (t: TypeUID;  s: BitSize;  n_fields: INTEGER);
    declare_field (n: Name;  o: BitOffset;  s: BitSize;  t: TypeUID);
    declare_set (t, domain: TypeUID;  s: BitSize);
    declare_subrange (t, domain: TypeUID; READONLY min,max: Target.Int;
                      s: BitSize);
    declare_pointer (t, target: TypeUID;  brand: TEXT;  traced: BOOLEAN);
    declare_indirect (t, target: TypeUID);
    declare_proctype (t: TypeUID;  n_formals: INTEGER;
                      result: TypeUID;  n_raises: INTEGER);
    declare_formal (n: Name;  t: TypeUID);
    declare_raises (n: Name);
    declare_object (t, super: TypeUID;  brand: TEXT;
                    traced: BOOLEAN;  n_fields, n_methods: INTEGER;
                    field_size: BitSize);
    declare_method (n: Name;  signature: TypeUID);
    declare_opaque (t, super: TypeUID);
    reveal_opaque (lhs, rhs: TypeUID);

    declare_exception (sym: INTEGER;  arg_type: TypeUID;  raise_proc: BOOLEAN);
    declare_global    (sym: INTEGER;  s: ByteSize;  m3t: TypeUID);
    declare_constant  (sym: INTEGER;  s: ByteSize;  m3t: TypeUID);

    declare_local (n: Name;  s: ByteSize;  frame: ByteOffset;  m3t: TypeUID);
    declare_param (n: Name;  s: ByteSize;  frame: ByteOffset;  m3t: TypeUID);

    declare_procedure (sym: INTEGER;  n_params: INTEGER;
                       nested, exported: BOOLEAN);

    begin_procedure (sym: INTEGER);
    end_procedure (sym: INTEGER);

    begin_block ();
    end_block ();

    note_procedure_origin (sym: INTEGER);
  END;

TYPE
  Seg = {Text, Data};

END M3ObjFile.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
