<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3objfile/src/MasmObjFile.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3objfile/src/MasmObjFile.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="MasmObjFile.i3">MasmObjFile</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../libm3/derived/IntIntTbl.i3">IntIntTbl</A>, <A HREF="../../libm3/derived/IntArraySort.i3">IntArraySort</A>;
IMPORT <A HREF="M3ObjFile.i3">M3ObjFile</A>, <A HREF="#x1">M3ID</A>, <A HREF="../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="../../m3middle/src/Target.i3">Target</A>;
FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Name, BitOffset, BitSize, ByteOffset, ByteSize, TypeUID;

TYPE
  Seg = M3ObjFile.Seg;

TYPE
  Byte = BITS 8 FOR [0..255];
  Bytes = REF ARRAY OF Byte;

TYPE
  SKind = { Text, Data, Bss, Extern };

CONST
  SegToKind = ARRAY Seg OF SKind { SKind.Text, SKind.Data };

TYPE
  SymbolList = REF ARRAY OF Symbol;
  Symbol = RECORD
    id     : M3ID.T;
    kind   : SKind;
    offset : INTEGER; (* align for SKind = Bss *)
    size   : INTEGER;
    export : BOOLEAN;
    used   : BOOLEAN;
  END;

TYPE
  Alignment = [0..3];
CONST
  AlignBytes = ARRAY Alignment OF [0..8] { 1, 2, 4, 8 };
  AlignName  = ARRAY Alignment OF TEXT { &quot;BYTE&quot;, &quot;WORD&quot;, &quot;DWORD&quot;, &quot;QWORD&quot; };
  AlignDefn  = ARRAY Alignment OF TEXT { &quot;DB&quot;, &quot;DW&quot;, &quot;DD&quot;, &quot;DQ&quot; };

TYPE
  RelocList = REF ARRAY OF Reloc;
  Reloc = RECORD
    src_sym, src_offset : INTEGER;
    target_sym          : INTEGER;
  END;

TYPE
  LineNumList = REF ARRAY OF LineNum;
  LineNum = RECORD pc, line: INTEGER; END;

REVEAL
  <A NAME="T">T</A> = M3ObjFile.T BRANDED &quot;MasmObjFile.T&quot; OBJECT
    size     := ARRAY Seg OF INTEGER { 0, .. };
    bytes    := ARRAY Seg OF Bytes { NIL, .. };
    sym_map  : IntIntTbl.T := NIL;
    symbols  : SymbolList := NIL;
    n_syms   := 0;
    relocs   : RelocList := NIL;
    n_relocs := 0;
    n_bss    := 0;
    n_lines  := 0;
    last_pc  := 0;
    lines    : LineNumList := NIL;
    file     : TEXT := NIL;
  OVERRIDES
    cursor              := Cursor;
    append              := Append;
    patch               := Patch;
    relocate            := Relocate;
    import_symbol       := ImportSymbol;
    define_symbol       := DefineSymbol;
    define_bss_symbol   := DefineBssSymbol;
    move_symbol         := MoveSymbol;
    export_symbol       := ExportSymbol;
    set_source_file     := SetSourceFile;
    set_source_line     := SetSourceLine;

    declare_typename    := DeclareTypename;
    declare_array       := DeclareArray;
    declare_open_array  := DeclareOpenArray;
    declare_enum        := DeclareEnum;
    declare_enum_elt    := DeclareEnumElt;
    declare_packed      := DeclarePacked ;
    declare_record      := DeclareRecord;
    declare_field       := DeclareField;
    declare_set         := DeclareSet;
    declare_subrange    := DeclareSubrange;
    declare_pointer     := DeclarePointer;
    declare_indirect    := DeclareIndirect;
    declare_proctype    := DeclareProctype;
    declare_formal      := DeclareFormal;
    declare_raises      := DeclareRaises;
    declare_object      := DeclareObject;
    declare_method      := DeclareMethod;
    declare_opaque      := DeclareOpaque;
    reveal_opaque       := RevealOpaque;

    declare_exception   := DeclareException;
    declare_global      := DeclareGlobal;
    declare_constant    := DeclareConstant;

    declare_local       := DeclareLocal;
    declare_param       := DeclareParam;

    declare_procedure   := DeclareProcedure;
    begin_procedure     := BeginProcedure;
    end_procedure       := EndProcedure;

    begin_block         := BeginBlock;
    end_block           := EndBlock;

    note_procedure_origin := NoteProcedureOrigin;
  END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (): T =
  BEGIN
    RETURN NEW (T);
  END New;

PROCEDURE <A NAME="Cursor"><procedure>Cursor</procedure></A> (t: T;  s: Seg): INTEGER =
  BEGIN
    RETURN t.size [s];
  END Cursor;

PROCEDURE <A NAME="Append"><procedure>Append</procedure></A> (t: T;  s: Seg;  value, length: INTEGER) =
  VAR
    offs := t.size [s];
    seg  := EnsureLength (t.bytes[s], offs + length);
  BEGIN
    WHILE (length &gt; 0) DO
      seg[offs] := Word.And (value, 16_ff);
      value := Word.RightShift (value, 8);
      INC (offs);
      DEC (length);
    END;
    t.size[s] := offs;
  END Append;

PROCEDURE <A NAME="EnsureLength"><procedure>EnsureLength</procedure></A> (VAR b: Bytes;  length: INTEGER): Bytes =
  VAR n, m: INTEGER;
  BEGIN
    IF (b = NIL) THEN  b := NEW (Bytes, 1024);  END;
    n := NUMBER (b^);
    IF (n &lt; length) THEN
      m := n;
      WHILE (m &lt; length) DO INC (m, m); END;
      VAR new := NEW (Bytes, m); BEGIN
        SUBARRAY (new^, 0, n) := b^;
        b := new;
      END;
    END;
    RETURN b;
  END EnsureLength;

PROCEDURE <A NAME="Patch"><procedure>Patch</procedure></A> (t: T;  s: Seg;  offset, value, length: INTEGER) =
  VAR seg := t.bytes[s];
  BEGIN
    &lt;*ASSERT t.size [s] &gt; offset *&gt;
    WHILE (length &gt; 0) DO
      seg[offset] := Word.And (value, 16_ff);
      value := Word.RightShift (value, 8);
      INC (offset);
      DEC (length);
    END;
  END Patch;

PROCEDURE <A NAME="Relocate"><procedure>Relocate</procedure></A> (t: T;  src_sym, src_offs, tar_sym: INTEGER) =
  BEGIN
    IF (t.relocs = NIL) OR (t.n_relocs &gt;= NUMBER (t.relocs^)) THEN
      ExpandRelocs (t);
    END;
    WITH r = t.relocs [t.n_relocs] DO
      r.src_sym       := src_sym;
      r.src_offset    := src_offs;
      r.target_sym    := tar_sym;
    END;
    t.symbols [src_sym].used := TRUE;
    t.symbols [tar_sym].used := TRUE;
    INC (t.n_relocs);
  END Relocate;

PROCEDURE <A NAME="ExpandRelocs"><procedure>ExpandRelocs</procedure></A> (t: T) =
  VAR n: INTEGER;  new: RelocList;
  BEGIN
    IF (t.relocs = NIL) THEN
      t.relocs := NEW (RelocList, 100);
    ELSE
      n := NUMBER (t.relocs^);
      new := NEW (RelocList, n + n);
      SUBARRAY (new^, 0, n) := t.relocs^;
      t.relocs := new;
    END;
  END ExpandRelocs;

PROCEDURE <A NAME="ImportSymbol"><procedure>ImportSymbol</procedure></A> (t: T;  id: M3ID.T): INTEGER =
  VAR z := NewSym (t, id);
  BEGIN
    WITH sym = t.symbols[z] DO
      sym.kind   := SKind.Extern;
      sym.export := FALSE;
      sym.offset := z;
      sym.size   := 0;
    END;
    RETURN z;
  END ImportSymbol;

PROCEDURE <A NAME="DefineSymbol"><procedure>DefineSymbol</procedure></A> (t: T;  id: M3ID.T;  s: Seg;  offset: INTEGER): INTEGER=
  VAR z := NewSym (t, id);
  BEGIN
    WITH sym = t.symbols[z] DO
      sym.kind   := SegToKind [s];
      sym.offset := offset;
      sym.size   := 0;
    END;
    RETURN z;
  END DefineSymbol;

PROCEDURE <A NAME="DefineBssSymbol"><procedure>DefineBssSymbol</procedure></A> (t: T;  id: M3ID.T;  size, align: INTEGER): INTEGER=
  VAR z := NewSym (t, id);  a := FindAlign (align);
  BEGIN
    WITH sym = t.symbols[z] DO
      sym.kind   := SKind.Bss;
      sym.offset := a;
      sym.size   := (size + AlignBytes[a] - 1) DIV AlignBytes[a];
    END;
    INC (t.n_bss);
    RETURN z;
  END DefineBssSymbol;

PROCEDURE <A NAME="MoveSymbol"><procedure>MoveSymbol</procedure></A> (t: T;  sym: INTEGER;  new_offset: INTEGER) =
  BEGIN
    t.symbols[sym].offset := new_offset;
  END MoveSymbol;

PROCEDURE <A NAME="ExportSymbol"><procedure>ExportSymbol</procedure></A> (t: T;  sym: INTEGER) =
  BEGIN
    WITH s = t.symbols[sym] DO
      s.export := TRUE;
      s.used   := TRUE;
    END;
  END ExportSymbol;

PROCEDURE <A NAME="FindAlign"><procedure>FindAlign</procedure></A> (align: INTEGER): Alignment =
  BEGIN
    FOR i := FIRST (AlignBytes) TO LAST (AlignBytes) DO
      IF (AlignBytes[i] = align) THEN RETURN i; END;
    END;
    &lt;*ASSERT FALSE*&gt;
  END FindAlign;

PROCEDURE <A NAME="NewSym"><procedure>NewSym</procedure></A> (t: T;  id: M3ID.T): INTEGER =
  VAR x: INTEGER;
  BEGIN
    IF (t.sym_map = NIL) THEN t.sym_map := NEW (IntIntTbl.Default).init(); END;
    IF t.sym_map.get (id, x) THEN &lt;*ASSERT FALSE*&gt; (* duplicate symbol *) END;
    x := t.n_syms;  INC (t.n_syms);
    EVAL t.sym_map.put (id, x);
    IF (t.symbols = NIL) OR (x &gt;= NUMBER (t.symbols^)) THEN ExpandSyms(t); END;
    WITH sym = t.symbols[x] DO
      sym.id     := id;
      sym.kind   := SKind.Extern;
      sym.offset := 0;
      sym.size   := 0;
      sym.export := FALSE;
      sym.used   := FALSE;
    END;
    RETURN x;
  END NewSym;

PROCEDURE <A NAME="ExpandSyms"><procedure>ExpandSyms</procedure></A> (t: T) =
  VAR n: INTEGER;  new: SymbolList;
  BEGIN
    IF (t.symbols = NIL) THEN
      t.symbols := NEW (SymbolList, 100);
    ELSE
      n := NUMBER (t.symbols^);
      new := NEW (SymbolList, n + n);
      SUBARRAY (new^, 0, n) := t.symbols^;
      t.symbols := new;
    END;
  END ExpandSyms;

PROCEDURE <A NAME="SetSourceFile"><procedure>SetSourceFile</procedure></A> (t: T;  filename: TEXT) =
  BEGIN
    t.file := filename;
  END SetSourceFile;

PROCEDURE <A NAME="SetSourceLine"><procedure>SetSourceLine</procedure></A> (t: T;  source_line: INTEGER) =
  BEGIN
    IF (t.lines = NIL) OR (t.n_lines &gt;= NUMBER (t.lines^)) THEN
      ExpandLines(t);
    END;
    IF (t.n_lines &gt; 0) AND (t.last_pc = t.size [Seg.Text]) THEN
      (* forget the last line number *)
      DEC (t.n_lines);
    END;
    WITH ln = t.lines [t.n_lines] DO
      ln.pc   := t.size [Seg.Text];
      ln.line := source_line;
    END;
    INC (t.n_lines);
  END SetSourceLine;

PROCEDURE <A NAME="ExpandLines"><procedure>ExpandLines</procedure></A> (t: T) =
  VAR n: INTEGER;  new: LineNumList;
  BEGIN
    IF (t.lines = NIL) THEN
      t.lines := NEW (LineNumList, 100);
    ELSE
      n := NUMBER (t.lines^);
      new := NEW (LineNumList, n + n);
      SUBARRAY (new^, 0, n) := t.lines^;
      t.lines := new;
    END;
  END ExpandLines;
</PRE>----------------------------------------------------- debugging support ---

<P><PRE>PROCEDURE <A NAME="DeclareTypename"><procedure>DeclareTypename</procedure></A> (t: T;  type: TypeUID;  n: Name) =
  BEGIN
    EVAL t; EVAL type; EVAL n;
  END DeclareTypename;

PROCEDURE <A NAME="DeclareArray"><procedure>DeclareArray</procedure></A> (t: T;  type, index, elt: TypeUID;  s: BitSize) =
  BEGIN
    EVAL t; EVAL type; EVAL index; EVAL elt; EVAL s;
  END DeclareArray;

PROCEDURE <A NAME="DeclareOpenArray"><procedure>DeclareOpenArray</procedure></A> (t: T;  type, elt: TypeUID;  s: BitSize) =
  BEGIN
    EVAL t; EVAL type; EVAL elt; EVAL s;
  END DeclareOpenArray;

PROCEDURE <A NAME="DeclareEnum"><procedure>DeclareEnum</procedure></A> (t: T;  type: TypeUID; n_elts: INTEGER;  s: BitSize) =
  BEGIN
    EVAL t; EVAL type; EVAL n_elts; EVAL s;
  END DeclareEnum;

PROCEDURE <A NAME="DeclareEnumElt"><procedure>DeclareEnumElt</procedure></A> (t: T;  n: Name) =
  BEGIN
    EVAL t; EVAL n;
  END DeclareEnumElt;

PROCEDURE <A NAME="DeclarePacked"><procedure>DeclarePacked</procedure></A> (t: T;  type: TypeUID;  s: BitSize;  base: TypeUID) =
  BEGIN
    EVAL t;  EVAL type; EVAL s; EVAL base;
  END DeclarePacked;

PROCEDURE <A NAME="DeclareRecord"><procedure>DeclareRecord</procedure></A> (t: T;  type: TypeUID;  s: BitSize;  n_fields: INTEGER) =
  BEGIN
    EVAL t; EVAL type; EVAL s; EVAL n_fields;
  END DeclareRecord;

PROCEDURE <A NAME="DeclareField"><procedure>DeclareField</procedure></A> (t: T;  n: Name;  o: BitOffset;  s: BitSize;  type: TypeUID) =
  BEGIN
    EVAL t; EVAL n; EVAL o; EVAL s; EVAL type;
  END DeclareField;

PROCEDURE <A NAME="DeclareSet"><procedure>DeclareSet</procedure></A> (t: T;  type, domain: TypeUID;  s: BitSize) =
  BEGIN
    EVAL t; EVAL type; EVAL domain; EVAL s;
  END DeclareSet;

PROCEDURE <A NAME="DeclareSubrange"><procedure>DeclareSubrange</procedure></A> (t: T;  type, domain: TypeUID; READONLY min,max: Target.Int;
                           s: BitSize) =
  BEGIN
    EVAL t; EVAL type; EVAL domain; EVAL min; EVAL max; EVAL s;
  END DeclareSubrange;

PROCEDURE <A NAME="DeclarePointer"><procedure>DeclarePointer</procedure></A> (t: T;  type, target: TypeUID;  brand: TEXT;  traced: BOOLEAN) =
  BEGIN
    EVAL t; EVAL type; EVAL target; EVAL brand; EVAL traced;
  END DeclarePointer;

PROCEDURE <A NAME="DeclareIndirect"><procedure>DeclareIndirect</procedure></A> (t: T;  type, target: TypeUID) =
  BEGIN
    EVAL t; EVAL type; EVAL target;
  END DeclareIndirect;

PROCEDURE <A NAME="DeclareProctype"><procedure>DeclareProctype</procedure></A> (t: T;  type: TypeUID;  n_formals: INTEGER;
                           result: TypeUID;  n_raises: INTEGER) =
  BEGIN
    EVAL t; EVAL type; EVAL n_formals; EVAL result; EVAL n_raises;
  END DeclareProctype;

PROCEDURE <A NAME="DeclareFormal"><procedure>DeclareFormal</procedure></A> (t: T;  n: Name;  type: TypeUID) =
  BEGIN
    EVAL t; EVAL n; EVAL type;
  END DeclareFormal;

PROCEDURE <A NAME="DeclareRaises"><procedure>DeclareRaises</procedure></A> (t: T;  n: Name) =
  BEGIN
    EVAL t;  EVAL n;
  END DeclareRaises;

PROCEDURE <A NAME="DeclareObject"><procedure>DeclareObject</procedure></A> (t: T;  type, super: TypeUID;  brand: TEXT;
                         traced: BOOLEAN;  n_fields, n_methods: INTEGER;
                         field_size: BitSize) =
  BEGIN
    EVAL t; EVAL type; EVAL super; EVAL brand;
    EVAL traced; EVAL n_fields; EVAL n_methods;
    EVAL field_size;
  END DeclareObject;

PROCEDURE <A NAME="DeclareMethod"><procedure>DeclareMethod</procedure></A> (t: T;  n: Name;  signature: TypeUID) =
  BEGIN
    EVAL t;  EVAL n; EVAL signature;
  END DeclareMethod;

PROCEDURE <A NAME="DeclareOpaque"><procedure>DeclareOpaque</procedure></A> (t: T;  type, super: TypeUID) =
  BEGIN
    EVAL t; EVAL type; EVAL super;
  END DeclareOpaque;

PROCEDURE <A NAME="RevealOpaque"><procedure>RevealOpaque</procedure></A> (t: T;  lhs, rhs: TypeUID) =
  BEGIN
    EVAL t; EVAL lhs; EVAL rhs;
  END RevealOpaque;

PROCEDURE <A NAME="DeclareException"><procedure>DeclareException</procedure></A> (t: T;  sym: INTEGER;  arg_type: TypeUID;
                            raise_proc: BOOLEAN) =
  BEGIN
    EVAL t;  EVAL sym; EVAL arg_type; EVAL raise_proc;
  END DeclareException;

PROCEDURE <A NAME="DeclareGlobal"><procedure>DeclareGlobal</procedure></A> (t: T;  sym: INTEGER;  s: ByteSize;  m3t: TypeUID) =
  BEGIN
    EVAL t;  EVAL sym; EVAL s; EVAL m3t;
  END DeclareGlobal;

PROCEDURE <A NAME="DeclareConstant"><procedure>DeclareConstant</procedure></A>  (t: T;  sym: INTEGER;  s: ByteSize;  m3t: TypeUID) =
  BEGIN
    EVAL t; EVAL sym; EVAL s; EVAL m3t;
  END DeclareConstant;

PROCEDURE <A NAME="DeclareLocal"><procedure>DeclareLocal</procedure></A> (t: T;  n: Name;  s: ByteSize;  frame: ByteOffset;
                        m3t: TypeUID) =
  BEGIN
    EVAL t;  EVAL n; EVAL s; EVAL frame; EVAL m3t;
  END DeclareLocal;

PROCEDURE <A NAME="DeclareParam"><procedure>DeclareParam</procedure></A> (t: T;  n: Name;  s: ByteSize;  frame: ByteOffset;
                        m3t: TypeUID) =
  BEGIN
    EVAL t;  EVAL n; EVAL s; EVAL frame; EVAL m3t;
  END DeclareParam;

PROCEDURE <A NAME="DeclareProcedure"><procedure>DeclareProcedure</procedure></A> (t: T;  sym: INTEGER;  n_params: INTEGER;
                            nested, exported: BOOLEAN) =
  BEGIN
    EVAL t;  EVAL sym; EVAL n_params; EVAL nested;  EVAL exported;
  END DeclareProcedure;

PROCEDURE <A NAME="BeginProcedure"><procedure>BeginProcedure</procedure></A> (t: T;  sym: INTEGER) =
  BEGIN
    EVAL t;  EVAL sym;
  END BeginProcedure;

PROCEDURE <A NAME="EndProcedure"><procedure>EndProcedure</procedure></A> (t: T;  sym: INTEGER) =
  BEGIN
    EVAL t; EVAL sym;
  END EndProcedure;

PROCEDURE <A NAME="BeginBlock"><procedure>BeginBlock</procedure></A> (t: T) =
  BEGIN
    EVAL t;
  END BeginBlock;

PROCEDURE <A NAME="EndBlock"><procedure>EndBlock</procedure></A> (t: T) =
  BEGIN
    EVAL t;
  END EndBlock;

PROCEDURE <A NAME="NoteProcedureOrigin"><procedure>NoteProcedureOrigin</procedure></A> (t: T;  sym: INTEGER) =
  BEGIN
    EVAL t; EVAL sym;
  END NoteProcedureOrigin;
</PRE>---------------------------------------------------------------- output ---

<P><PRE>TYPE
  DState = RECORD
    t          : T;
    buf        : M3Buf.T;
    sym_map    : REF ARRAY OF INTEGER;
    reloc_map  : REF ARRAY OF INTEGER;
    next_sym   : INTEGER;
    next_reloc : INTEGER;
    next_line  : INTEGER;
  END;

PROCEDURE <A NAME="Dump"><procedure>Dump</procedure></A> (t: T;  wr: Wr.T) =
  CONST SegName = ARRAY Seg OF TEXT { &quot;_TEXT&quot;, &quot;_DATA&quot; };
  VAR
    s                 : DState;
    offset            : INTEGER;
    seg_size          : INTEGER;
    next_sym_offset   : INTEGER;
    next_reloc_offset : INTEGER;
    seg_kind          : SKind;
  BEGIN
    s.t   := t;
    s.buf := M3Buf.New ();
    M3Buf.AttachDrain (s.buf, wr);

    (* write the object file header *)
    M3Buf.PutText (s.buf, &quot;\t.386P&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;_TEXT\tSEGMENT PARA USE32 PUBLIC 'CODE'&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;_TEXT\tENDS&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;_DATA\tSEGMENT DWORD USE32 PUBLIC 'DATA'&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;_DATA\tENDS&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;CONST\tSEGMENT DWORD USE32 PUBLIC 'CONST'&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;CONST\tENDS&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;_BSS\tSEGMENT DWORD USE32 PUBLIC 'BSS'&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;_BSS\tENDS&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;_TLS\tSEGMENT DWORD USE32 PUBLIC 'TLS'&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;_TLS\tENDS&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;$$SYMBOLS\tSEGMENT BYTE USE32 PUBLIC 'DEBSYM'&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;$$SYMBOLS\tENDS&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;$$TYPES\tSEGMENT BYTE USE32 PUBLIC 'DEBTYP'&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;$$TYPES\tENDS&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;FLAT\tGROUP _DATA, CONST, _BSS&quot;); NL(s);
    M3Buf.PutText (s.buf, &quot;\tASSUME CS: FLAT, DS: FLAT, SS: FLAT&quot;); NL(s);

    IF (t.file # NIL) THEN
      M3Buf.PutText (s.buf, &quot;; File &quot;);
      M3Buf.PutText (s.buf, t.file);
      NL (s);
    END;

    (* dump the imported symbols *)
    NL(s);
    FOR i := 0 TO t.n_syms-1 DO
      WITH sym = t.symbols[i] DO
        IF (sym.kind = SKind.Extern) AND (sym.used) THEN
          M3Buf.PutText (s.buf, &quot;EXTRN\t&quot;);
          M3ID.Put (s.buf, sym.id);
          M3Buf.PutText (s.buf, &quot;:NEAR&quot;); NL(s);
        END;
      END;
    END;

    (* dump the exported symbols *)
    NL(s);
    FOR i := 0 TO t.n_syms-1 DO
      WITH sym = t.symbols[i] DO
        IF sym.export AND (sym.kind &lt;= SKind.Data) THEN
          M3Buf.PutText (s.buf, &quot;PUBLIC\t&quot;);
          M3ID.Put (s.buf, sym.id);
          NL (s);
        END;
      END;
    END;

    (* dump the common symbols *)
    NL (s);
    M3Buf.PutText (s.buf, &quot;_DATA\tSEGMENT&quot;); NL(s);
    FOR i := 0 TO t.n_syms-1 DO
      WITH sym = t.symbols[i] DO
        IF (sym.kind = SKind.Bss) AND (sym.export) THEN
          M3Buf.PutText (s.buf, &quot;COMM\t&quot;);
          M3ID.Put (s.buf, sym.id);
          M3Buf.PutChar (s.buf, ':');
          M3Buf.PutText (s.buf, AlignName [sym.offset]);
          M3Buf.PutChar (s.buf, ':');
          M3Buf.PutInt  (s.buf, sym.size);
        END;
      END;
    END;
    M3Buf.PutText (s.buf, &quot;_DATA\tENDS&quot;); NL(s);

    (* dump the bss symbols *)
    NL (s);
    M3Buf.PutText (s.buf, &quot;_BSS\tSEGMENT&quot;); NL(s);
    FOR i := 0 TO t.n_syms-1 DO
      WITH sym = t.symbols[i] DO
        IF (sym.kind = SKind.Bss) AND NOT (sym.export) AND (sym.used) THEN
          M3ID.Put (s.buf, sym.id);
          M3Buf.PutChar (s.buf, '\t');
          M3Buf.PutText (s.buf, AlignDefn [sym.offset]);
          M3Buf.PutChar (s.buf, '\t');
          M3Buf.PutInt  (s.buf, sym.size);
          M3Buf.PutText (s.buf, &quot; DUP (?)&quot;); NL(s);
        END;
      END;
    END;
    M3Buf.PutText (s.buf, &quot;_BSS\tENDS&quot;); NL(s);

    (* sort the symbols &amp; relocs by  (kind, offset) *)
    SortSymbols (s);
    SortRelocs (s);

    (* dump the segments *)
    s.next_sym   := 0;
    s.next_reloc := 0;
    s.next_line  := 0;
    FOR seg := FIRST (t.bytes) TO LAST (t.bytes) DO
      NL (s);
      M3Buf.PutText (s.buf, SegName [seg]);
      M3Buf.PutText (s.buf, &quot;\tSEGMENT&quot;); NL(s);
      offset := 0;
      seg_kind := SegToKind [seg];
      seg_size := t.size [seg];
      next_sym_offset := NextSymOffset (s, seg_kind);
      next_reloc_offset := NextRelocOffset (s, seg_kind);

      WHILE (offset &lt; seg_size) DO
        (* make sure we didn't skip any relocations or symbols *)
        &lt;*ASSERT next_sym_offset &gt;= offset *&gt;
        &lt;*ASSERT next_reloc_offset &gt;= offset *&gt;

        (* check for a line number *)
        WHILE (s.next_line &lt; t.n_lines)
          AND (t.lines[s.next_line].pc &lt;= offset) DO
          M3Buf.PutText (s.buf, &quot;; Line &quot;);
          M3Buf.PutInt  (s.buf, t.lines[s.next_line].line);
          NL (s);
          INC (s.next_line);
        END;

        (* dump the symbols attached to this byte *)
        WHILE (next_sym_offset = offset) DO
          WITH sym = t.symbols[s.sym_map[s.next_sym]] DO
            M3ID.Put (s.buf, sym.id);
            M3Buf.PutText (s.buf, &quot;:&quot;); NL(s);
          END;
          INC (s.next_sym);
          next_sym_offset := NextSymOffset (s, seg_kind);
        END;

        IF (next_reloc_offset = offset) THEN
          (* there are relocations to do here *)
          PutWord (s, offset, seg);
          WHILE (next_reloc_offset = offset) DO
            WITH reloc = t.relocs[s.reloc_map [s.next_reloc]] DO
              M3Buf.PutText (s.buf, &quot; + &quot;);
              M3ID.Put (s.buf, t.symbols[reloc.target_sym].id);
            END;
            INC (s.next_reloc);
            next_reloc_offset := NextRelocOffset (s, seg_kind);
          END;
          INC (offset, 4);
        ELSIF (next_sym_offset &gt;= offset+4)
          AND (next_reloc_offset &gt;= offset + 4) THEN
          PutWord (s, offset, seg);
          INC (offset, 4);
        ELSE
          (* we can only dump a byte *)
          PutByte (s, offset, seg);
          INC (offset, 1);
        END;

        NL (s);
      END;

      (* dump any remaining symbols in this segment *)
      WHILE (next_sym_offset &lt; LAST (INTEGER)) DO
        (********
        WITH sym = t.symbols[s.sym_map[s.next_sym]] DO
          M3ID.Put (s.buf, sym.id);
          M3Buf.PutText (s.buf, &quot;:&quot;); NL(s);
        END;
        *******)
        INC (s.next_sym);
        next_sym_offset := NextSymOffset (s, seg_kind);
      END;

      M3Buf.PutText (s.buf, SegName [seg]);
      M3Buf.PutText (s.buf, &quot;\tENDS&quot;); NL(s);
    END;

    (* write the object file trailer *)
    M3Buf.PutText (s.buf, &quot;END&quot;); NL(s);
    M3Buf.Flush (s.buf, wr);

    (* reset the object file for another run *)
    FOR i := FIRST (t.size) TO LAST (t.size) DO t.size[i] := 0; END;
    t.sym_map := NIL;
    t.n_relocs := 0;

    (* Give the collector a chance. *)
    s.t         := NIL;
    s.buf       := NIL;
    s.sym_map   := NIL;
    s.reloc_map := NIL;
  END Dump;

PROCEDURE <A NAME="NL"><procedure>NL</procedure></A> (VAR s: DState) =
  BEGIN
    M3Buf.PutText (s.buf, Target.EOL);
  END NL;

PROCEDURE <A NAME="SortSymbols"><procedure>SortSymbols</procedure></A> (VAR s: DState) =
  (* CONST KindName = ARRAY SKind OF TEXT { &quot;text&quot;,&quot;data&quot;,&quot;bss&quot;,&quot;extern&quot; }; *)
  VAR t := s.t;  n := t.n_syms;

  PROCEDURE Cmp (xa, xb: INTEGER): [-1..+1] =
    BEGIN
      WITH a = t.symbols [xa],  b = t.symbols [xb] DO
        IF (a.kind &lt; b.kind) THEN RETURN -1 END;
        IF (a.kind &gt; b.kind) THEN RETURN +1 END;
        IF (a.offset &lt; b.offset) THEN RETURN -1 END;
        IF (a.offset &gt; b.offset) THEN RETURN +1 END;
        RETURN 0;
      END;
    END Cmp;

  BEGIN
    s.sym_map := NEW (REF ARRAY OF INTEGER, n);
    FOR i := 0 TO n-1 DO s.sym_map[i] := i; END;
    IntArraySort.Sort (s.sym_map^, Cmp);
  END SortSymbols;

PROCEDURE <A NAME="SortRelocs"><procedure>SortRelocs</procedure></A> (VAR s: DState) =
  VAR t := s.t;  n := t.n_relocs;

  PROCEDURE Cmp (xa, xb: INTEGER): [-1..+1] =
    VAR oa, ob: INTEGER;
    BEGIN
      WITH ra = t.relocs [xa],  rb = t.relocs [xb] DO
        WITH a = t.symbols[ra.src_sym],  b = t.symbols[rb.src_sym] DO
          IF (a.kind &lt; b.kind) THEN RETURN -1 END;
          IF (a.kind &gt; b.kind) THEN RETURN +1 END;
          oa := a.offset + ra.src_offset;
          ob := b.offset + rb.src_offset;
          IF (oa &lt; ob) THEN RETURN -1 END;
          IF (oa &gt; ob) THEN RETURN +1 END;
          RETURN 0;
        END;
      END;
    END Cmp;

  BEGIN
    s.reloc_map := NEW (REF ARRAY OF INTEGER, n);
    FOR i := 0 TO n-1 DO s.reloc_map[i] := i; END;
    IntArraySort.Sort (s.reloc_map^, Cmp);
  END SortRelocs;

PROCEDURE <A NAME="NextSymOffset"><procedure>NextSymOffset</procedure></A> (VAR s: DState;  kind: SKind): INTEGER =
  BEGIN
    IF (s.next_sym &lt; NUMBER (s.sym_map^)) THEN
      WITH sym = s.t.symbols[s.sym_map [s.next_sym]] DO
        IF (sym.kind = kind) THEN RETURN sym.offset; END;
      END;
    END;
    RETURN LAST (INTEGER);
  END NextSymOffset;

PROCEDURE <A NAME="NextRelocOffset"><procedure>NextRelocOffset</procedure></A> (VAR s: DState;  kind: SKind): INTEGER =
  BEGIN
    IF (s.next_reloc &lt; NUMBER (s.reloc_map^)) THEN
      WITH reloc = s.t.relocs[s.reloc_map [s.next_reloc]] DO
        WITH sym = s.t.symbols[reloc.src_sym] DO
          IF (sym.kind = kind) THEN RETURN sym.offset + reloc.src_offset; END;
        END;
      END;
    END;
    RETURN LAST (INTEGER);
  END NextRelocOffset;

CONST
  HexDigit = ARRAY [0..15] OF CHAR {'0','1','2','3','4','5','6','7',
                                    '8','9','a','b','c','d','e','f'};

PROCEDURE <A NAME="PutWord"><procedure>PutWord</procedure></A> (VAR s: DState;  offs: INTEGER;  seg: Seg) =
  VAR b := s.t.bytes[seg];  val: INTEGER;
  BEGIN
    M3Buf.PutText (s.buf, &quot;\tDD\t0&quot;);
    FOR i := offs+3 TO offs BY -1 DO
      val := b[i];
      M3Buf.PutChar (s.buf, HexDigit [Word.RightShift (val, 4)]);
      M3Buf.PutChar (s.buf, HexDigit [Word.And (val, 16_f)]);
    END;
    M3Buf.PutChar (s.buf, 'h');
  END PutWord;

PROCEDURE <A NAME="PutByte"><procedure>PutByte</procedure></A> (VAR s: DState;  offs: INTEGER;  seg: Seg) =
  VAR val := s.t.bytes[seg][offs];
  BEGIN
    M3Buf.PutText (s.buf, &quot;\tDB\t0&quot;);
    M3Buf.PutChar (s.buf, HexDigit [Word.RightShift (val, 4)]);
    M3Buf.PutChar (s.buf, HexDigit [Word.And (val, 16_f)]);
    M3Buf.PutChar (s.buf, 'h');
  END PutByte;

BEGIN
END MasmObjFile.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
