<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface>M3AST</interface>;

IMPORT <A HREF="../gast/AST.i3">AST</A>;
</PRE> This interface and its companions, define an abstract syntax for
the Modula-3 programming language, expressed as a tree of nodes
represented by <CODE>OBJECT</CODE> types. The specification follows the approach
described in the <CODE>AST</CODE> interface, and is structured in several layers.
The principal layers are <CODE>M3AST_LX</CODE>, <CODE>M3AST_AS</CODE> and <CODE>M3AST_SM</CODE>, which
define the lexical, syntactic and semantic layers, respectively.
Within these interfaces the AST nodes are specified as opaque <CODE>OBJECT</CODE>
types, with attributes defined abstractly using the <CODE>FIELDS</CODE> pragma.
Additional interfaces define the access method to the attributes. For
example, <CODE>M3AST_AS_F</CODE> defines the attributes as fields of the object
type.  In the abstract interfaces, the name and type of abstract
attributes are indicated with a <CODE>FIELDS</CODE> declaration, for example: 
<P>
<PRE>
       &lt;* FIELDS OF Node 
            attribute_name: Attribute_type; *&gt;
</PRE>
\subsection{Attribute Types}
<P>
Attribute types fall into three groups. First, lexical types denoting,
for example, the characters of an identifier or the characters of a
text literal. These correspond to the token grammar of the concrete
syntax.  The lexical attribute types are declared in the interface
<CODE>M3AST_LX</CODE>, are opaque, and are given concrete definitions by a
particular compiler implementation. Thus, the details of the token
grammar are not reflected in the abstract syntax.  The lexical
attribute names are distinguished by a prefix of <CODE>lx_</CODE>.
<P>
The second group, are always other node types, that is, subtypes of
<CODE>AST.NODE</CODE>, and are often called the children of the node.  In
general, each non-terminal on the right hand side of a rule in the
grammar is represented by a child node of the corresponding type. An
optional term <CODE>X</CODE> (denoted by <CODE>[X]</CODE> in the grammar), is represented by
a child of type of <CODE>X_NULL</CODE>, denoting that <CODE>NIL</CODE> represents a legal
missing item. A corollary of this is that a value of <CODE>NIL</CODE> is not
legal for any attribute in a well-formed syntax tree, unless it has
type <CODE>X_NULL</CODE>. Sequences of <CODE>X</CODE>'s (denoted by <CODE>{X}</CODE> in the syntax) are
represented as instances of an abstract sequence type <CODE>SEQUENCE OF T</CODE>.
Finally, non-terminals that are defined by more than one rule, for
example, <CODE>STM</CODE>, are defined by object types referred to as classes
(e.g. denoting the {\it class} of statements), with each choice
appearing as a separate subtype. There are no instances of such class
types in a tree instance, only of the subtypes.  To distinguish the
class types, they are named using all upper case leters.
<P>
The third group of attributes are those added by layers other than
<CODE>M3AST_LX</CODE> and <CODE>M3AST_AS</CODE>, and denote the results of processing the
syntactic AST. For example, the <CODE>M3AST_SM</CODE> layer adds attributes to
denote the results of static semantic analysis. These attributes are
very often node types, but can be any Modula-3 type.
<P>
\subsection{Multiple Inheritance}
<P>
There are a number of places where it would be convenient to declare a
node as a subtype of more than one parent, that is, use multiple
inheritance. Since this is not possible in Modula-3, a number of
mechanisms are used as workarounds. Sometimes the number of affected
nodes is small enough that it suffices to merely repeat the mutiple
inherited attribute in each node.  The general solution is as follows:
Suppose we wish to declare a new node <CODE>A</CODE> which inherits from <CODE>X</CODE> and
<CODE>Y</CODE>. Then choose one, say <CODE>X</CODE>, to be the supertype, and include an
attribute named <CODE>vY</CODE> of type <CODE>Y</CODE>. The <CODE>init</CODE> method for such a node
is overridden to build this structure. 

<P>\subsubsection{M3AST.NODE}
<P>
This is the interface in which one would define attributes that were common
to all Modula-3 AST nodes. In the current specification, there are no
such attributes, so we equate an <CODE>M3AST.NODE</CODE> with an <CODE>AST.NODE</CODE>. 

<P><PRE>TYPE
  NODE = AST.NODE;
  T = AST.T;

END M3AST.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
