<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3ASTOp_SM.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3ASTOp_SM.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3ASTOp_SM.i3">M3ASTOp_SM</A></implements></module>;

IMPORT <A HREF="M3AST.i3">M3AST</A>, <A HREF="M3AST_AS.i3">M3AST_AS</A>, <A HREF="M3AST_SM.i3">M3AST_SM</A>;
IMPORT <A HREF="M3AST_SM_F.i3">M3AST_SM_F</A>;

REVEAL <A NAME="CheckSetClosure">CheckSetClosure</A> = CheckSetClosure_public BRANDED OBJECT END;

PROCEDURE <A NAME="CheckSet"><procedure>CheckSet</procedure></A>(an: NODE; cl: CheckSetClosure)=
  VAR
    initId: M3AST_SM.INIT_ID;
    redefId: M3AST_SM.REDEF_ID;
    recobjId: M3AST_SM.RECOBJ_ID;
    usedId: M3AST_AS.USED_ID;
    ccvId: M3AST_SM.CCV_ID;
  BEGIN
    TYPECASE an OF
    | M3AST_AS.EXP(exp) =&gt;
        C(cl, an, exp.sm_exp_type_spec);
    | M3AST_AS.TYPED_ID(typed_id) =&gt;
        C(cl, an, typed_id.sm_type_spec);
    | M3AST_AS.UNIT_ID(unit_id) =&gt;
        C(cl, an, unit_id.sm_spec);
    | M3AST_AS.UNIT(unit) =&gt;
        C(cl, an, unit.sm_comp_unit);
    ELSE
    END;

    IF an.IsA_INIT_ID(initId) THEN
      B(cl, an, initId.sm_init_exp = M3AST_SM.UNSET_EXP());
    END;

    IF an.IsA_REDEF_ID(redefId) THEN
      B(cl, an, redefId.sm_int_def = M3AST_SM.UNSET_DEF_ID());
    END;

    IF an.IsA_RECOBJ_ID(recobjId) THEN
      C(cl, an, recobjId.sm_enc_type_spec);
    END;

    IF an.IsA_USED_ID(usedId) THEN
      C(cl, an, usedId.sm_def);
    END; (* if *)

    IF an.IsA_CCV_ID(ccvId) THEN
      B(cl, an, ccvId.sm_exp_value = NIL);
    END; (* if *)

    TYPECASE an OF
    | M3AST_AS.Named_type(named_type) =&gt;
        C(cl, an, named_type.sm_type_spec);
    | M3AST_AS.Subrange_type(subrange_type) =&gt;
        C(cl, an, subrange_type.sm_base_type_spec);
    | M3AST_AS.Enumeration_type(enumeration_type) =&gt;
        B(cl, an, enumeration_type.sm_num_elements &lt; 0);
    | M3AST_AS.Array_type(array_type) =&gt;
        C(cl, an, array_type.sm_norm_type);
    | M3AST_AS.Object_type(object_type) =&gt;
        B(cl, an, object_type.sm_rf_bitsize &lt; 0 OR
                  object_type.sm_rf_align &lt; 0);
    | M3AST_AS.Procedure_type(procedure_type) =&gt;
        B(cl, an, procedure_type.sm_def_id =
                M3AST_SM.UNSET_DEF_ID());
    | M3AST_AS.Proc_id(proc_id) =&gt;
        B(cl, an, proc_id.sm_concrete_proc_id =
                M3AST_SM.UNSET_DEF_ID());
    ELSE
    END; (* case *)

    TYPECASE an OF
    | M3AST_SM.Any_type, M3AST_SM.Type_type =&gt;
        (* Ignore unset attributes in these bogus types *)
    | M3AST_AS.TYPE_SPEC(typeSpec) =&gt;
        B(cl, an, typeSpec.sm_bitsize &lt; 0 OR typeSpec.sm_align &lt; 0);
    ELSE
    END; (* if *)
  END CheckSet;

PROCEDURE <A NAME="B"><procedure>B</procedure></A>(cl: CheckSetClosure; an: M3AST.NODE; b: BOOLEAN) RAISES {}=
  BEGIN
    IF b THEN cl.callback(an) END;
  END B;

PROCEDURE <A NAME="C"><procedure>C</procedure></A>(cl: CheckSetClosure; an: M3AST.NODE; tn: M3AST.NODE) RAISES {}=
  BEGIN
    IF tn = NIL THEN
      cl.callback(an);
    END; (* if *)
  END C;

BEGIN
END M3ASTOp_SM.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
