<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3ASTScope.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3ASTScope.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3ASTScope.m3">M3ASTScope</A></interface>;

IMPORT <A HREF="../gast/ASTWalk.i3">ASTWalk</A>, <A HREF="../gast/AST.i3">AST</A>, <A HREF="M3AST_AS.i3">M3AST_AS</A>, <A HREF="M3AST_SM.i3">M3AST_SM</A>;
</PRE> This interface provides support for managing scopes, in
   terms of the <CODE>M3AST_SM.SCOPE</CODE> class. The assumption is
   that a client is using the <CODE>ASTWalk</CODE> package to visit
   each node in the AST, on entry and exit. The <CODE>Set</CODE> procedure
   should be called each time a node is entered, and this
   will return a <CODE>SCOPE</CODE> object that can be used for identifier
   lookups.


<P><PRE>TYPE <A HREF="M3ASTScope.m3#Closure">Closure</A> &lt;: Closure_public;
     Closure_public = ASTWalk.Closure OBJECT
    scope: M3AST_SM.SCOPE := NIL;
  END;
</PRE><BLOCKQUOTE><EM> Create a subtype of <CODE>Closure</CODE>, with <CODE>callback</CODE> bound to
   the procedue that will call <CODE>Set</CODE>, and pass it to
   <CODE>ASTWalk.ModeVisitNodes</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ASTScope.m3#Set">Set</A>(cl: Closure; n: AST.NODE; vm: ASTWalk.VisitMode);
</PRE><BLOCKQUOTE><EM> This procedure updates the value of <CODE>cl.scope</CODE> according to
   the type of <CODE>n</CODE> and the value of <CODE>vm</CODE>, (Entry/Exit). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ASTScope.m3#Lookup">Lookup</A>(s: M3AST_SM.SCOPE;
                 used_id: M3AST_AS.USED_ID): M3AST_AS.DEF_ID;
</PRE><BLOCKQUOTE><EM> This procedure tries to bind the identifier occurrence <CODE>used_id</CODE>
   to a definition. If the search fails, NIL is returned, else
   the node of the defining occurrence. </EM></BLOCKQUOTE><PRE>

END M3ASTScope.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
