<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST_AS.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST_AS.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>M3AST_AS</CODE> is the syntactic layer of the Modula-3 AST specification. 

<P><PRE>INTERFACE <interface>M3AST_AS</interface>;

IMPORT <A HREF="M3AST_LX.i3">M3AST_LX</A>;

&lt;* PRAGMA FIELDS *&gt;

TYPE
   SRC_NODE = M3AST_LX.SRC_NODE;
   SRC_NODE_C = M3AST_LX.SRC_NODE_C;
</PRE> To support clients of previous versions of this interface, <CODE>SRC_NODE</CODE>
is passed through by this interface. 

<P> \subsection{Identifiers} 

<P><PRE>TYPE
   ID = M3AST_LX.ID;
</PRE> The subtypes of the <CODE>ID</CODE> class are partitioned into two disjoint sets,
those which correspond to identifers that are definitions (<CODE>DEF_ID</CODE>)
and those which are correspond to uses (<CODE>USED_ID</CODE>). Unlike the
concrete syntax, which does not distinguish identifier definitions,
each construct that can introduce a new identifier definition has an
aassociated, unique, subtype, e.g.  <CODE>Proc_id</CODE> for identifiers
associated with <CODE>PROCEDURE</CODE> declarations. 

<P> \subsubsection{Definitions} 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#DEF_ID">DEF_ID</A> &lt;: ID;
  DEF_ID_NULL = DEF_ID;

  <A HREF="../astall/M3AST_all.i3#UNIT_ID">UNIT_ID</A> &lt;: DEF_ID;               (* INTERFACE or MODULE *)
  <A HREF="../astall/M3AST_all.i3#Module_id">Module_id</A> &lt;: UNIT_ID;            (* MODULE m *)
  <A HREF="../astall/M3AST_all.i3#Interface_id">Interface_id</A> &lt;: UNIT_ID;         (* INTERFACE i *)
  <A HREF="../astall/M3AST_all.i3#Interface_AS_id">Interface_AS_id</A> &lt;: DEF_ID;       (* the J in IMPORT I AS J *)
  <A HREF="../astall/M3AST_all.i3#F_Interface_id">F_Interface_id</A> &lt;: DEF_ID;        (* generic formal *)
</PRE> The class <CODE>TYPED_ID</CODE> is introduced as a placeholder for semantic
information, to mitigate the lack of multiple inheritance.  All the
identifiers below are subtypes of <CODE>TYPED_ID</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#TYPED_ID">TYPED_ID</A> &lt;: DEF_ID;
  <A HREF="../astall/M3AST_all.i3#FORMAL_ID">FORMAL_ID</A> &lt;: TYPED_ID;           (* procedure formals *)
  <A HREF="../astall/M3AST_all.i3#F_Value_id">F_Value_id</A> &lt;: FORMAL_ID;         (* VALUE v *)
  <A HREF="../astall/M3AST_all.i3#F_Var_id">F_Var_id</A> &lt;: FORMAL_ID;           (* VAR v *)
  <A HREF="../astall/M3AST_all.i3#F_Readonly_id">F_Readonly_id</A> &lt;: FORMAL_ID;      (* READONLY v *)

  <A HREF="../astall/M3AST_all.i3#Type_id">Type_id</A> &lt;: TYPED_ID;             (* TYPE T *)
  <A HREF="../astall/M3AST_all.i3#Const_id">Const_id</A> &lt;: TYPED_ID;            (* CONST C *)
  <A HREF="../astall/M3AST_all.i3#Var_id">Var_id</A> &lt;: TYPED_ID;              (* VAR v (in blocks) *)
  <A HREF="../astall/M3AST_all.i3#Proc_id">Proc_id</A> &lt;: TYPED_ID;             (* PROCEDURE P *)
  <A HREF="../astall/M3AST_all.i3#Enum_id">Enum_id</A> &lt;: TYPED_ID;             (* {Red,Green,Blue} *)
  <A HREF="../astall/M3AST_all.i3#METHOD_OVERRIDE_ID">METHOD_OVERRIDE_ID</A> &lt;: TYPED_ID;
  <A HREF="../astall/M3AST_all.i3#Method_id">Method_id</A> &lt;: METHOD_OVERRIDE_ID; (* METHODS m *)
  <A HREF="../astall/M3AST_all.i3#Override_id">Override_id</A> &lt;: METHOD_OVERRIDE_ID;  (* OVERRIDES m *)
  <A HREF="../astall/M3AST_all.i3#Field_id">Field_id</A> &lt;: TYPED_ID;            (* in RECORD/OBJECT *)
  <A HREF="../astall/M3AST_all.i3#For_id">For_id</A> &lt;: TYPED_ID;              (* FOR i *)
  <A HREF="../astall/M3AST_all.i3#Handler_id">Handler_id</A> &lt;: TYPED_ID;          (* EXCEPT E(v) *)
  Handler_id_NULL = Handler_id;
  <A HREF="../astall/M3AST_all.i3#Tcase_id">Tcase_id</A> &lt;: TYPED_ID;            (* TYPECASE ... T(v) *)
  Tcase_id_NULL = Tcase_id;
  <A HREF="../astall/M3AST_all.i3#With_id">With_id</A> &lt;: TYPED_ID;             (* WITH b *)
  <A HREF="../astall/M3AST_all.i3#Exc_id">Exc_id</A> &lt;: TYPED_ID;              (* EXCEPTION E(T) *)
</PRE> \subsubsection{Uses}
Identifier uses are separated into three distinct subtypes.
Firstly, there are several cases where the binding of the use is
required by the language definition to be to an <CODE>Interface_id</CODE>, e.g.
<CODE>IMPORT I</CODE>. To improve readability, such uses are denoted by the
subtype <CODE>Used_interface_id</CODE>.  Secondly, there are occurrences such as
the identifier <CODE>N</CODE> in a <CODE>FROM I IMPORT N</CODE>. These are denoted by the
subtype <CODE>Used_def_id</CODE>. Finally, there are identifiers that can occur
in expressions. Here we have a problem, since such identifiers also
need to be a subtype of the class that denotes expressions (<CODE>EXP</CODE>).
The solution, of which more later, is to make these a subtype of
<CODE>EXP</CODE>, and call them <CODE>Exp_used_id</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#USED_ID">USED_ID</A> &lt;: ID;
  <A HREF="../astall/M3AST_all.i3#Used_interface_id">Used_interface_id</A> &lt;: USED_ID;
  Used_interface_id_NULL = Used_interface_id;
  <A HREF="../astall/M3AST_all.i3#Used_def_id">Used_def_id</A> &lt;: USED_ID;
</PRE> Qualified identifiers, e.g. <CODE>I.B</CODE>, can also appear in both
expression and non-expression contexts. In the former case, it is not
known after syntax analysis, whether a construct of the form <CODE>a.b</CODE>
denotes a qualified identifier or not, until the binding for <CODE>a</CODE> is
resolved. In the non-expression case, e.g. in <CODE>REVEAL I.T = ...</CODE>, a
qualified identifier is denoted by a separate node containing two
children of class <CODE>USED_ID</CODE>. Note that the <CODE>interface</CODE> component of
such a node can be empty, denoted by NIL. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Qual_used_id">Qual_used_id</A> &lt;: SRC_NODE_C;
  Qual_used_id_NULL = Qual_used_id;
  &lt;* FIELDS OF Qual_used_id
       as_intf_id: Used_interface_id_NULL;
       as_id: Used_def_id; *&gt;
</PRE> To support the {\em multiple inheritance} of the <CODE>ID</CODE>, or <CODE>USED_ID</CODE>
classes, methods are provided to enquire whether any <CODE>M3AST.NODE</CODE> instance
is also a member of these classes. See, for example,
<CODE>Exp_used_id</CODE> in the expressions section. These methods are actually
revealed in the representation interface, e.g. <CODE>M3AST_AS_F</CODE>.
<P>
<PRE>
          METHODS
            IsA_USED_ID(VAR (*out
 <PRE>used_id): BOOLEAN;
|       IsA_ID(VAR (*out*) id): BOOLEAN; *)
</PRE> \subsection{Compilation Units}
<P>
In order to provide a node in which to place to miscellaneous
attributes, e.g. compilation status, the AST is rooted in a node
called <CODE>Compilation_Unit</CODE>, which has no direct counterpart in the
concrete syntax. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Compilation_Unit">Compilation_Unit</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF Compilation_Unit
     as_root: UNIT; *&gt;
</PRE> The class that corresponds to the non-terminal named <CODE>Compilation</CODE>
in the concrete grammar is called <CODE>UNIT</CODE>, and it has subtypes to
denote generic definitions, generic instantiations and <CODE>normal</CODE>
interfaces and modules. Multiple inheritance would simplify the
structure here also, but in this case, it is simplest to simply repeat
(multiply inherited) attributes in the subtypes.  The <CODE>UNIT</CODE> class
carries the attribute denoting the identifier that is common to all
forms of <CODE>UNIT</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#UNIT">UNIT</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF UNIT
     as_id: UNIT_ID; *&gt;
</PRE> Generic definitions and {\it normal} units both have {\it bodies}, i.e.
imports and declarations, and these are associated with the class
<CODE>UNIT_WITH_BODY</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#UNIT_WITH_BODY">UNIT_WITH_BODY</A> &lt;: UNIT;
  &lt;* FIELDS OF UNIT_WITH_BODY
     as_import_s: SEQUENCE OF IMPORTED;
     as_block: Block *&gt;
</PRE> Generic definitions contain a list of formal parameters, and this
is captured by the <CODE>UNIT_GEN_DEF</CODE> class. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#UNIT_GEN_DEF">UNIT_GEN_DEF</A> &lt;: UNIT_WITH_BODY;
  &lt;* FIELDS OF UNIT_GEN_DEF
     as_id_s: SEQUENCE OF F_Interface_id; *&gt;

  <A HREF="../astall/M3AST_all.i3#Interface_gen_def">Interface_gen_def</A> &lt;: UNIT_GEN_DEF;

  <A HREF="../astall/M3AST_all.i3#Module_gen_def">Module_gen_def</A> &lt;: UNIT_GEN_DEF;
</PRE> Normal interfaces and modules can be <CODE>UNSAFE</CODE>. (as can generic
instantiations, but this example of multiple inheritance is not
captured in the type hierarchy. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#UNIT_NORMAL">UNIT_NORMAL</A> &lt;: UNIT_WITH_BODY;
  &lt;* FIELDS OF UNIT_NORMAL
    as_unsafe: Unsafe_NULL; *&gt;

  <A HREF="../astall/M3AST_all.i3#Interface">Interface</A> &lt;: UNIT_NORMAL;
</PRE> Modules can have an EXPORT list (as can generically instantiated
modules, but this example of multiple inheritance is not captured in
the type hierarchy). 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Module">Module</A> &lt;: UNIT_NORMAL;
  &lt;* FIELDS OF Module
    as_export_s: SEQUENCE OF Used_interface_id; *&gt;
</PRE> Generic instantiations can be <CODE>UNSAFE</CODE>, contain an identifier that
refers to the generic definition and a list of actual parameters.
These identifier occurrences must all bind to <CODE>Interface_id</CODE>s. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#UNIT_GEN_INS">UNIT_GEN_INS</A> &lt;: UNIT;
  &lt;* FIELDS OF UNIT_GEN_INS
     as_unsafe: Unsafe_NULL;
     as_gen_id: Used_interface_id;
     as_id_s: SEQUENCE OF Used_interface_id *&gt;

  <A HREF="../astall/M3AST_all.i3#Interface_gen_ins">Interface_gen_ins</A> &lt;: UNIT_GEN_INS;

  <A HREF="../astall/M3AST_all.i3#Module_gen_ins">Module_gen_ins</A> &lt;: UNIT_GEN_INS;
  &lt;* FIELDS OF Module_gen_ins
    as_export_s: SEQUENCE OF Used_interface_id; *&gt;
</PRE> <CODE>UNSAFE</CODE> is represented as node with no children. In order to record the
actual lexical token, it is declared as a subtype of <CODE>SRC_NODE_C</CODE>. The
<CODE>lx_node_s</CODE> will contain a single <CODE>Token</CODE> element. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Unsafe">Unsafe</A> &lt;: SRC_NODE_C;
  Unsafe_NULL = Unsafe;
</PRE> Imports fall into two classes, denoted by <CODE>AsImport</CODE> and
<CODE>FromImport</CODE> in the concrete syntax. The class <CODE>IMPORTED</CODE> is used in
the AST to denote the choice, with subtypes <CODE>Simple_import</CODE> and
<CODE>From_import</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#IMPORTED">IMPORTED</A> &lt;: SRC_NODE_C;
  <A HREF="../astall/M3AST_all.i3#Simple_import">Simple_import</A> &lt;: IMPORTED;
  &lt;* FIELDS OF Simple_import
    as_import_item_s: SEQUENCE OF Import_item; *&gt;
</PRE> An <CODE>Import_item</CODE> node corresponds directly to <CODE>ImportItem</CODE> in the 
   concrete syntax 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Import_item">Import_item</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF Import_item
     as_intf_id: Used_interface_id;
     as_id: Interface_AS_id; *&gt;

  <A HREF="../astall/M3AST_all.i3#From_import">From_import</A> &lt;: IMPORTED;
  &lt;* FIELDS OF From_import
     as_intf_id: Used_interface_id;
     as_id_s: SEQUENCE OF Used_def_id; *&gt;
</PRE> \subsection{Declarations and Revelations}
The concrete syntax groups revelations under the <CODE>Decl</CODE> rules.  In
the AST we introduce a class <CODE>DECL_REVL</CODE> to handle either, and two
subtypes <CODE>DECL</CODE> and <CODE>Revelation_s</CODE> 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#DECL_REVL">DECL_REVL</A> &lt;: SRC_NODE_C;
</PRE> Declarations are somewhat tedious to represent, since each
occurrence of, say, <CODE>CONST</CODE>, can introduce several actual declarations.
Accordingly, we introduce nodes of the form <CODE>X_s</CODE>, which carry a
sequence attribute. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#DECL">DECL</A> &lt;: DECL_REVL;

  <A HREF="../astall/M3AST_all.i3#Const_decl_s">Const_decl_s</A> &lt;: DECL;            (* CONST ... *)
  &lt;* FIELDS OF Const_decl_s
     as_const_decl_s: SEQUENCE OF Const_decl *&gt;

  <A HREF="../astall/M3AST_all.i3#Type_decl_s">Type_decl_s</A> &lt;: DECL;             (* TYPE ... *)
  &lt;* FIELDS OF Type_decl_s
     as_type_decl_s: SEQUENCE OF TYPE_DECL *&gt;

  <A HREF="../astall/M3AST_all.i3#Var_decl_s">Var_decl_s</A> &lt;: DECL;              (* VAR ... *)
  &lt;* FIELDS OF Var_decl_s
     as_var_decl_s: SEQUENCE OF Var_decl *&gt;

  <A HREF="../astall/M3AST_all.i3#Exc_decl_s">Exc_decl_s</A> &lt;: DECL;              (* EXCEPTION ... *)
  &lt;* FIELDS OF Exc_decl_s
     as_exc_decl_s: SEQUENCE OF Exc_decl *&gt;
</PRE> <CODE>Proc_decl</CODE> is the exception to the rule. The <CODE>as_body</CODE> attribute
will be <CODE>NIL</CODE> in an AST that represents an interface.  

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Proc_decl">Proc_decl</A> &lt;: DECL;
  &lt;* FIELDS OF Proc_decl
    as_id: Proc_id;
    as_type: Procedure_type;
    as_body: Block_NULL; *&gt;
</PRE> Now the declarations proper. Note that the identifer in each node
is of the appropriate type, e.g. <CODE>Const_id</CODE> for a <CODE>Const_decl</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Const_decl">Const_decl</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF Const_decl
     as_id: Const_id;
     as_type: M3TYPE_NULL;
     as_exp: EXP; *&gt;
</PRE> Type declarations are either opaque (subtype) or concrete. The
class <CODE>TYPE_DECL</CODE> captures this. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#TYPE_DECL">TYPE_DECL</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF TYPE_DECL
     as_id: Type_id;
     as_type: M3TYPE; *&gt;
</PRE> The <CODE>as_type</CODE> attribute for a <CODE>Subtype_decl</CODE> is always an
<CODE>Opaque_type</CODE> node (see below). The value of <CODE>U</CODE> is encoded as an
attribute of the <CODE>Opaque_type</CODE> node. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Subtype_decl">Subtype_decl</A> &lt;: TYPE_DECL;       (* TYPE T &lt;: U *)
  <A HREF="../astall/M3AST_all.i3#Concrete_decl">Concrete_decl</A> &lt;: TYPE_DECL;      (* TYPE T = U *)
</PRE> Variable declarations are unusual in that several identifiers can
be introduced in the same declaration. Note that either the <CODE>as_type</CODE>
attribute or the <CODE>as_default</CODE> attribute may be <CODE>NIL</CODE>, but not both.  The
latter constraint is not expressed in the AST. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Var_decl">Var_decl</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF Var_decl
     as_id_s: SEQUENCE OF Var_id;
     as_type: M3TYPE_NULL;
     as_default: EXP_NULL; *&gt;

  <A HREF="../astall/M3AST_all.i3#Exc_decl">Exc_decl</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF Exc_decl
     as_id: Exc_id;
     as_type: M3TYPE_NULL; *&gt;

  <A HREF="../astall/M3AST_all.i3#Revelation_s">Revelation_s</A> &lt;: DECL_REVL;
  &lt;* FIELDS OF Revelation_s
    as_reveal_s: SEQUENCE OF REVELATION; *&gt;
</PRE> Like type declarations, revelations can be opaque (subtype) or concrete. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#REVELATION">REVELATION</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF REVELATION
     as_qual_id: Qual_used_id;
     as_type: M3TYPE; *&gt;

  <A HREF="../astall/M3AST_all.i3#Subtype_reveal">Subtype_reveal</A> &lt;: REVELATION;    (* REVEAL T &lt;: U *)
  <A HREF="../astall/M3AST_all.i3#Concrete_reveal">Concrete_reveal</A> &lt;: REVELATION;   (* REVEAL T = U *)
</PRE> \subsubsection{Type Productions} 

<P> There are situations where an attribute can be either a type or an
expression, so we define the class <CODE>EXP_TYPE</CODE> to denote that choice. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#EXP_TYPE">EXP_TYPE</A> &lt;: SRC_NODE_C;
</PRE> Types can appear in the AST as type constructions or as qualified
identifiers (which must ultimately bind to a name declared as a
<CODE>Type_id</CODE>. The class <CODE>M3TYPE</CODE> is used to denote this choice. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#M3TYPE">M3TYPE</A> &lt;: EXP_TYPE;
  M3TYPE_NULL = M3TYPE;

  <A HREF="../astall/M3AST_all.i3#Named_type">Named_type</A> &lt;: M3TYPE;
  &lt;* FIELDS OF Named_type
    as_qual_id: Qual_used_id; *&gt;
</PRE> Type constructions (specifications) are grouped under the class
<CODE>TYPE_SPEC</CODE> 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#TYPE_SPEC">TYPE_SPEC</A> &lt;: M3TYPE;
</PRE> The following built-in types are primitive. Others, such as
<CODE>BOOLEAN</CODE>, are expressed as instances of the apropriate <CODE>TYPE_SPEC</CODE>
subtype (<CODE>Enumeration_type</CODE> for <CODE>BOOLEAN</CODE>). 

<P> For convenience all the floating types are grouped under <CODE>FLOAT_TYPE</CODE> 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#FLOAT_TYPE">FLOAT_TYPE</A> &lt;: TYPE_SPEC;
  <A HREF="../astall/M3AST_all.i3#Real_type">Real_type</A> &lt;: FLOAT_TYPE;               (* REAL *)
  <A HREF="../astall/M3AST_all.i3#LongReal_type">LongReal_type</A> &lt;: FLOAT_TYPE;           (* LONGREAL *)
  <A HREF="../astall/M3AST_all.i3#Extended_type">Extended_type</A> &lt;: FLOAT_TYPE;           (* EXTENDED *)

  <A HREF="../astall/M3AST_all.i3#Integer_type">Integer_type</A> &lt;: TYPE_SPEC;             (* INTEGER *)
  <A HREF="../astall/M3AST_all.i3#Null_type">Null_type</A> &lt;: TYPE_SPEC;                (* NULL *)
  <A HREF="../astall/M3AST_all.i3#RefAny_type">RefAny_type</A> &lt;: TYPE_SPEC;              (* REFANY *)
  <A HREF="../astall/M3AST_all.i3#Address_type">Address_type</A> &lt;: TYPE_SPEC;             (* ADDRESS *)

  <A HREF="../astall/M3AST_all.i3#Root_type">Root_type</A> &lt;: TYPE_SPEC;                (* ROOT/UNTRACED ROOT *)
  &lt;* FIELDS OF Root_type
     as_trace_mode: Untraced_NULL *&gt;
</PRE> <CODE>UNTRACED ...</CODE> is denoted by a node of type <CODE>Untraced</CODE>. In order to
record the actual lexical token, it is declared as a subtype of
<CODE>SRC_NODE_C</CODE>. The <CODE>lx_node_s</CODE> will contain a single <CODE>Token</CODE> element. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Untraced">Untraced</A> &lt;: SRC_NODE_C;
  Untraced_NULL = Untraced;

  <A HREF="../astall/M3AST_all.i3#Packed_type">Packed_type</A> &lt;: TYPE_SPEC;
  &lt;* FIELDS OF Packed_type
     as_exp: EXP;
     as_type: M3TYPE *&gt;

  <A HREF="../astall/M3AST_all.i3#Array_type">Array_type</A> &lt;: TYPE_SPEC;
  &lt;* FIELDS OF Array_type
     as_indextype_s: SEQUENCE OF M3TYPE;
     as_elementtype: M3TYPE; *&gt;

  <A HREF="../astall/M3AST_all.i3#Enumeration_type">Enumeration_type</A> &lt;: TYPE_SPEC;
  &lt;* FIELDS OF Enumeration_type
     as_id_s: SEQUENCE OF Enum_id; *&gt;

  <A HREF="../astall/M3AST_all.i3#Set_type">Set_type</A> &lt;: TYPE_SPEC;
  &lt;* FIELDS OF Set_type
     as_type: M3TYPE; *&gt;

  <A HREF="../astall/M3AST_all.i3#Subrange_type">Subrange_type</A> &lt;: TYPE_SPEC;
  &lt;* FIELDS OF Subrange_type
     as_range: Range; *&gt;
</PRE> Several attributes need to encode a range of expressions, and in
Expressome cases a single value is a legal choice . To avoid duplication,
the class <CODE>RANGE_EXP</CODE> is introduced to denote this choice. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#RANGE_EXP">RANGE_EXP</A> &lt;: SRC_NODE_C;
</PRE> A single value is denoted by a <CODE>Range_EXP</CODE> (sic). 
  <PRE><A HREF="../astall/M3AST_all.i3#Range_EXP">Range_EXP</A> &lt;: RANGE_EXP;
  &lt;* FIELDS OF Range_EXP
     as_exp: EXP; *&gt;

  <A HREF="../astall/M3AST_all.i3#Range">Range</A> &lt;: RANGE_EXP;
  &lt;* FIELDS OF Range
     as_exp1, as_exp2: EXP *&gt;
</PRE> <CODE>RECORD</CODE> types simply contain a sequence of <CODE>Fields</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Record_type">Record_type</A> &lt;: TYPE_SPEC;
  &lt;* FIELDS OF Record_type
     as_fields_s: SEQUENCE OF Fields; *&gt;
</PRE> Like VAR declarations, Each <CODE>field</CODE> can introduce several
identifiers of the same type and initial value. The remarks about
<CODE>as_type</CODE> and <CODE>as_default</CODE> in the <CODE>Var_decl</CODE> node apply to fields
also. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Fields">Fields</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF Fields
    as_id_s: SEQUENCE OF Field_id;
    as_type: M3TYPE_NULL;
    as_default: EXP_NULL; *&gt;
</PRE> <CODE>OBJECT</CODE> types and <CODE>REF</CODE> types can be <CODE>BRANDED</CODE>, and this is denoted by
the <CODE>BRANDED_TYPE</CODE> class. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#BRANDED_TYPE">BRANDED_TYPE</A> &lt;: TYPE_SPEC;
  &lt;* FIELDS OF BRANDED_TYPE
     as_brand: Brand_NULL *&gt;
</PRE> A user supplied brand is optional. 
  <PRE><A HREF="../astall/M3AST_all.i3#Brand">Brand</A> &lt;: SRC_NODE_C;
  Brand_NULL = Brand;
  &lt;* FIELDS OF Brand
    as_exp: EXP_NULL; *&gt;

  <A HREF="../astall/M3AST_all.i3#Ref_type">Ref_type</A> &lt;: BRANDED_TYPE;
  &lt;* FIELDS OF Ref_type
     as_trace_mode: Untraced_NULL;
     as_type: M3TYPE *&gt;
</PRE> The object supertype (ancestor) is encoded as an attribute of type
<CODE>M3TYPE</CODE>. In fact only a <CODE>Named_type</CODE>, <CODE>Object_type</CODE> or <CODE>Root_Type</CODE> is
legal. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Object_type">Object_type</A> &lt;: BRANDED_TYPE;
  &lt;* FIELDS OF Object_type
     as_ancestor: M3TYPE_NULL;
     as_fields_s: SEQUENCE OF Fields;
     as_method_s: SEQUENCE OF Method;
     as_override_s: SEQUENCE OF Override; *&gt;
</PRE> Methods and Overrides have a similar syntactic structure, which is
encoded by the class <CODE>METHOD_OVERRIDE</CODE>. An <CODE>Override</CODE> has the
additional constraint that <CODE>as_default # NIL</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#METHOD_OVERRIDE">METHOD_OVERRIDE</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF METHOD_OVERRIDE
     as_id: METHOD_OVERRIDE_ID;
     as_default: EXP_NULL *&gt;

  <A HREF="../astall/M3AST_all.i3#Method">Method</A> &lt;: METHOD_OVERRIDE;
  &lt;* FIELDS OF Method
    as_type: Procedure_type; *&gt;

  <A HREF="../astall/M3AST_all.i3#Override">Override</A> &lt;: METHOD_OVERRIDE;

  <A HREF="../astall/M3AST_all.i3#Procedure_type">Procedure_type</A> &lt;: TYPE_SPEC;
  &lt;* FIELDS OF Procedure_type
     as_formal_param_s: SEQUENCE OF Formal_param;
     as_result_type: M3TYPE_NULL;
     as_raises: RAISEES_NULL *&gt;
</PRE> As with <CODE>Var_decl</CODE>s, only one of <CODE>as_formal_type</CODE> and <CODE>as_default</CODE>
may be NIL. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Formal_param">Formal_param</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF Formal_param
     as_id_s: SEQUENCE OF FORMAL_ID;
     as_formal_type: M3TYPE_NULL;
     as_default: EXP_NULL *&gt;

  <A HREF="../astall/M3AST_all.i3#RAISEES">RAISEES</A> &lt;: SRC_NODE_C;
  RAISEES_NULL = RAISEES;

  <A HREF="../astall/M3AST_all.i3#Raisees_some">Raisees_some</A> &lt;: RAISEES;
  &lt;* FIELDS OF Raisees_some
     as_raisees_s: SEQUENCE OF Qual_used_id *&gt;

  <A HREF="../astall/M3AST_all.i3#Raisees_any">Raisees_any</A> &lt;: RAISEES;  (* RAISES ANY *)
</PRE> Opaque types have no direct correspondence in the concrete syntax.
In effect they encode the <CODE>&lt;:</CODE> in a <CODE>Subtype_decl</CODE>, and provide a unique
node for each declaration, which is convenient for subsequent semantic
analysis. The <CODE>as_type</CODE> attribute encodes the <CODE>M3TYPE</CODE> that actually
appeared to the right of the <CODE>&lt;:</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Opaque_type">Opaque_type</A> &lt;: TYPE_SPEC;
  &lt;* FIELDS OF Opaque_type
    as_type: M3TYPE; *&gt;
</PRE> \subsection{Expression productions}
<P>
There is no analogue of <CODE>ConstExpr</CODE> in the abstract syntax. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#EXP">EXP</A> &lt;: EXP_TYPE;
  EXP_NULL = EXP;
</PRE> In <CODE>M3AST_LX</CODE>, the class <CODE>LITERAL</CODE> was declared as a subtype of
<CODE>SRC_NODE</CODE>. At this point we {\it reveal} that <CODE>LITERAL</CODE> is actually a
subtype of <CODE>EXP</CODE>. We also introduce distinct subtypes of <CODE>LITERAL</CODE> to
denote the different cases. Note that since <CODE>EXP</CODE> is defined as a
subtype of <CODE>SRC_NODE_C</CODE>, literals will inherit the <CODE>lx_node_s</CODE>
attribute, but the value will be the empty sequence. 

<P>  <PRE>LITERAL = M3AST_LX.LITERAL;

REVEAL
  M3AST_LX.LITERAL &lt;: EXP;

TYPE
  <A HREF="../astall/M3AST_all.i3#NUMERIC_LITERAL">NUMERIC_LITERAL</A> &lt;: M3AST_LX.LITERAL;

  <A HREF="../astall/M3AST_all.i3#Integer_literal">Integer_literal</A> &lt;: NUMERIC_LITERAL;
  <A HREF="../astall/M3AST_all.i3#Real_literal">Real_literal</A> &lt;: NUMERIC_LITERAL;
  <A HREF="../astall/M3AST_all.i3#LongReal_literal">LongReal_literal</A> &lt;: NUMERIC_LITERAL;
  <A HREF="../astall/M3AST_all.i3#Extended_literal">Extended_literal</A> &lt;: NUMERIC_LITERAL;

  <A HREF="../astall/M3AST_all.i3#Char_literal">Char_literal</A> &lt;: M3AST_LX.LITERAL;
  <A HREF="../astall/M3AST_all.i3#Text_literal">Text_literal</A> &lt;: M3AST_LX.LITERAL;
</PRE> Although we could simply represent <CODE>NIL</CODE> by an <CODE>Exp_used_id</CODE>, it
occurs sufficiently frequently that we choose to denote it by a
unique subtype, <CODE>Nil_literal</CODE> 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Nil_literal">Nil_literal</A> &lt;: M3AST_LX.LITERAL;
</PRE> Single identifiers occurring in expressions are really subtypes of
<CODE>EXP</CODE> and <CODE>USED_ID</CODE>. They are declared as subtypes of <CODE>EXP</CODE>, with the
<CODE>USED_ID</CODE> attributes <CODE>multiply inherited</CODE>  <PRE><A HREF="../astall/M3AST_all.i3#Exp_used_id">Exp_used_id</A> &lt;: EXP;

  &lt;* FIELDS OF Exp_used_id vUSED_ID: USED_ID; *&gt;
</PRE> Procedure call is denoted by a <CODE>Call</CODE> node. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Call">Call</A> &lt;: EXP;
  &lt;* FIELDS OF Call
     as_callexp: EXP;
     as_param_s: SEQUENCE OF Actual *&gt;
</PRE> The built-in functions, e.g. <CODE>ABS</CODE>, could be represented by 
unique node types, like <CODE>Plus</CODE>. However, to reduce the number of node
types, they are represented by <CODE>Call</CODE> nodes. An implementation
of this interface is expected to provide appropriate support for
determining if a <CODE>Call</CODE> node denotes a built-in function. 

<P> The desugaring of <CODE>NEW(ObjectType, method := P)</CODE> is made easier if
the applications of NEW are denoted by an independent subtype. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#NEWCall">NEWCall</A> &lt;: Call;
</PRE> Since it is legal for an actual parameter to some of the built-in
functions to be a type, <CODE>as_exp_type</CODE> is of class <CODE>EXP_TYPE</CODE>.  The
value of <CODE>as_id</CODE> will be <CODE>NIL</CODE> for the built-in functions.  

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Actual">Actual</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF Actual
       as_id: EXP_NULL;
       as_exp_type: EXP_TYPE *&gt;

  <A HREF="../astall/M3AST_all.i3#Index">Index</A> &lt;: EXP;    (* a[x,y,z,...] *)
  &lt;* FIELDS OF Index
     as_array: EXP;
     as_exp_s: SEQUENCE OF EXP *&gt;
</PRE> <CODE>ARRAY</CODE>, <CODE>RECORD</CODE> and <CODE>SET</CODE> constructors are not distinguished in the
AST, since they are not, in general, distinguished by syntax alone.
The different kinds of elements are denoted by the class <CODE>CONS_ELEM</CODE>.
Array element propagation is denoted a node of type <CODE>Propagate</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Constructor">Constructor</A> &lt;: EXP;
  &lt;* FIELDS OF Constructor
     as_type: M3TYPE;
     as_element_s: SEQUENCE OF CONS_ELEM;
     as_propagate: Propagate_NULL *&gt;

  <A HREF="../astall/M3AST_all.i3#Propagate">Propagate</A> &lt;: SRC_NODE_C;
  Propagate_NULL = Propagate;
</PRE> There are three different kinds of constructor elements, simple
expressions, ranges and keyword actuals. We use the already declared
types <CODE>RANGE_EXP</CODE> and <CODE>Actual</CODE> as the corresponding attribute types.


<P>  <PRE><A HREF="../astall/M3AST_all.i3#CONS_ELEM">CONS_ELEM</A> &lt;: SRC_NODE_C;

  <A HREF="../astall/M3AST_all.i3#RANGE_EXP_elem">RANGE_EXP_elem</A> &lt;: CONS_ELEM;
  &lt;* FIELDS OF RANGE_EXP_elem
    as_range_exp: RANGE_EXP; *&gt;

  <A HREF="../astall/M3AST_all.i3#Actual_elem">Actual_elem</A> &lt;: CONS_ELEM;
  &lt;* FIELDS OF Actual_elem
     as_actual: Actual *&gt;
</PRE> The binary and unary operators are encode as subtypes of the
<CODE>BINARY</CODE> and <CODE>UNARY</CODE> classes. Selection,``.'', is not treated as a
binary operator. It is defined as a separate subtype of <CODE>EXP</CODE>, because
it is almost always processed in a different manner to the other
binary operations. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#BINARY">BINARY</A> &lt;: EXP;
  &lt;* FIELDS OF BINARY
     as_exp1: EXP;
     as_exp2: EXP *&gt;

  <A HREF="../astall/M3AST_all.i3#Plus">Plus</A> &lt;: BINARY;    (* + *)
  <A HREF="../astall/M3AST_all.i3#Minus">Minus</A> &lt;: BINARY;   (* - *)
  <A HREF="../astall/M3AST_all.i3#Times">Times</A> &lt;: BINARY;   (* * *)
  <A HREF="../astall/M3AST_all.i3#Rdiv">Rdiv</A> &lt;: BINARY;    (* / *)
  <A HREF="../astall/M3AST_all.i3#Textcat">Textcat</A> &lt;: BINARY; (* &amp; *)
  <A HREF="../astall/M3AST_all.i3#Div">Div</A> &lt;: BINARY;     (* DIV *)
  <A HREF="../astall/M3AST_all.i3#Mod">Mod</A> &lt;: BINARY;     (* MOD *)
  <A HREF="../astall/M3AST_all.i3#Eq">Eq</A> &lt;: BINARY;      (* = *)
  <A HREF="../astall/M3AST_all.i3#Ne">Ne</A> &lt;: BINARY;      (* # *)
  <A HREF="../astall/M3AST_all.i3#Gt">Gt</A> &lt;: BINARY;      (* &gt; *)
  <A HREF="../astall/M3AST_all.i3#Lt">Lt</A> &lt;: BINARY;      (* &lt; *)
  <A HREF="../astall/M3AST_all.i3#Ge">Ge</A> &lt;: BINARY;      (* &gt;= *)
  <A HREF="../astall/M3AST_all.i3#Le">Le</A> &lt;: BINARY;      (* &lt;= *)
  <A HREF="../astall/M3AST_all.i3#And">And</A> &lt;: BINARY;     (* AND *)
  <A HREF="../astall/M3AST_all.i3#Or">Or</A> &lt;: BINARY;      (* OR *)
  <A HREF="../astall/M3AST_all.i3#In">In</A> &lt;: BINARY;      (* IN *)

  <A HREF="../astall/M3AST_all.i3#UNARY">UNARY</A> &lt;: EXP;
  &lt;* FIELDS OF UNARY
     as_exp: EXP *&gt;

  <A HREF="../astall/M3AST_all.i3#Not">Not</A> &lt;: UNARY;        (* NOT *)
  <A HREF="../astall/M3AST_all.i3#Unaryplus">Unaryplus</A> &lt;: UNARY;  (* + *)
  <A HREF="../astall/M3AST_all.i3#Unaryminus">Unaryminus</A> &lt;: UNARY; (* - *)
  <A HREF="../astall/M3AST_all.i3#Deref">Deref</A> &lt;: UNARY;      (* ^ *)

  <A HREF="../astall/M3AST_all.i3#Select">Select</A> &lt;: EXP;  (* . *)
  &lt;* FIELDS OF Select
     as_exp: EXP;
     as_id: Exp_used_id *&gt;
</PRE> \subsubsection{Statements} 

<P> The <CODE>STM</CODE> class captures all possible statement productions. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#STM">STM</A> &lt;: SRC_NODE_C;
</PRE> Statements partition into two groups, those with <CODE>a sequence of statements</CODE>
   as an attribute, e.g. <CODE>WHILE</CODE>, and those which do not, e.g. <CODE>RAISE</CODE>.
   The class <CODE>STM_WSS</CODE> contains the former group. Some statements contain 
   a component that, although it cannot appear where a <CODE>STM</CODE> can, also
   contains <CODE>a sequence of statements</CODE>, e.g. the <CODE>ELSE</CODE> clause in a <CODE>CASE</CODE>
   statement. These nodes are grouped into the class <CODE>SUBSTM_WSS</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#STM_WSS">STM_WSS</A> &lt;: STM;
  &lt;* FIELDS OF STM_WSS
    as_stm_s: SEQUENCE OF STM; *&gt;

  <A HREF="../astall/M3AST_all.i3#SUBSTM_WSS">SUBSTM_WSS</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF SUBSTM_WSS
    as_stm_s: SEQUENCE OF STM; *&gt;

  <A HREF="../astall/M3AST_all.i3#Assign_st">Assign_st</A> &lt;: STM;
  &lt;* FIELDS OF Assign_st
     as_lhs_exp: EXP;
     as_rhs_exp: EXP *&gt;

  <A HREF="../astall/M3AST_all.i3#Call_st">Call_st</A> &lt;: STM;
  &lt;* FIELDS OF Call_st
     as_call: Call; *&gt;

  <A HREF="../astall/M3AST_all.i3#Case_st">Case_st</A> &lt;: STM;
  &lt;* FIELDS OF Case_st
     as_exp: EXP;
     as_case_s: SEQUENCE OF Case;
     as_else: Else_stm_NULL; *&gt;

  <A HREF="../astall/M3AST_all.i3#Case">Case</A> &lt;: SUBSTM_WSS;
  &lt;* FIELDS OF Case
    as_case_label_s: SEQUENCE OF RANGE_EXP; *&gt;

  <A HREF="../astall/M3AST_all.i3#Else_stm">Else_stm</A> &lt;: SUBSTM_WSS;
  Else_stm_NULL = Else_stm;

  <A HREF="../astall/M3AST_all.i3#Eval_st">Eval_st</A> &lt;: STM;
  &lt;* FIELDS OF Eval_st
    as_exp: EXP; *&gt;

  <A HREF="../astall/M3AST_all.i3#Exit_st">Exit_st</A> &lt;: STM;

  <A HREF="../astall/M3AST_all.i3#Raise_st">Raise_st</A> &lt;: STM;
  &lt;* FIELDS OF Raise_st
     as_qual_id: Qual_used_id;
     as_exp_void: EXP_NULL *&gt;

  <A HREF="../astall/M3AST_all.i3#Typecase_st">Typecase_st</A> &lt;: STM;
  &lt;* FIELDS OF Typecase_st
     as_exp: EXP;
     as_tcase_s: SEQUENCE OF Tcase;
     as_else: Else_stm_NULL; *&gt;

  <A HREF="../astall/M3AST_all.i3#Tcase">Tcase</A> &lt;: SUBSTM_WSS;
  &lt;* FIELDS OF Tcase
     as_type_s: SEQUENCE OF M3TYPE;
     as_id: Tcase_id_NULL *&gt;

  <A HREF="../astall/M3AST_all.i3#Handler">Handler</A> &lt;: SUBSTM_WSS;
  &lt;* FIELDS OF Handler
     as_qual_id_s: SEQUENCE OF Qual_used_id;
     as_id: Handler_id_NULL *&gt;

  <A HREF="../astall/M3AST_all.i3#Return_st">Return_st</A> &lt;: STM;
  &lt;* FIELDS OF Return_st
    as_exp: EXP_NULL; *&gt;

  <A HREF="../astall/M3AST_all.i3#For_st">For_st</A> &lt;: STM_WSS;
  &lt;* FIELDS OF For_st
     as_id: For_id;
     as_from: EXP;
     as_to: EXP;
     as_by: By_NULL; *&gt;

  <A HREF="../astall/M3AST_all.i3#By">By</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF By
    as_exp: EXP; *&gt;
  By_NULL = By;

  <A HREF="../astall/M3AST_all.i3#If_st">If_st</A> &lt;: STM_WSS;
  &lt;* FIELDS OF If_st
     as_exp: EXP;
     as_elsif_s: SEQUENCE OF Elsif;
     as_else: Else_stm_NULL; *&gt;

  <A HREF="../astall/M3AST_all.i3#Elsif">Elsif</A> &lt;: SUBSTM_WSS;
  &lt;* FIELDS OF Elsif
    as_exp: EXP; *&gt;

  <A HREF="../astall/M3AST_all.i3#Lock_st">Lock_st</A> &lt;: STM_WSS;
  &lt;* FIELDS OF Lock_st
     as_exp: EXP; *&gt;

  <A HREF="../astall/M3AST_all.i3#Loop_st">Loop_st</A> &lt;: STM_WSS;
  &lt;* FIELDS OF Loop_st *&gt;

  <A HREF="../astall/M3AST_all.i3#Repeat_st">Repeat_st</A> &lt;: STM_WSS;
  &lt;* FIELDS OF Repeat_st as_exp: EXP; *&gt;

  <A HREF="../astall/M3AST_all.i3#Try_st">Try_st</A> &lt;: STM_WSS;
  &lt;* FIELDS OF Try_st as_try_tail: TRY_TAIL; *&gt;

  <A HREF="../astall/M3AST_all.i3#TRY_TAIL">TRY_TAIL</A> &lt;: SUBSTM_WSS;
  <A HREF="../astall/M3AST_all.i3#Try_except">Try_except</A> &lt;: TRY_TAIL;
  &lt;* FIELDS OF Try_except
    as_handler_s: SEQUENCE OF Handler;
    as_else: Else_stm_NULL *&gt;

  <A HREF="../astall/M3AST_all.i3#Try_finally">Try_finally</A> &lt;: TRY_TAIL;

  <A HREF="../astall/M3AST_all.i3#While_st">While_st</A> &lt;: STM_WSS;
  &lt;* FIELDS OF While_st
    as_exp: EXP; *&gt;

  <A HREF="../astall/M3AST_all.i3#With_st">With_st</A> &lt;: STM_WSS;
  &lt;* FIELDS OF With_st
     as_binding_s: SEQUENCE OF Binding; *&gt;

  <A HREF="../astall/M3AST_all.i3#Binding">Binding</A> &lt;: SRC_NODE_C;
  &lt;* FIELDS OF Binding as_id: With_id;
    as_exp: EXP *&gt;

  <A HREF="../astall/M3AST_all.i3#Block">Block</A> &lt;: STM_WSS;
  &lt;* FIELDS OF Block
     as_decl_s: SEQUENCE OF DECL_REVL; *&gt;
  Block_NULL = Block;
</PRE> Syntax errors are handled in part by new subtypes of a class named
   <CODE>Bad_Class</CODE>. I.e. a syntactically incorrect AST may contain an instance
   of <CODE>Bad_Class</CODE>, wherever an attribute of type <CODE>Class</CODE> could appear. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Bad_EXP">Bad_EXP</A> &lt;: EXP;
  <A HREF="../astall/M3AST_all.i3#Bad_M3TYPE">Bad_M3TYPE</A> &lt;: M3TYPE;
  <A HREF="../astall/M3AST_all.i3#Bad_STM">Bad_STM</A> &lt;: STM;

END M3AST_AS.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
