<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST_AS_Iter.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST_AS_Iter.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3AST_AS_Iter.i3">M3AST_AS_Iter</A></implements></module>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="M3AST_AS_F.i3">M3AST_AS_F</A>;
IMPORT <A HREF="../gast/AST_Iter.i3">AST_Iter</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_IMPORTED.i3">SeqM3AST_AS_IMPORTED</A>,
    <A HREF="../../derived/SeqM3AST_AS_Used_interface_id.i3">SeqM3AST_AS_Used_interface_id</A>, <A HREF="../../derived/SeqM3AST_AS_Used_def_id.i3">SeqM3AST_AS_Used_def_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Import_item.i3">SeqM3AST_AS_Import_item</A>, <A HREF="../../derived/SeqM3AST_AS_F_Interface_id.i3">SeqM3AST_AS_F_Interface_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_REVELATION.i3">SeqM3AST_AS_REVELATION</A>, <A HREF="../../derived/SeqM3AST_AS_DECL_REVL.i3">SeqM3AST_AS_DECL_REVL</A>, <A HREF="../../derived/SeqM3AST_AS_Const_decl.i3">SeqM3AST_AS_Const_decl</A>,
    <A HREF="../../derived/SeqM3AST_AS_TYPE_DECL.i3">SeqM3AST_AS_TYPE_DECL</A>, <A HREF="../../derived/SeqM3AST_AS_Var_decl.i3">SeqM3AST_AS_Var_decl</A>, <A HREF="../../derived/SeqM3AST_AS_Exc_decl.i3">SeqM3AST_AS_Exc_decl</A>,
    <A HREF="../../derived/SeqM3AST_AS_Var_id.i3">SeqM3AST_AS_Var_id</A>, <A HREF="../../derived/SeqM3AST_AS_Enum_id.i3">SeqM3AST_AS_Enum_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Field_id.i3">SeqM3AST_AS_Field_id</A>, <A HREF="../../derived/SeqM3AST_AS_FORMAL_ID.i3">SeqM3AST_AS_FORMAL_ID</A>, <A HREF="../../derived/SeqM3AST_AS_Qual_used_id.i3">SeqM3AST_AS_Qual_used_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Fields.i3">SeqM3AST_AS_Fields</A>, <A HREF="../../derived/SeqM3AST_AS_Method.i3">SeqM3AST_AS_Method</A>, <A HREF="../../derived/SeqM3AST_AS_M3TYPE.i3">SeqM3AST_AS_M3TYPE</A>,
    <A HREF="../../derived/SeqM3AST_AS_Formal_param.i3">SeqM3AST_AS_Formal_param</A>, <A HREF="../../derived/SeqM3AST_AS_CONS_ELEM.i3">SeqM3AST_AS_CONS_ELEM</A>,
    <A HREF="../../derived/SeqM3AST_AS_EXP.i3">SeqM3AST_AS_EXP</A>, <A HREF="../../derived/SeqM3AST_AS_Actual.i3">SeqM3AST_AS_Actual</A>, <A HREF="../../derived/SeqM3AST_AS_Case.i3">SeqM3AST_AS_Case</A>, <A HREF="../../derived/SeqM3AST_AS_STM.i3">SeqM3AST_AS_STM</A>,
    <A HREF="../../derived/SeqM3AST_AS_Elsif.i3">SeqM3AST_AS_Elsif</A>, <A HREF="../../derived/SeqM3AST_AS_Tcase.i3">SeqM3AST_AS_Tcase</A>, <A HREF="../../derived/SeqM3AST_AS_Handler.i3">SeqM3AST_AS_Handler</A>,
    <A HREF="../../derived/SeqM3AST_AS_Binding.i3">SeqM3AST_AS_Binding</A>, <A HREF="../../derived/SeqM3AST_AS_RANGE_EXP.i3">SeqM3AST_AS_RANGE_EXP</A>;

IMPORT <A HREF="M3AST_AS_Iter_rep.i3">M3AST_AS_Iter_rep</A>;

PROCEDURE <A NAME="By_update"><procedure>By_update</procedure></A>(iter: By_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp := nn;

    END;
  END By_update;

PROCEDURE <A NAME="By_next"><procedure>By_next</procedure></A>(iter: By_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END By_next;

TYPE
  By_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.By;
  OVERRIDES
    next := By_next;
    update := By_update;
  END;

PROCEDURE <A NAME="Binding_update"><procedure>Binding_update</procedure></A>(iter: Binding_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_id := nn;

    | 1 =&gt;
        iter.n.as_exp := nn;

    END;
  END Binding_update;

PROCEDURE <A NAME="Binding_next"><procedure>Binding_next</procedure></A>(iter: Binding_iter; VAR r: AST.NODE): BOOLEAN RAISES {
    }=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_id;

    | 1 =&gt;
        r := iter.n.as_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Binding_next;

TYPE
  Binding_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Binding;
  OVERRIDES
    next := Binding_next;
    update := Binding_update;
  END;

PROCEDURE <A NAME="Handler_update"><procedure>Handler_update</procedure></A>(iter: Handler_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Qual_used_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Qual_used_id.Update(iter.n.as_qual_id_s, iter.iter0,
                nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_id := nn;
          RETURN ;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter1, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Handler_update;

PROCEDURE <A NAME="Handler_next"><procedure>Handler_next</procedure></A>(iter: Handler_iter; VAR r: AST.NODE): BOOLEAN RAISES {
    }=
  VAR
    node0: M3AST_AS.Qual_used_id;
    node1: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Qual_used_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_id;
          EXIT;

      | 2 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Handler_next;

TYPE
  Handler_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Handler;
    iter0: SeqM3AST_AS_Qual_used_id.Iter;
    iter1: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Handler_next;
    update := Handler_update;
  END;

PROCEDURE <A NAME="Tcase_update"><procedure>Tcase_update</procedure></A>(iter: Tcase_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_M3TYPE.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_M3TYPE.Update(iter.n.as_type_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_id := nn;
          RETURN ;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter1, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Tcase_update;

PROCEDURE <A NAME="Tcase_next"><procedure>Tcase_next</procedure></A>(iter: Tcase_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.M3TYPE;
    node1: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_M3TYPE.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_id;
          EXIT;

      | 2 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Tcase_next;

TYPE
  Tcase_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Tcase;
    iter0: SeqM3AST_AS_M3TYPE.Iter;
    iter1: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Tcase_next;
    update := Tcase_update;
  END;

PROCEDURE <A NAME="Try_finally_update"><procedure>Try_finally_update</procedure></A>(iter: Try_finally_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Try_finally_update;

PROCEDURE <A NAME="Try_finally_next"><procedure>Try_finally_next</procedure></A>(iter: Try_finally_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Try_finally_next;

TYPE
  Try_finally_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Try_finally;
    iter0: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Try_finally_next;
    update := Try_finally_update;
  END;

PROCEDURE <A NAME="Try_except_update"><procedure>Try_except_update</procedure></A>(iter: Try_except_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Handler.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Handler.Update(iter.n.as_handler_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_else := nn;
          RETURN ;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter1, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Try_except_update;

PROCEDURE <A NAME="Try_except_next"><procedure>Try_except_next</procedure></A>(iter: Try_except_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.Handler;
    node1: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Handler.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_else;
          EXIT;

      | 2 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Try_except_next;

TYPE
  Try_except_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Try_except;
    iter0: SeqM3AST_AS_Handler.Iter;
    iter1: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Try_except_next;
    update := Try_except_update;
  END;

PROCEDURE <A NAME="Elsif_update"><procedure>Elsif_update</procedure></A>(iter: Elsif_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_exp := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Elsif_update;

PROCEDURE <A NAME="Elsif_next"><procedure>Elsif_next</procedure></A>(iter: Elsif_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_exp;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Elsif_next;

TYPE
  Elsif_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Elsif;
    iter0: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Elsif_next;
    update := Elsif_update;
  END;

PROCEDURE <A NAME="Else_stm_update"><procedure>Else_stm_update</procedure></A>(iter: Else_stm_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Else_stm_update;

PROCEDURE <A NAME="Else_stm_next"><procedure>Else_stm_next</procedure></A>(iter: Else_stm_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Else_stm_next;

TYPE
  Else_stm_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Else_stm;
    iter0: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Else_stm_next;
    update := Else_stm_update;
  END;

PROCEDURE <A NAME="Case_update"><procedure>Case_update</procedure></A>(iter: Case_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_RANGE_EXP.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_RANGE_EXP.Update(iter.n.as_case_label_s, iter.iter0,
                nn);
            RETURN ;
          END;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter1, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Case_update;

PROCEDURE <A NAME="Case_next"><procedure>Case_next</procedure></A>(iter: Case_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.RANGE_EXP;
    node1: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_RANGE_EXP.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Case_next;

TYPE
  Case_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Case;
    iter0: SeqM3AST_AS_RANGE_EXP.Iter;
    iter1: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Case_next;
    update := Case_update;
  END;

PROCEDURE <A NAME="Block_update"><procedure>Block_update</procedure></A>(iter: Block_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_DECL_REVL.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_DECL_REVL.Update(iter.n.as_decl_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter1, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Block_update;

PROCEDURE <A NAME="Block_next"><procedure>Block_next</procedure></A>(iter: Block_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.DECL_REVL;
    node1: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_DECL_REVL.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Block_next;

TYPE
  Block_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Block;
    iter0: SeqM3AST_AS_DECL_REVL.Iter;
    iter1: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Block_next;
    update := Block_update;
  END;

PROCEDURE <A NAME="With_st_update"><procedure>With_st_update</procedure></A>(iter: With_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Binding.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Binding.Update(iter.n.as_binding_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter1, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END With_st_update;

PROCEDURE <A NAME="With_st_next"><procedure>With_st_next</procedure></A>(iter: With_st_iter; VAR r: AST.NODE): BOOLEAN RAISES {
    }=
  VAR
    node0: M3AST_AS.Binding;
    node1: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Binding.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END With_st_next;

TYPE
  With_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.With_st;
    iter0: SeqM3AST_AS_Binding.Iter;
    iter1: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := With_st_next;
    update := With_st_update;
  END;

PROCEDURE <A NAME="While_st_update"><procedure>While_st_update</procedure></A>(iter: While_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_exp := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END While_st_update;

PROCEDURE <A NAME="While_st_next"><procedure>While_st_next</procedure></A>(iter: While_st_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_exp;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END While_st_next;

TYPE
  While_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.While_st;
    iter0: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := While_st_next;
    update := While_st_update;
  END;

PROCEDURE <A NAME="Typecase_st_update"><procedure>Typecase_st_update</procedure></A>(iter: Typecase_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_exp := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_Tcase.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Tcase.Update(iter.n.as_tcase_s, iter.iter0, nn);
            RETURN ;
          END;

      | 2 =&gt;
          iter.n.as_else := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Typecase_st_update;

PROCEDURE <A NAME="Typecase_st_next"><procedure>Typecase_st_next</procedure></A>(iter: Typecase_st_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.Tcase;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_exp;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_Tcase.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 2 =&gt;
          r := iter.n.as_else;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Typecase_st_next;

TYPE
  Typecase_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Typecase_st;
    iter0: SeqM3AST_AS_Tcase.Iter;
  OVERRIDES
    next := Typecase_st_next;
    update := Typecase_st_update;
  END;

PROCEDURE <A NAME="Try_st_update"><procedure>Try_st_update</procedure></A>(iter: Try_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_try_tail := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Try_st_update;

PROCEDURE <A NAME="Try_st_next"><procedure>Try_st_next</procedure></A>(iter: Try_st_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_try_tail;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Try_st_next;

TYPE
  Try_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Try_st;
    iter0: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Try_st_next;
    update := Try_st_update;
  END;

PROCEDURE <A NAME="Return_st_update"><procedure>Return_st_update</procedure></A>(iter: Return_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp := nn;

    END;
  END Return_st_update;

PROCEDURE <A NAME="Return_st_next"><procedure>Return_st_next</procedure></A>(iter: Return_st_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Return_st_next;

TYPE
  Return_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Return_st;
  OVERRIDES
    next := Return_st_next;
    update := Return_st_update;
  END;

PROCEDURE <A NAME="Repeat_st_update"><procedure>Repeat_st_update</procedure></A>(iter: Repeat_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_exp := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Repeat_st_update;

PROCEDURE <A NAME="Repeat_st_next"><procedure>Repeat_st_next</procedure></A>(iter: Repeat_st_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_exp;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Repeat_st_next;

TYPE
  Repeat_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Repeat_st;
    iter0: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Repeat_st_next;
    update := Repeat_st_update;
  END;

PROCEDURE <A NAME="Raise_st_update"><procedure>Raise_st_update</procedure></A>(iter: Raise_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_qual_id := nn;

    | 1 =&gt;
        iter.n.as_exp_void := nn;

    END;
  END Raise_st_update;

PROCEDURE <A NAME="Raise_st_next"><procedure>Raise_st_next</procedure></A>(iter: Raise_st_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_qual_id;

    | 1 =&gt;
        r := iter.n.as_exp_void;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Raise_st_next;

TYPE
  Raise_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Raise_st;
  OVERRIDES
    next := Raise_st_next;
    update := Raise_st_update;
  END;

PROCEDURE <A NAME="Loop_st_update"><procedure>Loop_st_update</procedure></A>(iter: Loop_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Loop_st_update;

PROCEDURE <A NAME="Loop_st_next"><procedure>Loop_st_next</procedure></A>(iter: Loop_st_iter; VAR r: AST.NODE): BOOLEAN RAISES {
    }=
  VAR
    node0: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Loop_st_next;

TYPE
  Loop_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Loop_st;
    iter0: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Loop_st_next;
    update := Loop_st_update;
  END;

PROCEDURE <A NAME="Lock_st_update"><procedure>Lock_st_update</procedure></A>(iter: Lock_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_exp := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Lock_st_update;

PROCEDURE <A NAME="Lock_st_next"><procedure>Lock_st_next</procedure></A>(iter: Lock_st_iter; VAR r: AST.NODE): BOOLEAN RAISES {
    }=
  VAR
    node0: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_exp;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Lock_st_next;

TYPE
  Lock_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Lock_st;
    iter0: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := Lock_st_next;
    update := Lock_st_update;
  END;

PROCEDURE <A NAME="If_st_update"><procedure>If_st_update</procedure></A>(iter: If_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_exp := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_Elsif.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_Elsif.Update(iter.n.as_elsif_s, iter.iter1, nn);
            RETURN ;
          END;

      | 3 =&gt;
          iter.n.as_else := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END If_st_update;

PROCEDURE <A NAME="If_st_next"><procedure>If_st_next</procedure></A>(iter: If_st_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.STM;
    node1: M3AST_AS.Elsif;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_exp;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 2 =&gt;
          IF SeqM3AST_AS_Elsif.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      | 3 =&gt;
          r := iter.n.as_else;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END If_st_next;

TYPE
  If_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.If_st;
    iter0: SeqM3AST_AS_STM.Iter;
    iter1: SeqM3AST_AS_Elsif.Iter;
  OVERRIDES
    next := If_st_next;
    update := If_st_update;
  END;

PROCEDURE <A NAME="For_st_update"><procedure>For_st_update</procedure></A>(iter: For_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_id := nn;
          RETURN ;

      | 1 =&gt;
          iter.n.as_from := nn;
          RETURN ;

      | 2 =&gt;
          iter.n.as_to := nn;
          RETURN ;

      | 3 =&gt;
          iter.n.as_by := nn;
          RETURN ;

      | 4 =&gt;
          IF NOT SeqM3AST_AS_STM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_STM.Update(iter.n.as_stm_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END For_st_update;

PROCEDURE <A NAME="For_st_next"><procedure>For_st_next</procedure></A>(iter: For_st_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.STM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_id;
          EXIT;

      | 1 =&gt;
          r := iter.n.as_from;
          EXIT;

      | 2 =&gt;
          r := iter.n.as_to;
          EXIT;

      | 3 =&gt;
          r := iter.n.as_by;
          EXIT;

      | 4 =&gt;
          IF SeqM3AST_AS_STM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END For_st_next;

TYPE
  For_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.For_st;
    iter0: SeqM3AST_AS_STM.Iter;
  OVERRIDES
    next := For_st_next;
    update := For_st_update;
  END;

PROCEDURE <A NAME="Exit_st_update"><procedure>Exit_st_update</procedure></A>(&lt;*UNUSED*&gt; iter: Exit_st_iter;
                         &lt;*UNUSED*&gt; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    END;
  END Exit_st_update;

PROCEDURE <A NAME="Exit_st_next"><procedure>Exit_st_next</procedure></A>(&lt;*UNUSED*&gt;iter: Exit_st_iter;
                       &lt;*UNUSED*&gt;VAR r: AST.NODE): BOOLEAN RAISES {
    }=
  BEGIN
    RETURN FALSE;
  END Exit_st_next;

TYPE
  Exit_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Exit_st;
  OVERRIDES
    next := Exit_st_next;
    update := Exit_st_update;
  END;

PROCEDURE <A NAME="Eval_st_update"><procedure>Eval_st_update</procedure></A>(iter: Eval_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp := nn;

    END;
  END Eval_st_update;

PROCEDURE <A NAME="Eval_st_next"><procedure>Eval_st_next</procedure></A>(iter: Eval_st_iter; VAR r: AST.NODE): BOOLEAN RAISES {
    }=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Eval_st_next;

TYPE
  Eval_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Eval_st;
  OVERRIDES
    next := Eval_st_next;
    update := Eval_st_update;
  END;

PROCEDURE <A NAME="Case_st_update"><procedure>Case_st_update</procedure></A>(iter: Case_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_exp := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_Case.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Case.Update(iter.n.as_case_s, iter.iter0, nn);
            RETURN ;
          END;

      | 2 =&gt;
          iter.n.as_else := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Case_st_update;

PROCEDURE <A NAME="Case_st_next"><procedure>Case_st_next</procedure></A>(iter: Case_st_iter; VAR r: AST.NODE): BOOLEAN RAISES {
    }=
  VAR
    node0: M3AST_AS.Case;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_exp;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_Case.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 2 =&gt;
          r := iter.n.as_else;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Case_st_next;

TYPE
  Case_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Case_st;
    iter0: SeqM3AST_AS_Case.Iter;
  OVERRIDES
    next := Case_st_next;
    update := Case_st_update;
  END;

PROCEDURE <A NAME="Call_st_update"><procedure>Call_st_update</procedure></A>(iter: Call_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_call := nn;

    END;
  END Call_st_update;

PROCEDURE <A NAME="Call_st_next"><procedure>Call_st_next</procedure></A>(iter: Call_st_iter; VAR r: AST.NODE): BOOLEAN RAISES {
    }=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_call;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Call_st_next;

TYPE
  Call_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Call_st;
  OVERRIDES
    next := Call_st_next;
    update := Call_st_update;
  END;

PROCEDURE <A NAME="Assign_st_update"><procedure>Assign_st_update</procedure></A>(iter: Assign_st_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_lhs_exp := nn;

    | 1 =&gt;
        iter.n.as_rhs_exp := nn;

    END;
  END Assign_st_update;

PROCEDURE <A NAME="Assign_st_next"><procedure>Assign_st_next</procedure></A>(iter: Assign_st_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_lhs_exp;

    | 1 =&gt;
        r := iter.n.as_rhs_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Assign_st_next;

TYPE
  Assign_st_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Assign_st;
  OVERRIDES
    next := Assign_st_next;
    update := Assign_st_update;
  END;

PROCEDURE <A NAME="Actual_update"><procedure>Actual_update</procedure></A>(iter: Actual_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_id := nn;

    | 1 =&gt;
        iter.n.as_exp_type := nn;

    END;
  END Actual_update;

PROCEDURE <A NAME="Actual_next"><procedure>Actual_next</procedure></A>(iter: Actual_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_id;

    | 1 =&gt;
        r := iter.n.as_exp_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Actual_next;

TYPE
  Actual_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Actual;
  OVERRIDES
    next := Actual_next;
    update := Actual_update;
  END;

PROCEDURE <A NAME="Index_update"><procedure>Index_update</procedure></A>(iter: Index_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_array := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_EXP.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_EXP.Update(iter.n.as_exp_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Index_update;

PROCEDURE <A NAME="Index_next"><procedure>Index_next</procedure></A>(iter: Index_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.EXP;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_array;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_EXP.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Index_next;

TYPE
  Index_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Index;
    iter0: SeqM3AST_AS_EXP.Iter;
  OVERRIDES
    next := Index_next;
    update := Index_update;
  END;

PROCEDURE <A NAME="Call_update"><procedure>Call_update</procedure></A>(iter: Call_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_callexp := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_Actual.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Actual.Update(iter.n.as_param_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Call_update;

PROCEDURE <A NAME="Call_next"><procedure>Call_next</procedure></A>(iter: Call_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Actual;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_callexp;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_Actual.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Call_next;

TYPE
  Call_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Call;
    iter0: SeqM3AST_AS_Actual.Iter;
  OVERRIDES
    next := Call_next;
    update := Call_update;
  END;

PROCEDURE <A NAME="Select_update"><procedure>Select_update</procedure></A>(iter: Select_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp := nn;

    | 1 =&gt;
        iter.n.as_id := nn;

    END;
  END Select_update;

PROCEDURE <A NAME="Select_next"><procedure>Select_next</procedure></A>(iter: Select_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp;

    | 1 =&gt;
        r := iter.n.as_id;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Select_next;

TYPE
  Select_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Select;
  OVERRIDES
    next := Select_next;
    update := Select_update;
  END;

PROCEDURE <A NAME="UNARY_update"><procedure>UNARY_update</procedure></A>(iter: UNARY_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp := nn;

    END;
  END UNARY_update;

PROCEDURE <A NAME="UNARY_next"><procedure>UNARY_next</procedure></A>(iter: UNARY_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END UNARY_next;

TYPE
  UNARY_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.UNARY;
  OVERRIDES
    next := UNARY_next;
    update := UNARY_update;
  END;

PROCEDURE <A NAME="BINARY_update"><procedure>BINARY_update</procedure></A>(iter: BINARY_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp1 := nn;

    | 1 =&gt;
        iter.n.as_exp2 := nn;

    END;
  END BINARY_update;

PROCEDURE <A NAME="BINARY_next"><procedure>BINARY_next</procedure></A>(iter: BINARY_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp1;

    | 1 =&gt;
        r := iter.n.as_exp2;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END BINARY_next;

TYPE
  BINARY_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.BINARY;
  OVERRIDES
    next := BINARY_next;
    update := BINARY_update;
  END;

PROCEDURE <A NAME="Propagate_update"><procedure>Propagate_update</procedure></A>(iter: Propagate_iter;
                           &lt;*UNUSED*&gt; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    END;
  END Propagate_update;

PROCEDURE <A NAME="Propagate_next"><procedure>Propagate_next</procedure></A>(&lt;*UNUSED*&gt; iter: Propagate_iter; &lt;*UNUSED*&gt; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    RETURN FALSE;
  END Propagate_next;

TYPE
  Propagate_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Propagate;
  OVERRIDES
    next := Propagate_next;
    update := Propagate_update;
  END;

PROCEDURE <A NAME="Actual_elem_update"><procedure>Actual_elem_update</procedure></A>(iter: Actual_elem_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_actual := nn;

    END;
  END Actual_elem_update;

PROCEDURE <A NAME="Actual_elem_next"><procedure>Actual_elem_next</procedure></A>(iter: Actual_elem_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_actual;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Actual_elem_next;

TYPE
  Actual_elem_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Actual_elem;
  OVERRIDES
    next := Actual_elem_next;
    update := Actual_elem_update;
  END;

PROCEDURE <A NAME="RANGE_EXP_elem_update"><procedure>RANGE_EXP_elem_update</procedure></A>(iter: RANGE_EXP_elem_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_range_exp := nn;

    END;
  END RANGE_EXP_elem_update;

PROCEDURE <A NAME="RANGE_EXP_elem_next"><procedure>RANGE_EXP_elem_next</procedure></A>(iter: RANGE_EXP_elem_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_range_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END RANGE_EXP_elem_next;

TYPE
  RANGE_EXP_elem_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.RANGE_EXP_elem;
  OVERRIDES
    next := RANGE_EXP_elem_next;
    update := RANGE_EXP_elem_update;
  END;

PROCEDURE <A NAME="Constructor_update"><procedure>Constructor_update</procedure></A>(iter: Constructor_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_type := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_CONS_ELEM.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_CONS_ELEM.Update(iter.n.as_element_s, iter.iter0, nn);
            RETURN ;
          END;

      | 2 =&gt;
          iter.n.as_propagate := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Constructor_update;

PROCEDURE <A NAME="Constructor_next"><procedure>Constructor_next</procedure></A>(iter: Constructor_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.CONS_ELEM;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_type;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_CONS_ELEM.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 2 =&gt;
          r := iter.n.as_propagate;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Constructor_next;

TYPE
  Constructor_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Constructor;
    iter0: SeqM3AST_AS_CONS_ELEM.Iter;
  OVERRIDES
    next := Constructor_next;
    update := Constructor_update;
  END;

PROCEDURE <A NAME="Range_update"><procedure>Range_update</procedure></A>(iter: Range_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp1 := nn;

    | 1 =&gt;
        iter.n.as_exp2 := nn;

    END;
  END Range_update;

PROCEDURE <A NAME="Range_next"><procedure>Range_next</procedure></A>(iter: Range_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp1;

    | 1 =&gt;
        r := iter.n.as_exp2;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Range_next;

TYPE
  Range_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Range;
  OVERRIDES
    next := Range_next;
    update := Range_update;
  END;

PROCEDURE <A NAME="Range_EXP_update"><procedure>Range_EXP_update</procedure></A>(iter: Range_EXP_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp := nn;

    END;
  END Range_EXP_update;

PROCEDURE <A NAME="Range_EXP_next"><procedure>Range_EXP_next</procedure></A>(iter: Range_EXP_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Range_EXP_next;

TYPE
  Range_EXP_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Range_EXP;
  OVERRIDES
    next := Range_EXP_next;
    update := Range_EXP_update;
  END;

PROCEDURE <A NAME="Raisees_some_update"><procedure>Raisees_some_update</procedure></A>(iter: Raisees_some_iter; nn: AST.NODE) RAISES {
    }=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Qual_used_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Qual_used_id.Update(iter.n.as_raisees_s, iter.iter0,
                nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Raisees_some_update;

PROCEDURE <A NAME="Raisees_some_next"><procedure>Raisees_some_next</procedure></A>(iter: Raisees_some_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Qual_used_id;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Qual_used_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Raisees_some_next;

TYPE
  Raisees_some_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Raisees_some;
    iter0: SeqM3AST_AS_Qual_used_id.Iter;
  OVERRIDES
    next := Raisees_some_next;
    update := Raisees_some_update;
  END;

PROCEDURE <A NAME="Formal_param_update"><procedure>Formal_param_update</procedure></A>(iter: Formal_param_iter; nn: AST.NODE) RAISES {
    }=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_FORMAL_ID.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_FORMAL_ID.Update(iter.n.as_id_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_formal_type := nn;
          RETURN ;

      | 2 =&gt;
          iter.n.as_default := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Formal_param_update;

PROCEDURE <A NAME="Formal_param_next"><procedure>Formal_param_next</procedure></A>(iter: Formal_param_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.FORMAL_ID;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_FORMAL_ID.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_formal_type;
          EXIT;

      | 2 =&gt;
          r := iter.n.as_default;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Formal_param_next;

TYPE
  Formal_param_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Formal_param;
    iter0: SeqM3AST_AS_FORMAL_ID.Iter;
  OVERRIDES
    next := Formal_param_next;
    update := Formal_param_update;
  END;

PROCEDURE <A NAME="Override_update"><procedure>Override_update</procedure></A>(iter: Override_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_id := nn;

    | 1 =&gt;
        iter.n.as_default := nn;

    END;
  END Override_update;

PROCEDURE <A NAME="Override_next"><procedure>Override_next</procedure></A>(iter: Override_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_id;

    | 1 =&gt;
        r := iter.n.as_default;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Override_next;

TYPE
  Override_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Override;
  OVERRIDES
    next := Override_next;
    update := Override_update;
  END;

PROCEDURE <A NAME="Method_update"><procedure>Method_update</procedure></A>(iter: Method_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_type := nn;

    | 1 =&gt;
        iter.n.as_id := nn;

    | 2 =&gt;
        iter.n.as_default := nn;

    END;
  END Method_update;

PROCEDURE <A NAME="Method_next"><procedure>Method_next</procedure></A>(iter: Method_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_type;

    | 1 =&gt;
        r := iter.n.as_id;

    | 2 =&gt;
        r := iter.n.as_default;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Method_next;

TYPE
  Method_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Method;
  OVERRIDES
    next := Method_next;
    update := Method_update;
  END;

PROCEDURE <A NAME="Fields_update"><procedure>Fields_update</procedure></A>(iter: Fields_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Field_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Field_id.Update(iter.n.as_id_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_type := nn;
          RETURN ;

      | 2 =&gt;
          iter.n.as_default := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Fields_update;

PROCEDURE <A NAME="Fields_next"><procedure>Fields_next</procedure></A>(iter: Fields_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Field_id;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Field_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_type;
          EXIT;

      | 2 =&gt;
          r := iter.n.as_default;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Fields_next;

TYPE
  Fields_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Fields;
    iter0: SeqM3AST_AS_Field_id.Iter;
  OVERRIDES
    next := Fields_next;
    update := Fields_update;
  END;

PROCEDURE <A NAME="Brand_update"><procedure>Brand_update</procedure></A>(iter: Brand_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp := nn;

    END;
  END Brand_update;

PROCEDURE <A NAME="Brand_next"><procedure>Brand_next</procedure></A>(iter: Brand_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Brand_next;

TYPE
  Brand_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Brand;
  OVERRIDES
    next := Brand_next;
    update := Brand_update;
  END;

PROCEDURE <A NAME="Opaque_type_update"><procedure>Opaque_type_update</procedure></A>(iter: Opaque_type_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_type := nn;

    END;
  END Opaque_type_update;

PROCEDURE <A NAME="Opaque_type_next"><procedure>Opaque_type_next</procedure></A>(iter: Opaque_type_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Opaque_type_next;

TYPE
  Opaque_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Opaque_type;
  OVERRIDES
    next := Opaque_type_next;
    update := Opaque_type_update;
  END;

PROCEDURE <A NAME="Packed_type_update"><procedure>Packed_type_update</procedure></A>(iter: Packed_type_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_exp := nn;

    | 1 =&gt;
        iter.n.as_type := nn;

    END;
  END Packed_type_update;

PROCEDURE <A NAME="Packed_type_next"><procedure>Packed_type_next</procedure></A>(iter: Packed_type_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_exp;

    | 1 =&gt;
        r := iter.n.as_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Packed_type_next;

TYPE
  Packed_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Packed_type;
  OVERRIDES
    next := Packed_type_next;
    update := Packed_type_update;
  END;

PROCEDURE <A NAME="Ref_type_update"><procedure>Ref_type_update</procedure></A>(iter: Ref_type_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_trace_mode := nn;

    | 1 =&gt;
        iter.n.as_brand := nn;

    | 2 =&gt;
        iter.n.as_type := nn;

    END;
  END Ref_type_update;

PROCEDURE <A NAME="Ref_type_next"><procedure>Ref_type_next</procedure></A>(iter: Ref_type_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_trace_mode;

    | 1 =&gt;
        r := iter.n.as_brand;

    | 2 =&gt;
        r := iter.n.as_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Ref_type_next;

TYPE
  Ref_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Ref_type;
  OVERRIDES
    next := Ref_type_next;
    update := Ref_type_update;
  END;

PROCEDURE <A NAME="Procedure_type_update"><procedure>Procedure_type_update</procedure></A>(iter: Procedure_type_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Formal_param.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Formal_param.Update(iter.n.as_formal_param_s, iter.
                iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_result_type := nn;
          RETURN ;

      | 2 =&gt;
          iter.n.as_raises := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Procedure_type_update;

PROCEDURE <A NAME="Procedure_type_next"><procedure>Procedure_type_next</procedure></A>(iter: Procedure_type_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Formal_param;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Formal_param.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_result_type;
          EXIT;

      | 2 =&gt;
          r := iter.n.as_raises;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Procedure_type_next;

TYPE
  Procedure_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Procedure_type;
    iter0: SeqM3AST_AS_Formal_param.Iter;
  OVERRIDES
    next := Procedure_type_next;
    update := Procedure_type_update;
  END;

PROCEDURE <A NAME="Set_type_update"><procedure>Set_type_update</procedure></A>(iter: Set_type_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_type := nn;

    END;
  END Set_type_update;

PROCEDURE <A NAME="Set_type_next"><procedure>Set_type_next</procedure></A>(iter: Set_type_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Set_type_next;

TYPE
  Set_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Set_type;
  OVERRIDES
    next := Set_type_next;
    update := Set_type_update;
  END;

PROCEDURE <A NAME="Object_type_update"><procedure>Object_type_update</procedure></A>(iter: Object_type_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_ancestor := nn;
          RETURN ;

      | 1 =&gt;
          iter.n.as_brand := nn;
          RETURN ;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_Fields.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Fields.Update(iter.n.as_fields_s, iter.iter0, nn);
            RETURN ;
          END;

      | 3 =&gt;
          IF NOT SeqM3AST_AS_Method.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_Method.Update(iter.n.as_method_s, iter.iter1, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Object_type_update;

PROCEDURE <A NAME="Object_type_next"><procedure>Object_type_next</procedure></A>(iter: Object_type_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.Fields;
    node1: M3AST_AS.Method;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_ancestor;
          EXIT;

      | 1 =&gt;
          r := iter.n.as_brand;
          EXIT;

      | 2 =&gt;
          IF SeqM3AST_AS_Fields.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 3 =&gt;
          IF SeqM3AST_AS_Method.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Object_type_next;

TYPE
  Object_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Object_type;
    iter0: SeqM3AST_AS_Fields.Iter;
    iter1: SeqM3AST_AS_Method.Iter;
  OVERRIDES
    next := Object_type_next;
    update := Object_type_update;
  END;

PROCEDURE <A NAME="Record_type_update"><procedure>Record_type_update</procedure></A>(iter: Record_type_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Fields.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Fields.Update(iter.n.as_fields_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Record_type_update;

PROCEDURE <A NAME="Record_type_next"><procedure>Record_type_next</procedure></A>(iter: Record_type_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.Fields;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Fields.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Record_type_next;

TYPE
  Record_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Record_type;
    iter0: SeqM3AST_AS_Fields.Iter;
  OVERRIDES
    next := Record_type_next;
    update := Record_type_update;
  END;

PROCEDURE <A NAME="Array_type_update"><procedure>Array_type_update</procedure></A>(iter: Array_type_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_M3TYPE.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_M3TYPE.Update(iter.n.as_indextype_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_elementtype := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Array_type_update;

PROCEDURE <A NAME="Array_type_next"><procedure>Array_type_next</procedure></A>(iter: Array_type_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.M3TYPE;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_M3TYPE.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_elementtype;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Array_type_next;

TYPE
  Array_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Array_type;
    iter0: SeqM3AST_AS_M3TYPE.Iter;
  OVERRIDES
    next := Array_type_next;
    update := Array_type_update;
  END;

PROCEDURE <A NAME="Subrange_type_update"><procedure>Subrange_type_update</procedure></A>(iter: Subrange_type_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_range := nn;

    END;
  END Subrange_type_update;

PROCEDURE <A NAME="Subrange_type_next"><procedure>Subrange_type_next</procedure></A>(iter: Subrange_type_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_range;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Subrange_type_next;

TYPE
  Subrange_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Subrange_type;
  OVERRIDES
    next := Subrange_type_next;
    update := Subrange_type_update;
  END;

PROCEDURE <A NAME="Enumeration_type_update"><procedure>Enumeration_type_update</procedure></A>(iter: Enumeration_type_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Enum_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Enum_id.Update(iter.n.as_id_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Enumeration_type_update;

PROCEDURE <A NAME="Enumeration_type_next"><procedure>Enumeration_type_next</procedure></A>(iter: Enumeration_type_iter; VAR r: AST.NODE)
    : BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Enum_id;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Enum_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Enumeration_type_next;

TYPE
  Enumeration_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Enumeration_type;
    iter0: SeqM3AST_AS_Enum_id.Iter;
  OVERRIDES
    next := Enumeration_type_next;
    update := Enumeration_type_update;
  END;

PROCEDURE <A NAME="Root_type_update"><procedure>Root_type_update</procedure></A>(iter: Root_type_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_trace_mode := nn;

    END;
  END Root_type_update;

PROCEDURE <A NAME="Root_type_next"><procedure>Root_type_next</procedure></A>(iter: Root_type_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_trace_mode;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Root_type_next;

TYPE
  Root_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Root_type;
  OVERRIDES
    next := Root_type_next;
    update := Root_type_update;
  END;

PROCEDURE <A NAME="Named_type_update"><procedure>Named_type_update</procedure></A>(iter: Named_type_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_qual_id := nn;

    END;
  END Named_type_update;

PROCEDURE <A NAME="Named_type_next"><procedure>Named_type_next</procedure></A>(iter: Named_type_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_qual_id;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Named_type_next;

TYPE
  Named_type_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Named_type;
  OVERRIDES
    next := Named_type_next;
    update := Named_type_update;
  END;

PROCEDURE <A NAME="Concrete_reveal_update"><procedure>Concrete_reveal_update</procedure></A>(iter: Concrete_reveal_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_qual_id := nn;

    | 1 =&gt;
        iter.n.as_type := nn;

    END;
  END Concrete_reveal_update;

PROCEDURE <A NAME="Concrete_reveal_next"><procedure>Concrete_reveal_next</procedure></A>(iter: Concrete_reveal_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_qual_id;

    | 1 =&gt;
        r := iter.n.as_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Concrete_reveal_next;

TYPE
  Concrete_reveal_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Concrete_reveal;
  OVERRIDES
    next := Concrete_reveal_next;
    update := Concrete_reveal_update;
  END;

PROCEDURE <A NAME="Subtype_reveal_update"><procedure>Subtype_reveal_update</procedure></A>(iter: Subtype_reveal_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_qual_id := nn;

    | 1 =&gt;
        iter.n.as_type := nn;

    END;
  END Subtype_reveal_update;

PROCEDURE <A NAME="Subtype_reveal_next"><procedure>Subtype_reveal_next</procedure></A>(iter: Subtype_reveal_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_qual_id;

    | 1 =&gt;
        r := iter.n.as_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Subtype_reveal_next;

TYPE
  Subtype_reveal_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Subtype_reveal;
  OVERRIDES
    next := Subtype_reveal_next;
    update := Subtype_reveal_update;
  END;

PROCEDURE <A NAME="Concrete_decl_update"><procedure>Concrete_decl_update</procedure></A>(iter: Concrete_decl_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_id := nn;

    | 1 =&gt;
        iter.n.as_type := nn;

    END;
  END Concrete_decl_update;

PROCEDURE <A NAME="Concrete_decl_next"><procedure>Concrete_decl_next</procedure></A>(iter: Concrete_decl_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_id;

    | 1 =&gt;
        r := iter.n.as_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Concrete_decl_next;

TYPE
  Concrete_decl_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Concrete_decl;
  OVERRIDES
    next := Concrete_decl_next;
    update := Concrete_decl_update;
  END;

PROCEDURE <A NAME="Subtype_decl_update"><procedure>Subtype_decl_update</procedure></A>(iter: Subtype_decl_iter; nn: AST.NODE) RAISES {
    }=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_id := nn;

    | 1 =&gt;
        iter.n.as_type := nn;

    END;
  END Subtype_decl_update;

PROCEDURE <A NAME="Subtype_decl_next"><procedure>Subtype_decl_next</procedure></A>(iter: Subtype_decl_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_id;

    | 1 =&gt;
        r := iter.n.as_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Subtype_decl_next;

TYPE
  Subtype_decl_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Subtype_decl;
  OVERRIDES
    next := Subtype_decl_next;
    update := Subtype_decl_update;
  END;

PROCEDURE <A NAME="Exc_decl_update"><procedure>Exc_decl_update</procedure></A>(iter: Exc_decl_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_id := nn;

    | 1 =&gt;
        iter.n.as_type := nn;

    END;
  END Exc_decl_update;

PROCEDURE <A NAME="Exc_decl_next"><procedure>Exc_decl_next</procedure></A>(iter: Exc_decl_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_id;

    | 1 =&gt;
        r := iter.n.as_type;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Exc_decl_next;

TYPE
  Exc_decl_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Exc_decl;
  OVERRIDES
    next := Exc_decl_next;
    update := Exc_decl_update;
  END;

PROCEDURE <A NAME="Var_decl_update"><procedure>Var_decl_update</procedure></A>(iter: Var_decl_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Var_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Var_id.Update(iter.n.as_id_s, iter.iter0, nn);
            RETURN ;
          END;

      | 1 =&gt;
          iter.n.as_type := nn;
          RETURN ;

      | 2 =&gt;
          iter.n.as_default := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Var_decl_update;

PROCEDURE <A NAME="Var_decl_next"><procedure>Var_decl_next</procedure></A>(iter: Var_decl_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.Var_id;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Var_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 1 =&gt;
          r := iter.n.as_type;
          EXIT;

      | 2 =&gt;
          r := iter.n.as_default;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Var_decl_next;

TYPE
  Var_decl_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Var_decl;
    iter0: SeqM3AST_AS_Var_id.Iter;
  OVERRIDES
    next := Var_decl_next;
    update := Var_decl_update;
  END;

PROCEDURE <A NAME="Const_decl_update"><procedure>Const_decl_update</procedure></A>(iter: Const_decl_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_id := nn;

    | 1 =&gt;
        iter.n.as_type := nn;

    | 2 =&gt;
        iter.n.as_exp := nn;

    END;
  END Const_decl_update;

PROCEDURE <A NAME="Const_decl_next"><procedure>Const_decl_next</procedure></A>(iter: Const_decl_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_id;

    | 1 =&gt;
        r := iter.n.as_type;

    | 2 =&gt;
        r := iter.n.as_exp;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Const_decl_next;

TYPE
  Const_decl_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Const_decl;
  OVERRIDES
    next := Const_decl_next;
    update := Const_decl_update;
  END;

PROCEDURE <A NAME="Proc_decl_update"><procedure>Proc_decl_update</procedure></A>(iter: Proc_decl_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_id := nn;

    | 1 =&gt;
        iter.n.as_type := nn;

    | 2 =&gt;
        iter.n.as_body := nn;

    END;
  END Proc_decl_update;

PROCEDURE <A NAME="Proc_decl_next"><procedure>Proc_decl_next</procedure></A>(iter: Proc_decl_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_id;

    | 1 =&gt;
        r := iter.n.as_type;

    | 2 =&gt;
        r := iter.n.as_body;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Proc_decl_next;

TYPE
  Proc_decl_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Proc_decl;
  OVERRIDES
    next := Proc_decl_next;
    update := Proc_decl_update;
  END;

PROCEDURE <A NAME="Exc_decl_s_update"><procedure>Exc_decl_s_update</procedure></A>(iter: Exc_decl_s_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          IF NOT SeqM3AST_AS_Exc_decl.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Exc_decl.Update(iter.n.as_exc_decl_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Exc_decl_s_update;

PROCEDURE <A NAME="Exc_decl_s_next"><procedure>Exc_decl_s_next</procedure></A>(iter: Exc_decl_s_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.Exc_decl;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Exc_decl.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Exc_decl_s_next;

TYPE
  Exc_decl_s_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Exc_decl_s;
    iter0: SeqM3AST_AS_Exc_decl.Iter;
  OVERRIDES
    next := Exc_decl_s_next;
    update := Exc_decl_s_update;
  END;

PROCEDURE <A NAME="Var_decl_s_update"><procedure>Var_decl_s_update</procedure></A>(iter: Var_decl_s_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
        IF NOT SeqM3AST_AS_Var_decl.Exhausted(iter.iter0) THEN
          SeqM3AST_AS_Var_decl.Update(iter.n.as_var_decl_s, iter.iter0, nn);
          RETURN ;
        END;
      END;
      INC(iter.slot);
    END;
  END Var_decl_s_update;

PROCEDURE <A NAME="Var_decl_s_next"><procedure>Var_decl_s_next</procedure></A>(iter: Var_decl_s_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.Var_decl;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Var_decl.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Var_decl_s_next;

TYPE
  Var_decl_s_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Var_decl_s;
    iter0: SeqM3AST_AS_Var_decl.Iter;
  OVERRIDES
    next := Var_decl_s_next;
    update := Var_decl_s_update;
  END;

PROCEDURE <A NAME="Type_decl_s_update"><procedure>Type_decl_s_update</procedure></A>(iter: Type_decl_s_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
        IF NOT SeqM3AST_AS_TYPE_DECL.Exhausted(iter.iter0) THEN
          SeqM3AST_AS_TYPE_DECL.Update(iter.n.as_type_decl_s, iter.iter0, nn);
          RETURN ;
        END;
      END;
      INC(iter.slot);
    END;
  END Type_decl_s_update;

PROCEDURE <A NAME="Type_decl_s_next"><procedure>Type_decl_s_next</procedure></A>(iter: Type_decl_s_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.TYPE_DECL;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_TYPE_DECL.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Type_decl_s_next;

TYPE
  Type_decl_s_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Type_decl_s;
    iter0: SeqM3AST_AS_TYPE_DECL.Iter;
  OVERRIDES
    next := Type_decl_s_next;
    update := Type_decl_s_update;
  END;

PROCEDURE <A NAME="Const_decl_s_update"><procedure>Const_decl_s_update</procedure></A>(iter: Const_decl_s_iter; nn: AST.NODE) RAISES {
    }=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
        IF NOT SeqM3AST_AS_Const_decl.Exhausted(iter.iter0) THEN
          SeqM3AST_AS_Const_decl.Update(iter.n.as_const_decl_s, iter.iter0,nn);
          RETURN ;
        END;
      END;
      INC(iter.slot);
    END;
  END Const_decl_s_update;

PROCEDURE <A NAME="Const_decl_s_next"><procedure>Const_decl_s_next</procedure></A>(iter: Const_decl_s_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Const_decl;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Const_decl.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Const_decl_s_next;

TYPE
  Const_decl_s_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Const_decl_s;
    iter0: SeqM3AST_AS_Const_decl.Iter;
  OVERRIDES
    next := Const_decl_s_next;
    update := Const_decl_s_update;
  END;

PROCEDURE <A NAME="Revelation_s_update"><procedure>Revelation_s_update</procedure></A>(iter: Revelation_s_iter; nn: AST.NODE) RAISES {
    }=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
        IF NOT SeqM3AST_AS_REVELATION.Exhausted(iter.iter0) THEN
          SeqM3AST_AS_REVELATION.Update(iter.n.as_reveal_s, iter.iter0, nn);
          RETURN ;
        END;
      END;
      INC(iter.slot);
    END;
  END Revelation_s_update;

PROCEDURE <A NAME="Revelation_s_next"><procedure>Revelation_s_next</procedure></A>(iter: Revelation_s_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.REVELATION;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_REVELATION.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Revelation_s_next;

TYPE
  Revelation_s_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Revelation_s;
    iter0: SeqM3AST_AS_REVELATION.Iter;
  OVERRIDES
    next := Revelation_s_next;
    update := Revelation_s_update;
  END;

PROCEDURE <A NAME="From_import_update"><procedure>From_import_update</procedure></A>(iter: From_import_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_intf_id := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_Used_def_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Used_def_id.Update(iter.n.as_id_s, iter.iter0, nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END From_import_update;

PROCEDURE <A NAME="From_import_next"><procedure>From_import_next</procedure></A>(iter: From_import_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.Used_def_id;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_intf_id;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_Used_def_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END From_import_next;

TYPE
  From_import_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.From_import;
    iter0: SeqM3AST_AS_Used_def_id.Iter;
  OVERRIDES
    next := From_import_next;
    update := From_import_update;
  END;

PROCEDURE <A NAME="Simple_import_update"><procedure>Simple_import_update</procedure></A>(iter: Simple_import_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
        IF NOT SeqM3AST_AS_Import_item.Exhausted(iter.iter0) THEN
          SeqM3AST_AS_Import_item.Update(iter.n.as_import_item_s, iter.
              iter0, nn);
          RETURN ;
        END;
      END;
      INC(iter.slot);
    END;
  END Simple_import_update;

PROCEDURE <A NAME="Simple_import_next"><procedure>Simple_import_next</procedure></A>(iter: Simple_import_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Import_item;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          IF SeqM3AST_AS_Import_item.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
  END Simple_import_next;

TYPE
  Simple_import_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Simple_import;
    iter0: SeqM3AST_AS_Import_item.Iter;
  OVERRIDES
    next := Simple_import_next;
    update := Simple_import_update;
  END;

PROCEDURE <A NAME="Import_item_update"><procedure>Import_item_update</procedure></A>(iter: Import_item_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_intf_id := nn;

    | 1 =&gt;
        iter.n.as_id := nn;

    END;
  END Import_item_update;

PROCEDURE <A NAME="Import_item_next"><procedure>Import_item_next</procedure></A>(iter: Import_item_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_intf_id;

    | 1 =&gt;
        r := iter.n.as_id;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Import_item_next;

TYPE
  Import_item_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Import_item;
  OVERRIDES
    next := Import_item_next;
    update := Import_item_update;
  END;

PROCEDURE <A NAME="Module_update"><procedure>Module_update</procedure></A>(iter: Module_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_unsafe := nn;
          RETURN ;

      | 1 =&gt;
          iter.n.as_id := nn;
          RETURN ;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_Used_interface_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Used_interface_id.Update(iter.n.as_export_s, iter.
                iter0, nn);
            RETURN ;
          END;

      | 3 =&gt;
          IF NOT SeqM3AST_AS_IMPORTED.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_IMPORTED.Update(iter.n.as_import_s, iter.iter1, nn);
            RETURN ;
          END;

      | 4 =&gt;
          iter.n.as_block := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Module_update;

PROCEDURE <A NAME="Module_next"><procedure>Module_next</procedure></A>(iter: Module_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Used_interface_id;
    node1: M3AST_AS.IMPORTED;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_unsafe;
          EXIT;

      | 1 =&gt;
          r := iter.n.as_id;
          EXIT;

      | 2 =&gt;
          IF SeqM3AST_AS_Used_interface_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 3 =&gt;
          IF SeqM3AST_AS_IMPORTED.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      | 4 =&gt;
          r := iter.n.as_block;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Module_next;

TYPE
  Module_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Module;
    iter0: SeqM3AST_AS_Used_interface_id.Iter;
    iter1: SeqM3AST_AS_IMPORTED.Iter;
  OVERRIDES
    next := Module_next;
    update := Module_update;
  END;

PROCEDURE <A NAME="Interface_update"><procedure>Interface_update</procedure></A>(iter: Interface_iter; nn: AST.NODE) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_unsafe := nn;
          RETURN ;

      | 1 =&gt;
          iter.n.as_id := nn;
          RETURN ;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_IMPORTED.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_IMPORTED.Update(iter.n.as_import_s, iter.iter0, nn);
            RETURN ;
          END;

      | 3 =&gt;
          iter.n.as_block := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Interface_update;

PROCEDURE <A NAME="Interface_next"><procedure>Interface_next</procedure></A>(iter: Interface_iter; VAR r: AST.NODE): BOOLEAN
    RAISES {}=
  VAR
    node0: M3AST_AS.IMPORTED;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_unsafe;
          EXIT;

      | 1 =&gt;
          r := iter.n.as_id;
          EXIT;

      | 2 =&gt;
          IF SeqM3AST_AS_IMPORTED.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 3 =&gt;
          r := iter.n.as_block;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Interface_next;

TYPE
  Interface_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Interface;
    iter0: SeqM3AST_AS_IMPORTED.Iter;
  OVERRIDES
    next := Interface_next;
    update := Interface_update;
  END;

PROCEDURE <A NAME="Module_gen_ins_update"><procedure>Module_gen_ins_update</procedure></A>(iter: Module_gen_ins_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_unsafe := nn;
          RETURN ;

      | 1 =&gt;
          iter.n.as_id := nn;
          RETURN ;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_Used_interface_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Used_interface_id.Update(iter.n.as_export_s, iter.
                iter0, nn);
            RETURN ;
          END;

      | 3 =&gt;
          iter.n.as_gen_id := nn;
          RETURN ;

      | 4 =&gt;
          IF NOT SeqM3AST_AS_Used_interface_id.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_Used_interface_id.Update(iter.n.as_id_s, iter.iter1,
                nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Module_gen_ins_update;

PROCEDURE <A NAME="Module_gen_ins_next"><procedure>Module_gen_ins_next</procedure></A>(iter: Module_gen_ins_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Used_interface_id;
    node1: M3AST_AS.Used_interface_id;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_unsafe;
          EXIT;

      | 1 =&gt;
          r := iter.n.as_id;
          EXIT;

      | 2 =&gt;
          IF SeqM3AST_AS_Used_interface_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 3 =&gt;
          r := iter.n.as_gen_id;
          EXIT;

      | 4 =&gt;
          IF SeqM3AST_AS_Used_interface_id.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Module_gen_ins_next;

TYPE
  Module_gen_ins_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Module_gen_ins;
    iter0: SeqM3AST_AS_Used_interface_id.Iter;
    iter1: SeqM3AST_AS_Used_interface_id.Iter;
  OVERRIDES
    next := Module_gen_ins_next;
    update := Module_gen_ins_update;
  END;

PROCEDURE <A NAME="Interface_gen_ins_update"><procedure>Interface_gen_ins_update</procedure></A>(iter: Interface_gen_ins_iter; nn: AST.NODE
    ) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_unsafe := nn;
          RETURN ;

      | 1 =&gt;
          iter.n.as_id := nn;
          RETURN ;

      | 2 =&gt;
          iter.n.as_gen_id := nn;
          RETURN ;

      | 3 =&gt;
          IF NOT SeqM3AST_AS_Used_interface_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_Used_interface_id.Update(iter.n.as_id_s, iter.iter0,
                nn);
            RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Interface_gen_ins_update;

PROCEDURE <A NAME="Interface_gen_ins_next"><procedure>Interface_gen_ins_next</procedure></A>(iter: Interface_gen_ins_iter;
    VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Used_interface_id;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_unsafe;
          EXIT;

      | 1 =&gt;
          r := iter.n.as_id;
          EXIT;

      | 2 =&gt;
          r := iter.n.as_gen_id;
          EXIT;

      | 3 =&gt;
          IF SeqM3AST_AS_Used_interface_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Interface_gen_ins_next;

TYPE
  Interface_gen_ins_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Interface_gen_ins;
    iter0: SeqM3AST_AS_Used_interface_id.Iter;
  OVERRIDES
    next := Interface_gen_ins_next;
    update := Interface_gen_ins_update;
  END;

PROCEDURE <A NAME="Module_gen_def_update"><procedure>Module_gen_def_update</procedure></A>(iter: Module_gen_def_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_id := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_F_Interface_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_F_Interface_id.Update(iter.n.as_id_s, iter.iter0, nn);
            RETURN ;
          END;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_IMPORTED.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_IMPORTED.Update(iter.n.as_import_s, iter.iter1, nn);
            RETURN ;
          END;

      | 3 =&gt;
          iter.n.as_block := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Module_gen_def_update;

PROCEDURE <A NAME="Module_gen_def_next"><procedure>Module_gen_def_next</procedure></A>(iter: Module_gen_def_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.F_Interface_id;
    node1: M3AST_AS.IMPORTED;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_id;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_F_Interface_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 2 =&gt;
          IF SeqM3AST_AS_IMPORTED.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      | 3 =&gt;
          r := iter.n.as_block;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Module_gen_def_next;

TYPE
  Module_gen_def_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Module_gen_def;
    iter0: SeqM3AST_AS_F_Interface_id.Iter;
    iter1: SeqM3AST_AS_IMPORTED.Iter;
  OVERRIDES
    next := Module_gen_def_next;
    update := Module_gen_def_update;
  END;

PROCEDURE <A NAME="Interface_gen_def_update"><procedure>Interface_gen_def_update</procedure></A>(iter: Interface_gen_def_iter; nn: AST.NODE
    ) RAISES {}=
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      | 0 =&gt;
          iter.n.as_id := nn;
          RETURN ;

      | 1 =&gt;
          IF NOT SeqM3AST_AS_F_Interface_id.Exhausted(iter.iter0) THEN
            SeqM3AST_AS_F_Interface_id.Update(iter.n.as_id_s, iter.iter0, nn);
            RETURN ;
          END;

      | 2 =&gt;
          IF NOT SeqM3AST_AS_IMPORTED.Exhausted(iter.iter1) THEN
            SeqM3AST_AS_IMPORTED.Update(iter.n.as_import_s, iter.iter1, nn);
            RETURN ;
          END;

      | 3 =&gt;
          iter.n.as_block := nn;
          RETURN ;

      END;
      INC(iter.slot);
    END;
  END Interface_gen_def_update;

PROCEDURE <A NAME="Interface_gen_def_next"><procedure>Interface_gen_def_next</procedure></A>(iter: Interface_gen_def_iter;
    VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.F_Interface_id;
    node1: M3AST_AS.IMPORTED;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_id;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_F_Interface_id.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      | 2 =&gt;
          IF SeqM3AST_AS_IMPORTED.Next(iter.iter1, node1) THEN
            r := node1;
            RETURN TRUE;
          END;

      | 3 =&gt;
          r := iter.n.as_block;
          EXIT;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Interface_gen_def_next;

TYPE
  Interface_gen_def_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Interface_gen_def;
    iter0: SeqM3AST_AS_F_Interface_id.Iter;
    iter1: SeqM3AST_AS_IMPORTED.Iter;
  OVERRIDES
    next := Interface_gen_def_next;
    update := Interface_gen_def_update;
  END;

PROCEDURE <A NAME="Compilation_Unit_update"><procedure>Compilation_Unit_update</procedure></A>(iter: Compilation_Unit_iter; nn: AST.NODE)
    RAISES {}=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_root := nn;

    END;
  END Compilation_Unit_update;

PROCEDURE <A NAME="Compilation_Unit_next"><procedure>Compilation_Unit_next</procedure></A>(iter: Compilation_Unit_iter; VAR r: AST.NODE)
    : BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_root;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Compilation_Unit_next;

TYPE
  Compilation_Unit_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Compilation_Unit;
  OVERRIDES
    next := Compilation_Unit_next;
    update := Compilation_Unit_update;
  END;

PROCEDURE <A NAME="Qual_used_id_update"><procedure>Qual_used_id_update</procedure></A>(iter: Qual_used_id_iter; nn: AST.NODE) RAISES {
    }=
  BEGIN
    CASE iter.slot OF &lt;*NOWARN*&gt;
    | 0 =&gt;
        iter.n.as_intf_id := nn;

    | 1 =&gt;
        iter.n.as_id := nn;

    END;
  END Qual_used_id_update;

PROCEDURE <A NAME="Qual_used_id_next"><procedure>Qual_used_id_next</procedure></A>(iter: Qual_used_id_iter; VAR r: AST.NODE):
    BOOLEAN RAISES {}=
  BEGIN
    CASE iter.slot OF
    | 0 =&gt;
        r := iter.n.as_intf_id;

    | 1 =&gt;
        r := iter.n.as_id;

    ELSE
      RETURN FALSE;
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Qual_used_id_next;

TYPE
  Qual_used_id_iter = AST_Iter.T OBJECT
    n: M3AST_AS_F.Qual_used_id;
  OVERRIDES
    next := Qual_used_id_next;
    update := Qual_used_id_update;
  END;

PROCEDURE <A NAME="Qual_used_id_newIter"><procedure>Qual_used_id_newIter</procedure></A>(n: M3AST_AS_F.Qual_used_id): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Qual_used_id_iter, n := n);
  END Qual_used_id_newIter;

PROCEDURE <A NAME="Compilation_Unit_newIter"><procedure>Compilation_Unit_newIter</procedure></A>(n: M3AST_AS_F.Compilation_Unit): AST_Iter.
    T RAISES {}=
  BEGIN
    RETURN NEW(Compilation_Unit_iter, n := n);
  END Compilation_Unit_newIter;

PROCEDURE <A NAME="Interface_gen_def_newIter"><procedure>Interface_gen_def_newIter</procedure></A>(n: M3AST_AS_F.Interface_gen_def):
    AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Interface_gen_def_iter, n := n, iter0 :=
        SeqM3AST_AS_F_Interface_id.NewIter(n.as_id_s), iter1 :=
        SeqM3AST_AS_IMPORTED.NewIter(n.as_import_s));
  END Interface_gen_def_newIter;

PROCEDURE <A NAME="Module_gen_def_newIter"><procedure>Module_gen_def_newIter</procedure></A>(n: M3AST_AS_F.Module_gen_def): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Module_gen_def_iter, n := n, iter0 :=
        SeqM3AST_AS_F_Interface_id.NewIter(n.as_id_s), iter1 :=
        SeqM3AST_AS_IMPORTED.NewIter(n.as_import_s));
  END Module_gen_def_newIter;

PROCEDURE <A NAME="Interface_gen_ins_newIter"><procedure>Interface_gen_ins_newIter</procedure></A>(n: M3AST_AS_F.Interface_gen_ins):
    AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Interface_gen_ins_iter, n := n, iter0 :=
        SeqM3AST_AS_Used_interface_id.NewIter(n.as_id_s));
  END Interface_gen_ins_newIter;

PROCEDURE <A NAME="Module_gen_ins_newIter"><procedure>Module_gen_ins_newIter</procedure></A>(n: M3AST_AS_F.Module_gen_ins): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Module_gen_ins_iter, n := n, iter0 :=
        SeqM3AST_AS_Used_interface_id.NewIter(n.as_export_s), iter1 :=
        SeqM3AST_AS_Used_interface_id.NewIter(n.as_id_s));
  END Module_gen_ins_newIter;

PROCEDURE <A NAME="Interface_newIter"><procedure>Interface_newIter</procedure></A>(n: M3AST_AS_F.Interface): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Interface_iter, n := n, iter0 := SeqM3AST_AS_IMPORTED.NewIter(
        n.as_import_s));
  END Interface_newIter;

PROCEDURE <A NAME="Module_newIter"><procedure>Module_newIter</procedure></A>(n: M3AST_AS_F.Module): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Module_iter, n := n, iter0 := SeqM3AST_AS_Used_interface_id.
        NewIter(n.as_export_s), iter1 := SeqM3AST_AS_IMPORTED.NewIter(n.
        as_import_s));
  END Module_newIter;

PROCEDURE <A NAME="Import_item_newIter"><procedure>Import_item_newIter</procedure></A>(n: M3AST_AS_F.Import_item): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Import_item_iter, n := n);
  END Import_item_newIter;

PROCEDURE <A NAME="Simple_import_newIter"><procedure>Simple_import_newIter</procedure></A>(n: M3AST_AS_F.Simple_import): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Simple_import_iter, n := n, iter0 := SeqM3AST_AS_Import_item.
        NewIter(n.as_import_item_s));
  END Simple_import_newIter;

PROCEDURE <A NAME="From_import_newIter"><procedure>From_import_newIter</procedure></A>(n: M3AST_AS_F.From_import): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(From_import_iter, n := n, iter0 := SeqM3AST_AS_Used_def_id.
        NewIter(n.as_id_s));
  END From_import_newIter;

PROCEDURE <A NAME="Revelation_s_newIter"><procedure>Revelation_s_newIter</procedure></A>(n: M3AST_AS_F.Revelation_s): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Revelation_s_iter, n := n, iter0 := SeqM3AST_AS_REVELATION.
        NewIter(n.as_reveal_s));
  END Revelation_s_newIter;

PROCEDURE <A NAME="Const_decl_s_newIter"><procedure>Const_decl_s_newIter</procedure></A>(n: M3AST_AS_F.Const_decl_s): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Const_decl_s_iter, n := n, iter0 := SeqM3AST_AS_Const_decl.
        NewIter(n.as_const_decl_s));
  END Const_decl_s_newIter;

PROCEDURE <A NAME="Type_decl_s_newIter"><procedure>Type_decl_s_newIter</procedure></A>(n: M3AST_AS_F.Type_decl_s): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Type_decl_s_iter, n := n, iter0 := SeqM3AST_AS_TYPE_DECL.
        NewIter(n.as_type_decl_s));
  END Type_decl_s_newIter;

PROCEDURE <A NAME="Var_decl_s_newIter"><procedure>Var_decl_s_newIter</procedure></A>(n: M3AST_AS_F.Var_decl_s): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Var_decl_s_iter, n := n, iter0 := SeqM3AST_AS_Var_decl.NewIter
        (n.as_var_decl_s));
  END Var_decl_s_newIter;

PROCEDURE <A NAME="Exc_decl_s_newIter"><procedure>Exc_decl_s_newIter</procedure></A>(n: M3AST_AS_F.Exc_decl_s): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Exc_decl_s_iter, n := n, iter0 := SeqM3AST_AS_Exc_decl.NewIter
        (n.as_exc_decl_s));
  END Exc_decl_s_newIter;

PROCEDURE <A NAME="Proc_decl_newIter"><procedure>Proc_decl_newIter</procedure></A>(n: M3AST_AS_F.Proc_decl): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Proc_decl_iter, n := n);
  END Proc_decl_newIter;

PROCEDURE <A NAME="Const_decl_newIter"><procedure>Const_decl_newIter</procedure></A>(n: M3AST_AS_F.Const_decl): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Const_decl_iter, n := n);
  END Const_decl_newIter;

PROCEDURE <A NAME="Var_decl_newIter"><procedure>Var_decl_newIter</procedure></A>(n: M3AST_AS_F.Var_decl): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Var_decl_iter, n := n, iter0 := SeqM3AST_AS_Var_id.NewIter(n.
        as_id_s));
  END Var_decl_newIter;

PROCEDURE <A NAME="Exc_decl_newIter"><procedure>Exc_decl_newIter</procedure></A>(n: M3AST_AS_F.Exc_decl): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Exc_decl_iter, n := n);
  END Exc_decl_newIter;

PROCEDURE <A NAME="Subtype_decl_newIter"><procedure>Subtype_decl_newIter</procedure></A>(n: M3AST_AS_F.Subtype_decl): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Subtype_decl_iter, n := n);
  END Subtype_decl_newIter;

PROCEDURE <A NAME="Concrete_decl_newIter"><procedure>Concrete_decl_newIter</procedure></A>(n: M3AST_AS_F.Concrete_decl): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Concrete_decl_iter, n := n);
  END Concrete_decl_newIter;

PROCEDURE <A NAME="Subtype_reveal_newIter"><procedure>Subtype_reveal_newIter</procedure></A>(n: M3AST_AS_F.Subtype_reveal): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Subtype_reveal_iter, n := n);
  END Subtype_reveal_newIter;

PROCEDURE <A NAME="Concrete_reveal_newIter"><procedure>Concrete_reveal_newIter</procedure></A>(n: M3AST_AS_F.Concrete_reveal): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Concrete_reveal_iter, n := n);
  END Concrete_reveal_newIter;

PROCEDURE <A NAME="Named_type_newIter"><procedure>Named_type_newIter</procedure></A>(n: M3AST_AS_F.Named_type): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Named_type_iter, n := n);
  END Named_type_newIter;

PROCEDURE <A NAME="Root_type_newIter"><procedure>Root_type_newIter</procedure></A>(n: M3AST_AS_F.Root_type): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Root_type_iter, n := n);
  END Root_type_newIter;

PROCEDURE <A NAME="Enumeration_type_newIter"><procedure>Enumeration_type_newIter</procedure></A>(n: M3AST_AS_F.Enumeration_type): AST_Iter.
    T RAISES {}=
  BEGIN
    RETURN NEW(Enumeration_type_iter, n := n, iter0 := SeqM3AST_AS_Enum_id.
        NewIter(n.as_id_s));
  END Enumeration_type_newIter;

PROCEDURE <A NAME="Subrange_type_newIter"><procedure>Subrange_type_newIter</procedure></A>(n: M3AST_AS_F.Subrange_type): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Subrange_type_iter, n := n);
  END Subrange_type_newIter;

PROCEDURE <A NAME="Array_type_newIter"><procedure>Array_type_newIter</procedure></A>(n: M3AST_AS_F.Array_type): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Array_type_iter, n := n, iter0 := SeqM3AST_AS_M3TYPE.NewIter(n
        .as_indextype_s));
  END Array_type_newIter;

PROCEDURE <A NAME="Record_type_newIter"><procedure>Record_type_newIter</procedure></A>(n: M3AST_AS_F.Record_type): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Record_type_iter, n := n, iter0 := SeqM3AST_AS_Fields.NewIter(
        n.as_fields_s));
  END Record_type_newIter;

PROCEDURE <A NAME="Object_type_newIter"><procedure>Object_type_newIter</procedure></A>(n: M3AST_AS_F.Object_type): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Object_type_iter, n := n, iter0 := SeqM3AST_AS_Fields.NewIter(
        n.as_fields_s), iter1 := SeqM3AST_AS_Method.NewIter(n.as_method_s));
  END Object_type_newIter;

PROCEDURE <A NAME="Set_type_newIter"><procedure>Set_type_newIter</procedure></A>(n: M3AST_AS_F.Set_type): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Set_type_iter, n := n);
  END Set_type_newIter;

PROCEDURE <A NAME="Procedure_type_newIter"><procedure>Procedure_type_newIter</procedure></A>(n: M3AST_AS_F.Procedure_type): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Procedure_type_iter, n := n, iter0 := SeqM3AST_AS_Formal_param
        .NewIter(n.as_formal_param_s));
  END Procedure_type_newIter;

PROCEDURE <A NAME="Ref_type_newIter"><procedure>Ref_type_newIter</procedure></A>(n: M3AST_AS_F.Ref_type): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Ref_type_iter, n := n);
  END Ref_type_newIter;

PROCEDURE <A NAME="Packed_type_newIter"><procedure>Packed_type_newIter</procedure></A>(n: M3AST_AS_F.Packed_type): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Packed_type_iter, n := n);
  END Packed_type_newIter;

PROCEDURE <A NAME="Opaque_type_newIter"><procedure>Opaque_type_newIter</procedure></A>(n: M3AST_AS_F.Opaque_type): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Opaque_type_iter, n := n);
  END Opaque_type_newIter;

PROCEDURE <A NAME="Brand_newIter"><procedure>Brand_newIter</procedure></A>(n: M3AST_AS_F.Brand): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Brand_iter, n := n);
  END Brand_newIter;

PROCEDURE <A NAME="Fields_newIter"><procedure>Fields_newIter</procedure></A>(n: M3AST_AS_F.Fields): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Fields_iter, n := n, iter0 := SeqM3AST_AS_Field_id.NewIter(n.
        as_id_s));
  END Fields_newIter;

PROCEDURE <A NAME="Method_newIter"><procedure>Method_newIter</procedure></A>(n: M3AST_AS_F.Method): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Method_iter, n := n);
  END Method_newIter;

PROCEDURE <A NAME="Override_newIter"><procedure>Override_newIter</procedure></A>(n: M3AST_AS_F.Override): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Override_iter, n := n);
  END Override_newIter;

PROCEDURE <A NAME="Formal_param_newIter"><procedure>Formal_param_newIter</procedure></A>(n: M3AST_AS_F.Formal_param): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Formal_param_iter, n := n, iter0 := SeqM3AST_AS_FORMAL_ID.
        NewIter(n.as_id_s));
  END Formal_param_newIter;

PROCEDURE <A NAME="Raisees_some_newIter"><procedure>Raisees_some_newIter</procedure></A>(n: M3AST_AS_F.Raisees_some): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(Raisees_some_iter, n := n, iter0 := SeqM3AST_AS_Qual_used_id.
        NewIter(n.as_raisees_s));
  END Raisees_some_newIter;

PROCEDURE <A NAME="Range_EXP_newIter"><procedure>Range_EXP_newIter</procedure></A>(n: M3AST_AS_F.Range_EXP): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Range_EXP_iter, n := n);
  END Range_EXP_newIter;

PROCEDURE <A NAME="Range_newIter"><procedure>Range_newIter</procedure></A>(n: M3AST_AS_F.Range): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Range_iter, n := n);
  END Range_newIter;

PROCEDURE <A NAME="Constructor_newIter"><procedure>Constructor_newIter</procedure></A>(n: M3AST_AS_F.Constructor): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Constructor_iter, n := n, iter0 := SeqM3AST_AS_CONS_ELEM.
        NewIter(n.as_element_s));
  END Constructor_newIter;

PROCEDURE <A NAME="RANGE_EXP_elem_newIter"><procedure>RANGE_EXP_elem_newIter</procedure></A>(n: M3AST_AS_F.RANGE_EXP_elem): AST_Iter.T
    RAISES {}=
  BEGIN
    RETURN NEW(RANGE_EXP_elem_iter, n := n);
  END RANGE_EXP_elem_newIter;

PROCEDURE <A NAME="Actual_elem_newIter"><procedure>Actual_elem_newIter</procedure></A>(n: M3AST_AS_F.Actual_elem): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Actual_elem_iter, n := n);
  END Actual_elem_newIter;

PROCEDURE <A NAME="Propagate_newIter"><procedure>Propagate_newIter</procedure></A>(n: M3AST_AS_F.Propagate): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Propagate_iter, n := n);
  END Propagate_newIter;

PROCEDURE <A NAME="BINARY_newIter"><procedure>BINARY_newIter</procedure></A>(n: M3AST_AS_F.BINARY): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(BINARY_iter, n := n);
  END BINARY_newIter;

PROCEDURE <A NAME="UNARY_newIter"><procedure>UNARY_newIter</procedure></A>(n: M3AST_AS_F.UNARY): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(UNARY_iter, n := n);
  END UNARY_newIter;

PROCEDURE <A NAME="Select_newIter"><procedure>Select_newIter</procedure></A>(n: M3AST_AS_F.Select): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Select_iter, n := n);
  END Select_newIter;

PROCEDURE <A NAME="Call_newIter"><procedure>Call_newIter</procedure></A>(n: M3AST_AS_F.Call): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Call_iter, n := n, iter0 := SeqM3AST_AS_Actual.NewIter(n.
        as_param_s));
  END Call_newIter;

PROCEDURE <A NAME="Index_newIter"><procedure>Index_newIter</procedure></A>(n: M3AST_AS_F.Index): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Index_iter, n := n, iter0 := SeqM3AST_AS_EXP.NewIter(n.
        as_exp_s));
  END Index_newIter;

PROCEDURE <A NAME="Actual_newIter"><procedure>Actual_newIter</procedure></A>(n: M3AST_AS_F.Actual): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Actual_iter, n := n);
  END Actual_newIter;

PROCEDURE <A NAME="Assign_st_newIter"><procedure>Assign_st_newIter</procedure></A>(n: M3AST_AS_F.Assign_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Assign_st_iter, n := n);
  END Assign_st_newIter;

PROCEDURE <A NAME="Call_st_newIter"><procedure>Call_st_newIter</procedure></A>(n: M3AST_AS_F.Call_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Call_st_iter, n := n);
  END Call_st_newIter;

PROCEDURE <A NAME="Case_st_newIter"><procedure>Case_st_newIter</procedure></A>(n: M3AST_AS_F.Case_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Case_st_iter, n := n, iter0 := SeqM3AST_AS_Case.NewIter(n.
        as_case_s));
  END Case_st_newIter;

PROCEDURE <A NAME="Eval_st_newIter"><procedure>Eval_st_newIter</procedure></A>(n: M3AST_AS_F.Eval_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Eval_st_iter, n := n);
  END Eval_st_newIter;

PROCEDURE <A NAME="Exit_st_newIter"><procedure>Exit_st_newIter</procedure></A>(n: M3AST_AS_F.Exit_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Exit_st_iter, n := n);
  END Exit_st_newIter;

PROCEDURE <A NAME="For_st_newIter"><procedure>For_st_newIter</procedure></A>(n: M3AST_AS_F.For_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(For_st_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s));
  END For_st_newIter;

PROCEDURE <A NAME="If_st_newIter"><procedure>If_st_newIter</procedure></A>(n: M3AST_AS_F.If_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(If_st_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s), iter1 := SeqM3AST_AS_Elsif.NewIter(n.as_elsif_s));
  END If_st_newIter;

PROCEDURE <A NAME="Lock_st_newIter"><procedure>Lock_st_newIter</procedure></A>(n: M3AST_AS_F.Lock_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Lock_st_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s));
  END Lock_st_newIter;

PROCEDURE <A NAME="Loop_st_newIter"><procedure>Loop_st_newIter</procedure></A>(n: M3AST_AS_F.Loop_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Loop_st_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s));
  END Loop_st_newIter;

PROCEDURE <A NAME="Raise_st_newIter"><procedure>Raise_st_newIter</procedure></A>(n: M3AST_AS_F.Raise_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Raise_st_iter, n := n);
  END Raise_st_newIter;

PROCEDURE <A NAME="Repeat_st_newIter"><procedure>Repeat_st_newIter</procedure></A>(n: M3AST_AS_F.Repeat_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Repeat_st_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s));
  END Repeat_st_newIter;

PROCEDURE <A NAME="Return_st_newIter"><procedure>Return_st_newIter</procedure></A>(n: M3AST_AS_F.Return_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Return_st_iter, n := n);
  END Return_st_newIter;

PROCEDURE <A NAME="Try_st_newIter"><procedure>Try_st_newIter</procedure></A>(n: M3AST_AS_F.Try_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Try_st_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s));
  END Try_st_newIter;

PROCEDURE <A NAME="Typecase_st_newIter"><procedure>Typecase_st_newIter</procedure></A>(n: M3AST_AS_F.Typecase_st): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Typecase_st_iter, n := n, iter0 := SeqM3AST_AS_Tcase.NewIter(n
        .as_tcase_s));
  END Typecase_st_newIter;

PROCEDURE <A NAME="While_st_newIter"><procedure>While_st_newIter</procedure></A>(n: M3AST_AS_F.While_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(While_st_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s));
  END While_st_newIter;

PROCEDURE <A NAME="With_st_newIter"><procedure>With_st_newIter</procedure></A>(n: M3AST_AS_F.With_st): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(With_st_iter, n := n, iter0 := SeqM3AST_AS_Binding.NewIter(n.
        as_binding_s), iter1 := SeqM3AST_AS_STM.NewIter(n.as_stm_s));
  END With_st_newIter;

PROCEDURE <A NAME="Block_newIter"><procedure>Block_newIter</procedure></A>(n: M3AST_AS_F.Block): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Block_iter, n := n, iter0 := SeqM3AST_AS_DECL_REVL.NewIter(n.
        as_decl_s), iter1 := SeqM3AST_AS_STM.NewIter(n.as_stm_s));
  END Block_newIter;

PROCEDURE <A NAME="Case_newIter"><procedure>Case_newIter</procedure></A>(n: M3AST_AS_F.Case): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Case_iter, n := n, iter0 := SeqM3AST_AS_RANGE_EXP.NewIter(n.
        as_case_label_s), iter1 := SeqM3AST_AS_STM.NewIter(n.as_stm_s));
  END Case_newIter;

PROCEDURE <A NAME="Else_stm_newIter"><procedure>Else_stm_newIter</procedure></A>(n: M3AST_AS_F.Else_stm): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Else_stm_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s));
  END Else_stm_newIter;

PROCEDURE <A NAME="Elsif_newIter"><procedure>Elsif_newIter</procedure></A>(n: M3AST_AS_F.Elsif): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Elsif_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s));
  END Elsif_newIter;

PROCEDURE <A NAME="Try_except_newIter"><procedure>Try_except_newIter</procedure></A>(n: M3AST_AS_F.Try_except): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Try_except_iter, n := n, iter0 := SeqM3AST_AS_Handler.NewIter(
        n.as_handler_s), iter1 := SeqM3AST_AS_STM.NewIter(n.as_stm_s));
  END Try_except_newIter;

PROCEDURE <A NAME="Try_finally_newIter"><procedure>Try_finally_newIter</procedure></A>(n: M3AST_AS_F.Try_finally): AST_Iter.T RAISES {
    }=
  BEGIN
    RETURN NEW(Try_finally_iter, n := n, iter0 := SeqM3AST_AS_STM.NewIter(n.
        as_stm_s));
  END Try_finally_newIter;

PROCEDURE <A NAME="Tcase_newIter"><procedure>Tcase_newIter</procedure></A>(n: M3AST_AS_F.Tcase): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Tcase_iter, n := n, iter0 := SeqM3AST_AS_M3TYPE.NewIter(n.
        as_type_s), iter1 := SeqM3AST_AS_STM.NewIter(n.as_stm_s));
  END Tcase_newIter;

PROCEDURE <A NAME="Handler_newIter"><procedure>Handler_newIter</procedure></A>(n: M3AST_AS_F.Handler): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Handler_iter, n := n, iter0 := SeqM3AST_AS_Qual_used_id.
        NewIter(n.as_qual_id_s), iter1 := SeqM3AST_AS_STM.NewIter(n.as_stm_s)
        );
  END Handler_newIter;

PROCEDURE <A NAME="Binding_newIter"><procedure>Binding_newIter</procedure></A>(n: M3AST_AS_F.Binding): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(Binding_iter, n := n);
  END Binding_newIter;

PROCEDURE <A NAME="By_newIter"><procedure>By_newIter</procedure></A>(n: M3AST_AS_F.By): AST_Iter.T RAISES {}=
  BEGIN
    RETURN NEW(By_iter, n := n);
  END By_newIter;

BEGIN
END M3AST_AS_Iter.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
