<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST_AS_Walk.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST_AS_Walk.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3AST_AS_Walk.i3">M3AST_AS_Walk</A></implements></module>;

IMPORT <A HREF="M3AST_AS.i3">M3AST_AS</A>, <A HREF="M3AST_PG.i3">M3AST_PG</A>;
IMPORT <A HREF="M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="M3AST_PG_F.i3">M3AST_PG_F</A>;

IMPORT <A HREF="../gast/AST_WalkRep.i3">AST_WalkRep</A>;
IMPORT
    <A HREF="../../derived/SeqM3AST_AS_IMPORTED.i3">SeqM3AST_AS_IMPORTED</A>,
    <A HREF="../../derived/SeqM3AST_AS_Import_item.i3">SeqM3AST_AS_Import_item</A>, <A HREF="../../derived/SeqM3AST_AS_F_Interface_id.i3">SeqM3AST_AS_F_Interface_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Used_interface_id.i3">SeqM3AST_AS_Used_interface_id</A>, <A HREF="../../derived/SeqM3AST_AS_Used_def_id.i3">SeqM3AST_AS_Used_def_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_REVELATION.i3">SeqM3AST_AS_REVELATION</A>, <A HREF="../../derived/SeqM3AST_AS_DECL_REVL.i3">SeqM3AST_AS_DECL_REVL</A>,
    <A HREF="../../derived/SeqM3AST_AS_Const_decl.i3">SeqM3AST_AS_Const_decl</A>, <A HREF="../../derived/SeqM3AST_AS_TYPE_DECL.i3">SeqM3AST_AS_TYPE_DECL</A>,
    <A HREF="../../derived/SeqM3AST_AS_Var_decl.i3">SeqM3AST_AS_Var_decl</A>, <A HREF="../../derived/SeqM3AST_AS_Exc_decl.i3">SeqM3AST_AS_Exc_decl</A>,
    <A HREF="../../derived/SeqM3AST_AS_Var_id.i3">SeqM3AST_AS_Var_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Enum_id.i3">SeqM3AST_AS_Enum_id</A>, <A HREF="../../derived/SeqM3AST_AS_Field_id.i3">SeqM3AST_AS_Field_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_FORMAL_ID.i3">SeqM3AST_AS_FORMAL_ID</A>, <A HREF="../../derived/SeqM3AST_AS_Qual_used_id.i3">SeqM3AST_AS_Qual_used_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Fields.i3">SeqM3AST_AS_Fields</A>, <A HREF="../../derived/SeqM3AST_AS_Method.i3">SeqM3AST_AS_Method</A>,
    <A HREF="../../derived/SeqM3AST_AS_M3TYPE.i3">SeqM3AST_AS_M3TYPE</A>,
    <A HREF="../../derived/SeqM3AST_AS_Formal_param.i3">SeqM3AST_AS_Formal_param</A>, <A HREF="../../derived/SeqM3AST_AS_CONS_ELEM.i3">SeqM3AST_AS_CONS_ELEM</A>,
    <A HREF="../../derived/SeqM3AST_AS_EXP.i3">SeqM3AST_AS_EXP</A>, <A HREF="../../derived/SeqM3AST_AS_Actual.i3">SeqM3AST_AS_Actual</A>,
    <A HREF="../../derived/SeqM3AST_AS_Case.i3">SeqM3AST_AS_Case</A>, <A HREF="../../derived/SeqM3AST_AS_STM.i3">SeqM3AST_AS_STM</A>,
    <A HREF="../../derived/SeqM3AST_AS_Elsif.i3">SeqM3AST_AS_Elsif</A>, <A HREF="../../derived/SeqM3AST_AS_Tcase.i3">SeqM3AST_AS_Tcase</A>,
    <A HREF="../../derived/SeqM3AST_AS_Handler.i3">SeqM3AST_AS_Handler</A>, <A HREF="../../derived/SeqM3AST_AS_Binding.i3">SeqM3AST_AS_Binding</A>,
    <A HREF="../../derived/SeqM3AST_AS_RANGE_EXP.i3">SeqM3AST_AS_RANGE_EXP</A>, <A HREF="../../derived/SeqM3AST_AS_Override.i3">SeqM3AST_AS_Override</A>;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="VisitSeqStm"><procedure>VisitSeqStm</procedure></A>(seqStm: SeqM3AST_AS_STM.T; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.STM;
    iter := SeqM3AST_AS_STM.NewIter(seqStm);
  BEGIN
    WHILE SeqM3AST_AS_STM.Next(iter, m) DO h.Visit(m); END;
  END VisitSeqStm;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="VisitEXTERNAL_DECL"><procedure>VisitEXTERNAL_DECL</procedure></A>(n: M3AST_PG.External_NULL;
    h: AST_WalkRep.Handle) RAISES ANY=
  BEGIN
    IF n # NIL THEN h.Visit(n) END;
  END VisitEXTERNAL_DECL;

PROCEDURE <A NAME="Qual_used_id"><procedure>Qual_used_id</procedure></A>(n: M3AST_AS_F.Qual_used_id; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    IF n.as_intf_id # NIL THEN h.Visit(n.as_intf_id); END;
    h.Visit(n.as_id);
  END Qual_used_id;

PROCEDURE <A NAME="Compilation_Unit"><procedure>Compilation_Unit</procedure></A>(n: M3AST_AS_F.Compilation_Unit;
      h: AST_WalkRep.Handle) RAISES ANY =
  BEGIN
    h.Visit(n.as_root);
  END Compilation_Unit;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="VisitUNIT_WITH_BODY"><procedure>VisitUNIT_WITH_BODY</procedure></A>(n: M3AST_AS_F.UNIT_WITH_BODY;
    h: AST_WalkRep.Handle) RAISES ANY=
  VAR
    m2: M3AST_AS.IMPORTED;
    iter2 := SeqM3AST_AS_IMPORTED.NewIter(n.as_import_s);
  BEGIN
    WHILE SeqM3AST_AS_IMPORTED.Next(iter2, m2) DO h.Visit(m2);
    END;
    h.Visit(n.as_block);
  END VisitUNIT_WITH_BODY;

PROCEDURE <A NAME="VisitUNIT_GEN_DEF"><procedure>VisitUNIT_GEN_DEF</procedure></A>(n: M3AST_AS_F.UNIT_GEN_DEF; h: AST_WalkRep.Handle)
     RAISES ANY=
  VAR iter := SeqM3AST_AS_F_Interface_id.NewIter(n.as_id_s);
    m: M3AST_AS.F_Interface_id;
  BEGIN
    WHILE SeqM3AST_AS_F_Interface_id.Next(iter, m) DO h.Visit(m); END;
  END VisitUNIT_GEN_DEF;

PROCEDURE <A NAME="Interface"><procedure>Interface</procedure></A>(n: M3AST_AS_F.Interface; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h);
    IF n.as_unsafe # NIL THEN h.Visit(n.as_unsafe); END;
    h.Visit(n.as_id);
    VisitUNIT_WITH_BODY(n, h);
  END Interface;

PROCEDURE <A NAME="Module"><procedure>Module</procedure></A>(n: M3AST_AS_F.Module; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Used_interface_id;
    iter := SeqM3AST_AS_Used_interface_id.NewIter(n.as_export_s);
  BEGIN
    IF n.as_unsafe # NIL THEN h.Visit(n.as_unsafe); END;
    h.Visit(n.as_id);
    WHILE SeqM3AST_AS_Used_interface_id.Next(iter, m) DO h.Visit(m); END;
    VisitUNIT_WITH_BODY(n, h);
  END Module;

PROCEDURE <A NAME="Interface_gen_def"><procedure>Interface_gen_def</procedure></A>(n: M3AST_AS_F.Interface_gen_def;
    h: AST_WalkRep.Handle) RAISES ANY =
  BEGIN
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h);
    h.Visit(n.as_id);
    VisitUNIT_GEN_DEF(n, h);
    VisitUNIT_WITH_BODY(n, h);
  END Interface_gen_def;

PROCEDURE <A NAME="Module_gen_def"><procedure>Module_gen_def</procedure></A>(n: M3AST_AS_F.Module_gen_def; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_id);
    VisitUNIT_GEN_DEF(n, h);
    VisitUNIT_WITH_BODY(n, h);
  END Module_gen_def;

PROCEDURE <A NAME="Interface_gen_ins"><procedure>Interface_gen_ins</procedure></A>(n: M3AST_AS_F.Interface_gen_ins;
    h: AST_WalkRep.Handle) RAISES ANY =
  VAR
    m: M3AST_AS.Used_interface_id;
    iter := SeqM3AST_AS_Used_interface_id.NewIter(n.as_id_s);
  BEGIN
    IF n.as_unsafe # NIL THEN h.Visit(n.as_unsafe); END;
    h.Visit(n.as_id);
    h.Visit(n.as_gen_id);
    WHILE SeqM3AST_AS_Used_interface_id.Next(iter, m) DO h.Visit(m); END;
  END Interface_gen_ins;

PROCEDURE <A NAME="Module_gen_ins"><procedure>Module_gen_ins</procedure></A>(n: M3AST_AS_F.Module_gen_ins; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Used_interface_id;
    iter := SeqM3AST_AS_Used_interface_id.NewIter(n.as_export_s);
    iter1 := SeqM3AST_AS_Used_interface_id.NewIter(n.as_id_s);
  BEGIN
    IF n.as_unsafe # NIL THEN h.Visit(n.as_unsafe); END;
    h.Visit(n.as_id);
    WHILE SeqM3AST_AS_Used_interface_id.Next(iter, m) DO h.Visit(m); END;
    h.Visit(n.as_gen_id);
    WHILE SeqM3AST_AS_Used_interface_id.Next(iter1, m) DO h.Visit(m); END;
  END Module_gen_ins;

PROCEDURE <A NAME="Simple_import"><procedure>Simple_import</procedure></A>(n: M3AST_AS_F.Simple_import; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Import_item;
    iter := SeqM3AST_AS_Import_item.NewIter(n.as_import_item_s);
  BEGIN
    WHILE SeqM3AST_AS_Import_item.Next(iter, m) DO h.Visit(m); END;
  END Simple_import;

PROCEDURE <A NAME="Import_item"><procedure>Import_item</procedure></A>(n: M3AST_AS_F.Import_item; h: AST_WalkRep.Handle)
     RAISES ANY=
  BEGIN
    h.Visit(n.as_intf_id);
    IF n.as_id # NIL THEN h.Visit(n.as_id) END;
  END Import_item;

PROCEDURE <A NAME="From_import"><procedure>From_import</procedure></A>(n: M3AST_AS_F.From_import; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Used_def_id;
    iter := SeqM3AST_AS_Used_def_id.NewIter(n.as_id_s);
  BEGIN
    h.Visit(n.as_intf_id);
    WHILE SeqM3AST_AS_Used_def_id.Next(iter, m) DO h.Visit(m); END;
  END From_import;

PROCEDURE <A NAME="Revelation_s"><procedure>Revelation_s</procedure></A>(n: M3AST_AS_F.Revelation_s; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.REVELATION;
    iter := SeqM3AST_AS_REVELATION.NewIter(n.as_reveal_s);
  BEGIN
    WHILE SeqM3AST_AS_REVELATION.Next(iter, m) DO h.Visit(m); END;
  END Revelation_s;

PROCEDURE <A NAME="Const_decl_s"><procedure>Const_decl_s</procedure></A>(n: M3AST_AS_F.Const_decl_s; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Const_decl;
    iter := SeqM3AST_AS_Const_decl.NewIter(n.as_const_decl_s);
  BEGIN
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h);
    WHILE SeqM3AST_AS_Const_decl.Next(iter, m) DO h.Visit(m); END;
  END Const_decl_s;

PROCEDURE <A NAME="Type_decl_s"><procedure>Type_decl_s</procedure></A>(n: M3AST_AS_F.Type_decl_s; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.TYPE_DECL;
    iter := SeqM3AST_AS_TYPE_DECL.NewIter(n.as_type_decl_s);
  BEGIN
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h);
    WHILE SeqM3AST_AS_TYPE_DECL.Next(iter, m) DO h.Visit(m); END;
  END Type_decl_s;

PROCEDURE <A NAME="Var_decl_s"><procedure>Var_decl_s</procedure></A>(n: M3AST_AS_F.Var_decl_s; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Var_decl;
    iter := SeqM3AST_AS_Var_decl.NewIter(n.as_var_decl_s);
  BEGIN
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h);
    WHILE SeqM3AST_AS_Var_decl.Next(iter, m) DO h.Visit(m); END;
  END Var_decl_s;

PROCEDURE <A NAME="Exc_decl_s"><procedure>Exc_decl_s</procedure></A>(n: M3AST_AS_F.Exc_decl_s; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Exc_decl;
    iter := SeqM3AST_AS_Exc_decl.NewIter(n.as_exc_decl_s);
  BEGIN
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h);
    WHILE SeqM3AST_AS_Exc_decl.Next(iter, m) DO h.Visit(m); END;
  END Exc_decl_s;

PROCEDURE <A NAME="Proc_decl"><procedure>Proc_decl</procedure></A>(n: M3AST_AS_F.Proc_decl; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h);
    IF n.pg_inline # NIL THEN h.Visit(n.pg_inline); END;
    h.Visit(n.as_id);
    h.Visit(n.as_type);
    IF n.as_body # NIL THEN h.Visit(n.as_body); END;
  END Proc_decl;

PROCEDURE <A NAME="Const_decl"><procedure>Const_decl</procedure></A>(n: M3AST_AS_F.Const_decl; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_id);
    IF n.as_type # NIL THEN h.Visit(n.as_type); END;
    h.Visit(n.as_exp);
  END Const_decl;

PROCEDURE <A NAME="Var_decl"><procedure>Var_decl</procedure></A>(n: M3AST_AS_F.Var_decl; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Var_id;
    iter := SeqM3AST_AS_Var_id.NewIter(n.as_id_s);
  BEGIN
    WHILE SeqM3AST_AS_Var_id.Next(iter, m) DO h.Visit(m); END;
    IF n.as_type # NIL THEN h.Visit(n.as_type); END;
    IF n.as_default # NIL THEN h.Visit(n.as_default); END;
  END Var_decl;

PROCEDURE <A NAME="Exc_decl"><procedure>Exc_decl</procedure></A>(n: M3AST_AS_F.Exc_decl; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_id);
    IF n.as_type # NIL THEN h.Visit(n.as_type); END;
  END Exc_decl;

PROCEDURE <A NAME="Subtype_decl"><procedure>Subtype_decl</procedure></A>(n: M3AST_AS_F.Subtype_decl; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_id);
    h.Visit(n.as_type);
  END Subtype_decl;

PROCEDURE <A NAME="Concrete_decl"><procedure>Concrete_decl</procedure></A>(n: M3AST_AS_F.Concrete_decl; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_id);
    h.Visit(n.as_type);
  END Concrete_decl;

PROCEDURE <A NAME="Subtype_reveal"><procedure>Subtype_reveal</procedure></A>(
    n: M3AST_AS_F.Subtype_reveal;
    h: AST_WalkRep.Handle) RAISES ANY =
  BEGIN
    h.Visit(n.as_qual_id);
    h.Visit(n.as_type);
  END Subtype_reveal;

PROCEDURE <A NAME="Concrete_reveal"><procedure>Concrete_reveal</procedure></A>(n: M3AST_AS_F.Concrete_reveal;
    h: AST_WalkRep.Handle) RAISES ANY =
  BEGIN
    h.Visit(n.as_qual_id);
    h.Visit(n.as_type);
  END Concrete_reveal;

PROCEDURE <A NAME="Named_type"><procedure>Named_type</procedure></A>(n: M3AST_AS_F.Named_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_qual_id);
  END Named_type;

PROCEDURE <A NAME="Root_type"><procedure>Root_type</procedure></A>(n: M3AST_AS_F.Root_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    IF n.as_trace_mode # NIL THEN h.Visit(n.as_trace_mode); END;
  END Root_type;

PROCEDURE <A NAME="Enumeration_type"><procedure>Enumeration_type</procedure></A>(n: M3AST_AS_F.Enumeration_type;
    h: AST_WalkRep.Handle) RAISES ANY =
  VAR
    m: M3AST_AS.Enum_id;
    iter := SeqM3AST_AS_Enum_id.NewIter(n.as_id_s);
  BEGIN
    WHILE SeqM3AST_AS_Enum_id.Next(iter, m) DO h.Visit(m); END;
  END Enumeration_type;

PROCEDURE <A NAME="Subrange_type"><procedure>Subrange_type</procedure></A>(n: M3AST_AS_F.Subrange_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_range);
  END Subrange_type;

PROCEDURE <A NAME="Array_type"><procedure>Array_type</procedure></A>(n: M3AST_AS_F.Array_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.M3TYPE;
    iter := SeqM3AST_AS_M3TYPE.NewIter(n.as_indextype_s);
  BEGIN
    WHILE SeqM3AST_AS_M3TYPE.Next(iter, m) DO h.Visit(m); END;
    h.Visit(n.as_elementtype);
  END Array_type;

PROCEDURE <A NAME="Record_type"><procedure>Record_type</procedure></A>(n: M3AST_AS_F.Record_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Fields;
    iter := SeqM3AST_AS_Fields.NewIter(n.as_fields_s);
  BEGIN
    WHILE SeqM3AST_AS_Fields.Next(iter, m) DO h.Visit(m); END;
  END Record_type;

PROCEDURE <A NAME="Object_type"><procedure>Object_type</procedure></A>(n: M3AST_AS_F.Object_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Fields;
    iter := SeqM3AST_AS_Fields.NewIter(n.as_fields_s);
    m2: M3AST_AS.Method;
    iter2 := SeqM3AST_AS_Method.NewIter(n.as_method_s);
    m3: M3AST_AS.Override;
    iter3 := SeqM3AST_AS_Override.NewIter(n.as_override_s);
  BEGIN
    IF n.as_ancestor # NIL THEN h.Visit(n.as_ancestor); END;
    IF n.as_brand # NIL THEN h.Visit(n.as_brand); END;
    WHILE SeqM3AST_AS_Fields.Next(iter, m) DO h.Visit(m); END;
    WHILE SeqM3AST_AS_Method.Next(iter2, m2) DO h.Visit(m2); END;
    WHILE SeqM3AST_AS_Override.Next(iter3, m3) DO h.Visit(m3); END;
  END Object_type;

PROCEDURE <A NAME="Set_type"><procedure>Set_type</procedure></A>(n: M3AST_AS_F.Set_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_type);
  END Set_type;

PROCEDURE <A NAME="Procedure_type"><procedure>Procedure_type</procedure></A>(n: M3AST_AS_F.Procedure_type;
    h: AST_WalkRep.Handle) RAISES ANY =
  VAR
    m: M3AST_AS.Formal_param;
    iter := SeqM3AST_AS_Formal_param.NewIter(n.as_formal_param_s);
  BEGIN
    WHILE SeqM3AST_AS_Formal_param.Next(iter, m) DO h.Visit(m); END;
    IF n.as_result_type # NIL THEN h.Visit(n.as_result_type); END;
    IF n.as_raises # NIL THEN h.Visit(n.as_raises); END;
  END Procedure_type;

PROCEDURE <A NAME="Ref_type"><procedure>Ref_type</procedure></A>(n: M3AST_AS_F.Ref_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    IF n.as_trace_mode # NIL THEN h.Visit(n.as_trace_mode); END;
    IF n.as_brand # NIL THEN h.Visit(n.as_brand) END;
    h.Visit(n.as_type);
  END Ref_type;

PROCEDURE <A NAME="Packed_type"><procedure>Packed_type</procedure></A>(n: M3AST_AS_F.Packed_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
    h.Visit(n.as_type);
  END Packed_type;

PROCEDURE <A NAME="Opaque_type"><procedure>Opaque_type</procedure></A>(n: M3AST_AS_F.Opaque_type; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_type);
  END Opaque_type;

PROCEDURE <A NAME="Brand"><procedure>Brand</procedure></A>(
    n: M3AST_AS_F.Brand; h: AST_WalkRep.Handle
    ) RAISES ANY=
  BEGIN
    IF n.as_exp # NIL THEN h.Visit(n.as_exp) END;
  END Brand;

PROCEDURE <A NAME="Fields"><procedure>Fields</procedure></A>(n: M3AST_AS_F.Fields; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Field_id;
    iter := SeqM3AST_AS_Field_id.NewIter(n.as_id_s);
  BEGIN
    WHILE SeqM3AST_AS_Field_id.Next(iter, m) DO h.Visit(m); END;
    IF n.as_type # NIL THEN h.Visit(n.as_type); END;
    IF n.as_default # NIL THEN h.Visit(n.as_default); END;
  END Fields;

PROCEDURE <A NAME="Method"><procedure>Method</procedure></A>(n: M3AST_AS_F.Method; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_id);
    h.Visit(n.as_type);
    IF n.as_default # NIL THEN h.Visit(n.as_default); END;
  END Method;

PROCEDURE <A NAME="Override"><procedure>Override</procedure></A>(n: M3AST_AS_F.Override; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_id);
    h.Visit(n.as_default);
  END Override;

PROCEDURE <A NAME="Formal_param"><procedure>Formal_param</procedure></A>(n: M3AST_AS_F.Formal_param; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.FORMAL_ID;
    iter := SeqM3AST_AS_FORMAL_ID.NewIter(n.as_id_s);
  BEGIN
    WHILE SeqM3AST_AS_FORMAL_ID.Next(iter, m) DO h.Visit(m); END;
    IF n.as_formal_type # NIL THEN h.Visit(n.as_formal_type); END;
    IF n.as_default # NIL THEN h.Visit(n.as_default); END;
  END Formal_param;

PROCEDURE <A NAME="Raisees_some"><procedure>Raisees_some</procedure></A>(n: M3AST_AS_F.Raisees_some; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Qual_used_id;
    iter := SeqM3AST_AS_Qual_used_id.NewIter(n.as_raisees_s);
  BEGIN
    WHILE SeqM3AST_AS_Qual_used_id.Next(iter, m) DO h.Visit(m); END;
  END Raisees_some;

PROCEDURE <A NAME="Range"><procedure>Range</procedure></A>(n: M3AST_AS_F.Range; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp1);
    h.Visit(n.as_exp2);
  END Range;

PROCEDURE <A NAME="Range_EXP"><procedure>Range_EXP</procedure></A>(n: M3AST_AS_F.Range_EXP; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
  END Range_EXP;

PROCEDURE <A NAME="Constructor"><procedure>Constructor</procedure></A>(n: M3AST_AS_F.Constructor; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.CONS_ELEM;
    iter := SeqM3AST_AS_CONS_ELEM.NewIter(n.as_element_s);
  BEGIN
    h.Visit(n.as_type);
    WHILE SeqM3AST_AS_CONS_ELEM.Next(iter, m) DO h.Visit(m); END;
    IF n.as_propagate # NIL THEN h.Visit(n.as_propagate); END;
  END Constructor;

PROCEDURE <A NAME="RANGE_EXP_elem"><procedure>RANGE_EXP_elem</procedure></A>(n: M3AST_AS_F.RANGE_EXP_elem; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_range_exp);
  END RANGE_EXP_elem;

PROCEDURE <A NAME="Actual_elem"><procedure>Actual_elem</procedure></A>(n: M3AST_AS_F.Actual_elem; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_actual);
  END Actual_elem;

PROCEDURE <A NAME="BINARY"><procedure>BINARY</procedure></A>(n: M3AST_AS_F.BINARY; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp1);
    h.Visit(n.as_exp2);
  END BINARY;

PROCEDURE <A NAME="UNARY"><procedure>UNARY</procedure></A>(n: M3AST_AS_F.UNARY; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
  END UNARY;

PROCEDURE <A NAME="Select"><procedure>Select</procedure></A>(
    n: M3AST_AS_F.Select; h: AST_WalkRep.Handle
    ) RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
    h.Visit(n.as_id);
  END Select;

PROCEDURE <A NAME="Call"><procedure>Call</procedure></A>(n: M3AST_AS_F.Call; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Actual;
    iter := SeqM3AST_AS_Actual.NewIter(n.as_param_s);
  BEGIN
    h.Visit(n.as_callexp);
    WHILE SeqM3AST_AS_Actual.Next(iter, m) DO h.Visit(m); END;
  END Call;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A>(n: M3AST_AS_F.Index; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.EXP;
    iter := SeqM3AST_AS_EXP.NewIter(n.as_exp_s);
  BEGIN
    h.Visit(n.as_array);
    WHILE SeqM3AST_AS_EXP.Next(iter, m) DO h.Visit(m); END;
  END Index;

PROCEDURE <A NAME="Actual"><procedure>Actual</procedure></A>(n: M3AST_AS_F.Actual; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    IF n.as_id # NIL THEN h.Visit(n.as_id); END;
    h.Visit(n.as_exp_type);
  END Actual;

PROCEDURE <A NAME="Assign_st"><procedure>Assign_st</procedure></A>(n: M3AST_AS_F.Assign_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_lhs_exp);
    h.Visit(n.as_rhs_exp);
  END Assign_st;

PROCEDURE <A NAME="Call_st"><procedure>Call_st</procedure></A>(n: M3AST_AS_F.Call_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_call);
  END Call_st;

PROCEDURE <A NAME="Case_st"><procedure>Case_st</procedure></A>(n: M3AST_AS_F.Case_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Case;
    iter := SeqM3AST_AS_Case.NewIter(n.as_case_s);
  BEGIN
    h.Visit(n.as_exp);
    WHILE SeqM3AST_AS_Case.Next(iter, m) DO h.Visit(m); END;
    IF n.as_else # NIL THEN h.Visit(n.as_else); END;
  END Case_st;

PROCEDURE <A NAME="Eval_st"><procedure>Eval_st</procedure></A>(n: M3AST_AS_F.Eval_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
  END Eval_st;

PROCEDURE <A NAME="For_st"><procedure>For_st</procedure></A>(n: M3AST_AS_F.For_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_id);
    h.Visit(n.as_from);
    h.Visit(n.as_to);
    IF n.as_by # NIL THEN h.Visit(n.as_by); END;
    VisitSeqStm(n.as_stm_s, h);
  END For_st;

PROCEDURE <A NAME="If_st"><procedure>If_st</procedure></A>(n: M3AST_AS_F.If_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Elsif;
    iter := SeqM3AST_AS_Elsif.NewIter(n.as_elsif_s);
  BEGIN
    h.Visit(n.as_exp);
    VisitSeqStm(n.as_stm_s, h);
    WHILE SeqM3AST_AS_Elsif.Next(iter, m) DO h.Visit(m); END;
    IF n.as_else # NIL THEN h.Visit(n.as_else); END;
  END If_st;

PROCEDURE <A NAME="Lock_st"><procedure>Lock_st</procedure></A>(n: M3AST_AS_F.Lock_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
    VisitSeqStm(n.as_stm_s, h);
  END Lock_st;

PROCEDURE <A NAME="Loop_st"><procedure>Loop_st</procedure></A>(n: M3AST_AS_F.Loop_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    VisitSeqStm(n.as_stm_s, h);
  END Loop_st;

PROCEDURE <A NAME="Raise_st"><procedure>Raise_st</procedure></A>(n: M3AST_AS_F.Raise_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_qual_id);
    IF n.as_exp_void # NIL THEN h.Visit(n.as_exp_void); END;
  END Raise_st;

PROCEDURE <A NAME="Repeat_st"><procedure>Repeat_st</procedure></A>(n: M3AST_AS_F.Repeat_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    VisitSeqStm(n.as_stm_s, h);
    h.Visit(n.as_exp);
  END Repeat_st;

PROCEDURE <A NAME="Return_st"><procedure>Return_st</procedure></A>(n: M3AST_AS_F.Return_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    IF n.as_exp # NIL THEN h.Visit(n.as_exp); END;
  END Return_st;

PROCEDURE <A NAME="Try_st"><procedure>Try_st</procedure></A>(n: M3AST_AS_F.Try_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    VisitSeqStm(n.as_stm_s, h);
    h.Visit(n.as_try_tail);
  END Try_st;

PROCEDURE <A NAME="Typecase_st"><procedure>Typecase_st</procedure></A>(n: M3AST_AS_F.Typecase_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Tcase;
    iter := SeqM3AST_AS_Tcase.NewIter(n.as_tcase_s);
  BEGIN
    h.Visit(n.as_exp);
    WHILE SeqM3AST_AS_Tcase.Next(iter, m) DO h.Visit(m); END;
    IF n.as_else # NIL THEN h.Visit(n.as_else); END;
  END Typecase_st;

PROCEDURE <A NAME="While_st"><procedure>While_st</procedure></A>(n: M3AST_AS_F.While_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
    VisitSeqStm(n.as_stm_s, h);
  END While_st;

PROCEDURE <A NAME="With_st"><procedure>With_st</procedure></A>(n: M3AST_AS_F.With_st; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Binding;
    iter := SeqM3AST_AS_Binding.NewIter(n.as_binding_s);
  BEGIN
    WHILE SeqM3AST_AS_Binding.Next(iter, m) DO h.Visit(m); END;
    VisitSeqStm(n.as_stm_s, h);
  END With_st;

PROCEDURE <A NAME="Case"><procedure>Case</procedure></A>(
    n: M3AST_AS_F.Case; h: AST_WalkRep.Handle
    ) RAISES ANY=
  VAR
    m: M3AST_AS.RANGE_EXP;
    iter := SeqM3AST_AS_RANGE_EXP.NewIter(n.as_case_label_s);
  BEGIN
    WHILE SeqM3AST_AS_RANGE_EXP.Next(iter, m) DO h.Visit(m); END;
    VisitSeqStm(n.as_stm_s, h);
  END Case;

PROCEDURE <A NAME="Block"><procedure>Block</procedure></A>(n: M3AST_AS_F.Block; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.DECL_REVL;
    iter := SeqM3AST_AS_DECL_REVL.NewIter(n.as_decl_s);
  BEGIN
    WHILE SeqM3AST_AS_DECL_REVL.Next(iter, m) DO h.Visit(m); END;
    VisitSeqStm(n.as_stm_s, h);
  END Block;

PROCEDURE <A NAME="Else_stm"><procedure>Else_stm</procedure></A>(n: M3AST_AS_F.Else_stm; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    VisitSeqStm(n.as_stm_s, h);
  END Else_stm;

PROCEDURE <A NAME="By"><procedure>By</procedure></A>(n: M3AST_AS_F.By; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
  END By;

PROCEDURE <A NAME="Elsif"><procedure>Elsif</procedure></A>(n: M3AST_AS_F.Elsif; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
    VisitSeqStm(n.as_stm_s, h);
  END Elsif;

PROCEDURE <A NAME="Try_except"><procedure>Try_except</procedure></A>(n: M3AST_AS_F.Try_except; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Handler;
    iter := SeqM3AST_AS_Handler.NewIter(n.as_handler_s);
  BEGIN
    WHILE SeqM3AST_AS_Handler.Next(iter, m) DO h.Visit(m); END;
    IF n.as_else # NIL THEN h.Visit(n.as_else); END;
  END Try_except;

PROCEDURE <A NAME="Try_finally"><procedure>Try_finally</procedure></A>(n: M3AST_AS_F.Try_finally; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    VisitSeqStm(n.as_stm_s, h);
  END Try_finally;

PROCEDURE <A NAME="Tcase"><procedure>Tcase</procedure></A>(n: M3AST_AS_F.Tcase; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.M3TYPE;
    iter := SeqM3AST_AS_M3TYPE.NewIter(n.as_type_s);
  BEGIN
    WHILE SeqM3AST_AS_M3TYPE.Next(iter, m) DO h.Visit(m); END;
    IF n.as_id # NIL THEN h.Visit(n.as_id) END;
    VisitSeqStm(n.as_stm_s, h);
  END Tcase;

PROCEDURE <A NAME="Handler"><procedure>Handler</procedure></A>(n: M3AST_AS_F.Handler; h: AST_WalkRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Qual_used_id;
    iter := SeqM3AST_AS_Qual_used_id.NewIter(n.as_qual_id_s);
  BEGIN
    WHILE SeqM3AST_AS_Qual_used_id.Next(iter, m) DO h.Visit(m); END;
    IF n.as_id # NIL THEN h.Visit(n.as_id); END;
    VisitSeqStm(n.as_stm_s, h);
  END Handler;

PROCEDURE <A NAME="Binding"><procedure>Binding</procedure></A>(n: M3AST_AS_F.Binding; h: AST_WalkRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_id);
    h.Visit(n.as_exp);
  END Binding;

BEGIN
END M3AST_AS_Walk.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
