<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST_LX.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST_LX.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface>M3AST_LX</interface>;

IMPORT <A HREF="M3AST.i3">M3AST</A>;
</PRE> This interface defines the types of the lexical entities in the
Modula-3 AST. At this level of the specification, most of the entities
are declared as opaque types, to be given a definition by a particular
implementation of the AST. The exception is source position
information which is defined as an <CODE>INTEGER</CODE>, although the encoding of
the bits is not specified here. 

<P><PRE>TYPE
  Symbol_rep &lt;: REFANY;       (* identifiers *)
  Literal_rep &lt;: REFANY;      (* all literals *)
  <A HREF="../syn/M3CLiteral.m3#Number_rep">Number_rep</A> &lt;: Literal_rep;  (* numeric literals *)
  <A HREF="../syn/M3CLiteral.m3#Text_rep">Text_rep</A> &lt;: Literal_rep;    (* text and character literals *)
  SrcPos = INTEGER;           (* source positions *)
  Whitespace_rep &lt;: REFANY;   (* whitespace *)
  <A HREF="../astall/M3AST_all.i3#BadChar_rep">BadChar_rep</A> &lt;: REFANY;      (* illlegal character *)
  <A HREF="../astall/M3AST_all.i3#Comment_rep">Comment_rep</A> &lt;: REFANY;      (* a comment *)
  <A HREF="../astall/M3AST_all.i3#Pragma_rep">Pragma_rep</A> &lt;: REFANY;       (* a pragma *)
  <A HREF="../syn/M3CToken.m3#Token_rep">Token_rep</A> &lt;: REFANY;        (* reserved word or symbol *)
</PRE> The AST is capable of recording the complete set of characters that
were present in the original source file, allowing exact reproduction.
The class <CODE>SRC_NODE</CODE> is defined to denote a node that represents an
entity in the source form of the program.  The {\it source position}
of any <CODE>SRC_NODE</CODE> is available as an attribute, <CODE>lx_srcpos</CODE>. The
terminal symbols of the Modula-3 grammar are represented by subtypes
of <CODE>SRC_NODE</CODE>, as are whitespace, comments, pragmas, and illegal
characters. 
<P>
Nodes that represent non-terminals of the grammer and, therefore have
child nodes, are declared as subtypes of <CODE>SRC_NODE_C</CODE>. This class carries a
sequence attribute, <CODE>lx_node_s</CODE>, that encodes all the terminals and
child nodes, in the order of occurrence. 

<P><PRE>&lt;* PRAGMA FIELDS *&gt;

TYPE
  <A HREF="../astall/M3AST_all.i3#SRC_NODE">SRC_NODE</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF SRC_NODE
       lx_srcpos: SrcPos; *&gt;

  <A HREF="../astall/M3AST_all.i3#SRC_NODE_C">SRC_NODE_C</A> &lt;: SRC_NODE;
  &lt;* FIELDS OF SRC_NODE_T
       lx_node_s: SEQUENCE OF SRC_NODE; *&gt;

  <A HREF="../astall/M3AST_all.i3#Whitespace">Whitespace</A> &lt;: SRC_NODE;
  &lt;* FIELDS OF Whitespace
       lx_whitespace_rep: Whitespace_rep; *&gt;

  <A HREF="../astall/M3AST_all.i3#Comment">Comment</A> &lt;: SRC_NODE;
  &lt;* FIELDS OF Comment
       lx_comment_rep: Comment_rep; *&gt;

  <A HREF="../astall/M3AST_all.i3#Pragma">Pragma</A> &lt;: SRC_NODE;
  &lt;* FIELDS OF Pragma
       lx_pragma_rep: Pragma_rep *&gt;

  <A HREF="../astall/M3AST_all.i3#BadChar">BadChar</A> &lt;: SRC_NODE;
  &lt;* FIELDS OF BadChar
      lx_badchar_rep: BadChar_rep *&gt;

  <A HREF="../astall/M3AST_all.i3#Token">Token</A> &lt;: SRC_NODE;
  &lt;* FIELDS OF Token
       lx_token_rep: Token_rep; *&gt;
</PRE> Identifiers are represented by many different node types, all of
which are subtypes of the <CODE>ID</CODE> class. This class carries the lexical
attribute that denotes the name of the identifier. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#ID">ID</A> &lt;: SRC_NODE;
  &lt;* FIELDS OF ID
    lx_symrep: M3AST_LX.Symbol_rep; *&gt;
</PRE> All literals are members of the class <CODE>LITERAL</CODE>, which carries the
lexical information. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#LITERAL">LITERAL</A> &lt;: SRC_NODE;
  &lt;* FIELDS OF LITERAL
       lx_litrep: Literal_rep; *&gt;

END M3AST_LX.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
