<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST_PG.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST_PG.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

&lt;* PRAGMA FIELDS *&gt;

INTERFACE <interface><A HREF="M3AST_PG.m3">M3AST_PG</A></interface>;
</PRE> Standard pragmas, as defined in the report, i.e. <CODE>INLINE</CODE> and
<CODE>EXTERNAL</CODE>.  There was a time when these were part of the language
syntax, so they are integrated more closely with the AST than other
pragmas, and it is expected that a Modula-3 parser will process these
pragmas and build the AST nodes that are specified in this interface.


<P><PRE>IMPORT <A HREF="M3AST.i3">M3AST</A>, <A HREF="M3AST_LX.i3">M3AST_LX</A>;
</PRE> We use the general approach to multiple inheritance here and
   introduce the class <CODE>EXTERNAL_DECL</CODE> to carry the information
   as to whether an <CODE>Interface</CODE> or <CODE>DECL</CODE> node is <CODE>EXTERNAL</CODE>. 
   So there is an attribute <CODE>vEXTERNAL_DECL</CODE> on <CODE>Interface</CODE>,
   <CODE>Interface_gen_def</CODE> and <CODE>DECL</CODE> nodes. 

<P> Generic interfaces can be EXTERNAL 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Interface_gen_def
     vEXTERNAL_DECL: EXTERNAL_DECL; *&gt;
</PRE> Interfaces can be EXTERNAL 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Interface
     vEXTERNAL_DECL: EXTERNAL_DECL; *&gt;
</PRE> The abstract syntax permits any <CODE>DECL</CODE> to be EXTERNAL, although the
static semantics are more restrictive. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.DECL
     vEXTERNAL_DECL: EXTERNAL_DECL; *&gt;

  &lt;* FIELDS OF M3AST_AS.Proc_decl
     pg_inline: Inline_NULL; *&gt;

TYPE
  <A HREF="../astall/M3AST_all.i3#Inline">Inline</A> &lt;: M3AST_LX.SRC_NODE_C;
  Inline_NULL = Inline;
</PRE> &lt;*EXTERNAL L*&gt; (DECL | INTERFACE) 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#EXTERNAL_DECL">EXTERNAL_DECL</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF EXTERNAL_DECL
     pg_external: External_NULL *&gt;

  <A HREF="../astall/M3AST_all.i3#External">External</A> &lt;: M3AST_LX.SRC_NODE_C;
  &lt;* FIELDS OF External
     lx_lang_spec: M3AST_LX.Text_rep *&gt;

  External_NULL = External;
  External_NULL_UNSET = External_NULL;
</PRE> Since the semantic analyser chooses to use <CODE>DEF_ID</CODE> nodes to carry
most of the semantic information, it is convenient to propagate the
<CODE>external</CODE> information to some <CODE>DEF_ID</CODE> nodes.  Again we use multiple
inheritance, and in <CODE>M3AST_SM</CODE> the associated nodes will contain a
<CODE>vEXTERNAL_ID</CODE> attribute.  The value of the <CODE>pg_external</CODE> field is a
back pointer to the <CODE>External</CODE> node of the enclosing <CODE>EXTERNAL</CODE>
declaration.  The value of <CODE>pg_external</CODE> will be NIL if the
<CODE>EXTERNAL_ID</CODE> is not <CODE>EXTERNAL</CODE>. Note that for all <CODE>EXTERNAL_ID</CODE> nodes
in an interface that is <CODE>EXTERNAL</CODE>, the value of <CODE>pg_external</CODE> will not be
<CODE>NIL</CODE>. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#EXTERNAL_ID">EXTERNAL_ID</A> &lt;: M3AST.NODE;    (* Ids that can be EXTERNAL *)
  &lt;* FIELDS OF EXTERNAL_ID
     pg_external: External_NULL_UNSET *&gt;

PROCEDURE <A HREF="M3AST_PG.m3#IsA_EXTERNAL_DECL">IsA_EXTERNAL_DECL</A>(n: M3AST.NODE;
    VAR(*out*) external_decl: EXTERNAL_DECL): BOOLEAN;
</PRE><BLOCKQUOTE><EM> ISTYPE(n, Interface) OR ISTYPE(n, DECL) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3AST_PG.m3#IsA_EXTERNAL_ID">IsA_EXTERNAL_ID</A>(n: M3AST.NODE;
    VAR(*out*) external_id: EXTERNAL_ID): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Interface_id OR Proc_id OR Var_id OR Const_id OR Type_id OR Exc_id </EM></BLOCKQUOTE><PRE>
</PRE> This proc returns distinguished values that indicates UNSET. 

<P><PRE>PROCEDURE <A HREF="M3AST_PG.m3#UNSET_External">UNSET_External</A>(): External_NULL_UNSET;

END M3AST_PG.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
