<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST_SM.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST_SM.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The <CODE>M3AST_SM</CODE> interface defines the static semantic layer of the
Modula-3 AST. 

<P> <PRE>INTERFACE <interface><A HREF="M3AST_SM.m3">M3AST_SM</A></interface>;

IMPORT <A HREF="M3AST.i3">M3AST</A>, <A HREF="M3AST_AS.i3">M3AST_AS</A>;
</PRE> The reader is assumed to be familiar with the interfaces <CODE>AST</CODE> and
<CODE>M3AST_AS</CODE>. As with <CODE>M3AST_AS</CODE>, the exact representation of the node
attributes is left to a companion interface, e.g. <CODE>M3AST_SM_F</CODE>.  A
value of <CODE>NIL</CODE> is legal for (almost) all semantic attributes and is
interpreted as {\it unset}, i.e. not computed.  However, there are a
few cases in which <CODE>NIL</CODE> is legal because the corresponding syntactic
attribute could legally be null, e.g. the default expression for a
variable declaration.  In this case we use another distinguishing
value of the appropriate class, named <CODE>UNSET_CLASS</CODE>, to indicate
unset.  Some attributes have <CODE>INTEGER</CODE> type; for these <CODE>-1</CODE> is the
unset value.
<P>
Following semantic analysis, if a unit has no semantic errors then,
with the exception of unrevealed opaque types, one can assert that no
attributes are unset.
<P>
It is not obvious what set of semantic attributes should be computed.
Each client of this interface might well have a different opinion of
what information is important. Since the AST framework makes it
straightforward for each tool to define its own attributes, this
interface concentrates on generating that information which is hard to
compute, e.g. the binding of identifiers or the types of expressions.
In particular, there is scant use of back-pointers, since these can
always be generated if necessary with a single pass through the tree.
<P>
Rather than create new nodes to carry semantic information, the
strategy is to reuse syntactic nodes wherever possible. In particular,
nodes in the <CODE>DEF_ID</CODE> and <CODE>TYPE_SPEC</CODE> classes are reused extensively.
As a consequence many other semantic attributes are declared as having
these types.  In many cases a semantic attribute will be a set;
however, we continue use the sequence interface, <CODE>SeqElem</CODE>, to denote
a set, with the understanding that there will be no duplicates.
<P>


<P><PRE>&lt;* PRAGMA FIELDS *&gt;
</PRE>\subsection{Naming Conventions}
<P>
Semantic attributes are all prefixed with the characters <CODE>sm_</CODE>.
It is conventional to use the <CODE>Name_UNSET</CODE> name to indicate an attribute
type that is either <CODE>unset</CODE> or has a value of type <CODE>Name</CODE>. 
It is conventional to indicate a legal <CODE>NULL</CODE> value by the type
named <CODE>Name_NULL_UNSET</CODE>. 

<P><PRE>TYPE
  DEF_ID_UNSET = M3AST_AS.DEF_ID;
  TYPE_SPEC_UNSET = M3AST_AS.TYPE_SPEC;
  EXP_UNSET = M3AST_AS.EXP;
  Proc_decl_UNSET = M3AST_AS.Proc_decl;
  METHOD_OVERRIDE_UNSET = M3AST_AS.METHOD_OVERRIDE;

  EXP_NULL_UNSET = M3AST_AS.EXP_NULL;
  DEF_ID_NULL_UNSET = M3AST_AS.DEF_ID_NULL;
</PRE> These functions return distinguished values that indicate {\it unset}. 

<P><PRE>PROCEDURE <A HREF="M3AST_SM.m3#UNSET_EXP">UNSET_EXP</A>(): EXP_NULL_UNSET;

PROCEDURE <A HREF="M3AST_SM.m3#UNSET_DEF_ID">UNSET_DEF_ID</A>(): DEF_ID_NULL_UNSET;
</PRE> \subsection{Unit Attributes} 

<P> A <CODE>UNIT</CODE> has a back pointer to the parent <CODE>Compilation_Unit</CODE>. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.UNIT
       sm_comp_unit: M3AST_AS.Compilation_Unit *&gt;
</PRE> A <CODE>UNIT_WITH_BODY</CODE> has the following semantic attributes:
<P>
\begin{itemize}
\item The set of units defined as the transitive closure of all imported 
      interfaces, plus, in the case of a module, the exported interfaces.
<P>
\item The set of all <CODE>OBJECT</CODE> types and traced <CODE>REF</CODE> types in the unit.
<P>
\item For each <CODE>REVEAL</CODE> of a particular opaque type in the unit, information 
      that is needed for consistency checking by, say, a Modula-3 linker. 
\end{itemize} 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.UNIT_WITH_BODY
       sm_import_s: SEQUENCE OF M3AST_AS_Used_interface_id.T;
       sm_type_spec_s: SEQUENCE OF M3AST_AS_TYPE_SPEC.T;
       sm_reveal_s: SEQUENCE OF Opaque_type_Revln *&gt;
</PRE> An <CODE>Opaque_type_Revln</CODE> is a new node type introduced at this level
to carry information about a revelation. The <CODE>sm_type_id</CODE> attribute is
a binding to the <CODE>Type_id</CODE> for which the revelation information
pertinent.  Even if there are multiple revelations for a single type,
there is only a single <CODE>Opaque_type_Revln</CODE> node constructed. The
<CODE>sm_concrete_rev</CODE> attribute is set to the <CODE>TYPE_SPEC</CODE> corresponding to
the right hand side of any concrete revelation in the unit. The
<CODE>sm_opaque_rev_s</CODE> attribute is the set of <CODE>TYPE_SPEC</CODE>s corresponding
to the right hand side of any partial revelations in the unit. <CODE>In the
unit</CODE> means that the corresponding <CODE>REVELATION</CODE> node occurs in the
tree rooted at <CODE>UNIT</CODE>. 

<P><PRE>TYPE
  <A HREF="../astall/M3AST_all.i3#Opaque_type_Revln">Opaque_type_Revln</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF Opaque_type_Revln
     sm_type_id: M3AST_SM.DEF_ID_UNSET;
     sm_concrete_rev: M3AST_AS.TYPE_SPEC;
     sm_opaque_rev_s: SEQUENCE OF M3AST_AS_TYPE_SPEC.T; *&gt;
</PRE> Generic instantiations, <CODE>UNIT_GEN_INS</CODE> nodes, have an attribute
denoting the instantiated AST. This is defined as a
<CODE>Compilation_Unit</CODE>, so that status information may be annotated on
both ASTs. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.UNIT_GEN_INS
       sm_ins_comp_unit: M3AST_AS.Compilation_Unit *&gt;
</PRE> A <CODE>Module</CODE> has a normalised set of exported interfaces. I.e.  if no
<CODE>EXPORTS</CODE> clause is present, the <CODE>MODULE M</CODE> -&gt; <CODE>MODULE M EXPORTS M</CODE>
desugaring is represented by the <CODE>sm_export_s</CODE> attribute. If an
<CODE>EXPORTS</CODE> clause is present, the <CODE>sm_export_s</CODE> sequence contains the
same members as the <CODE>as_export_s</CODE> attribute. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Module
       sm_export_s := SEQUENCE OF M3AST_AS_Used_interface_id *&gt;
</PRE>\subsection{Identifier Attributes}

<P> A <CODE>UNIT_ID</CODE> node has a back pointer to the enclosing <CODE>UNIT</CODE> 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.UNIT_ID
       sm_spec: M3AST_AS.UNIT *&gt;
</PRE> All the defining identifier nodes that can appear in a declaration
that can be marked <CODE>EXTERNAL</CODE>, multiply inherit the <CODE>EXTERNAL_ID</CODE>
class, which carries the same information as the <CODE>EXTERNAL_DECL</CODE>
class. See <CODE>M3AST_PG</CODE> interface for details. 

<P>  <PRE>&lt;*  FIELDS OF M3AST_AS.Interface_id, M3AST_AS.Type_id,
                M3AST_AS.Exc_id, M3AST_AS.Proc_id
        vEXTERNAL_ID: M3AST_PG.EXTERNAL_ID *&gt;
</PRE> Defining identifiers that can have initialising expressions
multiply inherit the <CODE>INIT_ID</CODE> class, which refers to the <CODE>EXP</CODE> node
in the initialising expression. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#INIT_ID">INIT_ID</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF INIT_ID
       sm_init_exp: M3AST_SM.EXP_NULL_UNSET *&gt;

  &lt;* FIELDS OF M3AST_AS.METHOD_OVERRIDE_ID, M3AST_AS.Field_id,
               M3AST_AS.Const_id, M3AST_AS.Var_id, M3AST_AS.F_Value_id,
               M3AST_AS.F_Readonly_id, M3AST_AS.For_id, M3AST_AS.With_id
       vINIT_ID: M3AST_SM.INIT_ID *&gt;
</PRE> <CODE>Const_id</CODE> and <CODE>Enum_id</CODE> inherit a class <CODE>CCV_ID</CODE> that captures the
value of the constant expression or value representing the enumeration
member, respectively. The representation is specified in terms of an
opaque type <CODE>Exp_value</CODE>, which is revealed by a particular compiler
implementation 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#CCV_ID">CCV_ID</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF CCV_ID
       sm_exp_value: M3AST_SM.Exp_value *&gt;

  &lt;* FIELDS OF M3AST_AS.Const_id, M3AST_AS.Enum_id
       vCCV_ID: M3AST_SM.CCV_ID *&gt;

  <A HREF="../target/M3CBackEnd_C.i3#Exp_value">Exp_value</A> &lt;: REFANY;
</PRE> A back pointer from a <CODE>Field_id</CODE>, a <CODE>Method_id</CODE> and and an
<CODE>Override_id</CODE> to the enclosing <CODE>Object_type</CODE> node, is useful and is
captured by the <CODE>RECOBJ_ID</CODE> class. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#RECOBJ_ID">RECOBJ_ID</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF RECOBJ_ID
       sm_enc_type_spec: M3AST_SM.TYPE_SPEC_UNSET *&gt;

  &lt;* FIELDS OF M3AST_AS.Field_id, M3AST_AS.METHOD_OVERRIDE_ID
       vRECOBJ_ID: M3AST_SM.RECOBJ_ID *&gt;
</PRE> Some <CODE>DEF_ID</CODE> nodes, although they occur as separate nodes in an
AST are almost re-definitions, namely a <CODE>Proc_id</CODE> in a module that
exports its counterpart in an interface, and a method override in an
<CODE>Object_type</CODE>. The connection is established through the <CODE>REDEF_ID</CODE>
class.  

<P>  <PRE><A HREF="../astall/M3AST_all.i3#REDEF_ID">REDEF_ID</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF REDEF_ID
       sm_int_def: M3AST_SM.DEF_ID_NULL_UNSET *&gt;
</PRE> For a <CODE>Proc_id</CODE> node in an interface AST, the value of <CODE>sm_int_def</CODE>
refers to itself. For a <CODE>Proc_id</CODE> node in a module AST, the value is
either <CODE>NIL</CODE>, which denotes a local, or private, procedure, or it refers
to the corresponding <CODE>Proc_id</CODE> node in one of the interface ASTs in
the <CODE>sm_export_s</CODE> set of the module, and denotes a public or exported
procedure. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Proc_id
       vREDEF_ID: M3AST_SM.REDEF_ID *&gt;
</PRE> For a <CODE>Method_id</CODE> node, the value of <CODE>sm_int_def</CODE> refers to itself.
For an <CODE>Override_id</CODE> node, the value refers to the <CODE>Method_id</CODE> node
that is being overridden. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.METHOD_OVERRIDE_ID
       vREDEF_ID: M3AST_SM.REDEF_ID *&gt;
</PRE> A <CODE>Proc_id</CODE> node has a back pointer to the containing <CODE>Proc_decl</CODE>
node. It also has an attribute <CODE>sm_concrete_proc_id</CODE>, which is the
inverse of the <CODE>sm_int_def</CODE> attribute. In a module AST, the value of
<CODE>sm_concrete_proc_id</CODE> refers to itself. In an interface AST, the value
refers to the exporting <CODE>Proc_id</CODE> node in a module AST.  In
particular, if <CODE>m.sm_intf_def = i</CODE>, then <CODE>i.sm_concrete_proc_id = m</CODE>.


<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Proc_id
       sm_spec: M3AST_SM.Proc_decl_UNSET;
       sm_concrete_proc_id: M3AST_SM.DEF_ID_NULL_UNSET *&gt;
</PRE> All used identifiers contain an attribute that denotes their
binding, or defining occurrence. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.USED_ID
       sm_def: M3AST_SM.DEF_ID_UNSET *&gt;
</PRE> All members of the <CODE>TYPED_ID</CODE> class contain an attribute that
denotes their type. We will define the value of this attribute in
pseudo Modula-3, terms of the attributes of the nodes that contain the
identifier node. Assume a function <CODE>M3TYPE_To_TYPE_SPEC</CODE> that maps a
value of type <CODE>M3TYPE</CODE> to a value of <CODE>TYPE_SPEC</CODE>, i.e. resolves the
identifiers in <CODE>Named_type</CODE> nodes. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.TYPED_ID
       sm_type_spec: M3AST_SM.TYPE_SPEC_UNSET *&gt;
</PRE><P>
<PRE>
        Const_id: const_decl.as_id.sm_type_spec =
          IF const_decl.as_type = NIL THEN const_decl.as_exp.sm_exp_type_spec
          ELSE M3TYPE_To_TYPE_SPEC(const_decl.as_type)
</PRE>
<PRE>
        Type_id: type_decl.as_id.sm_type_spec =
          IF ISTYPE(type_decl, Subtype_decl) THEN NewOpaque_type()
          ELSE M3TYPE_To_TYPE_SPEC(type_decl.as_type)
</PRE>
<PRE>
        Exc_id: exc_decl.as_id.sm_type_spec =
          M3TYPE_To_TYPE_SPEC(exc_decl.as_type)
</PRE>
<PRE>
        Var_id: ForAll v IN var_decl.as_id_s v.sm_type_spec =
          IF var_decl.as_type # NIL THEN M3TYPE_To_TYPE_SPEC(var_decl.as_type)
          ELSE var_decl.as_default.sm_exp_type_spec
</PRE>
<PRE>
        FORMAL_ID: ForAll v IN formal_param.as_id_s v.sm_type_spec =
          IF formal_param .as_type # NIL THEN 
            M3TYPE_To_TYPE_SPEC(formal_param.as_type)
          ELSE formal_param.as_default.sm_exp_type_spec
</PRE>
<PRE>
        Enum_id: ForAll v IN enumeration_type.as_id_s v.sm_type_spec =
          enumeration_type
</PRE>
<PRE>
        Field_id: ForAll v IN fields.as_id_s v.sm_type_spec =
          IF fields.as_type # NIL THEN M3TYPE_To_TYPE_SPEC(fields.as_type)
          ELSE fields.as_default.sm_exp_type_spec
</PRE>
<PRE>
        Proc_id: proc_decl.as_id.sm_type_spec = proc_decl.as_type;
</PRE>
<PRE>
        Method_id: method.as_id.sm_type_spec = method.as_type;
</PRE>
<PRE>
        Override_id: override_id.sm_type_spec =
          override_id.vREDEF_ID.sm_int_def.sm_type_spec
</PRE>
<PRE>
        For_id: for_st.as_id.sm_type_spec =
          CommonBaseType(for_st.as_from.sm_exp_type_spec,
                         for_st.as_to.sm_exp_type_spec)
</PRE>
<PRE>
        Handler_id: handler.as_id.sm_type_spec =
          NARROW(SeqM3AST_AS_Qual_used_id.First(handler.qual_id_s).sm_def,
                 M3AST_AS.Exc_id).sm_type_spec
</PRE>
<PRE>
        Tcase_id: tcase.as_id.sm_type_spec =
          M3TYPE_To_TYPE_SPEC(SeqM3AST_AS_M3TYPE.First(tcase.as_type_s);
</PRE>
<PRE>
        With_id: binding.as_id.sm_type_spec =
          binding.as_exp.sm_exp_type_spec; 


<P>
<P></PRE>
\subsection{Type Attributes} 

<P> Enumeration types have an attribute specifying the number of elements. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Enumeration_type
       sm_num_elements: INTEGER *&gt;
</PRE> <CODE>Array_type</CODE> nodes have an attribute denoting their normalised
form.  E.g. 
<P>
<PRE>
      ARRAY [0..9], [0..9] OF T 
      ARRAY [0..9] OF ARRAY [0..9] OF T  (* normalsed 


<P><PRE>We reuse the same &quot;Array_type&quot; node with the constraint that the
&quot;as_indextype_s&quot; has at most one member. *)

  &lt;* FIELDS OF M3AST_AS.Array_type
       sm_norm_type: M3AST_AS.Array_type *&gt;
</PRE> An <CODE>Opaque_type</CODE> node has attributes denoting all its revelations.
The scope of these attributes is <CODE>global</CODE> in the sense that whenever a
revelation that refers to this <CODE>Opaque_type</CODE> node is processed in any
AST, the corresponding <CODE>TYPE_SPEC</CODE> node is added to the the set.
Contrast this to the information in an <CODE>Opaque_type_Revln</CODE> node which
is local to a given AST. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Opaque_type
     sm_concrete_type_spec: M3AST_SM.TYPE_SPEC_UNSET;
     sm_type_spec_s: SEQUENCE OF M3AST_AS_TYPE_SPEC.T *&gt;
</PRE> <CODE>Named_type</CODE> nodes have an attribute denoting the resolution of the
name to a <CODE>TYPE_SPEC</CODE>. Given that the name resolves to a <CODE>Type_id</CODE> node
<CODE>t</CODE>, the value is given by <CODE>t.sm_type_spec</CODE>. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Named_type
       sm_type_spec: M3AST_SM.TYPE_SPEC_UNSET *&gt;
</PRE> Subrange types have an attribute denoting their base type 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Subrange_type
       sm_base_type_spec: M3AST_SM.TYPE_SPEC_UNSET *&gt;
</PRE> All <CODE>TYPE_SPEC</CODE> nodes have a size in bits and an alignment in bits.
Although these values are back-end specific, they can feature in
type-checking through the use of the <CODE>BITSIZE/BYTESIZE</CODE> function in type
constructors. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.TYPE_SPEC
       sm_bitsize: INTEGER;
       sm_align: INTEGER *&gt;
</PRE> <CODE>Object_type</CODE> nodes have additional attributes to hold the size and
alignment of the referent; i.e. <CODE>sm_bitsize</CODE> for an <CODE>Object_type</CODE> is
the same as that for a <CODE>Ref_type</CODE>. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Object_type
       sm_rf_bitsize: INTEGER;
       sm_rf_align: INTEGER *&gt;
</PRE> Irrespective of whether the programmer supplied an explicit brand,
one is made available as an <CODE>Exp_value</CODE> that will denote a text
literal. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Brand
       sm_brand: M3AST_SM.Exp_value *&gt;
</PRE> A <CODE>Procedure_type</CODE> is distinguished as to a procedure signature or
method signature by an attribute <CODE>sm_def_id</CODE>, which refers to the
<CODE>Proc_id</CODE> or <CODE>Method_id</CODE>, respectively. The case of a standalone
signature (i.e.  <CODE>T = PROCEDURE(...)</CODE>) is indicated by <CODE>NIL</CODE>.  In a
<CODE>Type.method</CODE> context, the <CODE>sm_exp_type_spec</CODE> attribute (see the
Expressions section) of the selection node refers to a
<CODE>Procedure_type</CODE>, with <CODE>sm_def_id</CODE> referring to the <CODE>Type_id</CODE> node
denoting <CODE>Type</CODE>. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Procedure_type
       sm_def_id: M3AST_SM.DEF_ID_NULL_UNSET *&gt;
</PRE> Types used to represent the arguments to the built-in (polymorphic)
procedures. These only occur in the AST that represents the built-in
types. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Type_type">Type_type</A> &lt;: M3AST_AS.TYPE_SPEC;
  <A HREF="../astall/M3AST_all.i3#Any_type">Any_type</A> &lt;: M3AST_AS.TYPE_SPEC;
</PRE> The notion of {\it no-type} is convenient, e.g. for a procedure
call that does not return a result. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Void_type">Void_type</A> &lt;: M3AST_AS.TYPE_SPEC;
</PRE> \subsection{Expressin Attributes}

<P> All expressions have an associated type defined by the rules for
expressions in the language definition. If an expression can be
evaluated at compile time, it will also have a constant value. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.EXP
       sm_exp_type_spec: M3AST_SM.TYPE_SPEC_UNSET;
       sm_exp_value: M3AST_SM.Exp_value *&gt;
</PRE> Procedure calls have a normalised parameter list. The value of
<CODE>call.as_exp.sm_exp_type_spec</CODE>, which will refer to a <CODE>Procedure_type</CODE>
node, defines the order and default values of the formal parameters.
The <CODE>sm_actual_s</CODE> list will correspond to the rules for procedure call
in section 2.3.2 of the language definition. <CODE>sm_actual_s</CODE> is
admittedly a bad choice of name, since it denotes a sequence of
<CODE>EXPs</CODE> not a sequence of <CODE>Actuals</CODE>. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Call
       sm_actual_s: SEQUENCE OF M3AST_AS_EXP.T *&gt;
</PRE> Calls to NEW have the method binding desuraging computed.
   For example:
<P>
<PRE>
       NEW(T, m := P, f := E) is desugared to:
       NEW(T OBJECT OVERRIDES m := P END, f := E);
</PRE>
The <CODE>sm_exp_type_spec</CODE> attribute for a <CODE>NEWCall</CODE> node is the desugared
<CODE>Object_type</CODE>. The methods that walk the children of a <CODE>NEWCall</CODE> node
are overridden at this level to walk the desugared parameters. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.NEWCall
       sm_norm_actual_s: SEQUENCE OF M3AST_AS_Actual.T *&gt;
</PRE> Record constructors also have a normalised set of bindings, again
according to the rules in section 2.6.8 of the language definition. 

<P>  <PRE>&lt;* FIELDS OF M3AST_AS.Constructor
       sm_actual_s: SEQUENCE OF M3AST_AS_RANGE_EXP.T *&gt;
</PRE> When generating the normalised parameter bindings for a built-in
call with a <CODE>Type</CODE> as argument, we must invent a subtype of <CODE>EXP</CODE> to
denote it, since the <CODE>sm_actual_s</CODE> attribute is a sequence of <CODE>EXP</CODE>
nodes.  The value of <CODE>TypeActual.sm_exp_type_spec</CODE> is the <CODE>TYPE_SPEC</CODE>
node corresponding to the actual parameter. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#TypeActual">TypeActual</A> &lt;: M3AST_AS.EXP;
</PRE>\subsection{Identifier Scopes} 

<P> It is sometimes convenient to enumerate all the <CODE>DEF_IDs</CODE> that are
in scope at a particular point in an AST. This can be used, for
example, to perform additional name resolution beyond that already
carried out for <CODE>USED_ID</CODE> nodes in the AST. This is achieved by
introducing a <CODE>SCOPE</CODE> class that is multiply inherited by the relevant
AST nodes. This class denotes the identifiers introduced into scope by
the associated node and references the enclosing <CODE>SCOPE</CODE> node. So, by
following the chain of enclosing scopes, one can enumerate all the
<CODE>DEF_IDs</CODE> in scope at any given point. Contrary to normal practice, a
back-pointer to the multiply inheriting node is recorded. Several
nodes may participate in defining a unique scope, and all of these
will have the same value of <CODE>sm_level</CODE>. Identifiers will all be
distinct in <CODE>SCOPE</CODE>s at the same level. The built-in identifiers are
at level zero. The <CODE>SCOPE</CODE> of a <CODE>Block</CODE> node associated with a
<CODE>UNIT_ID</CODE> or <CODE>Proc_id</CODE> may be empty, in which case, the enclosing
<CODE>SCOPE</CODE> node will contain the associated declared identifiers. 

<P>   <PRE><A HREF="../astall/M3AST_all.i3#SCOPE">SCOPE</A> &lt;: M3AST.NODE;
   &lt;* FIELDS OF SCOPE
      sm_def_id_s: SEQUENCE OF M3AST_AS_DEF_ID.T;
      sm_enc_scope: SCOPE;
      sm_level: INTEGER;
      sm_mi_node: M3AST_AS.SRC_NODE; *&gt;
</PRE> The following node types inherit the SCOPE class. 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.UNIT_ID, M3AST_AS.Block, M3AST_AS.Proc_id,
                M3AST_AS.Method_id, M3AST_AS.With_id, M3AST_AS.For_id,
                M3AST_AS.Tcase_id, M3AST_AS.Handler_id
        vSCOPE: SCOPE *&gt;
</PRE>\subsection{Multiple Inheritance Support} 

<P> Almost all the classes that were introduced at at this level
involve multiple inheritance, which cannot be expressed driectly in
Modula-3. The following methods are defined onan <CODE>M3AST.NODE</CODE>, to be
used where you would otherwise use <CODE>ISTYPE</CODE>.  If the result of the
call is TRUE, the <CODE>out</CODE> parameter is set to the multiply inherited
part of the (composite) node. The methods are revealed in the
representation interface (e.g, <CODE>M3AST_SM_F</CODE>).  

<P> 
<PRE>
       METHODS (* OF M3AST.NODE 

<PRE>|    IsA_INIT_ID(VAR(*out*) init_id: INIT_ID): BOOLEAN;
|    IsA_CCV_ID(VAR(*out*) ccv_id: CCV_ID): BOOLEAN;
|    IsA_RECOBJ_ID(VAR(*out*) recobj_id: RECOBJ_ID): BOOLEAN;
|    IsA_REDEF_ID(VAR(*out*) redef_id: REDEF_ID): BOOLEAN;
|    IsA_SCOPE(VAR(*out*) scope: SCOPE): BOOLEAN;
*)
</PRE> \subsection{Temporary Attributes}
<P>
The following attributes are defined to be set after semantic analysis
is complete, but have {\it temporary} status. The original notion of
temporary was defined such that these attributes would not be saved in
persistent ASTs, for example, in AST {\it pickles}. Certainly the
attributes can be recomputed in a single pass over the tree and the
expectation is that an implementation will make this transparent to
the client. For backward compatibility the attributes still contain
a <CODE>tmp_</CODE> prefix and are revealed in the representation interface
for <CODE>M3AST_TM</CODE> (e.g. <CODE>M3AST_TM_F</CODE>). 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.TYPE_SPEC
        tmp_unit_id: M3AST_AS.UNIT_ID *&gt;

   &lt;* FIELDS OF M3AST_AS.DEF_ID
        tmp_unit_id: M3AST_AS.UNIT_ID *&gt;
</PRE> These attributes denote which unit (AST) that a <CODE>DEF_ID</CODE> or <CODE>TYPE_SPEC</CODE>
belongs to. 

<P><PRE>END M3AST_SM.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
