<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST_SM_F.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST_SM_F.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3AST_SM_F.i3">M3AST_SM_F</A></implements></module>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="M3AST_AS.i3">M3AST_AS</A>, <A HREF="M3AST_PG.i3">M3AST_PG</A>, <A HREF="M3AST_SM.i3">M3AST_SM</A>;

PROCEDURE <A NAME="NotA_INIT_ID"><procedure>NotA_INIT_ID</procedure></A>(&lt;*UNUSED*&gt; n: NODE;
                       &lt;*UNUSED*&gt; VAR(*out*) init_id: M3AST_SM.INIT_ID): BOOLEAN=
  BEGIN RETURN FALSE END NotA_INIT_ID;

PROCEDURE <A NAME="NotA_CCV_ID"><procedure>NotA_CCV_ID</procedure></A>(&lt;*UNUSED*&gt; n: NODE;
                      &lt;*UNUSED*&gt; VAR(*out*) ccv_id: M3AST_SM.CCV_ID): BOOLEAN=
  BEGIN RETURN FALSE END NotA_CCV_ID;

PROCEDURE <A NAME="NotA_RECOBJ_ID"><procedure>NotA_RECOBJ_ID</procedure></A>(
    &lt;*UNUSED*&gt; n: NODE;
    &lt;*UNUSED*&gt; VAR(*out*) recobj_id: M3AST_SM.RECOBJ_ID): BOOLEAN=
  BEGIN RETURN FALSE END NotA_RECOBJ_ID;

PROCEDURE <A NAME="NotA_REDEF_ID"><procedure>NotA_REDEF_ID</procedure></A>(
    &lt;*UNUSED*&gt; n: NODE;
    &lt;*UNUSED*&gt; VAR(*out*) init_id: M3AST_SM.REDEF_ID): BOOLEAN=
  BEGIN RETURN FALSE END NotA_REDEF_ID;

PROCEDURE <A NAME="NotA_SCOPE"><procedure>NotA_SCOPE</procedure></A>(&lt;*UNUSED*&gt; n: NODE;
                     &lt;*UNUSED*&gt; VAR(*out*) scope: M3AST_SM.SCOPE): BOOLEAN=
  BEGIN RETURN FALSE END NotA_SCOPE;

PROCEDURE <A NAME="A_INIT_ID"><procedure>A_INIT_ID</procedure></A>(n: NODE;
                    VAR(*out*) init_id: M3AST_SM.INIT_ID): BOOLEAN=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Const_id(t) =&gt; init_id := t.vINIT_ID; RETURN TRUE
    | M3AST_AS.Var_id(t) =&gt; init_id := t.vINIT_ID; RETURN TRUE
    | M3AST_AS.F_Value_id(t) =&gt; init_id := t.vINIT_ID; RETURN TRUE
    | M3AST_AS.F_Readonly_id(t) =&gt; init_id := t.vINIT_ID; RETURN TRUE
    | M3AST_AS.Field_id(t) =&gt; init_id := t.vINIT_ID; RETURN TRUE
    | M3AST_AS.For_id(t) =&gt; init_id := t.vINIT_ID; RETURN TRUE
    | M3AST_AS.With_id(t) =&gt; init_id := t.vINIT_ID; RETURN TRUE
    | M3AST_AS.METHOD_OVERRIDE_ID(t) =&gt; init_id := t.vINIT_ID; RETURN TRUE;
    ELSE RETURN FALSE
    END
  END A_INIT_ID;

PROCEDURE <A NAME="A_CCV_ID"><procedure>A_CCV_ID</procedure></A>(n: NODE;
                      VAR(*out*) ccv_id: M3AST_SM.CCV_ID): BOOLEAN=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Const_id(t) =&gt; ccv_id := t.vCCV_ID; RETURN TRUE
    | M3AST_AS.Enum_id(t) =&gt; ccv_id := t.vCCV_ID; RETURN TRUE
    ELSE RETURN FALSE
    END;
  END A_CCV_ID;

PROCEDURE <A NAME="A_RECOBJ_ID"><procedure>A_RECOBJ_ID</procedure></A>(n: NODE;
                         VAR(*out*) recobj_id: M3AST_SM.RECOBJ_ID): BOOLEAN=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.METHOD_OVERRIDE_ID(t) =&gt; recobj_id := t.vRECOBJ_ID; RETURN TRUE
    | M3AST_AS.Field_id(t) =&gt; recobj_id := t.vRECOBJ_ID; RETURN TRUE
    ELSE RETURN FALSE
    END;
  END A_RECOBJ_ID;

PROCEDURE <A NAME="A_REDEF_ID"><procedure>A_REDEF_ID</procedure></A>(n: NODE;
                        VAR(*out*) redef_id: M3AST_SM.REDEF_ID): BOOLEAN=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Proc_id(t) =&gt; redef_id := t.vREDEF_ID; RETURN TRUE
    | M3AST_AS.METHOD_OVERRIDE_ID(t) =&gt; redef_id := t.vREDEF_ID; RETURN TRUE
    ELSE RETURN FALSE
    END;
  END A_REDEF_ID;

PROCEDURE <A NAME="A_SCOPE"><procedure>A_SCOPE</procedure></A>(n: NODE;
                     VAR(*out*) scope: M3AST_SM.SCOPE): BOOLEAN=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.UNIT_ID(t) =&gt; scope := t.vSCOPE; RETURN TRUE;
    | M3AST_AS.Block(t) =&gt; scope := t.vSCOPE; RETURN TRUE;
    | M3AST_AS.Proc_id(t) =&gt; scope := t.vSCOPE; RETURN TRUE;
    | M3AST_AS.Method_id(t) =&gt; scope := t.vSCOPE; RETURN TRUE;
    | M3AST_AS.With_id(t) =&gt; scope := t.vSCOPE; RETURN TRUE;
    | M3AST_AS.For_id(t) =&gt; scope := t.vSCOPE; RETURN TRUE;
    | M3AST_AS.Tcase_id(t) =&gt; scope := t.vSCOPE; RETURN TRUE;
    | M3AST_AS.Handler_id(t) =&gt; scope := t.vSCOPE; RETURN TRUE;
    ELSE
      RETURN FALSE
    END
  END A_SCOPE;

PROCEDURE <A NAME="Init_UNIT_ID"><procedure>Init_UNIT_ID</procedure></A>(n: UNIT_ID): AST.NODE=
  BEGIN
    n.vSCOPE := NEW(M3AST_SM.SCOPE).init();
    n.vSCOPE.sm_mi_node := n;
    RETURN n;
  END Init_UNIT_ID;

PROCEDURE <A NAME="Init_Interface_id"><procedure>Init_Interface_id</procedure></A>(n: Interface_id): AST.NODE RAISES {}=
  BEGIN
    n.vEXTERNAL_ID := NEW(M3AST_PG.EXTERNAL_ID).init();
    RETURN Init_UNIT_ID(n);
  END Init_Interface_id;

PROCEDURE <A NAME="Init_Module_id"><procedure>Init_Module_id</procedure></A>(n: Module_id): AST.NODE RAISES {}=
  BEGIN
    RETURN Init_UNIT_ID(n);
  END Init_Module_id;

PROCEDURE <A NAME="Init_Type_id"><procedure>Init_Type_id</procedure></A>(n: Type_id): AST.NODE RAISES {}=
  BEGIN
    n.vEXTERNAL_ID := NEW(M3AST_PG.EXTERNAL_ID).init();
    RETURN n;
  END Init_Type_id;

PROCEDURE <A NAME="Init_F_Value_id"><procedure>Init_F_Value_id</procedure></A>(n: F_Value_id): AST.NODE RAISES {}=
  BEGIN
    n.vINIT_ID := NEW(M3AST_SM.INIT_ID).init();
    RETURN n;
  END Init_F_Value_id;

PROCEDURE <A NAME="Init_F_Readonly_id"><procedure>Init_F_Readonly_id</procedure></A>(n: F_Readonly_id): AST.NODE RAISES {}=
  BEGIN
    n.vINIT_ID := NEW(M3AST_SM.INIT_ID).init();
    RETURN n;
  END Init_F_Readonly_id;

PROCEDURE <A NAME="Init_For_id"><procedure>Init_For_id</procedure></A>(n: For_id): AST.NODE RAISES {}=
  BEGIN
    n.vINIT_ID := NEW(M3AST_SM.INIT_ID).init();
    n.vSCOPE := NEW(M3AST_SM.SCOPE).init();
    n.vSCOPE.sm_mi_node := n;
    RETURN n;
  END Init_For_id;

PROCEDURE <A NAME="Init_Const_id"><procedure>Init_Const_id</procedure></A>(n: Const_id): AST.NODE RAISES {}=
  BEGIN
    n.vINIT_ID := NEW(M3AST_SM.INIT_ID).init();
    n.vCCV_ID := NEW(M3AST_SM.CCV_ID).init();
    n.vEXTERNAL_ID := NEW(M3AST_PG.EXTERNAL_ID).init();
    RETURN n;
  END Init_Const_id;

PROCEDURE <A NAME="Init_Var_id"><procedure>Init_Var_id</procedure></A>(n: Var_id): AST.NODE RAISES {}=
  BEGIN
    n.vINIT_ID := NEW(M3AST_SM.INIT_ID).init();
    n.vEXTERNAL_ID := NEW(M3AST_PG.EXTERNAL_ID).init();
    RETURN n;
  END Init_Var_id;

PROCEDURE <A NAME="Init_Proc_id"><procedure>Init_Proc_id</procedure></A>(n: Proc_id): AST.NODE RAISES {}=
  BEGIN
    n.vREDEF_ID := NEW(M3AST_SM.REDEF_ID).init();
    n.vEXTERNAL_ID := NEW(M3AST_PG.EXTERNAL_ID).init();
    n.vSCOPE := NEW(M3AST_SM.SCOPE).init();
    n.vSCOPE.sm_mi_node := n;
    n.sm_concrete_proc_id := M3AST_SM.UNSET_DEF_ID();
    RETURN n;
  END Init_Proc_id;

PROCEDURE <A NAME="Init_Enum_id"><procedure>Init_Enum_id</procedure></A>(n: Enum_id): AST.NODE RAISES {}=
  BEGIN
    n.vCCV_ID := NEW(M3AST_SM.CCV_ID).init();
    RETURN n;
  END Init_Enum_id;

PROCEDURE <A NAME="Init_Field_id"><procedure>Init_Field_id</procedure></A>(n: Field_id): AST.NODE RAISES {}=
  BEGIN
    n.vRECOBJ_ID := NEW(M3AST_SM.RECOBJ_ID).init();
    n.vINIT_ID := NEW(M3AST_SM.INIT_ID).init();
    RETURN n;
  END Init_Field_id;

PROCEDURE <A NAME="Init_METHOD_OVERRIDE_ID"><procedure>Init_METHOD_OVERRIDE_ID</procedure></A>(n: METHOD_OVERRIDE_ID): AST.NODE RAISES {}=
  BEGIN
    n.vINIT_ID := NEW(M3AST_SM.INIT_ID).init();
    n.vREDEF_ID := NEW(M3AST_SM.REDEF_ID).init();
    n.vRECOBJ_ID := NEW(M3AST_SM.RECOBJ_ID).init();
    RETURN n;
  END Init_METHOD_OVERRIDE_ID;

PROCEDURE <A NAME="Init_Method_id"><procedure>Init_Method_id</procedure></A>(n: Method_id): AST.NODE RAISES {}=
  BEGIN
    n.vSCOPE := NEW(M3AST_SM.SCOPE).init();
    n.vSCOPE.sm_mi_node := n;
    RETURN Init_METHOD_OVERRIDE_ID(n);
  END Init_Method_id;

PROCEDURE <A NAME="Init_With_id"><procedure>Init_With_id</procedure></A>(n: With_id): AST.NODE RAISES {}=
  BEGIN
    n.vINIT_ID := NEW(M3AST_SM.INIT_ID).init();
    n.vSCOPE := NEW(M3AST_SM.SCOPE).init();
    n.vSCOPE.sm_mi_node := n;
    RETURN n;
  END Init_With_id;

PROCEDURE <A NAME="Init_Exc_id"><procedure>Init_Exc_id</procedure></A>(n: Exc_id): AST.NODE RAISES {}=
  BEGIN
    n.vEXTERNAL_ID := NEW(M3AST_PG.EXTERNAL_ID).init();
    RETURN n;
  END Init_Exc_id;

PROCEDURE <A NAME="Init_Tcase_id"><procedure>Init_Tcase_id</procedure></A>(n: Tcase_id): AST.NODE RAISES {}=
  BEGIN
    n.vSCOPE := NEW(M3AST_SM.SCOPE).init();
    n.vSCOPE.sm_mi_node := n;
    RETURN n;
  END Init_Tcase_id;

PROCEDURE <A NAME="Init_Handler_id"><procedure>Init_Handler_id</procedure></A>(n: Handler_id): AST.NODE RAISES {}=
  BEGIN
    n.vSCOPE := NEW(M3AST_SM.SCOPE).init();
    n.vSCOPE.sm_mi_node := n;
    RETURN n;
  END Init_Handler_id;

PROCEDURE <A NAME="Init_Block"><procedure>Init_Block</procedure></A>(n: Block): AST.NODE RAISES {}=
  BEGIN
    n.vSCOPE := NEW(M3AST_SM.SCOPE).init();
    n.vSCOPE.sm_mi_node := n;
    RETURN n;
  END Init_Block;

PROCEDURE <A NAME="Init_INIT_ID"><procedure>Init_INIT_ID</procedure></A>(n: INIT_ID): AST.NODE RAISES {}=
  BEGIN
    n.sm_init_exp := M3AST_SM.UNSET_EXP();
    RETURN n;
  END Init_INIT_ID;

PROCEDURE <A NAME="Init_REDEF_ID"><procedure>Init_REDEF_ID</procedure></A>(n: REDEF_ID): AST.NODE RAISES {}=
  BEGIN
    n.sm_int_def := M3AST_SM.UNSET_DEF_ID();
    RETURN n;
  END Init_REDEF_ID;

PROCEDURE <A NAME="Init_Procedure_type"><procedure>Init_Procedure_type</procedure></A>(n: Procedure_type): AST.NODE RAISES {}=
  BEGIN
    n.sm_def_id := M3AST_SM.UNSET_DEF_ID();
    RETURN n;
  END Init_Procedure_type;

BEGIN
END M3AST_SM_F.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
