<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST_SM_Walk.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST_SM_Walk.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>M3AST_SM_Walk</module> EXPORTS <A HREF="M3AST_SM_F.i3"><implements>M3AST_SM_F</A></implements>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="M3AST_AS.i3">M3AST_AS</A>, <A HREF="M3AST_AS_F.i3">M3AST_AS_F</A>;
IMPORT <A HREF="../gast/AST_WalkRep.i3">AST_WalkRep</A>, <A HREF="../gast/AST_Iter.i3">AST_Iter</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_Actual.i3">SeqM3AST_AS_Actual</A>;

IMPORT <A HREF="M3AST_AS_Iter_rep.i3">M3AST_AS_Iter_rep</A>;

PROCEDURE <A NAME="Walk_NEWCall"><procedure>Walk_NEWCall</procedure></A>(n: NEWCall; h: AST_WalkRep.Handle) RAISES ANY=
  VAR
    m: M3AST_AS.Actual;
    iter: SeqM3AST_AS_Actual.Iter;
    s: SeqM3AST_AS_Actual.T;
  BEGIN
    h.Visit(n.as_callexp);
    IF n.sm_norm_actual_s = NIL THEN (* not set up yet! *)
      s := n.as_param_s;
    ELSE
      s := n.sm_norm_actual_s;
    END;
    iter := SeqM3AST_AS_Actual.NewIter(s);
    WHILE SeqM3AST_AS_Actual.Next(iter, m) DO h.Visit(m); END;
 END Walk_NEWCall;

TYPE
  Call_iter = AST_Iter.T OBJECT
    n: NEWCall;
    iter0: SeqM3AST_AS_Actual.Iter;
    norm := FALSE;
  OVERRIDES
    next := Call_next;
  END;

PROCEDURE <A NAME="NewIter_NEWCall"><procedure>NewIter_NEWCall</procedure></A>(n: NEWCall): AST_Iter.T RAISES {}=
  VAR
    s: SeqM3AST_AS_Actual.T;
  BEGIN
    WITH iter = NEW(Call_iter, n := n) DO
      IF n.sm_norm_actual_s = NIL THEN (* not set up yet! *)
        s := n.as_param_s;
      ELSE
        s := n.sm_norm_actual_s;
        iter.norm := TRUE;
      END;
      iter.iter0 := SeqM3AST_AS_Actual.NewIter(s);
      RETURN iter;
    END;
  END NewIter_NEWCall;

PROCEDURE <A NAME="Call_next"><procedure>Call_next</procedure></A>(iter: Call_iter; VAR r: AST.NODE): BOOLEAN RAISES {}=
  VAR
    node0: M3AST_AS.Actual;
  BEGIN
    LOOP
      CASE iter.slot OF
      | 0 =&gt;
          r := iter.n.as_callexp;
          EXIT;

      | 1 =&gt;
          IF SeqM3AST_AS_Actual.Next(iter.iter0, node0) THEN
            r := node0;
            RETURN TRUE;
          END;

      ELSE
        RETURN FALSE;
      END;
      INC(iter.slot);
    END;
    INC(iter.slot);
    RETURN TRUE;
  END Call_next;
</PRE>******************************************************************
PROCEDURE Update_NEWCall(n: NEWCall; iter: AST_Iter.T; nn: AST.NODE)
    RAISES {}=
  VAR
    narrow_iter:= NARROW(iter, Call_iter);
  BEGIN
    LOOP
      CASE iter.slot OF &lt;*NOWARN*&gt;
      <PRE>
      0 =&gt; 
          </PRE>
n.as_callexp := nn;
          RETURN ;
<P>
      <PRE>
      1 =&gt; 
          </PRE>
IF NOT SeqM3AST_AS_Actual.Exhausted(narrow_iter.iter0) THEN
            IF narrow_iter.norm THEN
              SeqM3AST_AS_Actual.Update(n.sm_norm_actual_s,
                  narrow_iter.iter0, nn);
            ELSE
              SeqM3AST_AS_Actual.Update(n.as_param_s, narrow_iter.iter0, nn);
            END; (* if 
            <PRE>RETURN ;
          END;

      END;
      INC(iter.slot);
    END;
  END Update_NEWCall;
*****************************************************************************)

BEGIN

END M3AST_SM_Walk.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
