<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/M3AST_TM.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/M3AST_TM.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>M3AST_TM</CODE> defines some {\em temporary} AST attributes to support
the semantic analyser. 

<P><PRE>INTERFACE <interface>M3AST_TM</interface>;
</PRE> This interface specifies some additional attributes that are
notionally <CODE>temporary</CODE>, most of which are to support the semantic
analyser.
<P>
   As with <CODE>M3AST_AS</CODE> and <CODE>M3AST_SM</CODE>, this interface only specifies an
abstract representation of the attributes, leaving the exact
representation to a companion interfaace, e.g. <CODE>M3AST_TM_F</CODE>.

<P><PRE>&lt;* PRAGMA FIELDS *&gt;
</PRE>-----------------------Private attributes-------------------------------

<P> Clients should make no assumptions about the value of any of the following
   attributes, which are private to the semantic analyser and other tools.
   Typically, a procedural interface will be provided elsewhere to
   some of the values. 

<P> A Modula-3 linker must assign a type code to all reference types.
   It turns out be convenient to also have such an attribute for
   semantic analysis. 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.TYPE_SPEC
        tmp_type_code: INTEGER; *&gt;
</PRE> To support the detection of recursive definitions, it is useful to
   flag a defining identifier as recursive (or not). 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.DEF_ID
        tmp_recursive: BOOLEAN; *&gt;
</PRE> To support setting of type attributes, instances of <CODE>Type_id</CODE> which have
   a <CODE>Named_type</CODE> as their <CODE>M3TYPE</CODE> have an attribute to allow the chain to be 
   followed.  A similar attribute is needed for <CODE>Exc_id</CODE>. 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.Type_id
        tmp_type: M3AST_AS.M3TYPE_NULL *&gt;

   &lt;* FIELDS OF M3AST_AS.Exc_id
        tmp_type: M3AST_AS.M3TYPE_NULL *&gt;
</PRE> To set the type of an method override, and to check coverage of
   defaults, we need to get from a method or override to the <CODE>Object_type</CODE>. 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.METHOD_OVERRIDE
        tmp_type: M3AST_AS.Object_type; *&gt;
</PRE> The attributes defined on an <CODE>M3AST_SM.Opaque_type_Revln in </CODE>M3AST_SM<CODE>
   only capture revelations local to an AST. The followwing attributes
   capture those revelation inherited from the imported interfaces. 

<P>
<P>   <PRE>&lt;* FIELDS OF M3AST_SM.Opaque_type_Revln
        tmp_count := 0;
        tmp_concrete_rev: M3AST_SM.TYPE_SPEC_UNSET;
        tmp_opaque_rev_s := SeqM3AST_AS_TYPE_SPEC.Null; *&gt;
</PRE> In any scope, there is the concept of the <CODE>most revealing</CODE> revelation,
   which is given by the following attribute. 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.Opaque_type
        tmp_rev_type_spec: M3AST_SM.TYPE_SPEC_UNSET; *&gt;
</PRE> We build a hash table of DEF_IDs in interfaces for fast lookup. 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.Interface
        tmp_def_id_table: IntRefTable.T; *&gt;
</PRE> IMPORT I AS J; the <CODE>J</CODE> has a back pointer to <CODE>I</CODE>, so that we
   can go through the level of indirection. 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.Interface_AS_id
        tmp_used_id: M3AST_AS.Used_interface_id; *&gt;
</PRE> to support efficient handling of RAISES clauses, we have an attribute
   that says whether a check is needed. We also mark whether a procedure
   needs a check for a missing return. 

<P>   <PRE>&lt;* FIELDS OF M3AST_AS.Proc_decl
        tmp_needs_raises: BOOLEAN;
        tmp_needs_return_check: BOOLEAN; *&gt;

   &lt;* FIELDS OF M3AST_AS.Raise_st
        tmp_fatal: BOOLEAN; *&gt;

END M3AST_TM.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
