<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/SeqElem.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/SeqElem.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

GENERIC INTERFACE <genericInterface><A HREF="SeqElem.mg">SeqElem</A></genericInterface>(Elem);
</PRE> This interface provides a sequence abstraction, tailored to
   support the repetitive constructs in an Abstract Syntax Tree.
   It can also be used to support sets, provided the client enures
   no duplicates. There are no primitives to remove elements or
   to join sequences, since these notions are infrequent in
   ASTs, and can be programmed, admittedly inefficiently, in
   terms of the given primitives. Since this interface is 
   instantiated many times, it is important to minimise its size.
<P>
   Clients of this interface should provide their own locking in the 
   case of multiple threads. 
   
<P><PRE>TYPE T &lt;: REFANY;

CONST Null: T = NIL;
</PRE><BLOCKQUOTE><EM> To declare the null sequence do: <CODE>VAR s := SeqElem.Null;</CODE>
   Do not assume, however, that an empty sequence has the value NIL,
   use <CODE>Empty</CODE> instead. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#Empty">Empty</A>(s: T): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Returns TRUE iff <CODE>s</CODE> is the empty or null sequence, FALSE otherwise. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#Length">Length</A>(s: T): CARDINAL RAISES {};
</PRE><BLOCKQUOTE><EM> Returns the length of sequence <CODE>s</CODE>. The null sequence has
   length 0. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#AddFront">AddFront</A>(VAR (*inout*) s: T; elem: Elem.T) RAISES {};
</PRE><BLOCKQUOTE><EM> Add the node <CODE>elem</CODE> to the front of sequence <CODE>s</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#AddRear">AddRear</A>(VAR (*inout*) s: T; elem: Elem.T) RAISES {};
</PRE><BLOCKQUOTE><EM> Add the node <CODE>elem</CODE> to the rear of sequence <CODE>s</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#Insert">Insert</A>(VAR (*inout*) s: T; elem: Elem.T; i: CARDINAL) RAISES {};
</PRE><BLOCKQUOTE><EM> Insert the node <CODE>elem</CODE> before the node at index <CODE>i</CODE> in the
   sequence. The nodes are indexed from <CODE>0</CODE> to <CODE>Length(s)-1</CODE>,
   and <CODE>0 &lt;= i &lt;= Length(s)</CODE>. If <CODE>i = 0</CODE> the call is equivalent
   to <CODE>AddFront(s, elem)</CODE>. If <CODE>i = Length(s)</CODE>, the call is equivalent
   to <CODE>AddRear(s, elem)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#First">First</A>(s: T): Elem.T RAISES {};
</PRE><BLOCKQUOTE><EM> Return the first node in sequence <CODE>s</CODE>. It is a checked run-time
   error if <CODE>Empty(s)</CODE>. </EM></BLOCKQUOTE><PRE>

TYPE Iter &lt;: REFANY;

PROCEDURE <A HREF="SeqElem.mg#NewIter">NewIter</A>(s: T): Iter RAISES {};
</PRE><BLOCKQUOTE><EM> Create an iterator on sequence <CODE>s</CODE>. The behaviour of the iterator
  is undefined if updates to the sequence occur during an iteration. 
  Each call creates a distinct iterator. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#Next">Next</A>(
    VAR (*inout*) iter: Iter;
    VAR (*out*) elem: Elem.T;
    ): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Sequential calls of <CODE>Next</CODE> return the members of the sequence in turn
  starting with the first. If there are no more members, FALSE is returned
  and <CODE>elem</CODE> is unchanged, else <CODE>elem</CODE> is set to the member and TRUE is
  returned. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#Exhausted">Exhausted</A>(iter: Iter): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Return TRUE iff <CODE>iter</CODE> is exhausted, i.e. a call of <CODE>Next</CODE>
   would return FALSE. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#Update">Update</A>(VAR (*inout*) s: T; iter: Iter; new_elem: Elem.T) RAISES {};
</PRE><BLOCKQUOTE><EM> If <CODE>Next(iter, elem)</CODE> would return TRUE, then this procedure replaces the
   member of <CODE>s</CODE> (whose old value was <CODE>elem) with </CODE>new_elem<CODE>. No actual call
   of </CODE>Next<CODE> takes place, however, and </CODE>iter<CODE> is NOT advanced. It is an 
   unchecked run-time error if </CODE>s<CODE> is not the same value that was passed to 
   the call of </CODE>NewIter<CODE> that created </CODE>iter<CODE>.  Typical usage is as follows:
<P>
  VAR 
    iter, iter_u := SeqElem.NewIter(s);
    elem, new_elem: Elem.T;
  BEGIN
    WHILE SeqElem.Next(iter, elem) DO
      IF some-condition THEN SeqElem.Update(s, iter_u, new_elem) END:
      EVAL SeqElem.Next(iter_u, elem);
    END;
  END
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SeqElem.mg#Ith">Ith</A>(s: T; i: CARDINAL): Elem.T RAISES {};
</PRE><BLOCKQUOTE><EM> Provides a view of the sequence as an array, indexed from <CODE>0</CODE>
   to <CODE>Length(s)-1</CODE>. It is a checked runtime error if <CODE>i</CODE> is out of
   bounds. N.B. This is not an efficient way to iterate the sequence. </EM></BLOCKQUOTE><PRE>

END SeqElem.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
