<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/SeqElem.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/SeqElem.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

GENERIC MODULE <genericModule><A HREF="SeqElem.ig">SeqElem</A></genericModule>(Elem);

PROCEDURE <A NAME="AddFront"><procedure>AddFront</procedure></A>(VAR s: T;
    elem: Elem.T) RAISES {} =
  VAR m := NEW(T);
  BEGIN
    m.elem := elem;
    m.next := s;
    s := m;
  END AddFront;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A>(t: T): CARDINAL RAISES {}=
  VAR
    i: CARDINAL := 0;
  BEGIN
    WHILE t # NIL DO
      t := t.next; INC(i);
    END; (* while *)
    RETURN i;
  END Length;

PROCEDURE <A NAME="Empty"><procedure>Empty</procedure></A>(s: T): BOOLEAN RAISES {}=
  BEGIN
    RETURN s = NIL;
  END Empty;

PROCEDURE <A NAME="AddRear"><procedure>AddRear</procedure></A>(VAR s: T; elem: Elem.T)
     RAISES {} =
  VAR
    m := NEW(T);
    t: T;
  BEGIN
    m.elem := elem;
    IF s = NIL THEN
      s := m;
    ELSE
      t := s;
      WHILE t.next # NIL DO
        t := t.next;
      END; (* while *)
      t.next := m;
    END; (* if *)
  END AddRear;

EXCEPTION IsEmpty;

PROCEDURE <A NAME="First"><procedure>First</procedure></A>(s: T): Elem.T RAISES {} =
  &lt;*FATAL IsEmpty*&gt;
  BEGIN
    IF s = NIL THEN
      RAISE IsEmpty;
    ELSE
      RETURN s.elem;
    END; (* if *)
  END First;

PROCEDURE <A NAME="NewIter"><procedure>NewIter</procedure></A>(s: T): Iter
     RAISES {} =
  BEGIN
    RETURN s;
  END NewIter;

PROCEDURE <A NAME="Next"><procedure>Next</procedure></A>(VAR iter: Iter; VAR elem: Elem.T)
    : BOOLEAN RAISES {} =
  BEGIN
    IF iter = NIL THEN
      RETURN FALSE;
    ELSE
      elem := iter.elem;
      iter := iter.next;
      RETURN TRUE;
    END; (* if *)
  END Next;

PROCEDURE <A NAME="Exhausted"><procedure>Exhausted</procedure></A>(iter: Iter): BOOLEAN RAISES {}=
  BEGIN
    RETURN iter = NIL;
  END Exhausted;

PROCEDURE <A NAME="Update"><procedure>Update</procedure></A>(&lt;*UNUSED*&gt; VAR s: T; iter: Iter; elem: Elem.T) RAISES {}=
  BEGIN
    iter.elem := elem;
  END Update;

EXCEPTION BoundsError;

PROCEDURE <A NAME="Ith"><procedure>Ith</procedure></A>(s: T; i: CARDINAL): Elem.T RAISES {}=
  &lt;*FATAL BoundsError*&gt;
  BEGIN
    FOR j := 1 TO i DO
      IF s # NIL THEN s := s.next END;
    END; (* for *)
    IF s = NIL THEN RAISE BoundsError ELSE RETURN s.elem END;
  END Ith;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A>(VAR (*inout*) s: T; elem: Elem.T; i: CARDINAL) RAISES {}=
  VAR t := s; tp: T := NIL;
    &lt;*FATAL BoundsError*&gt;
  BEGIN
    FOR j := 1 TO i DO
      IF t = NIL THEN RAISE BoundsError ELSE tp := t; t := t.next END;
    END; (* for *)
    VAR m := NEW(T);
    BEGIN
      m.elem := elem;
      IF s = NIL THEN s := m
      ELSE m.next := t; IF tp = NIL THEN s := m ELSE tp.next := m END;
      END;
    END;
  END Insert;

BEGIN

END SeqElem.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
