<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/ast/SeqElem_LM3.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/ast/SeqElem_LM3.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

GENERIC INTERFACE <genericInterface>SeqElem_LM3</genericInterface>(Elem);

&lt;*
  TYPE NODE_SEQUENCE = SEQUENCE OF Elem.T;

  FIELDS OF T
    seq: NODE_SEQUENCE;
    modified: BOOLEAN;

  PROCEDURE Empty(s)
    ENSURES
      IF (s = NIL) \or isEmpty(s.seq) THEN RESULT = TRUE ELSE RESULT = FALSE

  PROCEDURE Length(s)
    ENSURES IF (s = NIL) THEN RESULT = 0 ELSE RESULT = len(s.seq)

  PROCEDURE AddFront(s, elem)
    MODIFIES s
    ENSURES (s.seq' = elem \precat s.seq) \and s.modified'

  PROCEDURE AddRear(s, elem)
    MODIFIES s
    ENSURES (s.seq' = s.seq \postcat elem) \and s.modified'

  PROCEDURE First(s)
    ENSURES RESULT = head(s.seq)
    EXCEPT (s = NIL) \or isEmpty(s.seq) =&gt; RAISEVAL = CHECKEDRTE

  FIELDS OF Iter
    s: T;
    seq, seen: NODE_SEQUENCE;

  PROCEDURE NewIter(s)
    ENSURES (s.modified' = FALSE) \and (RESULT # NIL) \and
      (RESULT.s = s) \and
      (RESULT.seen = {}) \and (RESULT.seq = s.seq)

  PROCEDURE Next(iter, elem)
    REQUIRES (iter.s.modified' = FALSE)
    MODIFIES iter
    ENSURES
      IF (iter = NIL) \or isEmpty(iter.seq) THEN
        (RESULT = FALSE) \and UNCHANGED(elem)
      ELSE
        (elem' = head(iter.seq)) \and
        (iter.seq' = tail(iter.seq)) \and
        (iter.seen' = iter.seen \postcat elem')

  PROCEDURE Exhausted(iter)
    ENSURES
      IF (iter = NIL) \or isEmpty(iter.seq) THEN RESULT = TRUE
      ELSE RESULT = TRUE

  PROCEDURE Update(s, iter, new_elem)
    REQUIRES (iter # NIL) \and (s = iter.s)
    MODIFIES s
    ENSURES s' = (iter.seen \postcat new_elem) \postcat tail(iter.seq)
    EXCEPT
    | isEmpty(iter.seq) =&gt; RAISEVAL = CHECKEDRTE

  PROCEDURE Ith(s, i)
    REQUIRES (i &gt;= 0) \and (i &lt; len(s))
    ENSURES RESULT = s[i]
*&gt;

END SeqElem_LM3.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
