<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/astdisplay/M3ASTDisplay.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/astdisplay/M3ASTDisplay.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>M3ASTDisplay</module> EXPORTS <A HREF="M3ASTDisplay.i3"><implements>M3ASTDisplay</A></implements>, <A HREF="../gast/AST_DisplayRep.i3"><implements>AST_DisplayRep</A></implements>;

IMPORT <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../ast/M3AST.i3">M3AST</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;

IMPORT <A HREF="../gast/AST_DisplayRep.i3">AST_DisplayRep</A>, <A HREF="M3ASTDisplay_handle.i3">M3ASTDisplay_handle</A>;

REVEAL
  AST_DisplayRep.<A NAME="Handle">Handle</A> = M3ASTDisplay_handle.T BRANDED OBJECT
    ignoreChildren: BOOLEAN := FALSE;
    callOnEntry: BOOLEAN := FALSE;
    callOnExit: BOOLEAN := FALSE;
    closure: Closure := NIL;
  OVERRIDES
      Visit := DoVisit;
  END;

REVEAL
  <A NAME="Closure">Closure</A> = ASTWalk.Closure BRANDED OBJECT
      handle: Handle := NIL;
  END;

PROCEDURE <A NAME="Nodes"><procedure>Nodes</procedure></A>(
    n: M3AST.NODE;
    s: Wr.T)
    RAISES {Wr.Failure}=
  VAR
    handle := NEW(Handle);
  BEGIN
    DoNodes(handle, n, s);
  END Nodes;

PROCEDURE <A NAME="ModeNodes"><procedure>ModeNodes</procedure></A>(
    n: M3AST.NODE;
    c: Closure;
    vm : ASTWalk.VisitModeControl;
    s: Wr.T)
    RAISES {Wr.Failure} =
  VAR
    handle := NEW(Handle, closure := c);
  BEGIN
    c.handle := handle;
    handle.callOnEntry := ASTWalk.VisitMode.Entry IN vm;
    handle.callOnExit := ASTWalk.VisitMode.Exit IN vm;
    DoNodes(handle, n, s);
  END ModeNodes;

PROCEDURE <A NAME="DoNodes"><procedure>DoNodes</procedure></A>(
    handle: Handle;
    n: M3AST.NODE;
    s: Wr.T)
    RAISES {Wr.Failure}=
  &lt;*FATAL ANY*&gt;
  BEGIN
    handle.stream := s;
    TRY
      DoVisit(handle, n);
    EXCEPT
      ASTWalk.Aborted =&gt;
    END;
  END DoNodes;

PROCEDURE <A NAME="DoVisit"><procedure>DoVisit</procedure></A>(handle: Handle; n: M3AST.NODE) RAISES ANY=
  BEGIN
    IF handle.callOnEntry THEN handle.closure.callback(n); END;
    IF NOT handle.ignoreChildren THEN
      n.display(handle)
    END;
    IF handle.callOnExit THEN handle.closure.callback(n); END;
    handle.ignoreChildren := FALSE;
  END DoVisit;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="IgnoreChildren"><procedure>IgnoreChildren</procedure></A>(c: Closure) RAISES {} =
  BEGIN
    c.handle.ignoreChildren := TRUE;
  END IgnoreChildren;

BEGIN
END M3ASTDisplay.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
