<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/astdisplay/M3AST_AS_Display.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/astdisplay/M3AST_AS_Display.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="../ast/M3AST_AS_Display.i3">M3AST_AS_Display</A></implements></module>;

IMPORT <A HREF="../gast/AST_DisplayRep.i3">AST_DisplayRep</A>;
IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>, <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>;
IMPORT <A HREF="../../derived/SeqM3AST_LX_SRC_NODE.i3">SeqM3AST_LX_SRC_NODE</A>;

IMPORT <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>;
IMPORT <A HREF="../syn/M3CId.i3">M3CId</A>, <A HREF="../syn/M3CLiteral.i3">M3CLiteral</A>, <A HREF="../syn/M3CToken.i3">M3CToken</A>, <A HREF="../syn/M3CWhitespace.i3">M3CWhitespace</A>;
IMPORT <A HREF="M3ASTDisplay_handle.i3">M3ASTDisplay_handle</A>;

PROCEDURE <A NAME="SRC_NODE_C"><procedure>SRC_NODE_C</procedure></A>(n: M3AST_AS_F.SRC_NODE_C; h: AST_DisplayRep.Handle)
    RAISES ANY=
  VAR iter := SeqM3AST_LX_SRC_NODE.NewIter(n.lx_node_s);
    src_node: M3AST_LX.SRC_NODE;
  BEGIN
    WHILE SeqM3AST_LX_SRC_NODE.Next(iter, src_node) DO
      h.Visit(src_node);
    END;
  END SRC_NODE_C;

PROCEDURE <A NAME="ID"><procedure>ID</procedure></A>(n: M3AST_AS_F.ID; h: AST_DisplayRep.Handle) RAISES ANY=
  BEGIN
    Wr.PutText(h.stream, M3CId.ToText(n.lx_symrep));
  END ID;

PROCEDURE <A NAME="LITERAL"><procedure>LITERAL</procedure></A>(n: M3AST_AS_F.LITERAL; h: AST_DisplayRep.Handle) RAISES ANY
    =
  BEGIN
    Wr.PutText(h.stream, M3CLiteral.ToText(n.lx_litrep));
  END LITERAL;

PROCEDURE <A NAME="Whitespace"><procedure>Whitespace</procedure></A>(n: M3AST_AS_F.Whitespace; h: AST_DisplayRep.Handle)
    RAISES ANY=
  BEGIN
    Wr.PutText(h.stream, M3CWhitespace.ToText(n.lx_whitespace_rep));
  END Whitespace;

PROCEDURE <A NAME="Comment"><procedure>Comment</procedure></A>(&lt;*UNUSED*&gt; n: M3AST_AS_F.Comment;
                  &lt;*UNUSED*&gt; h: AST_DisplayRep.Handle) =
  BEGIN
  END Comment;

PROCEDURE <A NAME="Pragma"><procedure>Pragma</procedure></A>(&lt;*UNUSED*&gt; n: M3AST_AS_F.Pragma;
                 &lt;*UNUSED*&gt; h: AST_DisplayRep.Handle) =
  BEGIN
  END Pragma;

PROCEDURE <A NAME="BadChar"><procedure>BadChar</procedure></A>(&lt;*UNUSED*&gt; n: M3AST_AS_F.BadChar;
                  &lt;*UNUSED*&gt;  h: AST_DisplayRep.Handle) =
  BEGIN
  END BadChar;

PROCEDURE <A NAME="Token"><procedure>Token</procedure></A>(n: M3AST_AS_F.Token; h: AST_DisplayRep.Handle) RAISES ANY=
  BEGIN
    Wr.PutText(h.stream, M3CToken.Token_repToText(n.lx_token_rep));
  END Token;

BEGIN
END M3AST_AS_Display.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
