<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/astdisplay/StdFormat.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/astdisplay/StdFormat.m3</H2></A><HR>
<inModule>
<PRE></PRE>***********************************************************************
!		                                                        *
!*                                                                      *
!*         Copyright 1994 Sun Microsystems, Inc. All Rights Reserved.   *
!*                                                                      *
!*      Permission to use, copy, modify, and distribute this software   *
!*      and its documentation for any purpose and without fee is hereby *
!*      granted, provided that the above copyright notice appear in all *
!*      copies and that both that copyright notice and this permission  *
!*      notice appear in supporting documentation, and that the name of *
!*      Sun Microsystems, Inc. (SMI) not be used in advertising or      *
!*      publicity pertaining to distribution of the software without    *
!*      specific, written prior permission.                             *
!*                                                                      *
!*                                                                      *
!*      SMI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,      *
!*      INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,	        *
!*      FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.           *
!*      IN NO EVENT SHALL SMI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,    *
!*	INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER     *
!*      RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN      *
!*      ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,        *
!*      ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE     *
!*      OF THIS SOFTWARE.                                               *
!*                                                                      *
!**********************************************************************

<P><PRE>MODULE <module><implements><A HREF="StdFormat.i3">StdFormat</A></implements></module>;

IMPORT <A HREF="../gast/AST_Iter.i3">AST_Iter</A>; &lt;*NOWARN*&gt;
IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>, <A HREF="../ast/M3AST_PG.i3">M3AST_PG</A>;
IMPORT <A HREF="../../derived/SeqM3AST_LX_SRC_NODE.i3">SeqM3AST_LX_SRC_NODE</A>;
IMPORT <A HREF="../ast/M3AST_LX_F.i3">M3AST_LX_F</A>, <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_PG_F.i3">M3AST_PG_F</A>;
IMPORT <A HREF="../syn/M3CId.i3">M3CId</A>, <A HREF="../misc/M3Assert.i3">M3Assert</A>;
IMPORT <A HREF="../syn/M3CToken.i3">M3CToken</A>, <A HREF="../syn/M3CWhitespace.i3">M3CWhitespace</A>, <A HREF="../syn/M3CLiteral.i3">M3CLiteral</A>, <A HREF="../syn/M3CComment.i3">M3CComment</A>;

IMPORT
    <A HREF="../../derived/SeqM3AST_AS_IMPORTED.i3">SeqM3AST_AS_IMPORTED</A>,
    <A HREF="../../derived/SeqM3AST_AS_Used_interface_id.i3">SeqM3AST_AS_Used_interface_id</A>, <A HREF="../../derived/SeqM3AST_AS_Used_def_id.i3">SeqM3AST_AS_Used_def_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Import_item.i3">SeqM3AST_AS_Import_item</A>, <A HREF="../../derived/SeqM3AST_AS_Override.i3">SeqM3AST_AS_Override</A>,
    <A HREF="../../derived/SeqM3AST_AS_REVELATION.i3">SeqM3AST_AS_REVELATION</A>, <A HREF="../../derived/SeqM3AST_AS_DECL_REVL.i3">SeqM3AST_AS_DECL_REVL</A>,
    <A HREF="../../derived/SeqM3AST_AS_Const_decl.i3">SeqM3AST_AS_Const_decl</A>, <A HREF="../../derived/SeqM3AST_AS_TYPE_DECL.i3">SeqM3AST_AS_TYPE_DECL</A>,
    <A HREF="../../derived/SeqM3AST_AS_Var_decl.i3">SeqM3AST_AS_Var_decl</A>, <A HREF="../../derived/SeqM3AST_AS_Exc_decl.i3">SeqM3AST_AS_Exc_decl</A>,
    <A HREF="../../derived/SeqM3AST_AS_Var_id.i3">SeqM3AST_AS_Var_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Enum_id.i3">SeqM3AST_AS_Enum_id</A>, <A HREF="../../derived/SeqM3AST_AS_Field_id.i3">SeqM3AST_AS_Field_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_FORMAL_ID.i3">SeqM3AST_AS_FORMAL_ID</A>, <A HREF="../../derived/SeqM3AST_AS_Qual_used_id.i3">SeqM3AST_AS_Qual_used_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Fields.i3">SeqM3AST_AS_Fields</A>, <A HREF="../../derived/SeqM3AST_AS_Method.i3">SeqM3AST_AS_Method</A>,
    <A HREF="../../derived/SeqM3AST_AS_M3TYPE.i3">SeqM3AST_AS_M3TYPE</A>,
    <A HREF="../../derived/SeqM3AST_AS_Formal_param.i3">SeqM3AST_AS_Formal_param</A>, <A HREF="../../derived/SeqM3AST_AS_CONS_ELEM.i3">SeqM3AST_AS_CONS_ELEM</A>,
    <A HREF="../../derived/SeqM3AST_AS_EXP.i3">SeqM3AST_AS_EXP</A>, <A HREF="../../derived/SeqM3AST_AS_Actual.i3">SeqM3AST_AS_Actual</A>,
    <A HREF="../../derived/SeqM3AST_AS_Case.i3">SeqM3AST_AS_Case</A>, <A HREF="../../derived/SeqM3AST_AS_STM.i3">SeqM3AST_AS_STM</A>,
    <A HREF="../../derived/SeqM3AST_AS_Elsif.i3">SeqM3AST_AS_Elsif</A>, <A HREF="../../derived/SeqM3AST_AS_Tcase.i3">SeqM3AST_AS_Tcase</A>,
    <A HREF="../../derived/SeqM3AST_AS_Handler.i3">SeqM3AST_AS_Handler</A>, <A HREF="../../derived/SeqM3AST_AS_Binding.i3">SeqM3AST_AS_Binding</A>,
    <A HREF="../../derived/SeqM3AST_AS_RANGE_EXP.i3">SeqM3AST_AS_RANGE_EXP</A>,
    &lt;*NOWARN*&gt; <A HREF="../../derived/SeqM3AST_AS_F_Interface_id.i3">SeqM3AST_AS_F_Interface_id</A>;

TYPE
  WS = {Space, CommaSpace, Newline, SemiNewline, SemiSpace};
  Handle = OBJECT
    isModule, suppressPROC := FALSE;
    indent := 0;
    comments: M3CComment.Iter;
    comment: M3CComment.T;
    this_unit_id: M3AST_AS.UNIT_ID;
  END;

CONST
  WSV = ARRAY WS OF TEXT {&quot; &quot;, &quot;, &quot;, &quot;\n&quot;, &quot;;\n&quot;, &quot;; &quot;};
  Indent_Size = 2;

VAR
  ws_g: ARRAY WS OF M3AST_LX.Whitespace_rep;
  indent_ws_g: ARRAY [0..15] OF M3AST_LX.Whitespace_rep;

PROCEDURE <A NAME="MkWS"><procedure>MkWS</procedure></A>()=
  VAR indent := &quot;&quot;;
  BEGIN
    FOR i := FIRST(WS) TO LAST(WS) DO
      ws_g[i] := M3CWhitespace.Enter(WSV[i]);
    END;
    FOR i := 1 TO Indent_Size DO
      indent := indent &amp; &quot; &quot;;
    END;
    FOR i := FIRST(indent_ws_g) TO LAST(indent_ws_g) DO
      VAR this_indent := &quot;&quot;;
      BEGIN
        FOR j := 1 TO i DO
          this_indent := this_indent &amp; indent;
        END;
        indent_ws_g[i] := M3CWhitespace.Enter(this_indent);
      END;
    END;
  END MkWS;

PROCEDURE <A NAME="NewToken"><procedure>NewToken</procedure></A>(t: M3CToken.T): M3AST_LX.Token=
  BEGIN
    WITH n = NEW(M3AST_LX.Token) DO
      n.lx_token_rep := M3CToken.Token_rep(t);
      RETURN n;
    END
  END NewToken;

PROCEDURE <A NAME="NewWhitespace"><procedure>NewWhitespace</procedure></A>(ws: WS): M3AST_LX.Whitespace=
  BEGIN
    WITH n = NEW(M3AST_LX.Whitespace) DO
      n.lx_whitespace_rep := ws_g[ws];
      RETURN n;
    END
  END NewWhitespace;

PROCEDURE <A NAME="D"><procedure>D</procedure></A>(&lt;*UNUSED*&gt; h: Handle; n: M3AST_AS.SRC_NODE_C; t: TEXT)=
  BEGIN
    WITH ws = NEW(M3AST_LX.Whitespace) DO
      ws.lx_whitespace_rep := M3CWhitespace.Enter(t);
      SeqM3AST_LX_SRC_NODE.AddRear(n.lx_node_s, ws);
    END
  END D;

PROCEDURE <A NAME="Indent"><procedure>Indent</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE)=
  BEGIN
    IF h.indent # 0 THEN
     WITH ws = NEW(M3AST_LX.Whitespace) DO
       ws.lx_whitespace_rep := indent_ws_g[h.indent];
       Append(h, n, ws);
     END;
    END;
  END Indent;

PROCEDURE <A NAME="NLIncIndent"><procedure>NLIncIndent</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE)=
  BEGIN
    NL(h, n); IncIndent(h);
  END NLIncIndent;

PROCEDURE <A NAME="IncIndent"><procedure>IncIndent</procedure></A>(h: Handle)=
  BEGIN
    INC(h.indent);
  END IncIndent;

EXCEPTION IndentUnderflow;

PROCEDURE <A NAME="DecIndent"><procedure>DecIndent</procedure></A>(h: Handle)=
  BEGIN
    IF h.indent = 0 THEN
      &lt;*FATAL IndentUnderflow*&gt;
      BEGIN RAISE IndentUnderflow; END;
    END;
    DEC(h.indent);
  END DecIndent;

PROCEDURE <A NAME="Space"><procedure>Space</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE_C)=
  BEGIN
    Append(h, n, NewWhitespace(WS.Space));
  END Space;

PROCEDURE <A NAME="SCNL"><procedure>SCNL</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE_C)=
  BEGIN
    Append(h, n, NewWhitespace(WS.SemiNewline));
  END SCNL;

PROCEDURE <A NAME="CS"><procedure>CS</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE_C)=
  BEGIN
    Append(h, n, NewWhitespace(WS.CommaSpace));
  END CS;

PROCEDURE <A NAME="ScS"><procedure>ScS</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE_C)=
  BEGIN
    Append(h, n, NewWhitespace(WS.SemiSpace));
  END ScS;

PROCEDURE <A NAME="NL"><procedure>NL</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE_C)=
  BEGIN
    Append(h, n, NewWhitespace(WS.Newline));
  END NL;

PROCEDURE <A NAME="CommaSpace"><procedure>CommaSpace</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE_C)=
  BEGIN
    Append(h, n, NewWhitespace(WS.CommaSpace));
  END CommaSpace;

PROCEDURE <A NAME="Append"><procedure>Append</procedure></A>(h: Handle; n: M3AST_LX.SRC_NODE_C; s: M3AST_LX.SRC_NODE)=
  BEGIN
    FlushComments(h, n, TRUE, s);
    SeqM3AST_LX_SRC_NODE.AddRear(n.lx_node_s, s);
  END Append;

PROCEDURE <A NAME="Between"><procedure>Between</procedure></A>(
    h: Handle;
    n: M3AST_AS.SRC_NODE_C;
    VAR isFirst: BOOLEAN;
    p: PROCEDURE(h: Handle; n: M3AST_AS.SRC_NODE_C)) =
  BEGIN
    IF isFirst THEN isFirst := FALSE; RETURN; END;
    p(h, n);
  END Between;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(n: M3AST_AS.SRC_NODE_C; &lt;*UNUSED*&gt; indent := 0)=
  VAR cu := NARROW(n, M3AST_AS.Compilation_Unit);
  BEGIN
    WITH h = NEW(Handle, comments := M3CComment.NewIter(cu.lx_comments),
                         this_unit_id := cu.as_root.as_id) DO
      EVAL M3CComment.Next(h.comments, h.comment);
      DoIt(h, NIL, n);
      WHILE h.comment # NIL DO
        D(h, n, M3CComment.Body(h.comment));
        IF M3CComment.Next(h.comments, h.comment) THEN
        ELSE h.comment := NIL;
        END;
      END;
    END;
  END Set;

PROCEDURE <A NAME="DoIt"><procedure>DoIt</procedure></A>(h: Handle; parent, n: M3AST_AS.SRC_NODE_C)=
  BEGIN
    IF parent # NIL THEN Append(h, parent, n); END;
    n.lx_node_s := SeqM3AST_LX_SRC_NODE.Null;
    TYPECASE n OF
    | M3AST_AS.Compilation_Unit(q) =&gt; DoIt(h, n, q.as_root);
    | M3AST_AS.Interface(q) =&gt; Interface(h, q);
    | M3AST_AS.Qual_used_id(q) =&gt; Qual_used_id(h, q);
    | M3AST_AS.Module(q) =&gt; Module(h, q);
    | M3AST_AS.Unsafe(q) =&gt; Unsafe(h, q);
    | M3AST_AS.Import_item(q) =&gt; Import_item(h, q);
    | M3AST_AS.Simple_import(q) =&gt; Simple_import(h, q);
    | M3AST_AS.From_import(q) =&gt; From_import(h, q);
    | M3AST_AS.Revelation_s(q) =&gt; Revelation_s(h, q);
    | M3AST_AS.Const_decl_s(q) =&gt; Const_decl_s(h, q);
    | M3AST_AS.Type_decl_s(q) =&gt; Type_decl_s(h, q);
    | M3AST_AS.Var_decl_s(q) =&gt; Var_decl_s(h, q);
    | M3AST_AS.Exc_decl_s(q) =&gt; Exc_decl_s(h, q);
    | M3AST_AS.Proc_decl(q) =&gt; Proc_decl(h, q);
    | M3AST_PG.Inline(q) =&gt; Inline(h, q);
    | M3AST_PG.External(q) =&gt; External(h, q);
    | M3AST_AS.Const_decl(q) =&gt; Const_decl(h, q);
    | M3AST_AS.Var_decl(q) =&gt; Var_decl(h, q);
    | M3AST_AS.Exc_decl(q) =&gt; Exc_decl(h, q);
    | M3AST_AS.Subtype_decl(q) =&gt; Subtype_decl(h, q);
    | M3AST_AS.TYPE_DECL(q) =&gt; TYPE_DECL(h, q);
    | M3AST_AS.Concrete_decl(q) =&gt; Concrete_decl(h, q);
    | M3AST_AS.REVELATION(q) =&gt; REVELATION(h, q);
    | M3AST_AS.Concrete_reveal(q) =&gt; Concrete_reveal(h, q);
    | M3AST_AS.Subtype_reveal(q) =&gt; Subtype_reveal(h, q);
    | M3AST_AS.Named_type(q) =&gt; Named_type(h, q)
    | M3AST_AS.Integer_type(q) =&gt; Integer_type(h, q)
    | M3AST_AS.Real_type(q) =&gt; Real_type(h, q)
    | M3AST_AS.LongReal_type(q) =&gt; LongReal_type(h, q)
    | M3AST_AS.Extended_type(q) =&gt; Extended_type(h, q)
    | M3AST_AS.Null_type(q) =&gt; Null_type(h, q)
    | M3AST_AS.RefAny_type(q) =&gt; RefAny_type(h, q)
    | M3AST_AS.Address_type(q) =&gt; Address_type(h, q)
    | M3AST_AS.Root_type(q) =&gt; Root_type(h, q)
    | M3AST_AS.Array_type(q) =&gt; Array_type(h, q);
    | M3AST_AS.Enumeration_type(q) =&gt; Enumeration_type(h, q)
    | M3AST_AS.Subrange_type(q) =&gt; Subrange_type(h, q)
    | M3AST_AS.Record_type(q) =&gt; Record_type(h, q)
    | M3AST_AS.Object_type(q) =&gt; Object_type(h, q)
    | M3AST_AS.Set_type(q) =&gt; Set_type(h, q)
    | M3AST_AS.Procedure_type(q) =&gt; Procedure_type(h, q)
    | M3AST_AS.Ref_type(q) =&gt; Ref_type(h, q)
    | M3AST_AS.Packed_type(q) =&gt; Packed_type(h, q)
    | M3AST_AS.Opaque_type(q) =&gt; Opaque_type(h, q)
    | M3AST_SM.Type_type(q) =&gt; Type_type(h, q);
    | M3AST_SM.Any_type(q) =&gt; Any_type(h, q);
    | M3AST_AS.Brand(q) =&gt; Brand(h, q)
    | M3AST_AS.Untraced(q) =&gt; Untraced(h, q)
    | M3AST_AS.Fields(q) =&gt; Fields(h, q)
    | M3AST_AS.Method(q) =&gt; Method(h, q)
    | M3AST_AS.Override(q) =&gt; Override(h, q)
    | M3AST_AS.Formal_param(q) =&gt; Formal_param(h, q)
    | M3AST_AS.Raisees_any(q) =&gt; Raisees_any(h, q)
    | M3AST_AS.Raisees_some(q) =&gt; Raisees_some(h, q)
    | M3AST_AS.Range(q) =&gt; Range(h, q)
    | M3AST_AS.Range_EXP(q) =&gt; Range_EXP(h, q)
    | M3AST_AS.Constructor(q) =&gt; Constructor(h, q);
    | M3AST_AS.Propagate(q) =&gt; Propagate(h, q);
    | M3AST_AS.RANGE_EXP_elem(q) =&gt; RANGE_EXP_elem(h, q);
    | M3AST_AS.Actual_elem(q) =&gt; Actual_elem(h, q);
    | M3AST_AS.BINARY(q) =&gt; BINARY(h, q);
    | M3AST_AS.UNARY(q) =&gt; UNARY(h, q);
    | M3AST_AS.Select(q) =&gt; Select(h, q);
    | M3AST_AS.Call(q) =&gt; Call(h, q);
    | M3AST_AS.Index(q) =&gt; Index(h, q);
    | M3AST_AS.Actual(q) =&gt; Actual(h, q)
    | M3AST_AS.Exp_used_id(q) =&gt; Exp_used_id(h, q)
    | M3AST_AS.LITERAL =&gt; (* nothing more to do *)
    | M3AST_AS.Block(q) =&gt; Block(h, q)
    | M3AST_AS.Assign_st(q) =&gt; Assign_st(h, q);
    | M3AST_AS.Call_st(q) =&gt; Call_st(h, q);
    | M3AST_AS.Case_st(q) =&gt; Case_st(h, q);
    | M3AST_AS.Eval_st(q) =&gt; Eval_st(h, q);
    | M3AST_AS.Exit_st(q) =&gt; Exit_st(h, q);
    | M3AST_AS.For_st(q) =&gt; For_st(h, q);
    | M3AST_AS.If_st(q) =&gt; If_st(h, q);
    | M3AST_AS.Lock_st(q) =&gt; Lock_st(h, q);
    | M3AST_AS.Loop_st(q) =&gt; Loop_st(h, q);
    | M3AST_AS.Raise_st(q) =&gt; Raise_st(h, q);
    | M3AST_AS.Repeat_st(q) =&gt; Repeat_st(h, q);
    | M3AST_AS.Return_st(q) =&gt; Return_st(h, q);
    | M3AST_AS.Try_st(q) =&gt; Try_st(h, q);
    | M3AST_AS.Typecase_st(q) =&gt; Typecase_st(h, q);
    | M3AST_AS.While_st(q) =&gt; While_st(h, q);
    | M3AST_AS.With_st(q) =&gt; With_st(h, q);
    | M3AST_AS.Case(q) =&gt; Case(h, q);
    | M3AST_AS.Else_stm(q) =&gt; Else_stm(h, q);
    | M3AST_AS.By(q) =&gt; By(h, q);
    | M3AST_AS.Elsif(q) =&gt; Elsif(h, q);
    | M3AST_AS.Try_except(q) =&gt; Try_except(h, q);
    | M3AST_AS.Try_finally(q) =&gt; Try_finally(h, q);
    | M3AST_AS.Tcase(q) =&gt; Tcase(h, q);
    | M3AST_AS.Handler(q) =&gt; Handler(h, q);
    | M3AST_AS.Binding(q) =&gt; Binding(h, q);
    ELSE
      M3Assert.Check(FALSE);
    END
  END DoIt;

PROCEDURE <A NAME="DoUNIT_WITH_BODY"><procedure>DoUNIT_WITH_BODY</procedure></A>(h: Handle; n: M3AST_AS.UNIT_WITH_BODY)=
  VAR
    m2: M3AST_AS.IMPORTED;
    iter2 := SeqM3AST_AS_IMPORTED.NewIter(n.as_import_s);
  BEGIN
    IF NOT SeqM3AST_AS_IMPORTED.Empty(n.as_import_s) THEN NL(h, n); END;
    WHILE SeqM3AST_AS_IMPORTED.Next(iter2, m2) DO DoIt(h, n, m2); END;
    NL(h, n); NL(h, n);
    DoIt(h, n, n.as_block);
  END DoUNIT_WITH_BODY;

PROCEDURE <A NAME="DECL_Prelude"><procedure>DECL_Prelude</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE; s: M3CToken.T)=
  VAR
    e_decl: M3AST_PG.EXTERNAL_DECL;
  BEGIN
    IF h.indent = 0 THEN NL(h, n); END;
    Indent(h, n);
    IF M3AST_PG.IsA_EXTERNAL_DECL(n, e_decl) THEN
      WITH x = e_decl.pg_external DO
        IF x # NIL THEN DoIt(h, n, x); END;
      END;
    END; (* if *)
    Append(h, n, NewToken(s));
    NLIncIndent(h, n);
  END DECL_Prelude;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="UnitPostlude"><procedure>UnitPostlude</procedure></A>(h: Handle; n: M3AST_AS.UNIT) RAISES {}=
  BEGIN
    D(h, n, &quot; &quot; &amp; M3CId.ToText(n.as_id.lx_symrep) &amp; &quot;.&quot; &amp; &quot;\n&quot;);
  END UnitPostlude;

PROCEDURE <A NAME="Interface"><procedure>Interface</procedure></A>(h: Handle; n: M3AST_AS.Interface)=
  BEGIN
    h.isModule := FALSE;
    WITH x = n.vEXTERNAL_DECL.pg_external DO
      IF x # NIL THEN DoIt(h, n, x) END;
    END;
    IF n.as_unsafe # NIL THEN DoIt(h, n, n.as_unsafe); END;
    Append(h, n, NewToken(M3CToken.INTERFACE_)); Space(h, n);
    Append(h, n, n.as_id);
    SCNL(h, n);
    DoUNIT_WITH_BODY(h, n);
    UnitPostlude(h, n);
  END Interface;

PROCEDURE <A NAME="Qual_used_id"><procedure>Qual_used_id</procedure></A>(h: Handle; n: M3AST_AS.Qual_used_id)=
  BEGIN
    IF n.as_intf_id # NIL THEN
      Append(h, n, n.as_intf_id);
      Append(h, n, NewToken(M3CToken.Dot));
    END;
    Append(h, n, n.as_id);
  END Qual_used_id;

PROCEDURE <A NAME="Module"><procedure>Module</procedure></A>(h: Handle; n: M3AST_AS.Module)=
  VAR
    m: M3AST_AS.Used_interface_id;
    iter := SeqM3AST_AS_Used_interface_id.NewIter(n.as_export_s);
    isFirst := TRUE;
  BEGIN
    h.isModule := TRUE;
    IF n.as_unsafe # NIL THEN DoIt(h, n, n.as_unsafe); END;
    Append(h, n, NewToken(M3CToken.MODULE_)); Space(h, n);
    Append(h, n, n.as_id);
    IF NOT SeqM3AST_AS_Used_interface_id.Empty(n.as_export_s) THEN
      Space(h, n); Append(h, n, NewToken(M3CToken.EXPORTS_)); Space(h, n);
    END;
    WHILE SeqM3AST_AS_Used_interface_id.Next(iter, m) DO
      Between(h, n, isFirst, CS); Append(h, n, m);
    END;
    SCNL(h, n);
    DoUNIT_WITH_BODY(h, n);
    UnitPostlude(h, n);
  END Module;

PROCEDURE <A NAME="Unsafe"><procedure>Unsafe</procedure></A>(h: Handle; n: M3AST_AS.Unsafe)=
  BEGIN
    Append(h, n, NewToken(M3CToken.UNSAFE_)); Space(h, n);
  END Unsafe;

PROCEDURE <A NAME="Import_item"><procedure>Import_item</procedure></A>(h: Handle; n: M3AST_AS.Import_item)=
  BEGIN
    Append(h, n, n.as_intf_id);
    IF n.as_id # NIL THEN
      Space(h, n); Append(h, n, NewToken(M3CToken.AS_)); Space(h, n);
      Append(h, n, n.as_id);
    END;
  END Import_item;

PROCEDURE <A NAME="Simple_import"><procedure>Simple_import</procedure></A>(h: Handle; n: M3AST_AS.Simple_import)=
  VAR
    m: M3AST_AS.Import_item;
    iter := SeqM3AST_AS_Import_item.NewIter(n.as_import_item_s);
    isFirst := TRUE;
  BEGIN
    Append(h, n, NewToken(M3CToken.IMPORT_)); Space(h, n);
    WHILE SeqM3AST_AS_Import_item.Next(iter, m) DO
      Between(h, n, isFirst, CS); DoIt(h, n, m);
    END;
    SCNL(h, n);
  END Simple_import;

PROCEDURE <A NAME="From_import"><procedure>From_import</procedure></A>(h: Handle; n: M3AST_AS.From_import)=
  VAR
    m: M3AST_AS.Used_def_id;
    iter := SeqM3AST_AS_Used_def_id.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    Append(h, n, NewToken(M3CToken.FROM_));
    Space(h, n); Append(h, n, n.as_intf_id);
    Space(h, n); Append(h, n, NewToken(M3CToken.IMPORT_));
    Space(h, n);
    WHILE SeqM3AST_AS_Used_def_id.Next(iter, m) DO
      Between(h, n, isFirst, CS); Append(h, n, m);
    END;
    SCNL(h, n);
  END From_import;

PROCEDURE <A NAME="Revelation_s"><procedure>Revelation_s</procedure></A>(h: Handle; n: M3AST_AS.Revelation_s)=
  VAR
    m: M3AST_AS.REVELATION;
    iter := SeqM3AST_AS_REVELATION.NewIter(n.as_reveal_s);
  BEGIN
    DECL_Prelude(h, n, M3CToken.REVEAL_);
    WHILE SeqM3AST_AS_REVELATION.Next(iter, m) DO DoIt(h, n, m); END;
    DecIndent(h);
  END Revelation_s;

PROCEDURE <A NAME="Const_decl_s"><procedure>Const_decl_s</procedure></A>(h: Handle; n: M3AST_AS.Const_decl_s)=
  VAR
    m: M3AST_AS.Const_decl;
    iter := SeqM3AST_AS_Const_decl.NewIter(n.as_const_decl_s);
  BEGIN
    DECL_Prelude(h, n, M3CToken.CONST_);
    WHILE SeqM3AST_AS_Const_decl.Next(iter, m) DO DoIt(h, n, m); END;
    DecIndent(h);
  END Const_decl_s;

PROCEDURE <A NAME="Type_decl_s"><procedure>Type_decl_s</procedure></A>(h: Handle; n: M3AST_AS.Type_decl_s)=
  VAR
    m: M3AST_AS.TYPE_DECL;
    iter := SeqM3AST_AS_TYPE_DECL.NewIter(n.as_type_decl_s);
  BEGIN
    DECL_Prelude(h, n, M3CToken.TYPE_);
    WHILE SeqM3AST_AS_TYPE_DECL.Next(iter, m) DO DoIt(h, n, m); END;
    DecIndent(h);
  END Type_decl_s;

PROCEDURE <A NAME="Var_decl_s"><procedure>Var_decl_s</procedure></A>(h: Handle; n: M3AST_AS.Var_decl_s)=
  VAR
    m: M3AST_AS.Var_decl;
    iter := SeqM3AST_AS_Var_decl.NewIter(n.as_var_decl_s);
  BEGIN
    DECL_Prelude(h, n, M3CToken.VAR_);
    WHILE SeqM3AST_AS_Var_decl.Next(iter, m) DO DoIt(h, n, m); END;
    DecIndent(h);
  END Var_decl_s;

PROCEDURE <A NAME="Exc_decl_s"><procedure>Exc_decl_s</procedure></A>(h: Handle; n: M3AST_AS.Exc_decl_s)=
  VAR
    m: M3AST_AS.Exc_decl;
    iter := SeqM3AST_AS_Exc_decl.NewIter(n.as_exc_decl_s);
  BEGIN
    DECL_Prelude(h, n, M3CToken.EXCEPTION_);
    WHILE SeqM3AST_AS_Exc_decl.Next(iter, m) DO DoIt(h, n, m); END;
    DecIndent(h);
  END Exc_decl_s;

PROCEDURE <A NAME="Proc_decl"><procedure>Proc_decl</procedure></A>(h: Handle; n: M3AST_AS.Proc_decl)=
  BEGIN
    NL(h, n); Indent(h, n);
    WITH x = n.vEXTERNAL_DECL.pg_external DO
      IF x # NIL THEN DoIt(h, n, x); END;
    END;
    IF n.pg_inline # NIL THEN DoIt(h, n, n.pg_inline); END;
    Append(h, n, NewToken(M3CToken.PROCEDURE_)); Space(h, n);
    Append(h, n, n.as_id);
    h.suppressPROC := TRUE; DoIt(h, n, n.as_type);
    IF n.as_body # NIL THEN
      Append(h, n, NewToken(M3CToken.Equal));
      NLIncIndent(h, n);
      DoIt(h, n, n.as_body);
      D(h, n, &quot; &quot; &amp; M3CId.ToText(n.as_id.lx_symrep));
      DecIndent(h);
    END;
    SCNL(h, n);
  END Proc_decl;

PROCEDURE <A NAME="Inline"><procedure>Inline</procedure></A>(h: Handle; n: M3AST_PG.Inline)=
  BEGIN
    (* This ought to be a real pragma node *)
    D(h, n, &quot;&lt;*INLINE*&gt; &quot;);
  END Inline;

PROCEDURE <A NAME="External"><procedure>External</procedure></A>(h: Handle; n: M3AST_PG.External)=
  BEGIN
    (* This ought to be a real pragma node *)
    D(h, n, &quot;&lt;*EXTERNAL&quot;);
    IF n.lx_lang_spec # NIL THEN
      Space(h, n);
      D(h, n, M3CLiteral.ToText(n.lx_lang_spec));
      Space(h, n);
    END;
    D(h, n, &quot;*&gt; &quot;);
  END External;

PROCEDURE <A NAME="Const_decl"><procedure>Const_decl</procedure></A>(h: Handle; n: M3AST_AS.Const_decl)=
  BEGIN
    Indent(h, n);
    Append(h, n, n.as_id);
    IF n.as_type # NIL THEN
      Append(h, n, NewToken(M3CToken.Colon));
      DoIt(h, n, n.as_type);
    END;
    Space(h, n); Append(h, n, NewToken(M3CToken.Equal));
    Space(h, n); DoIt(h, n, n.as_exp);
    SCNL(h, n);
  END Const_decl;

PROCEDURE <A NAME="Var_decl"><procedure>Var_decl</procedure></A>(h: Handle; n: M3AST_AS.Var_decl)=
  VAR
    m: M3AST_AS.Var_id;
    iter := SeqM3AST_AS_Var_id.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    Indent(h, n);
    WHILE SeqM3AST_AS_Var_id.Next(iter, m) DO
      Between(h, n, isFirst, CS); Append(h, n , m);
    END;
    IF n.as_type # NIL THEN
      Append(h, n, NewToken(M3CToken.Colon)); Space(h, n);
      DoIt(h, n, n.as_type);
    END;
    IF n.as_default # NIL THEN
      Space(h, n); Append(h, n, NewToken(M3CToken.Becomes)); Space(h, n);
      DoIt(h, n, n.as_default);
    END;
    SCNL(h, n);
  END Var_decl;

PROCEDURE <A NAME="Exc_decl"><procedure>Exc_decl</procedure></A>(h: Handle; n: M3AST_AS.Exc_decl)=
  BEGIN
    Indent(h, n);
    Append(h, n, n.as_id);
    IF n.as_type # NIL THEN
      Append(h, n, NewToken(M3CToken.Bra));
      DoIt(h, n, n.as_type);
      Append(h, n, NewToken(M3CToken.Ket));
    END;
    SCNL(h, n);
  END Exc_decl;

PROCEDURE <A NAME="Subtype_decl"><procedure>Subtype_decl</procedure></A>(h: Handle; n: M3AST_AS.Subtype_decl)=
  BEGIN
    TYPE_DECL(h, n);
  END Subtype_decl;

PROCEDURE <A NAME="TYPE_DECL"><procedure>TYPE_DECL</procedure></A>(h: Handle; n: M3AST_AS.TYPE_DECL)=
  BEGIN
    Indent(h, n);
    Append(h, n, n.as_id);
    Space(h, n);
    IF ISTYPE(n, M3AST_AS.Subtype_decl) THEN
      Append(h, n, NewToken(M3CToken.Subtype))
    ELSE Append(h, n, NewToken(M3CToken.Equal));
    END;
    Space(h, n);
    DoIt(h, n, n.as_type);
    SCNL(h, n);
  END TYPE_DECL;

PROCEDURE <A NAME="Concrete_decl"><procedure>Concrete_decl</procedure></A>(h: Handle; n: M3AST_AS.Concrete_decl)=
  BEGIN
    TYPE_DECL(h, n);
  END Concrete_decl;

PROCEDURE <A NAME="Subtype_reveal"><procedure>Subtype_reveal</procedure></A>(h: Handle; n: M3AST_AS.Subtype_reveal)=
  BEGIN
    REVELATION(h, n);
  END Subtype_reveal;
</PRE> PRIVATE 
<PRE>PROCEDURE <A NAME="REVELATION"><procedure>REVELATION</procedure></A>(h: Handle; n: M3AST_AS.REVELATION)=
  BEGIN
    Indent(h, n);
    DoIt(h, n, n.as_qual_id);
    Space(h, n);
    IF ISTYPE(n, M3AST_AS.Subtype_reveal) THEN
      Append(h, n, NewToken(M3CToken.Subtype))
    ELSE Append(h, n, NewToken(M3CToken.Equal));
    END;
    Space(h, n);
    DoIt(h, n, n.as_type);
    SCNL(h, n);
  END REVELATION;

PROCEDURE <A NAME="Concrete_reveal"><procedure>Concrete_reveal</procedure></A>(h: Handle; n: M3AST_AS.Concrete_reveal)=
  BEGIN
    REVELATION(h, n);
  END Concrete_reveal;

PROCEDURE <A NAME="Named_type"><procedure>Named_type</procedure></A>(h: Handle; n: M3AST_AS.Named_type)=
  BEGIN
    DoIt(h, n, n.as_qual_id);
  END Named_type;

PROCEDURE <A NAME="Integer_type"><procedure>Integer_type</procedure></A>(
    h: Handle; n: M3AST_AS.Integer_type)=
  BEGIN
    Append(h, n, NewToken(M3CToken.INTEGER_));
  END Integer_type;

PROCEDURE <A NAME="Real_type"><procedure>Real_type</procedure></A>(
    h: Handle; n: M3AST_AS.Real_type;)=
  BEGIN
    Append(h, n, NewToken(M3CToken.REAL_));
  END Real_type;

PROCEDURE <A NAME="LongReal_type"><procedure>LongReal_type</procedure></A>(
    h: Handle; n: M3AST_AS.LongReal_type;)=
  BEGIN
    Append(h, n, NewToken(M3CToken.LONGREAL_));
  END LongReal_type;

PROCEDURE <A NAME="Extended_type"><procedure>Extended_type</procedure></A>(
    h: Handle; n: M3AST_AS.Extended_type;)=
  BEGIN
    Append(h, n, NewToken(M3CToken.EXTENDED_));
  END Extended_type;

PROCEDURE <A NAME="Null_type"><procedure>Null_type</procedure></A>(
    h: Handle; n: M3AST_AS.Null_type;)=
  BEGIN
    Append(h, n, NewToken(M3CToken.NULL_));
  END Null_type;

PROCEDURE <A NAME="RefAny_type"><procedure>RefAny_type</procedure></A>(
    h: Handle; n: M3AST_AS.RefAny_type;)=
  BEGIN
    Append(h, n, NewToken(M3CToken.REFANY_));
  END RefAny_type;

PROCEDURE <A NAME="Address_type"><procedure>Address_type</procedure></A>(
    h: Handle; n: M3AST_AS.Address_type;)=
  BEGIN
    Append(h, n, NewToken(M3CToken.ADDRESS_));
  END Address_type;

PROCEDURE <A NAME="Root_type"><procedure>Root_type</procedure></A>(
    h: Handle; n: M3AST_AS.Root_type)=
  BEGIN
    IF n.as_trace_mode # NIL THEN
      Append(h, n, NewToken(M3CToken.UNTRACED_));
      Append(h, n, NewToken(M3CToken.ROOT_));
    ELSE Append(h, n, NewToken(M3CToken.ROOT_));
    END;
  END Root_type;

PROCEDURE <A NAME="Array_type"><procedure>Array_type</procedure></A>(h: Handle; n: M3AST_AS.Array_type)=
  VAR
    m: M3AST_AS.M3TYPE;
    iter := SeqM3AST_AS_M3TYPE.NewIter(n.as_indextype_s);
    isFirst := TRUE;
  BEGIN
    Append(h, n, NewToken(M3CToken.ARRAY_));
    Space(h, n);
    IF NOT SeqM3AST_AS_M3TYPE.Exhausted(iter) THEN
      WHILE SeqM3AST_AS_M3TYPE.Next(iter, m) DO
        Between(h, n, isFirst, CommaSpace); DoIt(h, n, m);
      END;
    Space(h, n);
    END;
    Append(h, n, NewToken(M3CToken.OF_));
    Space(h, n);
    DoIt(h, n, n.as_elementtype);
  END Array_type;

PROCEDURE <A NAME="Enumeration_type"><procedure>Enumeration_type</procedure></A>(h: Handle; n: M3AST_AS.Enumeration_type)=
  VAR
    m: M3AST_AS.Enum_id;
    iter := SeqM3AST_AS_Enum_id.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    Append(h, n, NewToken(M3CToken.CurlyBra));
    WHILE SeqM3AST_AS_Enum_id.Next(iter, m) DO
      Between(h, n, isFirst, CS);
      Append(h, n, m);
    END;
    Append(h, n, NewToken(M3CToken.CurlyKet));
  END Enumeration_type;

PROCEDURE <A NAME="Subrange_type"><procedure>Subrange_type</procedure></A>(h: Handle; n: M3AST_AS.Subrange_type)=
  BEGIN
    Append(h, n, NewToken(M3CToken.SquareBra));
    DoIt(h, n, n.as_range);
    Append(h, n, NewToken(M3CToken.SquareKet));
  END Subrange_type;

PROCEDURE <A NAME="Record_type"><procedure>Record_type</procedure></A>(h: Handle; n: M3AST_AS.Record_type)=
  VAR
    m: M3AST_AS.Fields;
    iter := SeqM3AST_AS_Fields.NewIter(n.as_fields_s);
  BEGIN
    Append(h, n, NewToken(M3CToken.RECORD_));
    NLIncIndent(h, n);
    WHILE SeqM3AST_AS_Fields.Next(iter, m) DO
      DoIt(h, n, m);
    END;
    DecIndent(h); Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END Record_type;

PROCEDURE <A NAME="Object_type"><procedure>Object_type</procedure></A>(h: Handle; n: M3AST_AS.Object_type)
     =
  VAR
    m: M3AST_AS.Fields;
    iter := SeqM3AST_AS_Fields.NewIter(n.as_fields_s);
    m2: M3AST_AS.Method;
    iter2 := SeqM3AST_AS_Method.NewIter(n.as_method_s);
    m3: M3AST_AS.Override;
    iter3 := SeqM3AST_AS_Override.NewIter(n.as_override_s);
  BEGIN
    IF n.as_ancestor # NIL THEN DoIt(h, n, n.as_ancestor); Space(h, n); END;
    IF n.as_brand # NIL THEN DoIt(h, n, n.as_brand); END;
    Append(h, n, NewToken(M3CToken.OBJECT_));
    NLIncIndent(h, n);
    WHILE SeqM3AST_AS_Fields.Next(iter, m) DO DoIt(h, n, m); END;
    IF NOT SeqM3AST_AS_Method.Empty(n.as_method_s) THEN
      DecIndent(h); Indent(h, n);
      Append(h, n, NewToken(M3CToken.METHODS_));
      NLIncIndent(h, n);
      WHILE SeqM3AST_AS_Method.Next(iter2, m2) DO DoIt(h, n, m2); END;
    END; (* if *)
    IF NOT SeqM3AST_AS_Override.Empty(n.as_override_s) THEN
      DecIndent(h); Indent(h, n);
      Append(h, n, NewToken(M3CToken.OVERRIDES_));
      NLIncIndent(h, n);
      WHILE SeqM3AST_AS_Override.Next(iter3, m3) DO DoIt(h, n, m3); END;
    END; (* if *)
    DecIndent(h); Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END Object_type;

PROCEDURE <A NAME="Set_type"><procedure>Set_type</procedure></A>(h: Handle; n: M3AST_AS.Set_type)=
  BEGIN
    Append(h, n, NewToken(M3CToken.SET_)); Space(h, n);
    Append(h, n, NewToken(M3CToken.OF_)); Space(h, n);
    DoIt(h, n, n.as_type);
  END Set_type;

PROCEDURE <A NAME="Procedure_type"><procedure>Procedure_type</procedure></A>(h: Handle; n: M3AST_AS.Procedure_type)=
  VAR
    m: M3AST_AS.Formal_param;
    iter := SeqM3AST_AS_Formal_param.NewIter(n.as_formal_param_s);
    isFirst := TRUE;
  BEGIN
    IF NOT h.suppressPROC THEN
      Append(h, n, NewToken(M3CToken.PROCEDURE_)); Space(h, n);
      Append(h, n, NewToken(M3CToken.Bra));
    ELSE Append(h, n, NewToken(M3CToken.Bra));
    END;
    h.suppressPROC := FALSE;
    WHILE SeqM3AST_AS_Formal_param.Next(iter, m) DO
      Between(h, n, isFirst, ScS); DoIt(h, n, m);
    END;
    Append(h, n, NewToken(M3CToken.Ket));
    IF n.as_result_type # NIL THEN
      Append(h, n, NewToken(M3CToken.Colon));
      Space(h, n);
      DoIt(h, n, n.as_result_type);
    END;
    IF n.as_raises # NIL THEN DoIt(h, n, n.as_raises); END;
  END Procedure_type;

PROCEDURE <A NAME="Ref_type"><procedure>Ref_type</procedure></A>(h: Handle; n: M3AST_AS.Ref_type)=
  BEGIN
    IF n.as_trace_mode # NIL THEN DoIt(h, n, n.as_trace_mode); END;
    IF n.as_brand # NIL THEN DoIt(h, n, n.as_brand); END;
    Append(h, n, NewToken(M3CToken.REF_)); Space(h, n);
    DoIt(h, n, n.as_type);
  END Ref_type;

PROCEDURE <A NAME="Packed_type"><procedure>Packed_type</procedure></A>(h: Handle; n: M3AST_AS.Packed_type)=
  BEGIN
    Append(h, n, NewToken(M3CToken.BITS_)); Space(h, n);
    DoIt(h, n, n.as_exp);
    Space(h, n); Append(h, n, NewToken(M3CToken.FOR_)); Space(h, n);
    DoIt(h, n, n.as_type);
  END Packed_type;

PROCEDURE <A NAME="Opaque_type"><procedure>Opaque_type</procedure></A>(h: Handle; n: M3AST_AS.Opaque_type)=
  BEGIN
    DoIt(h, n, n.as_type);
  END Opaque_type;

PROCEDURE <A NAME="Type_type"><procedure>Type_type</procedure></A>(h: Handle; n: M3AST_SM.Type_type)=
  BEGIN
    D(h, n, &quot;M3TYPE&quot;);
  END Type_type;

PROCEDURE <A NAME="Any_type"><procedure>Any_type</procedure></A>(h: Handle; n: M3AST_SM.Any_type)=
  BEGIN
    D(h, n, &quot;ANY&quot;);
  END Any_type;

PROCEDURE <A NAME="Brand"><procedure>Brand</procedure></A>(h: Handle; n: M3AST_AS.Brand)=
  BEGIN
    Append(h, n, NewToken(M3CToken.BRANDED_)); Space(h, n);
    IF n.as_exp # NIL THEN DoIt(h, n, n.as_exp) END;
  END Brand;

PROCEDURE <A NAME="Untraced"><procedure>Untraced</procedure></A>(h: Handle; n: M3AST_AS.Untraced)=
  BEGIN
    Append(h, n, NewToken(M3CToken.UNTRACED_)); Space(h, n);
  END Untraced;

PROCEDURE <A NAME="Fields"><procedure>Fields</procedure></A>(h: Handle; n: M3AST_AS.Fields)=
  VAR
    m: M3AST_AS.Field_id;
    iter := SeqM3AST_AS_Field_id.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    Indent(h, n);
    WHILE SeqM3AST_AS_Field_id.Next(iter, m) DO
      Between(h, n, isFirst, CS); Append(h, n, m);
    END;
    IF n.as_type # NIL THEN
      Append(h, n, NewToken(M3CToken.Colon)); Space(h, n);
      DoIt(h, n, n.as_type);
    END;
    IF n.as_default # NIL THEN
      Space(h, n); Append(h, n, NewToken(M3CToken.Becomes)); Space(h, n);
      DoIt(h, n, n.as_default);
    END;
    SCNL(h, n);
  END Fields;

PROCEDURE <A NAME="Method"><procedure>Method</procedure></A>(h: Handle; n: M3AST_AS.Method)=
  BEGIN
    Indent(h, n);
    Append(h, n, n.as_id);
    h.suppressPROC := TRUE; DoIt(h, n, n.as_type);
    IF n.as_default # NIL THEN
      Space(h, n); Append(h, n, NewToken(M3CToken.Becomes)); Space(h, n);
      DoIt(h, n, n.as_default);
    END;
    SCNL(h, n);
  END Method;

PROCEDURE <A NAME="Override"><procedure>Override</procedure></A>(h: Handle; n: M3AST_AS.Override)=
  BEGIN
    Indent(h, n);
    Append(h, n, n.as_id);
    Space(h, n); Append(h, n, NewToken(M3CToken.Becomes)); Space(h, n);
    DoIt(h, n, n.as_default);
    SCNL(h, n);
  END Override;

PROCEDURE <A NAME="Formal_param"><procedure>Formal_param</procedure></A>(h: Handle; n: M3AST_AS.Formal_param)=
  VAR
    m: M3AST_AS.FORMAL_ID;
    iter := SeqM3AST_AS_FORMAL_ID.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    WHILE SeqM3AST_AS_FORMAL_ID.Next(iter, m) DO
      IF isFirst THEN
        TYPECASE m OF
        | M3AST_AS.F_Var_id =&gt;
            Append(h, n, NewToken(M3CToken.VAR_)); Space(h, n);
        | M3AST_AS.F_Readonly_id =&gt;
            Append(h, n, NewToken(M3CToken.READONLY_)); Space(h, n);
        ELSE (* VALUE implied *)
        END;
      END; (* if *)
      Between(h, n, isFirst, CS); Append(h, n, m);
    END;
    IF n.as_formal_type # NIL THEN
      Append(h, n, NewToken(M3CToken.Colon)); Space(h, n);
      DoIt(h, n, n.as_formal_type);
    END;
    IF n.as_default # NIL THEN
      Space(h, n); Append(h, n, NewToken(M3CToken.Becomes)); Space(h, n);
      DoIt(h, n, n.as_default);
    END;
  END Formal_param;

PROCEDURE <A NAME="Raisees_any"><procedure>Raisees_any</procedure></A>(h: Handle; n: M3AST_AS.Raisees_any)=
  BEGIN
    Space(h, n);
    Append(h, n, NewToken(M3CToken.RAISES_));
    Space(h, n);
    Append(h, n, NewToken(M3CToken.ANY_));
  END Raisees_any;

PROCEDURE <A NAME="Raisees_some"><procedure>Raisees_some</procedure></A>(h: Handle; n: M3AST_AS.Raisees_some)=
  VAR
    m: M3AST_AS.Qual_used_id;
    iter := SeqM3AST_AS_Qual_used_id.NewIter(n.as_raisees_s);
    isFirst := TRUE;
  BEGIN
    Space(h, n);
    Append(h, n, NewToken(M3CToken.RAISES_));
    Space(h, n);
    Append(h, n, NewToken(M3CToken.CurlyBra));
    WHILE SeqM3AST_AS_Qual_used_id.Next(iter, m) DO
      Between(h, n, isFirst, CS); DoIt(h, n, m);
    END;
    Append(h, n, NewToken(M3CToken.CurlyKet));
  END Raisees_some;

PROCEDURE <A NAME="Range"><procedure>Range</procedure></A>(h: Handle; n: M3AST_AS.Range)=
  BEGIN
    DoIt(h, n, n.as_exp1);
    Space(h, n);
    Append(h, n, NewToken(M3CToken.Range));
    Space(h, n);
    DoIt(h, n, n.as_exp2);
  END Range;

PROCEDURE <A NAME="Range_EXP"><procedure>Range_EXP</procedure></A>(h: Handle; n: M3AST_AS.Range_EXP)=
  BEGIN
    DoIt(h, n, n.as_exp);
  END Range_EXP;

PROCEDURE <A NAME="Constructor"><procedure>Constructor</procedure></A>(h: Handle; n: M3AST_AS.Constructor)=
  VAR
    m: M3AST_AS.CONS_ELEM;
    iter := SeqM3AST_AS_CONS_ELEM.NewIter(n.as_element_s);
    isFirst := TRUE;
  BEGIN
    DoIt(h, n, n.as_type);
    Space(h, n);
    Append(h, n, NewToken(M3CToken.CurlyBra));
    WHILE SeqM3AST_AS_CONS_ELEM.Next(iter, m) DO
      Between(h, n, isFirst, CS); DoIt(h, n, m);
    END;
    IF n.as_propagate # NIL THEN DoIt(h, n, n.as_propagate); END;
    Append(h, n, NewToken(M3CToken.CurlyKet));
  END Constructor;

PROCEDURE <A NAME="Propagate"><procedure>Propagate</procedure></A>(h: Handle; n: M3AST_AS.Propagate)=
  BEGIN
    Append(h, n, NewToken(M3CToken.Comma));
    Space(h, n);
    Append(h, n, NewToken(M3CToken.Range));
  END Propagate;

PROCEDURE <A NAME="RANGE_EXP_elem"><procedure>RANGE_EXP_elem</procedure></A>(h: Handle; n: M3AST_AS.RANGE_EXP_elem)=
  BEGIN
    DoIt(h, n, n.as_range_exp);
  END RANGE_EXP_elem;

PROCEDURE <A NAME="Actual_elem"><procedure>Actual_elem</procedure></A>(h: Handle; n: M3AST_AS.Actual_elem)=
  BEGIN
    DoIt(h, n, n.as_actual);
  END Actual_elem;

PROCEDURE <A NAME="LowerPrec"><procedure>LowerPrec</procedure></A>(child, parent: M3AST_AS.EXP; right: BOOLEAN
    ): BOOLEAN RAISES {}=
  VAR c_prec, p_prec: INTEGER;
  BEGIN
    (* Returns TRUE if child is lower precedence than parent
      (and hence needs bracketing). 'right' denotes whether this
      is the right hand side, for which a bracket is needed
      if precedence is equal.
    *)

    (* parent is either a Binary or Unary; child may be any expression *)
    TYPECASE child OF
    | M3AST_AS.BINARY(b) =&gt;
        c_prec := BPrec(b);
    | M3AST_AS.UNARY(u) =&gt;
        c_prec := UPrec(u);
    ELSE
      RETURN FALSE
    END; (* if *)

    TYPECASE parent OF &lt;*NOWARN*&gt;
    | M3AST_AS.BINARY(b) =&gt;
        p_prec := BPrec(b);
    | M3AST_AS.UNARY(u) =&gt;
        p_prec := UPrec(u);
    END; (* if *)

    RETURN c_prec &lt; p_prec OR (right AND c_prec = p_prec);
  END LowerPrec;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="BPrec"><procedure>BPrec</procedure></A>(op: M3AST_AS.BINARY): INTEGER RAISES {}=
  BEGIN
    TYPECASE op OF &lt;*NOWARN*&gt;
    | M3AST_AS.Times, M3AST_AS.Rdiv,
      M3AST_AS.Div, M3AST_AS.Mod =&gt; RETURN 7;

    | M3AST_AS.Plus, M3AST_AS.Minus, M3AST_AS.Textcat =&gt; RETURN 6;

    | M3AST_AS.Eq, M3AST_AS.Ne,
      M3AST_AS.Gt, M3AST_AS.Lt,
      M3AST_AS.Ge, M3AST_AS.Le, M3AST_AS.In =&gt; RETURN 5;

    | M3AST_AS.And =&gt; RETURN 3;

    | M3AST_AS.Or =&gt; RETURN 2;
    END; (* case *)
  END BPrec;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="UPrec"><procedure>UPrec</procedure></A>(op: M3AST_AS.UNARY): INTEGER RAISES {}=
  BEGIN
    TYPECASE op OF &lt;*NOWARN*&gt;
    | M3AST_AS.Deref =&gt; RETURN 9;

    | M3AST_AS.Unaryplus, M3AST_AS.Unaryminus =&gt; RETURN 8;

    | M3AST_AS.Not =&gt; RETURN 4;
    END; (* case *)
  END UPrec;

PROCEDURE <A NAME="BINARY"><procedure>BINARY</procedure></A>(h: Handle; n: M3AST_AS.BINARY)=
  VAR bracket := FALSE;
  BEGIN
    IF LowerPrec(n.as_exp1, n, right := FALSE) THEN
      Append(h, n, NewToken(M3CToken.Bra)); bracket := TRUE;
    END; (* if *)
    DoIt(h, n, n.as_exp1);
    IF bracket THEN Append(h, n, NewToken(M3CToken.Ket)) END;
    Space(h, n); Append(h, n, NewToken(BTokenFor(n))); Space(h, n);
    bracket := FALSE;
    IF LowerPrec(n.as_exp2, n, right := TRUE) THEN
       Append(h, n, NewToken(M3CToken.Bra)); bracket := TRUE;
    END; (* if *)
    DoIt(h, n, n.as_exp2);
    IF bracket THEN Append(h, n, NewToken(M3CToken.Ket)) END;
  END BINARY;

PROCEDURE <A NAME="BTokenFor"><procedure>BTokenFor</procedure></A>(n: M3AST_AS.BINARY): M3CToken.T=
  BEGIN
    TYPECASE n OF &lt;*NOWARN*&gt;
    | M3AST_AS.Plus =&gt; RETURN M3CToken.Plus;
    | M3AST_AS.Minus =&gt; RETURN M3CToken.Minus;
    | M3AST_AS.Times =&gt; RETURN M3CToken.Times;
    | M3AST_AS.Rdiv =&gt; RETURN M3CToken.Divide;
    | M3AST_AS.Textcat =&gt; RETURN M3CToken.Ampersand;
    | M3AST_AS.Div =&gt; RETURN M3CToken.DIV_;
    | M3AST_AS.Mod =&gt; RETURN M3CToken.MOD_;
    | M3AST_AS.Eq =&gt; RETURN M3CToken.Equal;
    | M3AST_AS.Ne =&gt; RETURN M3CToken.NotEqual;
    | M3AST_AS.Gt =&gt; RETURN M3CToken.GreaterThan;
    | M3AST_AS.Lt =&gt; RETURN M3CToken.LessThan;
    | M3AST_AS.Ge =&gt; RETURN M3CToken.GreaterThanOrEqual;
    | M3AST_AS.Le =&gt; RETURN M3CToken.LessThanOrEqual;
    | M3AST_AS.And =&gt; RETURN M3CToken.AND_;
    | M3AST_AS.Or =&gt; RETURN M3CToken.OR_;
    | M3AST_AS.In =&gt; RETURN M3CToken.IN_;
    END;
  END BTokenFor;

PROCEDURE <A NAME="UNARY"><procedure>UNARY</procedure></A>(h: Handle; n: M3AST_AS.UNARY)=
  VAR bracket := FALSE;
  BEGIN
    IF NOT ISTYPE(n, M3AST_AS.Deref) THEN
      Append(h, n, NewToken(UTokenFor(n)));
      IF ISTYPE(n, M3AST_AS.Not) THEN Space(h, n); END;
    END;
    IF LowerPrec(n.as_exp, n, right := TRUE) THEN
      Append(h, n, NewToken(M3CToken.Bra)); bracket := TRUE;
    END; (* if *)
    DoIt(h, n, n.as_exp);
    IF ISTYPE(n, M3AST_AS.Deref) THEN
      Append(h, n, NewToken(UTokenFor(n)));
    END;
    IF bracket THEN Append(h, n, NewToken(M3CToken.Ket)) END;
  END UNARY;

PROCEDURE <A NAME="UTokenFor"><procedure>UTokenFor</procedure></A>(n: M3AST_AS.UNARY): M3CToken.T=
  BEGIN
    TYPECASE n OF &lt;*NOWARN*&gt;
    | M3AST_AS.Not =&gt; RETURN M3CToken.NOT_;
    | M3AST_AS.Unaryplus =&gt; RETURN M3CToken.Plus;
    | M3AST_AS.Unaryminus =&gt; RETURN M3CToken.Minus;
    | M3AST_AS.Deref =&gt; RETURN M3CToken.Dereference;
    END
  END UTokenFor;

PROCEDURE <A NAME="Select"><procedure>Select</procedure></A>(h: Handle; n: M3AST_AS.Select)=
  BEGIN
    DoIt(h, n, n.as_exp);
    Append(h, n, NewToken(M3CToken.Dot));
    DoIt(h, n, n.as_id);
  END Select;

PROCEDURE <A NAME="Call"><procedure>Call</procedure></A>(h: Handle; n: M3AST_AS.Call)=
  VAR
    m: M3AST_AS.Actual;
    iter := SeqM3AST_AS_Actual.NewIter(n.as_param_s);
    isFirst := TRUE;
  BEGIN
    DoIt(h, n, n.as_callexp);
    Append(h, n, NewToken(M3CToken.Bra));
    WHILE SeqM3AST_AS_Actual.Next(iter, m) DO
      Between(h, n, isFirst, CS); DoIt(h, n, m);
    END;
    Append(h, n, NewToken(M3CToken.Ket));
  END Call;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A>(h: Handle; n: M3AST_AS.Index)=
  VAR
    m: M3AST_AS.EXP;
    iter := SeqM3AST_AS_EXP.NewIter(n.as_exp_s);
    isFirst := TRUE;
  BEGIN
    DoIt(h, n, n.as_array);
    Append(h, n, NewToken(M3CToken.SquareBra));
    WHILE SeqM3AST_AS_EXP.Next(iter, m) DO
      Between(h, n, isFirst, CS); DoIt(h, n, m);
    END;
    Append(h, n, NewToken(M3CToken.SquareKet));
  END Index;

PROCEDURE <A NAME="Actual"><procedure>Actual</procedure></A>(h: Handle; n: M3AST_AS_F.Actual)=
  BEGIN
    IF n.as_id # NIL THEN
      DoIt(h, n, n.as_id);
      Space(h, n);
      Append(h, n, NewToken(M3CToken.Becomes)); Space(h, n);
    END;
    DoIt(h, n, n.as_exp_type);
  END Actual;

PROCEDURE <A NAME="Exp_used_id"><procedure>Exp_used_id</procedure></A>(h: Handle; n: M3AST_AS.Exp_used_id)=
  BEGIN
    Append(h, n, n.vUSED_ID);
  END Exp_used_id;

PROCEDURE <A NAME="Block"><procedure>Block</procedure></A>(h: Handle; n: M3AST_AS.Block)=

  PROCEDURE LastNodeOf(n: M3AST_AS.SRC_NODE): M3AST_AS.SRC_NODE=
    VAR result: M3AST_AS.SRC_NODE := NIL;
    PROCEDURE Visit(n: M3AST_AS.SRC_NODE)=
       VAR iter := n.newIter(); child: AST.NODE;
       BEGIN
         result := n;
         WHILE iter.next(child) DO
           IF child # NIL THEN
             Visit(child)
           END;
         END;
       END Visit;
    BEGIN
      Visit(n);
      RETURN result
    END LastNodeOf;

  VAR
    m: M3AST_AS.DECL_REVL;
    iter := SeqM3AST_AS_DECL_REVL.NewIter(n.as_decl_s);
  BEGIN
    WHILE SeqM3AST_AS_DECL_REVL.Next(iter, m) DO
      DoIt(h, n, m);
      IF ISTYPE(h.this_unit_id, M3AST_AS.Interface_id) THEN
        FlushComments(h, n, FALSE, LastNodeOf(m));
      END;
    END;
    IF h.isModule THEN
      Indent(h, n);
      Append(h, n, NewToken(M3CToken.BEGIN_));
      NLIncIndent(h, n);
    END; (* if *)
    VisitSeqStm(h, n, n.as_stm_s);
    IF h.isModule THEN DecIndent(h); END;
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END Block;

PROCEDURE <A NAME="Assign_st"><procedure>Assign_st</procedure></A>(h: Handle; n: M3AST_AS.Assign_st)=
  BEGIN
    Indent(h, n);
    DoIt(h, n, n.as_lhs_exp);
    Space(h, n); Append(h, n, NewToken(M3CToken.Becomes)); Space(h, n);
    DoIt(h, n, n.as_rhs_exp);
  END Assign_st;

PROCEDURE <A NAME="Call_st"><procedure>Call_st</procedure></A>(h: Handle; n: M3AST_AS.Call_st)=
  BEGIN
    Indent(h, n);
    DoIt(h, n, n.as_call);
  END Call_st;

PROCEDURE <A NAME="Case_st"><procedure>Case_st</procedure></A>(h: Handle; n: M3AST_AS.Case_st)=
  VAR
    m: M3AST_AS.Case;
    iter := SeqM3AST_AS_Case.NewIter(n.as_case_s);
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.CASE_)); Space(h, n);
    DoIt(h, n, n.as_exp);
    Space(h, n); Append(h, n, NewToken(M3CToken.OF_)); NL(h, n);
    WHILE SeqM3AST_AS_Case.Next(iter, m) DO DoIt(h, n, m); END;
    IF n.as_else # NIL THEN DoIt(h, n, n.as_else); END;
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END Case_st;

PROCEDURE <A NAME="Eval_st"><procedure>Eval_st</procedure></A>(h: Handle; n: M3AST_AS.Eval_st)=
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.EVAL_)); Space(h, n);
    DoIt(h, n, n.as_exp);
  END Eval_st;

PROCEDURE <A NAME="Exit_st"><procedure>Exit_st</procedure></A>(h: Handle; n: M3AST_AS.Exit_st)=
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.EXIT_));
  END Exit_st;

PROCEDURE <A NAME="For_st"><procedure>For_st</procedure></A>(h: Handle; n: M3AST_AS.For_st)=
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.FOR_)); Space(h, n);
    Append(h, n, n.as_id); Space(h, n); Append(h, n, NewToken(M3CToken.Becomes)); Space(h, n);
    DoIt(h, n, n.as_from); Space(h, n); Append(h, n, NewToken(M3CToken.TO_)); Space(h, n);
    DoIt(h, n, n.as_to);
    IF n.as_by # NIL THEN DoIt(h, n, n.as_by); END;
    Space(h, n); Append(h, n, NewToken(M3CToken.DO_)); NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h); Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END For_st;

PROCEDURE <A NAME="If_st"><procedure>If_st</procedure></A>(h: Handle; n: M3AST_AS.If_st)=
  VAR
    m: M3AST_AS.Elsif;
    iter := SeqM3AST_AS_Elsif.NewIter(n.as_elsif_s);
  BEGIN
    Indent(h, n); Append(h, n, NewToken(M3CToken.IF_)); Space(h, n);
    DoIt(h, n, n.as_exp);
    Space(h, n); Append(h, n, NewToken(M3CToken.THEN_)); NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h);
    WHILE SeqM3AST_AS_Elsif.Next(iter, m) DO DoIt(h, n, m); END;
    IF n.as_else # NIL THEN DoIt(h, n, n.as_else); END;
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END If_st;

PROCEDURE <A NAME="Lock_st"><procedure>Lock_st</procedure></A>(h: Handle; n: M3AST_AS.Lock_st)=
  BEGIN
    Indent(h, n); Append(h, n, NewToken(M3CToken.LOCK_)); Space(h, n);
    DoIt(h, n, n.as_exp);
    Space(h, n); Append(h, n, NewToken(M3CToken.DO_)); NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h); Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END Lock_st;

PROCEDURE <A NAME="Loop_st"><procedure>Loop_st</procedure></A>(h: Handle; n: M3AST_AS.Loop_st)=
  BEGIN
    Indent(h, n); Append(h, n, NewToken(M3CToken.LOOP_));
    NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h); Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END Loop_st;

PROCEDURE <A NAME="Raise_st"><procedure>Raise_st</procedure></A>(h: Handle; n: M3AST_AS.Raise_st)=
  BEGIN
    Indent(h, n); Append(h, n, NewToken(M3CToken.RAISE_)); Space(h, n);
    DoIt(h, n, n.as_qual_id);
    IF n.as_exp_void # NIL THEN
      Space(h, n);
      Append(h, n, NewToken(M3CToken.Bra));
      DoIt(h, n, n.as_exp_void);
      Append(h, n, NewToken(M3CToken.Ket));
    END;
  END Raise_st;

PROCEDURE <A NAME="Repeat_st"><procedure>Repeat_st</procedure></A>(h: Handle; n: M3AST_AS.Repeat_st)=
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.REPEAT_));
    NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h); Indent(h, n);
    Append(h, n, NewToken(M3CToken.UNTIL_)); Space(h, n);
    DoIt(h, n, n.as_exp);
  END Repeat_st;

PROCEDURE <A NAME="Return_st"><procedure>Return_st</procedure></A>(h: Handle; n: M3AST_AS.Return_st)=
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.RETURN_)); Space(h, n);
    IF n.as_exp # NIL THEN DoIt(h, n, n.as_exp); END;
  END Return_st;

PROCEDURE <A NAME="Try_st"><procedure>Try_st</procedure></A>(h: Handle; n: M3AST_AS.Try_st)=
  BEGIN
    Indent(h, n); Append(h, n, NewToken(M3CToken.TRY_));
    NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h);
    DoIt(h, n, n.as_try_tail);
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END Try_st;

PROCEDURE <A NAME="Typecase_st"><procedure>Typecase_st</procedure></A>(h: Handle; n: M3AST_AS.Typecase_st)=
  VAR
    m: M3AST_AS.Tcase;
    iter := SeqM3AST_AS_Tcase.NewIter(n.as_tcase_s);
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.TYPECASE_)); Space(h, n);
    DoIt(h, n, n.as_exp);
    Space(h, n); Append(h, n, NewToken(M3CToken.OF_)); NL(h, n);
    WHILE SeqM3AST_AS_Tcase.Next(iter, m) DO DoIt(h, n, m); END;
    IF n.as_else # NIL THEN DoIt(h, n, n.as_else); END;
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END Typecase_st;

PROCEDURE <A NAME="While_st"><procedure>While_st</procedure></A>(h: Handle; n: M3AST_AS.While_st)=
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.WHILE_)); Space(h, n);
    DoIt(h, n, n.as_exp);
    Space(h, n); Append(h, n, NewToken(M3CToken.DO_)); NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h); Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END While_st;

PROCEDURE <A NAME="With_st"><procedure>With_st</procedure></A>(h: Handle; n: M3AST_AS.With_st)=
  VAR
    m: M3AST_AS.Binding;
    iter := SeqM3AST_AS_Binding.NewIter(n.as_binding_s);
    isFirst := TRUE;
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.WITH_)); Space(h, n);
    WHILE SeqM3AST_AS_Binding.Next(iter, m) DO
      Between(h, n, isFirst, CS); DoIt(h, n, m);
    END;
    Space(h, n); Append(h, n, NewToken(M3CToken.DO_)); NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h); Indent(h, n);
    Append(h, n, NewToken(M3CToken.END_));
  END With_st;

PROCEDURE <A NAME="Case"><procedure>Case</procedure></A>(h: Handle; n: M3AST_AS.Case)=
  VAR
    m: M3AST_AS.RANGE_EXP;
    iter := SeqM3AST_AS_RANGE_EXP.NewIter(n.as_case_label_s);
    isFirst := TRUE;
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.Bar)); Space(h, n);
    WHILE SeqM3AST_AS_RANGE_EXP.Next(iter, m) DO
      Between(h, n, isFirst, CS); DoIt(h, n, m);
    END;
    Space(h, n);
    Append(h, n, NewToken(M3CToken.Implies)); Space(h, n);
    IncIndent(h); NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h); DecIndent(h); NL(h, n);
  END Case;

PROCEDURE <A NAME="Else_stm"><procedure>Else_stm</procedure></A>(h: Handle; n: M3AST_AS.Else_stm)=
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.ELSE_));
    NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h);
  END Else_stm;

PROCEDURE <A NAME="By"><procedure>By</procedure></A>(h: Handle; n: M3AST_AS.By)=
  BEGIN
    Space(h, n); Append(h, n, NewToken(M3CToken.BY_)); Space(h, n);
    DoIt(h, n, n.as_exp);
  END By;

PROCEDURE <A NAME="Elsif"><procedure>Elsif</procedure></A>(h: Handle; n: M3AST_AS.Elsif)=
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.ELSIF_)); Space(h, n);
    DoIt(h, n, n.as_exp);
    Space(h, n); Append(h, n, NewToken(M3CToken.THEN_)); NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h);
  END Elsif;

PROCEDURE <A NAME="Try_except"><procedure>Try_except</procedure></A>(h: Handle; n: M3AST_AS.Try_except)=
  VAR
    m: M3AST_AS.Handler;
    iter := SeqM3AST_AS_Handler.NewIter(n.as_handler_s);
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.EXCEPT_));
    NL(h, n);
    WHILE SeqM3AST_AS_Handler.Next(iter, m) DO DoIt(h, n, m); END;
    IF n.as_else # NIL THEN DoIt(h, n, n.as_else); END;
  END Try_except;

PROCEDURE <A NAME="Try_finally"><procedure>Try_finally</procedure></A>(h: Handle; n: M3AST_AS.Try_finally)=
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.FINALLY_));
    NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h);
  END Try_finally;

PROCEDURE <A NAME="Tcase"><procedure>Tcase</procedure></A>(h: Handle; n: M3AST_AS.Tcase)=
  VAR
    m: M3AST_AS.M3TYPE;
    iter := SeqM3AST_AS_M3TYPE.NewIter(n.as_type_s);
    isFirst := TRUE;
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.Bar)); Space(h, n);
    WHILE SeqM3AST_AS_M3TYPE.Next(iter, m) DO
      Between(h, n, isFirst, CS); DoIt(h, n, m);
    END;
    IF n.as_id # NIL THEN
      Append(h, n, NewToken(M3CToken.Bra));
      Append(h, n, n.as_id);
      Append(h, n, NewToken(M3CToken.Ket));
    END;
    Space(h, n);
    Append(h, n, NewToken(M3CToken.Implies)); Space(h, n);
    IncIndent(h); NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h); DecIndent(h); NL(h, n);
  END Tcase;

PROCEDURE <A NAME="Handler"><procedure>Handler</procedure></A>(h: Handle; n: M3AST_AS.Handler)=
  VAR
    m: M3AST_AS.Qual_used_id;
    iter := SeqM3AST_AS_Qual_used_id.NewIter(n.as_qual_id_s);
    isFirst := TRUE;
  BEGIN
    Indent(h, n);
    Append(h, n, NewToken(M3CToken.Bar)); Space(h, n);
    WHILE SeqM3AST_AS_Qual_used_id.Next(iter, m) DO
      Between(h, n, isFirst, CS); DoIt(h, n, m);
    END;
    IF n.as_id # NIL THEN
      Append(h, n, NewToken(M3CToken.Bra));
      Append(h, n, n.as_id);
      Append(h, n, NewToken(M3CToken.Ket));
    END;
    Space(h, n);
    Append(h, n, NewToken(M3CToken.Implies)); Space(h, n);
    IncIndent(h); NLIncIndent(h, n);
    VisitSeqStm(h, n, n.as_stm_s);
    DecIndent(h); DecIndent(h); NL(h, n);
  END Handler;

PROCEDURE <A NAME="Binding"><procedure>Binding</procedure></A>(h: Handle; n: M3AST_AS.Binding)=
  BEGIN
    Append(h, n, n.as_id);
    Space(h, n); Append(h, n, NewToken(M3CToken.Equal)); Space(h, n);
    DoIt(h, n, n.as_exp);
  END Binding;

PROCEDURE <A NAME="VisitSeqStm"><procedure>VisitSeqStm</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE_C; ss: SeqM3AST_AS_STM.T)=
  VAR
    m: M3AST_AS.STM;
    iter := SeqM3AST_AS_STM.NewIter(ss);
  BEGIN
    WHILE SeqM3AST_AS_STM.Next(iter, m) DO
      DoIt(h, n, m);
      SCNL(h, n);
    END;
  END VisitSeqStm;

PROCEDURE <A NAME="FlushComments"><procedure>FlushComments</procedure></A>(h: Handle; n: M3AST_AS.SRC_NODE_C; follow: BOOLEAN;
    m: M3AST_AS.SRC_NODE)=
  VAR p: PROCEDURE(t: M3CComment.T): M3AST_AS.SRC_NODE;
  BEGIN
     IF follow THEN p := M3CComment.FollowingNode
     ELSE p := M3CComment.PrecedingNode;
     END;
     WHILE h.comment # NIL AND p(h.comment) = m DO
       D(h, n, M3CComment.Body(h.comment));
       NL(h, n);
       IF M3CComment.Next(h.comments, h.comment) THEN
       ELSE h.comment := NIL;
       END;
     END;
  END FlushComments;

BEGIN
  MkWS();
END StdFormat.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
