<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/astpickle/M3ASTPickle.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/astpickle/M3ASTPickle.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3ASTPickle.i3">M3ASTPickle</A></implements></module>;

IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../pickle/src/Pickle.i3">Pickle</A>;
IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="M3AST_SC.i3">M3AST_SC</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../syn/M3CId.i3">M3CId</A>, <A HREF="../syn/M3CLiteral.i3">M3CLiteral</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_Used_interface_id.i3">SeqM3AST_AS_Used_interface_id</A>, <A HREF="../../derived/SeqM3AST_SC_Exported_node.i3">SeqM3AST_SC_Exported_node</A>,
       <A HREF="../../derived/SeqM3AST_SC_Unit_stub.i3">SeqM3AST_SC_Unit_stub</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>, <A HREF="M3AST_SC_F.i3">M3AST_SC_F</A>;

&lt;*FATAL Wr.Failure, Rd.EndOfFile, Rd.Failure, Thread.Alerted, Pickle.Error *&gt;

CONST
  Internal = '0'; External = '1';

TYPE
  Reader = Pickle.Reader OBJECT
    cu: M3AST_AS.Compilation_Unit := NIL;
    context: M3Context.T;
    importProc: ImportedUnitProc;
  END;

  Writer = Pickle.Writer OBJECT
    cu: M3AST_AS.Compilation_Unit;
  END;

PROCEDURE <A NAME="Read"><procedure>Read</procedure></A>(context: M3Context.T; rd: Rd.T; p: ImportedUnitProc;
    VAR cu: M3AST_AS.Compilation_Unit
    ) RAISES {Rd.Failure, Thread.Alerted, Pickle.Error}=
  BEGIN
    cu := NEW(Reader, importProc := p, context := context,
              rd := rd).read();
  END Read;

PROCEDURE <A NAME="Write"><procedure>Write</procedure></A>(cu: M3AST_AS.Compilation_Unit; wr: Wr.T
  ) RAISES {Wr.Failure, Thread.Alerted, Pickle.Error}=
  VAR
    iter := SeqM3AST_AS_Used_interface_id.NewIter(
                NARROW(cu.as_root, M3AST_AS.UNIT_WITH_BODY).sm_import_s);
    used_intf_id: M3AST_AS.Used_interface_id;
  BEGIN
    WHILE SeqM3AST_AS_Used_interface_id.Next(iter, used_intf_id) DO
      BuildExportedNodeTable(
        NARROW(used_intf_id.sm_def, M3AST_AS.UNIT_ID).sm_spec.sm_comp_unit);
    END;
    NEW(Writer, cu := cu, wr := wr).write(cu);
  END Write;

PROCEDURE <A NAME="BuildExportedNodeTable"><procedure>BuildExportedNodeTable</procedure></A>(cu: M3AST_AS.Compilation_Unit)=
  &lt;*FATAL ANY*&gt;
  BEGIN
    IF SeqM3AST_SC_Exported_node.Empty(cu.sc_exported_node_s) THEN
      ASTWalk.VisitNodes(cu, NEW(BuildClosure, cu := cu));
    END;
  END BuildExportedNodeTable;

TYPE BuildClosure = ASTWalk.Closure OBJECT
    cu: M3AST_AS.Compilation_Unit;
  OVERRIDES
    callback := BuildNode
  END;

PROCEDURE <A NAME="BuildNode"><procedure>BuildNode</procedure></A>(cl: BuildClosure; n: AST.NODE;
                    &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode)=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.DEF_ID, M3AST_AS.TYPE_SPEC =&gt;
        SeqM3AST_SC_Exported_node.AddRear(cl.cu.sc_exported_node_s,
            NEW(M3AST_SC.Exported_node, sc_actual_node := n));
    ELSE
    END;
  END BuildNode;

PROCEDURE <A NAME="Special_read_TYPE_SPEC"><procedure>Special_read_TYPE_SPEC</procedure></A>(sp: Pickle.Special; reader: Pickle.Reader;
                                 id: Pickle.RefID): REFANY=
  VAR
    kind := Rd.GetChar(reader.rd);
    type_spec: M3AST_AS.TYPE_SPEC := NIL;
  BEGIN
    IF kind = Internal THEN
      type_spec := Pickle.Special.read(sp, reader, id)
    ELSE
      VAR imported_node: M3AST_SC.IMPORTED_NODE := reader.read();
        a: M3AST_AS.SRC_NODE;
      BEGIN
        IF imported_node # NIL THEN
          IF FindActualFromIMPORTED_NODE(reader, imported_node, a) THEN
            type_spec := a
          END;
        END;
        reader.noteRef(type_spec, id);
      END
    END;
    RETURN type_spec;
  END Special_read_TYPE_SPEC;

PROCEDURE <A NAME="Special_write_TYPE_SPEC"><procedure>Special_write_TYPE_SPEC</procedure></A>(sp: Pickle.Special; r: REFANY;
                                 writer: Pickle.Writer)=

  VAR
    type_spec := NARROW(r, M3AST_AS.TYPE_SPEC);
    ext_unit_id: M3AST_AS.UNIT_ID;
    this_cu := NARROW(writer, Writer).cu;
  BEGIN
    IF ThisUnit(this_cu, type_spec.tmp_unit_id, ext_unit_id) THEN
      Wr.PutChar(writer.wr, Internal);
      Pickle.Special.write(sp, r, writer);
    ELSE
      VAR imported_node: M3AST_SC.IMPORTED_NODE := NIL;
      BEGIN
        IF ext_unit_id # NIL THEN
          imported_node := NewIMPORTED_NODE(this_cu, ext_unit_id, type_spec);
        END;
        Wr.PutChar(writer.wr, External);
        writer.write(imported_node);
      END
    END
  END Special_write_TYPE_SPEC;

PROCEDURE <A NAME="Special_read_DEF_ID"><procedure>Special_read_DEF_ID</procedure></A>(sp: Pickle.Special; reader: Pickle.Reader;
                              id: Pickle.RefID): REFANY=
  VAR
    kind := Rd.GetChar(reader.rd);
    def_id: M3AST_AS.DEF_ID := NIL;
  BEGIN
    IF kind = Internal THEN
      def_id := Pickle.Special.read(sp, reader, id)
    ELSE
      VAR imported_node: M3AST_SC.IMPORTED_NODE := reader.read();
        a: M3AST_AS.SRC_NODE;
      BEGIN
        IF imported_node # NIL THEN
          IF FindActualFromIMPORTED_NODE(reader, imported_node, a) THEN
            def_id := a
          END;
        END;
        reader.noteRef(def_id, id);
      END
    END;
    RETURN def_id;
  END Special_read_DEF_ID;

PROCEDURE <A NAME="Special_write_DEF_ID"><procedure>Special_write_DEF_ID</procedure></A>(sp: Pickle.Special; r: REFANY;
                                 writer: Pickle.Writer)=

  VAR
    def_id := NARROW(r, M3AST_AS.DEF_ID);
    ext_unit_id: M3AST_AS.UNIT_ID;
    this_cu := NARROW(writer, Writer).cu;
  BEGIN
    IF ThisUnit(this_cu, def_id.tmp_unit_id, ext_unit_id) THEN
      Wr.PutChar(writer.wr, Internal);
      Pickle.Special.write(sp, r, writer);
    ELSE
      VAR imported_node: M3AST_SC.IMPORTED_NODE := NIL;
      BEGIN
        IF ext_unit_id # NIL THEN
          imported_node := NewIMPORTED_NODE(this_cu, ext_unit_id, def_id);
        END;
        Wr.PutChar(writer.wr, External);
        writer.write(imported_node);
      END
    END
  END Special_write_DEF_ID;

PROCEDURE <A NAME="NewIMPORTED_NODE"><procedure>NewIMPORTED_NODE</procedure></A>(this_cu: M3AST_AS.Compilation_Unit;
                           ext_unit_id: M3AST_AS.UNIT_ID;
                           n: M3AST_AS.SRC_NODE): M3AST_SC.IMPORTED_NODE=
  BEGIN
    WITH ext_cu = ext_unit_id.sm_spec.sm_comp_unit DO
      RETURN NEW(M3AST_SC.IMPORTED_NODE,
          sc_unit_stub := FindOrGenerateUnit_stub(this_cu, ext_cu),
          sc_eoi := FindExportedNodeIndexFor(n, ext_cu));
    END
  END NewIMPORTED_NODE;

PROCEDURE <A NAME="FindActualFromIMPORTED_NODE"><procedure>FindActualFromIMPORTED_NODE</procedure></A>(
    reader: Reader;
    imported_node: M3AST_SC.IMPORTED_NODE;
    VAR (*out*) actual_node: M3AST_AS.SRC_NODE): BOOLEAN=
  &lt;*FATAL ANY*&gt;
  VAR imp_cu: M3AST_AS.Compilation_Unit;
  BEGIN
    WITH usb = imported_node.sc_unit_stub DO
      IF reader.importProc(
           M3CId.ToText(usb.sc_unit_symrep),
           usb.sc_unit_type,
           usb.sc_unit_uid,
           reader.context,
           imp_cu) THEN
          BuildExportedNodeTable(imp_cu);
          actual_node := FindFromExportedNodeIndex(imp_cu,
                                                   imported_node.sc_eoi);
          RETURN TRUE;
      ELSE
        RETURN FALSE;
      END
    END
  END FindActualFromIMPORTED_NODE;

PROCEDURE <A NAME="ThisUnit"><procedure>ThisUnit</procedure></A>(cu: M3AST_AS.Compilation_Unit; unit_id: M3AST_AS.UNIT_ID;
    VAR (*out*) ext_unit_id: M3AST_AS.UNIT_ID): BOOLEAN=
  BEGIN
    IF unit_id = NIL OR unit_id = cu.as_root.as_id THEN RETURN TRUE
    ELSE
      IF ISTYPE(unit_id, M3AST_AS.Module_id) THEN ext_unit_id := NIL
      ELSE ext_unit_id := unit_id
      END;
      RETURN FALSE;
    END
  END ThisUnit;

PROCEDURE <A NAME="FindExportedNodeIndexFor"><procedure>FindExportedNodeIndexFor</procedure></A>(t: M3AST_AS.SRC_NODE;
    cu: M3AST_AS.Compilation_Unit): INTEGER RAISES{}=
  VAR
    en: M3AST_SC.Exported_node;
    iter := SeqM3AST_SC_Exported_node.NewIter(cu.sc_exported_node_s);
    eoi_uid: INTEGER := 0;
  BEGIN
    WHILE SeqM3AST_SC_Exported_node.Next(iter, en) DO
      IF en.sc_actual_node = t THEN
      	RETURN eoi_uid;
      END; (* if *)
      INC(eoi_uid);
    END; (* while *)
    &lt;*ASSERT FALSE*&gt;
  END FindExportedNodeIndexFor;

PROCEDURE <A NAME="FindFromExportedNodeIndex"><procedure>FindFromExportedNodeIndex</procedure></A>(
    cu: M3AST_AS.Compilation_Unit;
    this_eoi_uid: INTEGER): M3AST_AS.SRC_NODE=
  VAR
    en: M3AST_SC.Exported_node;
    iter := SeqM3AST_SC_Exported_node.NewIter(cu.sc_exported_node_s);
    eoi_uid: INTEGER := 0;
  BEGIN
    WHILE SeqM3AST_SC_Exported_node.Next(iter, en) DO
      IF eoi_uid = this_eoi_uid THEN
        RETURN en.sc_actual_node;
      END; (* if *)
      INC(eoi_uid);
    END; (* while *)
    &lt;*ASSERT FALSE*&gt;
  END FindFromExportedNodeIndex;

PROCEDURE <A NAME="FindOrGenerateUnit_stub"><procedure>FindOrGenerateUnit_stub</procedure></A>(
    this_cu, ext_cu: M3AST_AS.Compilation_Unit): M3AST_SC.Unit_stub RAISES {}=
  VAR
    iter := SeqM3AST_SC_Unit_stub.NewIter(this_cu.sc_unit_stub_s);
    unit_stub: M3AST_SC.Unit_stub;
  BEGIN
    WHILE SeqM3AST_SC_Unit_stub.Next(iter, unit_stub) DO
      IF ext_cu.as_root.as_id.lx_symrep = unit_stub.sc_unit_symrep THEN
        (* assume same type (interface) *)
        RETURN unit_stub
      END; (* if *)
    END; (* while *)
    unit_stub := NEW(M3AST_SC.Unit_stub,
        sc_unit_symrep := ext_cu.as_root.as_id.lx_symrep,
        sc_unit_uid := ext_cu.fe_uid,
        sc_unit_type := M3CUnit.ToType(ext_cu.as_root));
    SeqM3AST_SC_Unit_stub.AddRear(this_cu.sc_unit_stub_s, unit_stub);
    RETURN unit_stub;
  END FindOrGenerateUnit_stub;

PROCEDURE <A NAME="Special_read_Symbol_rep"><procedure>Special_read_Symbol_rep</procedure></A>(&lt;*UNUSED*&gt; sp: Pickle.Special;
                                  reader: Pickle.Reader;
                                  id: Pickle.RefID;): REFANY=
  VAR text: TEXT := reader.read();
  BEGIN
    WITH atom = M3CId.Enter(text) DO
      reader.noteRef(atom, id);
      RETURN atom;
    END
  END Special_read_Symbol_rep;

PROCEDURE <A NAME="Special_write_Symbol_rep"><procedure>Special_write_Symbol_rep</procedure></A>(&lt;*UNUSED*&gt; sp: Pickle.Special; r: REFANY;
                                 writer: Pickle.Writer)=
  BEGIN
    writer.write(M3CId.ToText(r));
  END Special_write_Symbol_rep;

PROCEDURE <A NAME="Special_read_Literal_rep"><procedure>Special_read_Literal_rep</procedure></A>(&lt;*UNUSED*&gt; sp: Pickle.Special;
                                   reader: Pickle.Reader;
                                   id: Pickle.RefID): REFANY=
  VAR text: TEXT := reader.read();
  BEGIN
    WITH lit = M3CLiteral.Enter(text) DO
      reader.noteRef(lit, id);
      RETURN lit;
    END
  END Special_read_Literal_rep;

PROCEDURE <A NAME="Special_write_Literal_rep"><procedure>Special_write_Literal_rep</procedure></A>(&lt;*UNUSED*&gt; sp: Pickle.Special; r: REFANY;
                                 writer: Pickle.Writer)=
  BEGIN
    writer.write(M3CLiteral.ToText(r));
  END Special_write_Literal_rep;

BEGIN
  Pickle.RegisterSpecial(
      NEW(Pickle.Special, sc := TYPECODE(M3AST_AS.TYPE_SPEC),
          read := Special_read_TYPE_SPEC,
          write := Special_write_TYPE_SPEC));

  Pickle.RegisterSpecial(
      NEW(Pickle.Special, sc := TYPECODE(M3AST_AS.DEF_ID),
          read := Special_read_DEF_ID,
          write := Special_write_DEF_ID));

  Pickle.RegisterSpecial(
      NEW(Pickle.Special, sc := TYPECODE(M3AST_LX.Symbol_rep),
          read := Special_read_Symbol_rep,
          write := Special_write_Symbol_rep));

  Pickle.RegisterSpecial(
      NEW(Pickle.Special, sc := TYPECODE(M3AST_LX.Literal_rep),
          read := Special_read_Literal_rep,
          write := Special_write_Literal_rep));
END M3ASTPickle.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
