<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/astpickle/M3ASTPickleTool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/astpickle/M3ASTPickleTool.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3ASTPickleTool.i3">M3ASTPickleTool</A></implements></module>;

IMPORT <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../rw/src/Common/FileWr.i3">FileWr</A>, <A HREF="../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../../pickle/src/Pickle.i3">Pickle</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="#x1">Err</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="../misc/M3Args.i3">M3Args</A>, <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A>;
IMPORT <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../toolmisc/M3CUnitRep.i3">M3CUnitRep</A>, <A HREF="../files/Common/M3Extension.i3">M3Extension</A>, <A HREF="../fe/M3CGo.i3">M3CGo</A>, <A HREF="../syn/M3CId.i3">M3CId</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_FE_F.i3">M3AST_FE_F</A>;
IMPORT <A HREF="M3ASTPickle.i3">M3ASTPickle</A>;

CONST Version = &quot;1-Dec-92&quot;;

VAR tool_g := M3Args.New(&quot;m3astpickle&quot;, &quot;AST pickle tool&quot;, Version);

TYPE
  Extension = M3CGo.Extension OBJECT
  OVERRIDES extend := Extend;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>()=
  BEGIN
    M3CGo.AddExtension(NEW(Extension));
  END Init;

PROCEDURE <A NAME="DoUnit"><procedure>DoUnit</procedure></A>(cu: M3AST_AS.Compilation_Unit)=
  BEGIN
    PickleCu(cu, M3CUnit.ToType(cu.as_root));
  END DoUnit;

PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A>(
    &lt;*UNUSED*&gt; e: Extension;
    &lt;*UNUSED*&gt; context: M3Context.T;
               cu: M3AST_AS.Compilation_Unit;
    &lt;*UNUSED*&gt; VAR (*inout*) phases: M3CUnit.Status)=
  VAR ut := M3CUnit.ToType(cu.as_root);
  BEGIN
    IF M3Conventions.PrimarySource IN cu.fe_status THEN
      IF M3Args.Find(tool_g) THEN
        VAR alli := M3Args.GetFlag(tool_g, PickleAllInterfaces_Arg);
            allm := M3Args.GetFlag(tool_g, PickleAllModules_Arg);
        BEGIN
          IF (ut IN M3CUnit.Interfaces AND
              (alli OR InList(cu, ut))) OR
             (ut IN M3CUnit.Modules AND
               (allm OR InList(cu, ut))) THEN
            PickleCu(cu, ut);
          END;
        END
      END
    END;
  END Extend;

PROCEDURE <A NAME="InList"><procedure>InList</procedure></A>(cu: M3AST_AS.Compilation_Unit; ut: M3CUnit.Type): BOOLEAN=
  VAR list: REF ARRAY OF TEXT;
      name: TEXT;
  BEGIN
    name := M3CId.ToText(cu.as_root.as_id.lx_symrep);
    IF ut IN M3CUnit.Interfaces THEN
      list := M3Args.GetStringList(tool_g, PickleInterfaces_Arg);
    ELSE
      list := M3Args.GetStringList(tool_g, PickleModules_Arg);
    END;
    IF list # NIL THEN
      FOR i := 0 TO NUMBER(list^)-1 DO
        IF Text.Equal(list[i], name) THEN
          RETURN TRUE;
        END;
      END;
    END;
    RETURN FALSE;
  END InList;

PROCEDURE <A NAME="PickleCu"><procedure>PickleCu</procedure></A>(cu: M3AST_AS.Compilation_Unit; ut: M3CUnit.Type) =
  &lt;*FATAL Thread.Alerted*&gt;
  VAR e: M3Extension.T;
  BEGIN
    IF ut IN M3CUnit.Interfaces THEN e := M3Extension.T.PInt
    ELSE e := M3Extension.T.PMod
    END;
    VAR filename := M3Extension.Extend(Pathname.Base(cu.fe_uid.filename), e);
    VAR wr: Wr.T;
    BEGIN
      TRY
        wr := FileWr.Open(filename);
        M3ASTPickle.Write(cu, wr);
        Wr.Close(wr);
      EXCEPT OSError.E, Wr.Failure, Pickle.Error =&gt;
        Err.Print(Fmt.F(&quot;saving AST to file '%s' failed&quot;, filename),
                  Err.Severity.Error);
      END;
    END;
  END PickleCu;

BEGIN
  M3Args.RegisterFlag(tool_g, PickleAllInterfaces_Arg,
    &quot;pickle all interfaces&quot;);
  M3Args.RegisterFlag(tool_g, PickleAllModules_Arg,
    &quot;pickle all modules&quot;);
  M3Args.RegisterStringList(tool_g, PickleInterfaces_Arg,
    &quot;pickle given interfaces&quot;);
  M3Args.RegisterStringList(tool_g, PickleModules_Arg,
    &quot;pickle given modules&quot;);
END M3ASTPickleTool.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
